/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.script.npm.AbstractKingScriptCheckPlugin;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.sdk.kingscript.debug.endpoint.DebugServerEndpoint;

public class KingScriptDebugPlugin
extends AbstractKingScriptCheckPlugin {
    private static Log logger = LogFactory.getLog(KingScriptDebugPlugin.class);
    private static final String SEND_CODE_EDITOR_DEBUG_PROTOCOL = "sendCodeEditorDebugProtocol";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        KingScriptEdit edit = (KingScriptEdit)this.getControl("kingscripteditap");
        edit.addScriptEditorListener((KingScriptEditorListener)this);
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "sendCodeEditorDebugProtocol": {
                this.sendCodeEditorDebugProtocol(e.getParam());
            }
        }
    }

    private void sendCodeEditorDebugProtocol(Map<String, Object> args) {
        if (args == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u542f\u52a8\u8c03\u8bd5\u53c2\u6570\u4e3a\u7a7a\uff0c\u542f\u52a8\u5931\u8d25\u3002", (String)"KingScriptPlugin_15", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            return;
        }
        if ("Debugger.prepare".equals(args.get("method"))) {
            if (!this.isBindScript()) {
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u811a\u672c\u672a\u4e0e\u8868\u5355\u7ed1\u5b9a\uff0c\u8bf7\u5148\u4fdd\u5b58\u8bbe\u8ba1\u5668\u3002", (String)"KingScriptPlugin_12", (String)"bos-devportal-plugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                this.sendMessage(args, msg, false, "-3");
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u52a8\u8c03\u8bd5\u6210\u529f\uff0c\u53ef\u5230\u672c\u4f1a\u8bdd\u4e2d\u5bf9\u5e94\u9875\u9762\u8fdb\u884c\u6d4b\u8bd5\u3002", (String)"KingScriptPlugin_11", (String)"bos-devportal-plugin", (Object[])new Object[0]));
        }
        String debugId = (String)args.get("debugId");
        DebugServerEndpoint debugServer = new DebugServerEndpoint();
        debugServer.request(debugId, SerializationUtils.toJsonString(args));
    }

    private boolean isBindScript() {
        String editOpenType = KingScriptConfig.getEditorOpenType(this.getPageCache());
        if (!"designer".equals(editOpenType)) {
            return true;
        }
        String className = KingScriptConfig.getClassName(this.getPageCache());
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("bizpagenumber");
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParams().get("scripttypefilter");
        List<String> whiteList = Arrays.asList("ReportQueryPlugin", "ReportPluginExt", "BaseDataController");
        if (whiteList.contains(scriptTypeFilter)) {
            return true;
        }
        if ("operate".equalsIgnoreCase(scriptTypeFilter)) {
            String id = this.getMetaId();
            if (StringUtils.isBlank((CharSequence)id)) {
                return true;
            }
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
            List operations = entityMetadata.getRootEntity().getOperations();
            if (operations == null || operations.isEmpty()) {
                return false;
            }
            for (Operation operation : operations) {
                List pluginList = operation.getPlugins();
                if (pluginList == null || pluginList.isEmpty()) continue;
                for (Plugin plugin : pluginList) {
                    String pluginName = plugin.getClassName();
                    if (!className.equalsIgnoreCase(pluginName)) continue;
                    return true;
                }
            }
        } else {
            List<Plugin> plugins = this.getPluginsByType(formId);
            if (plugins == null || plugins.isEmpty()) {
                return false;
            }
            for (Plugin plugin : plugins) {
                if (!plugin.getClassName().equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Plugin> getPluginsByType(String formId) {
        List plugins = null;
        String designerName = KingScriptConfig.getDesignerName(this.getPageCache());
        String id = this.getMetaId();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        FormAp rootAp = formMetadata.getRootAp();
        if (StringUtils.isBlank((CharSequence)designerName)) {
            return rootAp == null ? null : rootAp.getPlugins();
        }
        switch (designerName) {
            case "MobListMeta": {
                if (!(rootAp instanceof BillFormAp)) break;
                plugins = ((BillFormAp)rootAp).getMobListMeta().getRootAp().getPlugins();
                break;
            }
            case "ListMeta": {
                if (!(rootAp instanceof BillFormAp)) break;
                plugins = ((BillFormAp)rootAp).getListMeta().getRootAp().getPlugins();
                break;
            }
            case "MobMeta": {
                if (!(rootAp instanceof BillFormAp)) break;
                plugins = ((BillFormAp)rootAp).getMobMeta().getRootAp().getPlugins();
                break;
            }
            default: {
                plugins = rootAp.getPlugins();
            }
        }
        return plugins;
    }
}

