/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.script.npm.AbstractKingScriptCheckPlugin;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.devportal.script.npm.helper.KingScriptConfigHelper;
import kd.bos.devportal.script.npm.helper.KingScriptMutexViewHelper;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.KingScriptEdit;
import kd.bos.form.control.KingScriptEditorListener;
import kd.bos.form.control.events.KingScriptEditorEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppReader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;
import kd.sdk.kingscript.util.Tuple;

public class KingScriptOperationPlugin
extends AbstractKingScriptCheckPlugin {
    private static Log logger = LogFactory.getLog(KingScriptOperationPlugin.class);
    protected static final String OK = "ok";
    protected static final String SAVE = "save";
    protected static final String CODE = "kingscripteditap";
    private static final String EXIT = "exit";
    private static final String EXPORT = "export";
    private static final String EXPORTICON = "exporticon";
    private static final String GUIDE = "guide";
    private static final String GUIDE_LABEL = "guidelabel";
    private static final String BASEINFO = "baseinfo";
    private static final String BASEINFO_LABEL = "baseinfolabel";
    private static final String ACTION_SCRIPT_CODE_SAVE = "saveCodeEditorCont";
    private static final String CONFIRM_CALL_BACK_EDITOR_SAVE = "editorSaveCallBack";
    private static final String SCRIPT_NAME = "scriptName";
    private static final String SCRIPT_TYPE = "scriptType";
    private static final String THROW_COMPILE_EXCEPT = "throwCompileExcept";
    private static final String CLIENT_TYPE = "clientType";
    private static final String EDITOR = "editor";
    private static final String DCS_AUTO_GIT = "kingscript.dcs.autogit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        KingScriptEdit edit = (KingScriptEdit)this.getControl(CODE);
        edit.addScriptEditorListener((KingScriptEditorListener)this);
        this.addClickListeners(new String[]{OK, EXIT, SAVE, EXPORT, EXPORTICON, GUIDE, GUIDE_LABEL, BASEINFO, BASEINFO_LABEL});
    }

    public void afterBindData(EventObject e) {
        String tenantCode;
        super.afterBindData(e);
        String viewStatus = KingScriptConfig.getViewStatus(this.getPageCache());
        if ("edit".equals(viewStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
        boolean disable = Boolean.getBoolean(DCS_AUTO_GIT);
        RequestContext ctx = RequestContext.get();
        if (ctx != null && (tenantCode = ctx.getTenantCode()) != null && !tenantCode.isEmpty()) {
            StringBuilder sb = new StringBuilder(tenantCode).append("_").append(DCS_AUTO_GIT);
            disable = Boolean.getBoolean(sb.toString());
        }
        if (disable) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPORT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EXPORTICON});
        }
    }

    public void codeEditorAction(KingScriptEditorEvent e) {
        String key = e.getKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        KingScriptConfig scriptConfig = KingScriptConfig.getConfig(this.getPageCache());
        switch (key) {
            case "saveCodeEditorCont": {
                if (!this.check(e.getParam())) break;
                this.save(scriptConfig, false, e.getParam());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        KingScriptConfig scriptConfig = KingScriptConfig.getConfig(this.getPageCache());
        switch (key) {
            case "ok": {
                if (!this.check(null)) break;
                this.save(scriptConfig, true, null);
                break;
            }
            case "save": {
                if (!this.check(null)) break;
                this.save(scriptConfig, false, null);
                break;
            }
            case "exit": {
                String code = this.getPageCache().get(CODE);
                if (this.getModel().getDataChanged() || !StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)scriptConfig.getCodeNow(this.getView()))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u7f16\u8f91\u5668\u6570\u636e\u6709\u672a\u4fdd\u5b58\u7684\u6539\u52a8\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"KingScriptPlugin_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_CALL_BACK_EDITOR_SAVE));
                    return;
                }
                this.getView().close();
                break;
            }
            case "export": 
            case "exporticon": {
                String scriptId = KingScriptConfig.getScriptId(this.getPageCache());
                if (StringUtils.isBlank((CharSequence)scriptId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u811a\u672c\u5185\u5bb9\u3002", (String)"KingScriptPlugin_3", (String)"bos-devportal-plugin", (Object[])new Object[0]));
                    return;
                }
                DevportalUtil.exportScriptCallBack(scriptId, this.getView());
                break;
            }
            case "guide": 
            case "guidelabel": {
                this.getView().openUrl("https://vip.kingdee.com/article/474603833033832192");
                break;
            }
            case "baseinfo": 
            case "baseinfolabel": {
                String visitBaseInfo = this.getPageCache().get("visitBaseInfo");
                boolean isVisitBaseInfo = "edit".equals(KingScriptConfig.getViewStatus(this.getPageCache()));
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)visitBaseInfo)) {
                    isVisitBaseInfo = !Boolean.parseBoolean(visitBaseInfo);
                }
                this.getView().setVisible(Boolean.valueOf(isVisitBaseInfo), new String[]{"flexpanelap3"});
                this.getPageCache().put("visitBaseInfo", String.valueOf(isVisitBaseInfo));
            }
        }
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String scriptId = KingScriptConfig.getScriptId(this.getPageCache());
        String status = this.getPageCache().get("viewStatus");
        Object obj = null;
        if (StringUtils.isNotBlank((CharSequence)scriptId)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String bizAppId = (String)parameter.getCustomParam("bizappid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
            String description = dynamicObject.getString("description");
            if ("edit".equals(status)) {
                Object plugin = parameter.getCustomParam("plugin");
                if (plugin != null) {
                    Map pluginMap = (Map)plugin;
                    pluginMap.put("Description", description);
                    this.getView().returnDataToParent(plugin);
                }
            } else {
                String className = dynamicObject.getString("classname");
                this.returnDataToParent(bizAppId, scriptId, className, description, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(KingScriptConfig scriptConfig, boolean close, Map<String, Object> args) {
        try {
            String modifiDateTime;
            String id;
            DynamicObject obj;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String bizAppId = (String)parameter.getCustomParam("bizappid");
            String description = (String)this.getModel().getValue("description");
            String scriptId = scriptConfig.getScriptId();
            if (StringUtils.isBlank((CharSequence)scriptId)) {
                List<DynamicObject> objs = this.addNew(scriptConfig, args);
                if (objs == null || objs.isEmpty()) {
                    return;
                }
                obj = objs.get(0);
                scriptConfig.getUpdateBuild().scriptId = scriptId = obj.getString("id");
                this.requireLock(scriptId);
            } else {
                List<DynamicObject> objs = this.update(scriptConfig, scriptId, args);
                if (objs == null || objs.isEmpty()) {
                    return;
                }
                obj = objs.get(0);
            }
            scriptConfig.getUpdateBuild().content = scriptConfig.getCodeNow(this.getView());
            this.showNotification(args, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"KingScriptPlugin_8", (String)"bos-devportal-plugin", (Object[])new Object[0]), ErrorLevel.Info);
            String className = obj.getString("classname");
            scriptConfig.getUpdateBuild().scriptId = id = obj.getString("id");
            long newModifyDate = Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())).getTime();
            scriptConfig.getUpdateBuild().modifiDateTime = modifiDateTime = String.valueOf(newModifyDate);
            this.getModel().setDataChanged(false);
            if (StringUtils.isNotBlank((CharSequence)className)) {
                Date modifyDate = obj.getDate("modifydate");
                long version = System.currentTimeMillis();
                if (modifyDate != null) {
                    try {
                        version = this.dateFormat.parse(this.dateFormat.format(modifyDate)).getTime();
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                ScriptVersionManager.setVersion((String)className, (String)String.valueOf(version), null);
            }
            if (!close) {
                return;
            }
            scriptConfig.getUpdateBuild().viewStatus = "edit";
            this.returnDataToParent(bizAppId, id, className, description, true);
            this.getView().close();
        }
        finally {
            scriptConfig.getUpdateBuild().update(this.getPageCache());
        }
    }

    private List<DynamicObject> update(KingScriptConfig scriptConfig, String scriptId, Map<String, Object> args) {
        String scriptName = (String)this.getModel().getValue("scriptname");
        String description = (String)this.getModel().getValue("description");
        String scriptNumber = (String)this.getModel().getValue("scriptnumber");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        String content = scriptConfig.getCodeNow(this.getView());
        String bizAppId = scriptConfig.getBizAppId();
        if (StringUtils.isBlank((CharSequence)bizAppId) && StringUtils.isBlank((CharSequence)(bizAppId = dynamicObject.getString("bizappid")))) {
            return null;
        }
        AppInfo masterAppInfo = MetadataDao.getMasterAppInfo((String)bizAppId);
        String appNumber = masterAppInfo != null ? masterAppInfo.getNumber() : AppReader.getAppNumberById((String)bizAppId);
        String className = scriptConfig.getClassName();
        if (StringUtils.isBlank((CharSequence)className)) {
            className = dynamicObject.getString("classname");
        }
        Map<String, String> updateScriptsByApp = Collections.singletonMap(className, content);
        HashMap<String, Object> extraParam = new HashMap<String, Object>(4);
        extraParam.put(SCRIPT_NAME, scriptName);
        extraParam.put("description", description);
        extraParam.put("scriptnumber", scriptNumber);
        extraParam.put(THROW_COMPILE_EXCEPT, false);
        extraParam.put(CLIENT_TYPE, EDITOR);
        Map result = (Map)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"ScriptService", (String)"doMsPushScripts", (Object[])new Object[]{Collections.emptyMap(), Collections.singletonMap(bizAppId, updateScriptsByApp), Collections.emptyMap(), extraParam});
        if ((Integer)result.get("code") == 1) {
            this.showNotification(args, String.format(ResManager.loadKDString((String)"\u7f16\u8bd1\u5931\u8d25\uff0c\u7f16\u8bd1\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"KingScriptPlugin_17", (String)"bos-devportal-plugin", (Object[])new Object[0]), result.get("exceptionMsg")), ErrorLevel.Warning);
        }
        List successObjs = (List)result.get("successObj");
        return successObjs;
    }

    private List<DynamicObject> addNew(KingScriptConfig scriptConfig, Map<String, Object> args) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String formNumber = (String)parameter.getCustomParam("bizpagenumber");
        DynamicObject form = this.getForm();
        String formId = form == null ? "" : form.getPkValue().toString();
        String bizAppId = (String)parameter.getCustomParam("bizappid");
        if (StringUtils.isBlank((CharSequence)bizAppId) && form != null) {
            bizAppId = form.getString("bizappid");
        }
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return null;
        }
        String modelType = (String)parameter.getCustomParam("modelType");
        if (StringUtils.isBlank((CharSequence)modelType) && form != null) {
            modelType = form.getString("modeltype");
        }
        String scriptNumber = (String)this.getModel().getValue("scriptnumber");
        String scriptName = (String)this.getModel().getValue("scriptname");
        String description = (String)this.getModel().getValue("description");
        String content = scriptConfig.getCodeNow(this.getView());
        String bizUnitId = this.getBizunit(formId);
        String className = this.getClassName(bizAppId, scriptNumber, "/");
        String scriptType = KingScriptConfigHelper.getScriptType(this.getView(), modelType);
        String module = this.getModule(bizAppId);
        className = module + "/" + className + ".ts";
        QFilter qClassName = new QFilter("classname", "=", (Object)className);
        QFilter[] filters = new QFilter[]{qClassName};
        if (QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])filters)) {
            this.setFocus("scriptnumber");
            this.showNotification(args, String.format(ResManager.loadKDString((String)"\u811a\u672c\u8def\u5f84%s\u5df2\u5b58\u5728\u3002", (String)"KingScriptPlugin_9", (String)"bos-devportal-plugin", (Object[])new Object[0]), className), ErrorLevel.Warning);
            return null;
        }
        HashMap<String, Object> extraParam = new HashMap<String, Object>(8);
        extraParam.put(SCRIPT_NAME, scriptName);
        extraParam.put("description", description);
        extraParam.put("scriptnumber", scriptNumber);
        extraParam.put("scriptmodule", module);
        extraParam.put(SCRIPT_TYPE, scriptType);
        extraParam.put("bizunitid", bizUnitId);
        extraParam.put(THROW_COMPILE_EXCEPT, false);
        extraParam.put(CLIENT_TYPE, EDITOR);
        AppInfo masterAppInfo = MetadataDao.getMasterAppInfo((String)bizAppId);
        String appNumber = masterAppInfo != null ? masterAppInfo.getNumber() : AppReader.getAppNumberById((String)bizAppId);
        Map<String, String> addScriptsByApp = Collections.singletonMap(className, content);
        Map result = (Map)DispatchServiceHelper.invokeBOSService((String)appNumber, (String)"ScriptService", (String)"doMsPushScripts", (Object[])new Object[]{Collections.singletonMap(bizAppId, addScriptsByApp), Collections.emptyMap(), Collections.emptyMap(), extraParam});
        if ((Integer)result.get("code") == 1) {
            this.showNotification(args, String.format(ResManager.loadKDString((String)"\u7f16\u8bd1\u5931\u8d25\uff0c\u7f16\u8bd1\u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"KingScriptPlugin_17", (String)"bos-devportal-plugin", (Object[])new Object[0]), result.get("exceptionMsg")), ErrorLevel.Warning);
        }
        List successObjs = (List)result.get("successObj");
        return successObjs;
    }

    private boolean requireLock(String scriptId) {
        Tuple mutexInfo = KingScriptMutexViewHelper.doMutex((IFormView)this.getView(), (String)scriptId);
        if (!((Boolean)mutexInfo.getKey()).booleanValue()) {
            this.getView().showErrorNotification((String)mutexInfo.getValue());
        }
        return (Boolean)mutexInfo.getKey();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String actionId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_CALL_BACK_EDITOR_SAVE.equals(actionId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getView().close();
        }
    }
}

