/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.devportal.script.npm.AbstractKingScriptPlugin;
import kd.bos.devportal.script.npm.helper.KingScriptConfigHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.compile.CompileResult;
import kd.sdk.kingscript.engine.compile.CompileTool;
import kd.sdk.kingscript.lib.crypto.CryptoUtil;
import kd.sdk.kingscript.lib.version.ScriptVersionManager;
import org.apache.log4j.Logger;

public class RegisterKingScriptPlugin
extends AbstractKingScriptPlugin {
    private static Logger log = Logger.getLogger(RegisterKingScriptPlugin.class);
    private static final String OK = "ok";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String ENTRY_ENABLE_NAME = "enabled";
    private static final String TXT_SCRIPTCOMPILE_TAG = "txt_scriptcompile_tag";
    private static final String TXT_SCRIPTSRCMAP_TAG = "txt_scriptsrcmap_tag";

    public void initialize() {
        Button btn = (Button)this.getView().getControl(OK);
        btn.addClickListener((ClickListener)this);
        btn = (Button)this.getView().getControl("exit");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (OK.equalsIgnoreCase(btn.getKey())) {
            if (this.check(null)) {
                this.save();
            }
        } else if (btn.getKey().equalsIgnoreCase("exit")) {
            this.getView().close();
        }
    }

    private void save() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String bizAppId = (String)parameter.getCustomParam("bizappid");
        String description = (String)this.getModel().getValue("description");
        boolean enable = (Boolean)this.getModel().getValue(ENTRY_ENABLE_NAME);
        DynamicObject obj = this.addNew();
        if (obj == null) {
            return;
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"KingScriptPlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        String className = obj.getString("classname");
        String scriptName = obj.getString("txt_scriptname");
        String id = obj.getString("id");
        this.getPageCache().put("id", id);
        this.getModel().setDataChanged(false);
        if (StringUtils.isNotBlank((CharSequence)className)) {
            Date modifyDate = obj.getDate("modifydate");
            long version = System.currentTimeMillis();
            if (modifyDate != null) {
                try {
                    version = this.dateFormat.parse(this.dateFormat.format(modifyDate)).getTime();
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            ScriptVersionManager.setVersion((String)className, (String)String.valueOf(version), null);
        }
        this.showKingscriptEditor(id);
        this.getPageCache().put("viewStatus", "edit");
        this.returnDataToParent(bizAppId, id, className, scriptName, description, enable);
        this.getView().close();
    }

    private void showKingscriptEditor(String scriptId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setCustomParam("isEdit", (Object)"isEdit");
        parameter.setCustomParam("formnumber", this.getView().getFormShowParameter().getCustomParam("formnumber"));
        parameter.setCustomParam("bizscriptid", (Object)scriptId);
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
        parameter.setFormId("ide_register_ts_plugin");
        String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)((String)parameter.getCustomParam("bizappid")), (String)((String)parameter.getCustomParam("bizpagenumber")));
        parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit"));
        this.getView().showForm(parameter);
    }

    private DynamicObject addNew() {
        DynamicObject scriptObj;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        DynamicObject form = this.getForm();
        String formId = form == null ? "" : form.getPkValue().toString();
        String bizAppId = (String)parameter.getCustomParam("bizappid");
        if (StringUtils.isBlank((CharSequence)bizAppId) && form != null) {
            bizAppId = form.getString("bizappid");
        }
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return null;
        }
        String modelType = (String)parameter.getCustomParam("modelType");
        if (StringUtils.isBlank((CharSequence)modelType) && form != null) {
            modelType = form.getString("modeltype");
        }
        String scriptNumber = (String)this.getModel().getValue("scriptnumber");
        String scriptName = (String)this.getModel().getValue("scriptname");
        String description = (String)this.getModel().getValue("description");
        String id = Uuid8.generateShortUuid();
        String bizUnitId = this.getBizunit(formId);
        String className = this.getClassName(bizAppId, scriptNumber, "/");
        String scriptType = KingScriptConfigHelper.getScriptType(this.getView(), modelType);
        String module = this.getModule(bizAppId);
        className = module + "/" + className + ".ts";
        QFilter qClassName = new QFilter("classname", "=", (Object)className);
        QFilter[] filters = new QFilter[]{qClassName};
        if (QueryServiceHelper.exists((String)"ide_pluginscript", (QFilter[])filters)) {
            this.setFocus("scriptnumber");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u811a\u672c\u8def\u5f84%s\u5df2\u5b58\u5728\u3002", (String)"KingScriptPlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), className));
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"ide_pluginscript");
        dynamicObject.set("enginetype", (Object)"1");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("txt_scriptname", (Object)scriptName);
        dynamicObject.set("txt_scriptnumber", (Object)scriptNumber);
        dynamicObject.set("description", (Object)description);
        dynamicObject.set("classname", (Object)className);
        dynamicObject.set("scriptmodule", (Object)module);
        dynamicObject.set("cbox_script_type", (Object)scriptType);
        dynamicObject.set("bizunitid", (Object)bizUnitId);
        dynamicObject.set("bizappid", (Object)bizAppId);
        String ScriptContent = "";
        String templateId = this.getTemplateId();
        if (StringUtils.isNotBlank((CharSequence)templateId) && (scriptObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"ide_pluginscript")) != null) {
            String content = scriptObj.getString("txt_scriptcontext_tag");
            StringBuffer title = this.initTitleContent();
            title.append(content);
            ScriptContent = title.toString();
            this.compileScript(className, content, dynamicObject);
        }
        dynamicObject.set("txt_scriptcontext_tag", (Object)ScriptContent);
        dynamicObject.set("txt_scriptcontext", (Object)" ");
        dynamicObject.set("creater", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("createdate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        dynamicObject.set("modifier", (Object)Long.valueOf(RequestContext.get().getUserId()));
        dynamicObject.set("modifydate", (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
        String isv = dynamicObject.getString("isv");
        if (StringUtils.isBlank((CharSequence)isv)) {
            isv = ISVService.getISVInfo().getId();
            dynamicObject.set("isv", (Object)isv);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    private void compileScript(String scriptPath, String scriptContext, DynamicObject dynamicObject) {
        HashMap<String, String> tsSourceMap = new HashMap<String, String>(1);
        tsSourceMap.put(scriptPath, scriptContext);
        Map compileResultMap = new HashMap(1);
        try (KingScriptEngine engine2 = ProjectInitializerManager.getEngine((boolean)false);){
            if (engine2 != null) {
                compileResultMap = CompileTool.compile((KingScriptEngine)engine2, tsSourceMap);
            }
        }
        catch (Throwable engine2) {
            // empty catch block
        }
        CompileResult compileResult = (CompileResult)compileResultMap.get(scriptPath);
        if (compileResult == null) {
            log.error((Object)("compile blank. scriptPath:" + scriptPath + ", scriptContext:" + scriptContext));
        }
        if (compileResult != null) {
            String compiledScript = compileResult.getTarget();
            if (StringUtils.isNotBlank((CharSequence)compiledScript)) {
                String encryptedScript = CryptoUtil.encrypt((String)"default", (String)compiledScript);
                dynamicObject.set(TXT_SCRIPTCOMPILE_TAG, (Object)encryptedScript);
            }
            if (StringUtils.isNotBlank((CharSequence)compileResult.getSourceMapping())) {
                dynamicObject.set(TXT_SCRIPTSRCMAP_TAG, (Object)compileResult.getSourceMapping());
            }
        }
    }
}

