/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.script.npm.helper;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.kingscript.KingScriptType;
import kd.bos.devportal.script.npm.KingScriptConfig;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.isv.ISVService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class KingScriptConfigHelper {
    private static final String FORMTS = "p1MEoP47";
    private static final String BILLTS = "rnry3Wse";
    private static final String LISTTS = "ZMJMZ50L";
    private static final String OPERATIONTS = "npsEzBqI";
    private static final String MOBILE_FORM = "J1oZDEE4";
    private static final String MOBILE_BILL = "H0j7Vznm";
    private static final String MOBILE_BILL_LIST = "RIe5s2q5";
    private static final String TEMPLATE_CONVERTTS = "6cIzjiU6";
    private static final String TEMPLATE_WRITEBACKTS = "Y4UMjaPu";
    private static final String TEMPLATE_PRINTTS = "LuEmc1Gj";

    public static boolean isDebugEnable(String className) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)className)) {
            return false;
        }
        String debugEnable = System.getProperty("kingscript.debug.enable", "true");
        return Boolean.parseBoolean(debugEnable);
    }

    public static boolean isEditEnable(String scriptId) {
        boolean editEnable = true;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)scriptId)) {
            return editEnable;
        }
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)"ide_pluginscript");
        String sriptIsv = scriptInfo.getString("isv");
        String isv = ISVService.getISVInfo().getId();
        if (isv == null || !isv.equalsIgnoreCase(sriptIsv)) {
            editEnable = false;
        }
        return editEnable;
    }

    public static boolean isCodeDemoEnable() {
        String codeDemoEnable = System.getProperty("kingscript.codedemo.enable", "true");
        return Boolean.parseBoolean(codeDemoEnable);
    }

    public static boolean enableGPT() {
        String tenantId = RequestContext.get().getTenantId();
        String value = SystemPropertyUtils.getProptyByTenant((String)"kingscript.editor.gpt.enable", (String)tenantId);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return Boolean.FALSE;
    }

    public static String getScriptType(IFormView view, String modelType) {
        return KingScriptType.getScriptType((IFormView)view, (String)modelType, KingScriptConfigHelper::getBillScriptType);
    }

    private static String getBillScriptType(IFormView view) {
        String designerName = KingScriptConfig.getDesignerName(view.getPageCache());
        String type = "2";
        if (StringUtils.isNotBlank((CharSequence)designerName)) {
            switch (designerName) {
                case "MobListMeta": 
                case "ListMeta": {
                    type = "3";
                    break;
                }
                case "MobMeta": {
                    type = "2";
                }
            }
        }
        return type;
    }

    public static String getTemplateId(KingScriptConfig designerConfig, IFormView view) {
        String modelType = (String)view.getFormShowParameter().getCustomParam("modelType");
        String scriptTypeFilter = (String)view.getFormShowParameter().getCustomParams().get("scripttypefilter");
        String id = "";
        if ("operate".equals(scriptTypeFilter)) {
            id = OPERATIONTS;
            return id;
        }
        if (StringUtils.isBlank((CharSequence)modelType)) {
            return "";
        }
        if ("importData".equals(scriptTypeFilter)) {
            return "";
        }
        if ("writebackplugin".equalsIgnoreCase(modelType)) {
            modelType = "WriteBackRuleModel";
        }
        switch (modelType) {
            case "BillFormModel": 
            case "BaseFormModel": 
            case "MobileBillFormModel": {
                id = KingScriptConfigHelper.getBillTemplate(designerConfig, view.getPageCache(), modelType);
                break;
            }
            case "DynamicFormModel": {
                id = FORMTS;
                break;
            }
            case "MobileFormModel": {
                id = MOBILE_FORM;
                break;
            }
            case "MobileListModel": {
                id = MOBILE_BILL_LIST;
                break;
            }
            case "ConvertRuleModel": {
                id = TEMPLATE_CONVERTTS;
                break;
            }
            case "WriteBackRuleModel": {
                id = TEMPLATE_WRITEBACKTS;
                break;
            }
            case "PrintModel": {
                id = TEMPLATE_PRINTTS;
            }
        }
        return id;
    }

    private static String getBillTemplate(KingScriptConfig designerConfig, IPageCache pageCache, String modelType) {
        String designerName;
        String id = BILLTS;
        String string = designerName = designerConfig == null ? "" : designerConfig.getDesignerName();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)designerName)) {
            designerName = KingScriptConfig.getDesignerName(pageCache);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)designerName)) {
            switch (designerName) {
                case "ListMeta": {
                    id = LISTTS;
                    break;
                }
                case "MobMeta": {
                    id = MOBILE_BILL;
                    break;
                }
                case "MobListMeta": {
                    id = MOBILE_BILL_LIST;
                }
            }
        } else if ("MobileBillFormModel".equals(modelType)) {
            id = MOBILE_BILL;
        }
        return id;
    }
}

