/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.validation.constraints.NotNull;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.business.pojo.PortalSchemeFile;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.DBVersion;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.DeployService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.FileUtils;
import kd.bos.util.SAXReaderUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@SdkPublic
public class AppPackageUtil {
    private static Log logger = LogFactory.getLog(AppPackageUtil.class);
    private static final String SOURCE_NAME = "name";
    private static final String SOURCE_ID = "id";
    private static final String SOURCE_NUMBER = "number";
    private static final String APP_ID = "appmeta#firmenu";
    private static final String APP_NUM = "appnum";
    private static final String PAGE_ID = "pagemeta#firmenu";
    private static final String PAGE_NUM = "pagenum";
    private static final String SCRIPT_ID = "scriptmeta#firmenu";
    private static final String SCRIPT_NUM = "scriptnum";
    private static final String BILLTYPE_ID = "billtypemeta#firmenu";
    private static final String BILLTYPE_NUM = "billtypenum";
    private static final String CODERULE_ID = "coderulemeta#firmenu";
    private static final String CODERULE_NUM = "coderulenum";
    private static final String CLOUD_ID = "cloudmeta#firmenu";
    private static final String CLOUD_NUM = "cloudnum";
    private static final String SCHEMA_ID = "schemameta#firmenu";
    private static final String SCHEMA_NUM = "schemanum";
    private static final String WORKBENCH_ID = "workbench#firmenu";
    private static final String WORKBENCH_NUM = "workbenchnum";
    private static final String URL_NAME = "urlname";
    private static final String URL = "url";
    private static final String DATABASE = "databasetype";
    private static final String BIZAPPID = "bizappid";
    private static final String DATAMODEL = "datamodel";
    private static final String PREINSDATA = "preinsdata";
    private static final String FOURBLANK = "\n    ";
    private static final String EIGHTBLANK = "\n        ";
    private static final String TWELVEBLANK = "\n            ";
    private static final String NEXTLINE = ";\t\n";
    private static final String KSQLEXCEPTION = "KSQLExpPlugin error:%s.";
    private static final String STRINGCOSTANT = "string";
    private static final String SEPARATOR = "Separator";
    private static final String DBKEY = "dbkey";
    private static final String SQLSCRIPT = "SqlScript";
    private static final String COSMIC_CUS = "cosmic_cus_";
    private static final String KDPKG = "kdpkg";
    private static final String SOURCEPATH = "sourcePath";
    public static final String STATICRESOURCE = "staticResource";
    public static final String DM = "dm";
    public static final String JAR = "jar";
    public static final String WEBAPP = "webapp";
    public static final String CUSTOMSTATIC = "customstatic";
    public static final String OEMFormatVer = "1.4";
    private static final String SECRET = "secret";
    private static final String SOURCE_PACKAGE = "Package";
    private static final String SOURCE_VER = "ver";
    private static final String SOURCE_APP = "app";
    private static final String SOURCE_ITEM = "item";
    private static final String SOURCE_PKNAME = "pkname";
    private static final String SOURCE_PATH = "path";
    private static final String SOURCE_DATAMODEL = "DataModel";
    private static final String SOURCE_DYMPATH = "dympath";
    private static final String SOURCE_XMLPATH = "xmlpath";
    private static final String SOURCE_SQLSCRIPT = "SqlScript";
    private static final String SOURCE_TYPE = "Type";
    private static final String SOURCE_SEPARATOR = "Separator";
    private static final String SOURCE_DBKEY = "dbkey";
    private static final String SOURCE_ERRORLEVEL = "ErrorLevel";
    private static final String SOURCE_PLUGIN = "Plugin";
    private static final String SOURCE_KDPKGS = "kdpkgs";
    private static final String SOURCE_ATTR_ISV = "isv";
    private static final String SOURCE_FORMAT = "format";
    private static final String SOURCE_ATTR_VER = "ver";
    private static final String SOURCE_DESCRIPTION = "description";
    private static final String SOURCE_TIME = "time";
    private static final String SOURCE_CONTENT = "content";
    private static final String SOURCE_PRODUCT = "product";
    private static final String SOURCE_NAMECN = "nameCN";
    private static final String SOURCE_APPIDS = "appids";
    private static final String SOURCE_DEPENDON = "dependon";
    private static final String SOURCE_RESOURCE = "resource";
    private static final String SOURCE_KDPKG = "kdpkg";
    private static final String SOURCE_KDPKG_ID = "ID";
    private static final String SOURCE_MD5 = "md5";
    private static final String SOURCE_SECRET = "secret";
    private static final String SOURCE_KDPKG_TYPE = "type";
    private static final String SOURCE_SOURCEPATH = "sourcePath";
    private static final String SOURCE_OUTPUTPATH = "outputPath";
    private static final long LIMITSIZ = 0x1400000L;
    private static IAppMetaServiceHelper appMetaServiceHelper = new /* Unavailable Anonymous Inner Class!! */;

    public static String getProductName() {
        return ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79(\u4e8c\u5f00)", (String)"AppPackageUtil_13", (String)"bos-devportal-plugin", (Object[])new Object[0]);
    }

    private AppPackageUtil() {
        throw new IllegalStateException("AppPackageUtil cannot be instantiated");
    }

    public static void createAppInfo(String zipPath, List<String> appNumbers, String packagePath) {
        String checkPackagePath = DevportalUtil.checkFilePath(packagePath);
        OutputFormat format = OutputFormat.createPrettyPrint();
        try {
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("AppDataModel");
            int i = 1;
            for (String appNumber : appNumbers) {
                root.addElement("AppSeq").addAttribute(SOURCE_ID, appNumber).addAttribute("seq", String.valueOf(i));
                ++i;
            }
            checkPackagePath = FileUtils.cleanString((String)checkPackagePath);
            Path customZipPath = Paths.get(checkPackagePath, new String[0]);
            XMLWriter writer = new XMLWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), format);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            AppPackageUtil.setErrorLog(e);
        }
    }

    public static void createAppXML(@NotNull String appNum, List<Map<String, String>> sqlList, @NotNull String mainPath, boolean hasXmlFlag) {
        DynamicObject appInfoObj = AppPackageUtil.getAppInfo(appNum);
        String dbRoute = appInfoObj.getString("dbroute");
        String checkAppPath = FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", mainPath, File.separator, appNum));
        String appXMLPathStr = FileUtils.cleanString((String)(checkAppPath + File.separator + appNum + ".xml"));
        Path appXMLPath = Paths.get(appXMLPathStr, new String[0]);
        try (OutputStream os = Files.newOutputStream(appXMLPath, new OpenOption[0]);){
            TransformerHandler handler = AppPackageUtil.getTransformerHandler(os);
            AttributesImpl rootImple = new AttributesImpl();
            handler.startDocument();
            handler.characters(FOURBLANK.toCharArray(), 0, 1);
            rootImple.addAttribute("", "", SOURCE_DYMPATH, STRINGCOSTANT, "metadata");
            if (hasXmlFlag) {
                rootImple.addAttribute("", "", SOURCE_XMLPATH, STRINGCOSTANT, "preinsdata/xml");
            }
            handler.startElement("", "", SOURCE_DATAMODEL, rootImple);
            for (Map<String, String> sqlMap : sqlList) {
                String sqlFileName = sqlMap.get("sqlfilename");
                String fileType = sqlMap.get("sqlfiletype");
                String dbType = sqlMap.get("dbtype");
                String dbRouteKey = sqlMap.get("dbroute");
                dbRoute = StringUtils.isBlank((CharSequence)dbRouteKey) ? dbRoute : dbRouteKey;
                AttributesImpl attrImple = new AttributesImpl();
                attrImple.addAttribute("", "", SOURCE_TYPE, STRINGCOSTANT, dbType);
                attrImple.addAttribute("", "", "Separator", STRINGCOSTANT, ";");
                attrImple.addAttribute("", "", "dbkey", STRINGCOSTANT, dbRoute);
                String relativePath = String.format("%1$s%2$s%3$s", fileType, "/", sqlFileName);
                AppPackageUtil.createElementWithoutAttribute(handler, attrImple, FOURBLANK, relativePath, "SqlScript");
            }
            handler.endElement("", "", SOURCE_DATAMODEL);
            handler.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            AppPackageUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static DynamicObject getAppInfo(String appNum) {
        QFilter filter = new QFilter(SOURCE_NUMBER, "=", (Object)appNum);
        DynamicObjectCollection appColl = ORM.create().query("bos_devportal_bizapp", filter.toArray());
        DynamicObject appInfoObj = (DynamicObject)appColl.get(0);
        return appInfoObj;
    }

    @Deprecated
    public static void createAppXML(String bizAppId, String bizAppNum, String appPath, JSONArray dbschemaArr, JSONArray preinsdataArr, List<String> sqlNameList, boolean hasXmlFlag) {
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        AppPackageUtil.createAppXML(appMeta.getAppElement().getDbRoute(), bizAppId, bizAppNum, appPath, dbschemaArr, preinsdataArr, sqlNameList, hasXmlFlag);
    }

    @Deprecated
    protected static void createAppXML(String dbRoute, String bizAppId, String bizAppNum, String appPath, JSONArray dbschemaArr, JSONArray preinsdataArr, List<String> sqlNameList, boolean hasXmlFlag) {
        String checkAppPath = DevportalUtil.checkFilePath(appPath);
        String appXMLPath = FileUtils.cleanString((String)(checkAppPath + File.separator + bizAppNum + ".xml"));
        Path customZipPath = Paths.get(appXMLPath, new String[0]);
        try (OutputStream os = Files.newOutputStream(customZipPath, new OpenOption[0]);){
            AttributesImpl attrImple;
            String dataBaseType;
            int i;
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(os);
            AttributesImpl coderuleImple = new AttributesImpl();
            AttributesImpl rootImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, 1);
            rootImple.addAttribute("", "", SOURCE_DYMPATH, STRINGCOSTANT, "metadata");
            if (hasXmlFlag) {
                rootImple.addAttribute("", "", SOURCE_XMLPATH, STRINGCOSTANT, "preinsdata/xml");
            }
            transformerHandle.startElement("", "", SOURCE_DATAMODEL, rootImple);
            coderuleImple.addAttribute("", "", SOURCE_TYPE, STRINGCOSTANT, "KSQL");
            coderuleImple.addAttribute("", "", "Separator", STRINGCOSTANT, ";");
            coderuleImple.addAttribute("", "", "dbkey", STRINGCOSTANT, "basedata");
            if (dbschemaArr != null && dbschemaArr.size() > 0) {
                for (i = 0; i < dbschemaArr.size(); ++i) {
                    JSONObject dbschemaObj = (JSONObject)dbschemaArr.get(i);
                    String dbschema = dbschemaObj.getString(URL_NAME);
                    dataBaseType = dbschemaObj.getString(DATABASE);
                    attrImple = new AttributesImpl();
                    attrImple.addAttribute("", "", SOURCE_TYPE, STRINGCOSTANT, dataBaseType);
                    attrImple.addAttribute("", "", "Separator", STRINGCOSTANT, ";");
                    attrImple.addAttribute("", "", "dbkey", STRINGCOSTANT, dbRoute);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, attrImple, FOURBLANK, "dbschema/" + dbschema, "SqlScript");
                }
            }
            if (preinsdataArr != null && preinsdataArr.size() > 0) {
                for (i = 0; i < preinsdataArr.size(); ++i) {
                    JSONObject preinsdataObj = (JSONObject)preinsdataArr.get(i);
                    String preinsdata = preinsdataObj.getString(URL_NAME);
                    dataBaseType = preinsdataObj.getString(DATABASE);
                    attrImple = new AttributesImpl();
                    attrImple.addAttribute("", "", SOURCE_TYPE, STRINGCOSTANT, dataBaseType);
                    attrImple.addAttribute("", "", "Separator", STRINGCOSTANT, ";");
                    attrImple.addAttribute("", "", "dbkey", STRINGCOSTANT, dbRoute);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, attrImple, FOURBLANK, "preinsdata/" + preinsdata, "SqlScript");
                }
            }
            for (String sqlName : sqlNameList) {
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, coderuleImple, FOURBLANK, "preinsdata/" + sqlName, "SqlScript");
            }
            transformerHandle.endElement("", "", SOURCE_DATAMODEL);
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            AppPackageUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<Map<String, String>> getAppXmlPathByDataModelXml(String datamodelXmlContent) throws DocumentException {
        ByteArrayInputStream dmXmlInputStream = new ByteArrayInputStream(datamodelXmlContent.getBytes(StandardCharsets.UTF_8));
        SAXReader reader = SAXReaderUtil.getSAXReader();
        reader.setEncoding(StandardCharsets.UTF_8.name());
        Document document = reader.read((InputStream)dmXmlInputStream);
        String cloudNum = document.getRootElement().attributeValue(SOURCE_NAME);
        String version = document.getRootElement().element("ver").getText();
        List elements = document.getRootElement().element(SOURCE_APP).elements();
        ArrayList<Map<String, String>> appXmlPathList = new ArrayList<Map<String, String>>(elements.size());
        for (Element element : elements) {
            String name = element.attributeValue(SOURCE_NAME);
            String appName = cloudNum + "-" + name;
            appName = appName.length() > 10 ? name : appName;
            String pkname = element.attributeValue(SOURCE_PKNAME);
            String subPath = element.attributeValue(SOURCE_PATH);
            String appXmlPath = String.format("%1$s%2$s%3$s%4$s%5$s%6$s%7$s.xml", DATAMODEL, Character.valueOf(File.separatorChar), version, Character.valueOf(File.separatorChar), subPath, Character.valueOf(File.separatorChar), name);
            appXmlPath = appXmlPath.replace(File.separator, "/");
            HashMap<String, String> appXmlInfoMap = new HashMap<String, String>();
            appXmlInfoMap.put("appxmlpath", appXmlPath);
            appXmlInfoMap.put("version", version);
            appXmlInfoMap.put("appname", appName);
            appXmlInfoMap.put(SOURCE_PKNAME, pkname);
            appXmlPathList.add(appXmlInfoMap);
        }
        return appXmlPathList;
    }

    public static List<Map<String, String>> paraseAppXml(String appXmlContent) {
        ArrayList<Map<String, String>> sqlFileList = new ArrayList<Map<String, String>>();
        SAXReader xmlReader = SAXReaderUtil.getSAXReader();
        xmlReader.setEncoding(StandardCharsets.UTF_8.name());
        ByteArrayInputStream is = new ByteArrayInputStream(appXmlContent.getBytes(StandardCharsets.UTF_8));
        Document xmlDoc = null;
        List sqlElements = null;
        try {
            xmlDoc = xmlReader.read((InputStream)is);
            sqlElements = xmlDoc.getRootElement().elements();
        }
        catch (DocumentException e) {
            AppPackageUtil.setErrorLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)((Object)e)));
            throw new RuntimeException(e);
        }
        if (sqlElements != null && !sqlElements.isEmpty()) {
            for (Element element : sqlElements) {
                String type = element.attributeValue(SOURCE_TYPE);
                String separator = element.attributeValue("Separator");
                separator = separator == null ? ";" : separator;
                String dbKey = element.attributeValue("dbkey");
                String errorLevel = element.attributeValue(SOURCE_ERRORLEVEL);
                errorLevel = errorLevel == null ? "" : errorLevel;
                String plugin = element.attributeValue(SOURCE_PLUGIN);
                String sqlFilePath = element.getText();
                HashMap<String, String> sqlFileInfoMap = new HashMap<String, String>();
                sqlFileInfoMap.put("sqlfilepath", sqlFilePath);
                sqlFileInfoMap.put(SOURCE_KDPKG_TYPE, type);
                sqlFileInfoMap.put("separator", separator);
                sqlFileInfoMap.put("dbkey", dbKey);
                sqlFileInfoMap.put("errorlevel", errorLevel);
                if (StringUtils.isNotBlank((CharSequence)plugin)) {
                    sqlFileInfoMap.put("plugin", plugin);
                }
                sqlFileList.add(sqlFileInfoMap);
            }
        }
        return sqlFileList;
    }

    public static void exportSchOrPreSource(String appPath, String urlName, String url, String sourceType) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (TXHandle tx = TX.required((String)"mdl_BizAppDeployTreePlugin_exportSchOrPreSource");){
            String dbOrPrePath = null;
            String dbOrPreFullPath = null;
            appPath = DevportalUtil.checkFilePath(appPath);
            if (sourceType.equals("dbschema")) {
                dbOrPrePath = appPath + File.separator + "dbschema";
                dbOrPreFullPath = dbOrPrePath + File.separator + urlName;
            } else {
                dbOrPrePath = appPath + File.separator + PREINSDATA;
                dbOrPreFullPath = dbOrPrePath + File.separator + urlName;
            }
            dbOrPrePath = FileUtils.cleanString((String)dbOrPrePath);
            File dbOrPreFile = new File(dbOrPrePath);
            if (!dbOrPreFile.exists()) {
                dbOrPreFile.mkdirs();
            }
            Path customZipPath = Paths.get(dbOrPreFullPath, new String[0]);
            try (InputStream inputStream = cache.getInputStream(url);
                 BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8));){
                String line = null;
                while ((line = in.readLine()) != null) {
                    bw.write(line);
                    bw.newLine();
                    bw.flush();
                }
            }
            catch (Exception exception) {
                AppPackageUtil.setErrorLog(exception);
            }
        }
    }

    public static void exportJarOrStaticSource(String zipPath, String urlName, String url, String relativePath) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        logger.debug("cache=" + cache);
        try (TXHandle tx = TX.required((String)"mdl_BizAppDeployTreePlugin_exportSchOrPreSource");){
            zipPath = DevportalUtil.checkFilePath(zipPath);
            String libPath = FileUtils.cleanString((String)(zipPath + File.separator + relativePath));
            File libFile = new File(libPath);
            if (!libFile.exists()) {
                libFile.mkdirs();
            }
            String jarPath = FileUtils.cleanString((String)(libPath + File.separator + urlName));
            Path customZipPath = Paths.get(jarPath, new String[0]);
            try (InputStream inputStream = cache.getInputStream(url);
                 OutputStream bos = Files.newOutputStream(customZipPath, new OpenOption[0]);){
                int readLength = 0;
                byte[] buf = new byte[0x100000];
                while ((readLength = inputStream.read(buf)) != -1) {
                    bos.write(buf, 0, readLength);
                }
                bos.close();
            }
            catch (Exception exception) {
                AppPackageUtil.setErrorLog(exception);
            }
        }
    }

    public static void exportCustomResource(String sourceUrl, String schemaPath, String zipPath, String schemaId) throws IOException {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        schemaPath = FileUtils.cleanString((String)DevportalUtil.checkFilePath(schemaPath));
        File customFile = new File(schemaPath);
        customFile.mkdirs();
        try (InputStream inputStream = fileService.getInputStream(sourceUrl);
             ZipInputStream zipIn = new ZipInputStream(inputStream);){
            ZipEntry entry = null;
            while ((entry = zipIn.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 1);
                    File entryFile = new File(schemaPath);
                    entryFile.mkdirs();
                    continue;
                }
                String childFilePath = FileUtils.cleanString((String)(schemaPath + File.separator + entry.getName()));
                File child = new File(childFilePath);
                String childPath = FileUtils.cleanString((String)child.getCanonicalPath());
                if (childPath.contains("\\")) {
                    childPath = childPath.replace('\\', '/');
                    child = new File(childPath);
                }
                if (!child.getParentFile().exists()) {
                    child.getParentFile().mkdirs();
                }
                Path customZipPath = Paths.get(childFilePath, new String[0]);
                try {
                    OutputStream outPutStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                    Object object = null;
                    try {
                        int len = 0;
                        byte[] buf = new byte[1024];
                        while ((len = zipIn.read(buf)) != -1) {
                            outPutStream.write(buf, 0, len);
                        }
                    }
                    catch (Throwable len) {
                        object = len;
                        throw len;
                    }
                    finally {
                        if (outPutStream == null) continue;
                        if (object != null) {
                            try {
                                outPutStream.close();
                            }
                            catch (Throwable len) {
                                ((Throwable)object).addSuppressed(len);
                            }
                            continue;
                        }
                        outPutStream.close();
                    }
                }
                catch (Exception exception) {
                    AppPackageUtil.setErrorLog(exception);
                }
            }
            String jsonPath = zipPath + File.separator + "schemasource" + File.separator + schemaId;
            ArrayList<String> fileList = new ArrayList<String>();
            List<String> schemaList = DevportalUtil.recursiveFiles(schemaPath, fileList);
            HashMap agencyMap = new HashMap();
            ArrayList<String> jsonStr = new ArrayList<String>(schemaList.size());
            for (String schemaFileName : schemaList) {
                String replaceSchema = schemaFileName.replace(File.separator, "/");
                String schemaFile = replaceSchema.substring(replaceSchema.indexOf(WEBAPP));
                jsonStr.add(schemaFile);
            }
            agencyMap.put("modify", jsonStr);
            String keyListValue = SerializationUtils.toJsonString(agencyMap);
            DevportalUtil.createJsonFile(keyListValue, jsonPath, WEBAPP);
        }
        catch (Exception exception) {
            AppPackageUtil.setErrorLog(exception);
        }
    }

    public static void getJarAndStaticResource(JSONArray jarMsg, JSONArray staticSourceMsg, IDataModel dataModel) {
        int sourceRowCount = dataModel.getEntryRowCount("sourceentryentity");
        for (int i = 0; i < sourceRowCount; ++i) {
            JSONObject sourceObject = new JSONObject();
            String sourceType = (String)dataModel.getValue("sourcetype", i);
            String sourceName = (String)dataModel.getValue("sourcename", i);
            String sourcePath = (String)dataModel.getValue("sourceurl", i);
            String sourceAppId = (String)dataModel.getValue("sourceappid", i);
            sourceObject.put(URL_NAME, (Object)sourceName);
            sourceObject.put(URL, (Object)sourcePath);
            sourceObject.put("sourceappid", (Object)sourceAppId);
            if (ResManager.loadKDString((String)"\u9759\u6001\u8d44\u6e90", (String)"AppPackageUtil_9", (String)"bos-devportal-plugin", (Object[])new Object[0]).equals(sourceType)) {
                staticSourceMsg.add((Object)sourceObject);
                continue;
            }
            if (!ResManager.loadKDString((String)"JAR\u5305", (String)"AppPackageUtil_10", (String)"bos-devportal-plugin", (Object[])new Object[0]).equals(sourceType)) continue;
            jarMsg.add((Object)sourceObject);
        }
    }

    public static void putSqlIntoApp(int sqlRowCount, String selectAppId, JSONArray dbschemaMsg, JSONArray preinsdataMsg, IDataModel dataModel) {
        for (int i = 0; i < sqlRowCount; ++i) {
            JSONObject sqlObject = new JSONObject();
            String sqlAppId = (String)dataModel.getValue("sqlappid", i);
            String sqlType = (String)dataModel.getValue("sqltype", i);
            String sqlName = (String)dataModel.getValue("sqlname", i);
            String sqlPath = (String)dataModel.getValue("urlpath", i);
            String dataBaseType = (String)dataModel.getValue(DATABASE, i);
            if (!sqlAppId.equals(selectAppId)) continue;
            sqlObject.put(URL_NAME, (Object)sqlName);
            sqlObject.put(URL, (Object)sqlPath);
            sqlObject.put(DATABASE, (Object)dataBaseType);
            sqlObject.put("sqlappid", (Object)sqlAppId);
            if (ResManager.loadKDString((String)"\u5efa\u8868SQL", (String)"AppPackageUtil_11", (String)"bos-devportal-plugin", (Object[])new Object[0]).equals(sqlType)) {
                dbschemaMsg.add((Object)sqlObject);
                continue;
            }
            if (!ResManager.loadKDString((String)"\u9884\u7f6eSQL", (String)"AppPackageUtil_12", (String)"bos-devportal-plugin", (Object[])new Object[0]).equals(sqlType)) continue;
            preinsdataMsg.add((Object)sqlObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportPageScheme(List<Long> wkBenchList, String mainPath, List<String> sqlNameList) {
        Map<Long, PortalSchemeFile> pageSchemeMap = AppPackageUtil.exportPageScheme(wkBenchList);
        boolean hasXml = false;
        for (Map.Entry<Long, PortalSchemeFile> entry : pageSchemeMap.entrySet()) {
            Map xmlMap;
            PortalSchemeFile portalSchemeFile = entry.getValue();
            String portalSchemeSqlName = portalSchemeFile.getFileName();
            sqlNameList.add(portalSchemeSqlName);
            String portalSchemeSqlContent = portalSchemeFile.getSql();
            String checkMainPath = DevportalUtil.checkFilePath(mainPath);
            String pageSchemeFilePath = FileUtils.cleanString((String)(checkMainPath + File.separator + PREINSDATA + File.separator + portalSchemeSqlName));
            String pageSchemeXmlPath = FileUtils.cleanString((String)(checkMainPath + File.separator + PREINSDATA + File.separator + "xml"));
            File pageSchemeFile = new File(pageSchemeFilePath);
            File pageSchemeParentFile = pageSchemeFile.getParentFile();
            if (!pageSchemeParentFile.exists()) {
                pageSchemeParentFile.mkdirs();
            }
            Path customZipPath = Paths.get(pageSchemeFilePath, new String[0]);
            if (!pageSchemeFile.exists()) {
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);
                    Object object = null;
                    try {
                        writer.write(portalSchemeSqlContent);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (object != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    AppPackageUtil.setErrorLog(e);
                }
            }
            if ((xmlMap = portalSchemeFile.getXmlMap()) == null || xmlMap.isEmpty()) continue;
            hasXml = true;
            for (Map.Entry entry2 : xmlMap.entrySet()) {
                String xmlName = (String)entry2.getKey();
                StringWriter xmlContent = (StringWriter)entry2.getValue();
                String xmlFilePath = FileUtils.cleanString((String)(pageSchemeXmlPath + File.separator + xmlName));
                XMLWriter writer = null;
                try {
                    Document document = SAXReaderUtil.parseText((String)xmlContent.toString());
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setEncoding(StandardCharsets.UTF_8.name());
                    format.setTrimText(false);
                    File xmlPathFile = new File(pageSchemeXmlPath);
                    if (!xmlPathFile.exists()) {
                        xmlPathFile.mkdirs();
                    }
                    Path customXmlPath = Paths.get(FileUtils.cleanString((String)DevportalUtil.checkFilePath(xmlFilePath)), new String[0]);
                    writer = new XMLWriter(Files.newOutputStream(customXmlPath, new OpenOption[0]), format);
                    writer.write(document);
                }
                catch (Exception e) {
                    AppPackageUtil.setErrorLog(e);
                }
                finally {
                    if (writer == null) continue;
                    try {
                        writer.close();
                    }
                    catch (IOException ioException) {
                        AppPackageUtil.setErrorLog(ioException);
                    }
                }
            }
        }
        return hasXml;
    }

    @Deprecated
    public static void createDataModelXML(String bizAppId, String selectAppNum, String bizCloudNum, String appVersion, String zipPath) {
        zipPath = DevportalUtil.checkFilePath(zipPath);
        String dataModelPath = FileUtils.cleanString((String)(zipPath + File.separator + DATAMODEL + File.separator + "datamodel.xml"));
        Path customZipPath = Paths.get(dataModelPath, new String[0]);
        try (OutputStream out = Files.newOutputStream(customZipPath, new OpenOption[0]);){
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(out);
            AttributesImpl attrImple = new AttributesImpl();
            AttributesImpl rootImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, 1);
            if (bizCloudNum.equalsIgnoreCase("dev") || bizCloudNum.equalsIgnoreCase("sys") || bizCloudNum.equalsIgnoreCase("wfs")) {
                bizCloudNum = "bos";
            }
            rootImple.addAttribute("", "", SOURCE_NAME, STRINGCOSTANT, bizCloudNum);
            transformerHandle.startElement("", "", SOURCE_PACKAGE, rootImple);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, FOURBLANK, appVersion, "ver");
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", SOURCE_APP, attrImple);
            attrImple.addAttribute("", "", SOURCE_ID, STRINGCOSTANT, selectAppNum);
            attrImple.addAttribute("", "", SOURCE_NAME, STRINGCOSTANT, selectAppNum);
            attrImple.addAttribute("", "", SOURCE_PKNAME, STRINGCOSTANT, bizCloudNum + "-" + selectAppNum);
            attrImple.addAttribute("", "", SOURCE_PATH, STRINGCOSTANT, "main/" + selectAppNum);
            transformerHandle.characters(EIGHTBLANK.toCharArray(), 0, EIGHTBLANK.length());
            transformerHandle.startElement("", "", SOURCE_ITEM, attrImple);
            transformerHandle.endElement("", "", SOURCE_ITEM);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", SOURCE_APP);
            transformerHandle.endElement("", "", SOURCE_PACKAGE);
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            AppPackageUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static void createDataModelXML(String appId, Set<String> appFileNameSet, String datamodelPath) {
        AppMetadata appMetaData = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)false);
        String appNum = appMetaData.getNumber().toLowerCase();
        String cldId = appMetaData.getBizCloudID();
        DynamicObject cldObj = BusinessDataServiceHelper.loadSingleFromCache((Object)cldId, (String)"bos_devportal_bizcloud", (String)SOURCE_NUMBER);
        String cldNum = cldObj.getString(SOURCE_NUMBER).toLowerCase();
        List<String> bosAppNumList = Arrays.asList("dev", "sys", "wfs");
        cldNum = bosAppNumList.contains(cldNum) ? "bos" : cldNum;
        String dataModelPath = FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", datamodelPath, File.separator, "datamodel.xml"));
        Path dataModelXmlFilePath = Paths.get(dataModelPath, new String[0]);
        try (OutputStream out = Files.newOutputStream(dataModelXmlFilePath, new OpenOption[0]);){
            TransformerHandler handler = AppPackageUtil.getTransformerHandler(out);
            handler.startDocument();
            handler.characters(FOURBLANK.toCharArray(), 0, 1);
            AttributesImpl rootImple = new AttributesImpl();
            rootImple.addAttribute("", "", SOURCE_NAME, STRINGCOSTANT, cldNum);
            handler.startElement("", "", SOURCE_PACKAGE, rootImple);
            AppPackageUtil.createElementWithoutAttribute(handler, null, FOURBLANK, AppPackageUtil.getAppVerion(appNum), "ver");
            handler.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            AttributesImpl appAttrImple = new AttributesImpl();
            handler.startElement("", "", SOURCE_APP, appAttrImple);
            for (String appFileName : appFileNameSet) {
                AttributesImpl attrImple = new AttributesImpl();
                attrImple.addAttribute("", "", SOURCE_ID, STRINGCOSTANT, appFileName);
                attrImple.addAttribute("", "", SOURCE_NAME, STRINGCOSTANT, appFileName);
                attrImple.addAttribute("", "", SOURCE_PKNAME, STRINGCOSTANT, String.format("%1$s-%2$s", cldNum, appNum));
                attrImple.addAttribute("", "", SOURCE_PATH, STRINGCOSTANT, String.format("main/%s", appFileName));
                handler.characters(EIGHTBLANK.toCharArray(), 0, EIGHTBLANK.length());
                handler.startElement("", "", SOURCE_ITEM, attrImple);
                handler.endElement("", "", SOURCE_ITEM);
            }
            handler.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            handler.endElement("", "", SOURCE_APP);
            handler.endElement("", "", SOURCE_PACKAGE);
            handler.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            AppPackageUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static String getAppVerion(String appNum) {
        String version = DBVersion.getVer();
        if (StringUtils.isNotBlank((CharSequence)appNum)) {
            String appVer;
            QFilter filter = new QFilter(SOURCE_NUMBER, "=", (Object)appNum);
            if (QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{filter})) {
                version = "";
            }
            if (StringUtils.isNotBlank((CharSequence)(appVer = DBVersion.getAppVer((String)appNum)))) {
                version = appVer;
            }
        }
        return version;
    }

    @Deprecated
    public static void createKdpkgsXML(List<String> appPackageNames, Map<String, String> dmMD5Vals, String zipPath, Map<String, String> jarMsg, Map<String, String> staticSourceMsg, List<String> customList, IFormView formView, IPageCache pageCache, IDataModel dataModel, Control descriptionControl, Control nameControl) {
        HashMap<String, Map<String, String>> md5Vals = new HashMap<String, Map<String, String>>(16);
        md5Vals.put(DM, dmMD5Vals);
        md5Vals.put(JAR, jarMsg);
        md5Vals.put(STATICRESOURCE, staticSourceMsg);
        AppPackageUtil.createKdpkgsXML(appPackageNames, md5Vals, null, zipPath, customList, formView, pageCache, dataModel, descriptionControl, nameControl);
    }

    @Deprecated
    public static void createKdpkgsXML(List<String> appPackageNames, Map<String, Map<String, String>> md5Vals, Map<String, Map<String, String>> shaVals, String zipPath, List<String> customList, IFormView formView, IPageCache pageCache, IDataModel dataModel, Control descriptionControl, Control nameControl) {
        Map<Object, Object> dmMD5Vals = md5Vals == null ? new HashMap(16) : md5Vals.get(DM);
        Map<Object, Object> jarMsg = md5Vals == null ? new HashMap(16) : md5Vals.get(JAR);
        Map<Object, Object> staticSourceMsg = md5Vals == null ? new HashMap(16) : md5Vals.get(STATICRESOURCE);
        Map<Object, Object> dmSHAVals = shaVals == null ? new HashMap(16) : shaVals.get(DM);
        Map<Object, Object> jarSHAMsg = shaVals == null ? new HashMap(16) : shaVals.get(JAR);
        Map<Object, Object> staticSourceSHAMsg = shaVals == null ? new HashMap(16) : shaVals.get(STATICRESOURCE);
        Map<Object, Object> customSHAMsg = shaVals == null ? new HashMap(16) : shaVals.get(CUSTOMSTATIC);
        zipPath = DevportalUtil.checkFilePath(zipPath);
        String packagePath = FileUtils.cleanString((String)(zipPath + File.separator + "kdpkgs.xml"));
        Path customZipPath = Paths.get(packagePath, new String[0]);
        try (OutputStream fileOutputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);){
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(fileOutputStream);
            AttributesImpl rootImple = new AttributesImpl();
            AttributesImpl productImple = new AttributesImpl();
            AttributesImpl staticResImple = new AttributesImpl();
            transformerHandle.startDocument();
            String isvString = ISVService.getISVInfo().getId();
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, 1);
            rootImple.addAttribute("", "", SOURCE_ATTR_ISV, STRINGCOSTANT, isvString);
            transformerHandle.startElement("", "", SOURCE_KDPKGS, rootImple);
            AppPackageUtil.createElementWithAttribute(transformerHandle, FOURBLANK, "", SOURCE_FORMAT, "ver", STRINGCOSTANT, "1.1");
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", SOURCE_DESCRIPTION, null);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dataFormat = sdf.format(new Date());
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, dataFormat, SOURCE_TIME);
            String description = "";
            if (descriptionControl != null) {
                OrmLocaleValue localeValue = (OrmLocaleValue)dataModel.getValue("pacckdescription");
                description = localeValue.getLocaleValue();
            }
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, description, SOURCE_CONTENT);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", SOURCE_DESCRIPTION);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            String packageVersion = (String)dataModel.getValue("pkversion");
            ArrayList<String> productSqlList = new ArrayList<String>();
            String delProductSql = String.format("delete from T_META_PKPRODUCTVERSION where FISV = '%s' and FPRODUCTNUMBER = '%s';", isvString, COSMIC_CUS + isvString);
            ArrayList<SqlParameter[]> productSqlParameters = new ArrayList<SqlParameter[]>();
            String insertProductSql = "insert into T_META_PKPRODUCTVERSION (FID,FISV,FPRODUCTNUMBER,FPRODUCTNAME,FUPGRADETIME,FVERSION) values (?,?,?,?,?,?)";
            productSqlParameters.add(new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"T_META_PKPRODUCTVERSION")), new SqlParameter(":FISV", 12, (Object)isvString), new SqlParameter(":FPRODUCTNUMBER", 12, (Object)(COSMIC_CUS + isvString)), new SqlParameter(":FPRODUCTNAME", 12, (Object)ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79(\u4e8c\u5f00)", (String)"AppPackageUtil_8", (String)"bos-devportal-plugin", (Object[])new Object[0])), new SqlParameter(":FUPGRADETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FVERSION", 12, (Object)packageVersion)});
            productSqlList.add(delProductSql);
            DevportalUtil.insertDevVersion(productSqlList);
            DB.executeBatch((DBRoute)DBRoute.meta, (String)insertProductSql, productSqlParameters);
            String bizAppId = (String)formView.getFormShowParameter().getCustomParam(BIZAPPID);
            AppMetadata appmeta = appMetaServiceHelper.loadAppMetadataFromCacheById(bizAppId, false);
            String appIsv = appmeta.getIsv();
            productImple.addAttribute("", "", SOURCE_NAME, "", COSMIC_CUS + appIsv);
            productImple.addAttribute("", "", SOURCE_NAMECN, "", ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79(\u4e8c\u5f00)", (String)"AppPackageUtil_8", (String)"bos-devportal-plugin", (Object[])new Object[0]));
            productImple.addAttribute("", "", "ver", "", packageVersion);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", SOURCE_PRODUCT, productImple);
            HashMap<String, String> appMap = new HashMap<String, String>(appPackageNames.size());
            long[] dbIds = DB.genLongIds((String)"T_META_PACKAGEAPPVERSION", (int)appPackageNames.size());
            int i = 0;
            for (String string : appPackageNames) {
                String string2 = string.split("-")[1];
                ArrayList<String> sqlList = new ArrayList<String>();
                String delSql = String.format("delete from T_META_PACKAGEAPPVERSION where FAPPID = '%s';", string2);
                ArrayList<SqlParameter[]> appSqlParameters = new ArrayList<SqlParameter[]>();
                String insertAppSql = "insert into T_META_PACKAGEAPPVERSION (FID,FAPPID,FUPGRADETIME,FDBVERSION) values (?,?,?,?)";
                appSqlParameters.add(new SqlParameter[]{new SqlParameter(":FID", -5, (Object)dbIds[i]), new SqlParameter(":FAPPID", 12, (Object)string2), new SqlParameter(":FUPGRADETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FDBVERSION", 12, (Object)packageVersion)});
                ++i;
                DB.executeBatch((DBRoute)DBRoute.meta, (String)insertAppSql, appSqlParameters);
                sqlList.add(delSql);
                DevportalUtil.insertDevVersion(sqlList);
                transformerHandle.characters(EIGHTBLANK.toCharArray(), 0, EIGHTBLANK.length());
                transformerHandle.startElement("", "", SOURCE_APP, null);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, TWELVEBLANK, string2, SOURCE_NAME);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, TWELVEBLANK, packageVersion, "ver");
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, TWELVEBLANK, string2, SOURCE_APPIDS);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, TWELVEBLANK, "", SOURCE_DEPENDON);
                String appUUID2 = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                StringBuilder dmUUID = new StringBuilder();
                dmUUID.append(appUUID2);
                appMap.put(string, appUUID2);
                if (!jarMsg.isEmpty()) {
                    for (Map.Entry<Object, Object> jarEntry : jarMsg.entrySet()) {
                        String jarKey = (String)jarEntry.getKey();
                        String jarVal = (String)jarEntry.getValue();
                        String jarAppNum = jarVal.split("-")[0];
                        if (!string2.equals(jarAppNum)) continue;
                        String jarUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                        dmUUID.append(',');
                        dmUUID.append(jarUUID);
                        jarMsg.put(jarKey, jarVal + "-" + jarUUID);
                    }
                }
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, TWELVEBLANK, dmUUID.toString(), SOURCE_RESOURCE);
                transformerHandle.characters(EIGHTBLANK.toCharArray(), 0, EIGHTBLANK.length());
                transformerHandle.endElement("", "", SOURCE_APP);
            }
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", SOURCE_PRODUCT);
            if (!appMap.isEmpty()) {
                appMap.forEach((appPackageName, appUUID) -> {
                    try {
                        String dmSHAVal;
                        transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                        transformerHandle.startElement("", "", "kdpkg", null);
                        String dmName = appPackageName + ".zip";
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, appUUID, SOURCE_KDPKG_ID);
                        String dmMD5Val = (String)dmMD5Vals.get(appPackageName);
                        if (StringUtils.isNotBlank((CharSequence)dmMD5Val)) {
                            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, dmMD5Val, SOURCE_MD5);
                        }
                        String string = dmSHAVal = dmSHAVals == null ? "" : (String)dmSHAVals.get(appPackageName);
                        if (StringUtils.isNotBlank((CharSequence)dmSHAVal)) {
                            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, dmSHAVal, "secret");
                        }
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, dmName, SOURCE_NAME);
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, DM, SOURCE_KDPKG_TYPE);
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, "dm/", "sourcePath");
                        transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                        transformerHandle.endElement("", "", "kdpkg");
                    }
                    catch (Exception e) {
                        AppPackageUtil.setErrorLog(e);
                        throw new KDBizException(e.getMessage());
                    }
                });
            }
            if (jarMsg != null && jarMsg.size() > 0) {
                for (Map.Entry entry : jarMsg.entrySet()) {
                    String string = (String)entry.getKey();
                    String jarVal = (String)entry.getValue();
                    transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                    transformerHandle.startElement("", "", "kdpkg", null);
                    String[] jarStrArr = jarVal.split("-");
                    String jarMD5Value = jarStrArr[1];
                    String jarUUID = jarStrArr[2];
                    String jarSHAValue = jarSHAMsg == null ? "" : (String)jarSHAMsg.get(string);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, jarUUID, SOURCE_KDPKG_ID);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, jarMD5Value, SOURCE_MD5);
                    if (StringUtils.isNotBlank((CharSequence)jarSHAValue)) {
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, jarSHAValue, "secret");
                    }
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, string, SOURCE_NAME);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, JAR, SOURCE_KDPKG_TYPE);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, "jar/", "sourcePath");
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, "cus", SOURCE_OUTPUTPATH);
                    transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                    transformerHandle.endElement("", "", "kdpkg");
                }
            }
            StringBuilder staticResource = new StringBuilder();
            if (staticSourceMsg != null && staticSourceMsg.size() > 0) {
                for (Map.Entry<Object, Object> entry : staticSourceMsg.entrySet()) {
                    String staticSourceName = (String)entry.getKey();
                    String staticSourceMD5Value = (String)entry.getValue();
                    String staticSourceUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                    if (StringUtils.isNotBlank((CharSequence)staticResource)) {
                        staticResource.append(',');
                        staticResource.append(staticSourceUUID);
                    } else {
                        staticResource.append(staticSourceUUID);
                    }
                    String staticSourceSHAValue = staticSourceSHAMsg == null ? "" : (String)staticSourceSHAMsg.get(staticSourceName);
                    transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                    transformerHandle.startElement("", "", "kdpkg", null);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, staticSourceUUID, SOURCE_KDPKG_ID);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, staticSourceMD5Value, SOURCE_MD5);
                    if (StringUtils.isNotBlank((CharSequence)staticSourceSHAValue)) {
                        AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, staticSourceSHAValue, "secret");
                    }
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, staticSourceName, SOURCE_NAME);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, STATICRESOURCE, SOURCE_KDPKG_TYPE);
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, "resource/uploadsource", "sourcePath");
                    transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                    transformerHandle.endElement("", "", "kdpkg");
                }
            }
            for (String string : customList) {
                String customSourceUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                if (StringUtils.isNotBlank((CharSequence)staticResource)) {
                    staticResource.append(',');
                    staticResource.append(customSourceUUID);
                } else {
                    staticResource.append(customSourceUUID);
                }
                transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                transformerHandle.startElement("", "", "kdpkg", null);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, customSourceUUID, SOURCE_KDPKG_ID);
                String customSourceMD5Value = pageCache.get(string);
                pageCache.remove(string);
                String customStaticSAHval = customSHAMsg == null ? "" : (String)customSHAMsg.get(string);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, customSourceMD5Value, SOURCE_MD5);
                if (StringUtils.isNotBlank((CharSequence)customStaticSAHval)) {
                    AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, customStaticSAHval, "secret");
                }
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, string, SOURCE_NAME);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, STATICRESOURCE, SOURCE_KDPKG_TYPE);
                AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, "resource/custom", "sourcePath");
                transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
                transformerHandle.endElement("", "", "kdpkg");
            }
            staticResImple.addAttribute("", "", "ver", "", packageVersion);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", STATICRESOURCE, staticResImple);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, staticResource.toString(), SOURCE_RESOURCE);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", STATICRESOURCE);
            transformerHandle.endElement("", "", SOURCE_KDPKGS);
            transformerHandle.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException e) {
            AppPackageUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static void createKdpkgsXML(String bizAppId, String packageVersion, String description, Collection<String> appPackageNames, Collection<String> jarAppNumColl, String zipPath, Map<String, Map<String, String>> md5Map, Map<String, Map<String, String>> shaMap) {
        AppPackageUtil.innerCreateKdpkgsXML(bizAppId, packageVersion, description, appPackageNames, jarAppNumColl, zipPath, md5Map, shaMap, null);
    }

    public static void createKdpkgsXML(String bizAppId, String packageVersion, String description, Collection<String> appPackageNames, Collection<String> jarAppNumColl, String zipPath, Map<String, Map<String, String>> md5Map, Map<String, Map<String, String>> shaMap, IFormView view) {
        AppPackageUtil.innerCreateKdpkgsXML(bizAppId, packageVersion, description, appPackageNames, jarAppNumColl, zipPath, md5Map, shaMap, view);
    }

    private static void innerCreateKdpkgsXML(String bizAppId, String packageVersion, String description, Collection<String> appPackageNames, Collection<String> jarAppNumColl, String zipPath, Map<String, Map<String, String>> md5Map, Map<String, Map<String, String>> shaMap, IFormView view) {
        Map<String, String> cusCtrlSHAMsg;
        boolean isOEMEnv = DevVerifyServiceHelper.isOEMEnv();
        Map<String, String> dmMD5Msg = md5Map == null ? null : md5Map.get(DM);
        Map<String, String> jarMD5Msg = md5Map == null ? null : md5Map.get(JAR);
        Map<String, String> staticSourceMsg = md5Map == null ? null : md5Map.get(STATICRESOURCE);
        Map<String, String> cusCtrlMD5Msg = md5Map == null ? null : md5Map.get(CUSTOMSTATIC);
        Map<String, String> dmSHAMsg = shaMap == null ? null : shaMap.get(DM);
        Map<String, String> jarSHAMsg = shaMap == null ? null : shaMap.get(JAR);
        Map<String, String> staticSourceSHAMsg = shaMap == null ? null : shaMap.get(STATICRESOURCE);
        Map<String, String> map = cusCtrlSHAMsg = shaMap == null ? null : shaMap.get(CUSTOMSTATIC);
        if (jarMD5Msg != null && !jarMD5Msg.isEmpty()) {
            for (Map.Entry<String, String> jarEntry : jarMD5Msg.entrySet()) {
                String jarName = jarEntry.getKey();
                String jarMD5Val = jarEntry.getValue();
                String jarUUID = UUID.randomUUID().toString().replace("-", "").substring(0, 10);
                jarMD5Msg.put(jarName, jarMD5Val + "-" + jarUUID);
            }
        }
        zipPath = DevportalUtil.checkFilePath(zipPath);
        String packagePath = FileUtils.cleanString((String)String.format("%1$s%2$s%3$s", zipPath, File.separator, "kdpkgs.xml"));
        Path packageZipPath = Paths.get(packagePath, new String[0]);
        try (OutputStream fileOutputStream = Files.newOutputStream(packageZipPath, new OpenOption[0]);){
            String jarUUID;
            TransformerHandler transformerHandle = AppPackageUtil.getTransformerHandler(fileOutputStream);
            AttributesImpl rootImple = new AttributesImpl();
            AttributesImpl staticResImple = new AttributesImpl();
            transformerHandle.startDocument();
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, 1);
            String isvId = ISVService.getISVInfo().getId();
            rootImple.addAttribute("", "", SOURCE_ATTR_ISV, STRINGCOSTANT, isvId);
            transformerHandle.startElement("", "", SOURCE_KDPKGS, rootImple);
            String formatVer = "1.1";
            if (isOEMEnv) {
                formatVer = OEMFormatVer;
            }
            AppPackageUtil.createElementWithAttribute(transformerHandle, FOURBLANK, "", SOURCE_FORMAT, "ver", STRINGCOSTANT, formatVer);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", SOURCE_DESCRIPTION, null);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dataFormat = sdf.format(new Date());
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, dataFormat, SOURCE_TIME);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, description, SOURCE_CONTENT);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", SOURCE_DESCRIPTION);
            AttributesImpl productImple = new AttributesImpl();
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            AppPackageUtil.saveProductVerInfo(isvId, packageVersion);
            AppMetadata appmeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            String appIsv = appmeta.getIsv();
            String productNum = String.format("cosmic_cus_%s", appIsv);
            productImple.addAttribute("", "", SOURCE_NAME, "", productNum);
            String productName = ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79(\u4e8c\u5f00)", (String)"AppPackageUtil_8", (String)"bos-devportal-plugin", (Object[])new Object[0]);
            if (isOEMEnv && view != null) {
                Object localeProductName = view.getModel().getValue("productname");
                productName = localeProductName instanceof OrmLocaleValue ? ((OrmLocaleValue)localeProductName).getLocaleValue() : productName;
            }
            productImple.addAttribute("", "", SOURCE_NAMECN, "", productName);
            productImple.addAttribute("", "", "ver", "", packageVersion);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", SOURCE_PRODUCT, productImple);
            HashMap<String, String> appMap = new HashMap<String, String>(appPackageNames.size());
            long[] dbIds = DB.genLongIds((String)"T_META_PACKAGEAPPVERSION", (int)appPackageNames.size());
            int i = 0;
            for (String string : appPackageNames) {
                String string2 = string.split("-")[1];
                ArrayList sqlList = new ArrayList();
                String string3 = String.format("delete from T_META_PACKAGEAPPVERSION where FAPPID = '%s';", string2);
                ArrayList<SqlParameter[]> appSqlParameters = new ArrayList<SqlParameter[]>();
                String insertAppSql = "insert into T_META_PACKAGEAPPVERSION (FID,FAPPID,FUPGRADETIME,FDBVERSION) values (?,?,?,?)";
                appSqlParameters.add(new SqlParameter[]{new SqlParameter(":FID", -5, (Object)dbIds[i]), new SqlParameter(":FAPPID", 12, (Object)string2), new SqlParameter(":FUPGRADETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FDBVERSION", 12, (Object)packageVersion)});
                ++i;
                DB.executeBatch((DBRoute)DBRoute.meta, (String)insertAppSql, appSqlParameters);
                sqlList.add(string3);
                AppPackageUtil.insertDevVersion(sqlList);
                String appUUID = AppPackageUtil.getUUID();
                StringBuilder dmUUID = new StringBuilder();
                dmUUID.append(appUUID);
                appMap.put(string, appUUID);
                if (jarAppNumColl != null && !jarAppNumColl.isEmpty() && jarAppNumColl.contains(string2)) {
                    if (jarMD5Msg != null && !jarMD5Msg.isEmpty()) {
                        for (Map.Entry<String, String> jarEntry : jarMD5Msg.entrySet()) {
                            String jarMD5Val = jarEntry.getValue();
                            String jarAppNum = jarMD5Val.split("-")[0];
                            String jarUUID2 = jarMD5Val.split("-")[2];
                            if (!string2.equals(jarAppNum)) continue;
                            dmUUID.append(',').append(jarUUID2);
                            break;
                        }
                    }
                    jarAppNumColl.remove(string2);
                }
                AppPackageUtil.createAppAttr(transformerHandle, string2, packageVersion, dmUUID.toString());
            }
            if (jarAppNumColl != null && !jarAppNumColl.isEmpty()) {
                for (String string : jarAppNumColl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (jarMD5Msg != null && !jarMD5Msg.isEmpty()) {
                        for (Map.Entry entry : jarMD5Msg.entrySet()) {
                            String jarMD5Val = (String)entry.getValue();
                            String tmpJarAppNum = jarMD5Val.split("-")[0];
                            jarUUID = jarMD5Val.split("-")[2];
                            if (!string.equals(tmpJarAppNum)) continue;
                            stringBuilder.append(jarUUID).append(",");
                        }
                    }
                    if (stringBuilder.length() <= 0) continue;
                    stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
                    AppPackageUtil.createAppAttr(transformerHandle, string, packageVersion, stringBuilder.toString());
                }
            }
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", SOURCE_PRODUCT);
            if (!appMap.isEmpty()) {
                String sourcePath2 = String.format("%s/", DM);
                for (Map.Entry entry : appMap.entrySet()) {
                    String appUUID = (String)entry.getValue();
                    String string = String.format("%s.zip", entry.getKey());
                    String dmMD5Val = dmMD5Msg == null ? "" : dmMD5Msg.get(string);
                    String dmSHAVal = dmSHAMsg == null ? "" : dmSHAMsg.get(string);
                    AppPackageUtil.createKdpkgAttr(transformerHandle, appUUID, string, dmMD5Val, dmSHAVal, DM, sourcePath2, null);
                }
            }
            if (jarMD5Msg != null && !jarMD5Msg.isEmpty()) {
                String sourcePath = String.format("%s/", JAR);
                for (Map.Entry<String, String> entry : jarMD5Msg.entrySet()) {
                    String jarKey = entry.getKey();
                    String string = entry.getValue();
                    String[] jarStrArr = string.split("-");
                    String jarMD5Value = jarStrArr[1];
                    jarUUID = jarStrArr[2];
                    String jarSHAValue = jarSHAMsg == null ? "" : jarSHAMsg.get(jarKey);
                    AppPackageUtil.createKdpkgAttr(transformerHandle, jarUUID, jarKey, jarMD5Value, jarSHAValue, JAR, sourcePath, "cus");
                }
            }
            StringBuilder staticResource = new StringBuilder();
            if (staticSourceMsg != null && !staticSourceMsg.isEmpty()) {
                String string = "resource/uploadsource";
                for (Map.Entry<String, String> staticSourceEntry : staticSourceMsg.entrySet()) {
                    String string4 = AppPackageUtil.getUUID();
                    String staticSourceName = staticSourceEntry.getKey();
                    String staticSourceMD5Value = staticSourceEntry.getValue();
                    if (StringUtils.isNotBlank((CharSequence)staticResource)) {
                        staticResource.append(',');
                        staticResource.append(string4);
                    } else {
                        staticResource.append(string4);
                    }
                    String staticSourceSHAValue = staticSourceSHAMsg == null ? "" : staticSourceSHAMsg.get(staticSourceName);
                    AppPackageUtil.createKdpkgAttr(transformerHandle, string4, staticSourceName, staticSourceMD5Value, staticSourceSHAValue, STATICRESOURCE, string, null);
                }
            }
            if (cusCtrlMD5Msg != null && !cusCtrlMD5Msg.isEmpty()) {
                String string = "resource/custom";
                for (Map.Entry<String, String> cusCtrlEntry : cusCtrlMD5Msg.entrySet()) {
                    String cusCtrlSHAVal;
                    String string5 = AppPackageUtil.getUUID();
                    String cusCtrlName = cusCtrlEntry.getKey();
                    String cusCtrlMD5Val = cusCtrlEntry.getValue();
                    String string6 = cusCtrlSHAVal = cusCtrlSHAMsg == null ? "" : cusCtrlSHAMsg.get(cusCtrlName);
                    if (StringUtils.isNotBlank((CharSequence)staticResource)) {
                        staticResource.append(',');
                        staticResource.append(string5);
                    } else {
                        staticResource.append(string5);
                    }
                    AppPackageUtil.createKdpkgAttr(transformerHandle, string5, cusCtrlName, cusCtrlMD5Val, cusCtrlSHAVal, STATICRESOURCE, string, null);
                }
            }
            staticResImple.addAttribute("", "", "ver", "", packageVersion);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.startElement("", "", STATICRESOURCE, staticResImple);
            AppPackageUtil.createElementWithoutAttribute(transformerHandle, null, EIGHTBLANK, staticResource.toString(), SOURCE_RESOURCE);
            transformerHandle.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
            transformerHandle.endElement("", "", STATICRESOURCE);
            transformerHandle.endElement("", "", SOURCE_KDPKGS);
            transformerHandle.endDocument();
        }
        catch (Exception e) {
            AppPackageUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static void saveProductVerInfo(String isvId, String packageVer) {
        ArrayList<String> productSqlList = new ArrayList<String>();
        String productNum = String.format("cosmic_cus_%s", isvId);
        String delProductSql = String.format("delete from T_META_PKPRODUCTVERSION where FISV = '%s' and FPRODUCTNUMBER = '%s';", isvId, productNum);
        ArrayList<SqlParameter[]> productSqlParameters = new ArrayList<SqlParameter[]>();
        String insertProductSql = "insert into T_META_PKPRODUCTVERSION (FID,FISV,FPRODUCTNUMBER,FPRODUCTNAME,FUPGRADETIME,FVERSION) values (?,?,?,?,?,?)";
        productSqlParameters.add(new SqlParameter[]{new SqlParameter(":FID", -5, (Object)DB.genLongId((String)"T_META_PKPRODUCTVERSION")), new SqlParameter(":FISV", 12, (Object)isvId), new SqlParameter(":FPRODUCTNUMBER", 12, (Object)productNum), new SqlParameter(":FPRODUCTNAME", 12, (Object)ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79(\u4e8c\u5f00)", (String)"AppPackageUtil_8", (String)"bos-devportal-plugin", (Object[])new Object[0])), new SqlParameter(":FUPGRADETIME", 93, (Object)new Timestamp(System.currentTimeMillis())), new SqlParameter(":FVERSION", 12, (Object)packageVer)});
        productSqlList.add(delProductSql);
        AppPackageUtil.insertDevVersion(productSqlList);
        DB.executeBatch((DBRoute)DBRoute.meta, (String)insertProductSql, productSqlParameters);
    }

    private static void insertDevVersion(List<String> sqlList) {
        ArrayList list = new ArrayList();
        sqlList.forEach(sql -> list.add(new SqlObject(sql, null)));
        if (list.size() > 0) {
            try {
                for (SqlObject sqlObject : list) {
                    DB.execute((DBRoute)DBRoute.meta, (String)sqlObject.getSql(), null);
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), "insertAppVersion")});
            }
        }
    }

    private static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 10);
    }

    private static void createAppAttr(TransformerHandler handler, String appNum, String packageVersion, String uuids) throws SAXException {
        handler.characters(EIGHTBLANK.toCharArray(), 0, EIGHTBLANK.length());
        handler.startElement("", "", SOURCE_APP, null);
        AppPackageUtil.createElementWithoutAttribute(handler, null, TWELVEBLANK, appNum, SOURCE_NAME);
        AppPackageUtil.createElementWithoutAttribute(handler, null, TWELVEBLANK, packageVersion, "ver");
        AppPackageUtil.createElementWithoutAttribute(handler, null, TWELVEBLANK, appNum, SOURCE_APPIDS);
        AppPackageUtil.createElementWithoutAttribute(handler, null, TWELVEBLANK, "", SOURCE_DEPENDON);
        AppPackageUtil.createElementWithoutAttribute(handler, null, TWELVEBLANK, uuids, SOURCE_RESOURCE);
        handler.characters(EIGHTBLANK.toCharArray(), 0, EIGHTBLANK.length());
        handler.endElement("", "", SOURCE_APP);
    }

    private static void createKdpkgAttr(TransformerHandler handler, String uuid, String name, String md5Val, String shaVal, String type, String sourcePath, String outputPath) throws SAXException {
        handler.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
        handler.startElement("", "", "kdpkg", null);
        AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, uuid, SOURCE_KDPKG_ID);
        if (StringUtils.isNotBlank((CharSequence)md5Val)) {
            AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, md5Val, SOURCE_MD5);
        }
        if (StringUtils.isNotBlank((CharSequence)shaVal)) {
            AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, shaVal, "secret");
        }
        AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, name, SOURCE_NAME);
        AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, type, SOURCE_KDPKG_TYPE);
        AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, sourcePath, "sourcePath");
        if (StringUtils.isNotBlank((CharSequence)outputPath)) {
            AppPackageUtil.createElementWithoutAttribute(handler, null, EIGHTBLANK, outputPath, SOURCE_OUTPUTPATH);
        }
        handler.characters(FOURBLANK.toCharArray(), 0, FOURBLANK.length());
        handler.endElement("", "", "kdpkg");
    }

    public static TransformerHandler getTransformerHandler(OutputStream fileOutputStream) throws TransformerConfigurationException {
        StreamResult reultXml = new StreamResult(fileOutputStream);
        SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        saxTransformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        saxTransformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        saxTransformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        TransformerHandler transformerHandle = saxTransformerFactory.newTransformerHandler();
        Transformer transformer = transformerHandle.getTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformerHandle.setResult(reultXml);
        return transformerHandle;
    }

    public static void createElementWithoutAttribute(TransformerHandler transformerHandle, AttributesImpl attributesImple, String blankLength, String endLength, String elementName) throws SAXException {
        AttributesImpl attriImple = null;
        attriImple = StringUtils.isBlank((Object)attributesImple) ? new AttributesImpl() : attributesImple;
        transformerHandle.characters(blankLength.toCharArray(), 0, blankLength.length());
        transformerHandle.startElement("", "", elementName, attriImple);
        if (StringUtils.isNotBlank((CharSequence)endLength)) {
            transformerHandle.characters(endLength.toCharArray(), 0, endLength.length());
        }
        transformerHandle.endElement("", "", elementName);
    }

    public static void createElementWithAttribute(TransformerHandler transformerHandle, String blankLength, String endLength, String elementName, String attributeName, String attributeType, String attributeValue) throws SAXException {
        AttributesImpl attriImple = new AttributesImpl();
        transformerHandle.characters(blankLength.toCharArray(), 0, blankLength.length());
        attriImple.addAttribute("", "", attributeName, attributeType, attributeValue);
        transformerHandle.startElement("", "", elementName, attriImple);
        if (StringUtils.isNotBlank((CharSequence)endLength)) {
            transformerHandle.characters(endLength.toCharArray(), 0, endLength.length());
        }
        transformerHandle.endElement("", "", elementName);
    }

    public static String getDevPorductVersion() {
        String productNum;
        String dbVersion = DBVersion.getVer();
        String sysProductSql = "select FVERSION from t_bas_industry_version where FISV = ? and FPRODUCTNUMBER = ?";
        String isv = ISVService.getISVInfo().getId();
        SqlParameter[] sysProductParams = new SqlParameter[]{new SqlParameter(":FISV", 12, (Object)isv), new SqlParameter(":FPRODUCTNUMBER", 12, (Object)(productNum = COSMIC_CUS + isv))};
        String sysProductVersion = DevportalUtil.selectSourceVersion(sysProductSql, (kd.bos.db.SqlParameter[])sysProductParams, "");
        if (StringUtils.isBlank((CharSequence)sysProductVersion)) {
            sysProductVersion = dbVersion;
        }
        String[] sysProductInfo = sysProductVersion.split("\\.");
        String sysProductBig = sysProductInfo[0] + "." + sysProductInfo[1];
        Integer sysProductBigVal = Integer.valueOf(sysProductInfo[0] + sysProductInfo[1]);
        String sysProductIter = sysProductInfo[sysProductInfo.length - 1];
        String devProductSql = "select FVERSION from t_meta_pkproductversion where FISV = ? and FPRODUCTNUMBER = ?";
        String devProductVersion = DevportalUtil.selectSourceVersion(devProductSql, (kd.bos.db.SqlParameter[])sysProductParams, "");
        if (StringUtils.isBlank((CharSequence)devProductVersion)) {
            devProductVersion = sysProductVersion;
        }
        String[] devProductInfo = devProductVersion.split("\\.");
        Integer devProductBigVal = Integer.valueOf(devProductInfo[0] + devProductInfo[1]);
        String devProductIter = devProductInfo[devProductInfo.length - 1];
        if (sysProductBigVal > devProductBigVal) {
            Integer tempSysProductionIterVal = Integer.valueOf(sysProductIter);
            tempSysProductionIterVal = tempSysProductionIterVal + 1;
            devProductIter = String.valueOf(tempSysProductionIterVal);
        } else {
            int devProductIterVal = Integer.parseInt(devProductIter);
            int sysProductIterVal = Integer.parseInt(sysProductIter);
            if (StringUtils.isNotBlank((CharSequence)devProductIter) && devProductIterVal >= sysProductIterVal) {
                Integer tempdevProductIterVal = Integer.valueOf(devProductIter);
                tempdevProductIterVal = tempdevProductIterVal + 1;
                devProductIter = String.valueOf(tempdevProductIterVal);
            } else {
                Integer tempSysProductionIterVal = Integer.valueOf(sysProductIter);
                tempSysProductionIterVal = tempSysProductionIterVal + 1;
                devProductIter = String.valueOf(tempSysProductionIterVal);
            }
        }
        String newPKIterVersion = "";
        newPKIterVersion = devProductIter.length() == 1 ? "00" + devProductIter : (devProductIter.length() == 2 ? "0" + devProductIter : devProductIter);
        String newPkProductionVersion = sysProductBig + "." + newPKIterVersion;
        return newPkProductionVersion;
    }

    public static JSONArray getFirNodes() {
        JSONArray jsonArray = new JSONArray();
        JSONObject cloudObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"AppPackageUtil_5", (String)"bos-devportal-plugin", (Object[])new Object[0]), CLOUD_ID, CLOUD_NUM);
        jsonArray.add((Object)cloudObject);
        JSONObject appObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u5e94\u7528\u4fe1\u606f(\u5305\u62ec\u83dc\u5355\u3001\u529f\u80fd\u5206\u7ec4)", (String)"AppPackageUtil_0", (String)"bos-devportal-plugin", (Object[])new Object[0]), APP_ID, APP_NUM);
        jsonArray.add((Object)appObject);
        JSONObject pageObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u9875\u9762", (String)"AppPackageUtil_1", (String)"bos-devportal-plugin", (Object[])new Object[0]), PAGE_ID, PAGE_NUM);
        jsonArray.add((Object)pageObject);
        JSONObject scriptObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u811a\u672c", (String)"AppPackageUtil_2", (String)"bos-devportal-plugin", (Object[])new Object[0]), SCRIPT_ID, SCRIPT_NUM);
        jsonArray.add((Object)scriptObject);
        JSONObject billTypeObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AppPackageUtil_3", (String)"bos-devportal-plugin", (Object[])new Object[0]), BILLTYPE_ID, BILLTYPE_NUM);
        jsonArray.add((Object)billTypeObject);
        JSONObject codeRuleObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219", (String)"AppPackageUtil_4", (String)"bos-devportal-plugin", (Object[])new Object[0]), CODERULE_ID, CODERULE_NUM);
        jsonArray.add((Object)codeRuleObject);
        JSONObject workBenchObject = AppPackageUtil.putObjToArr(ResManager.loadKDString((String)"\u5e94\u7528\u5de5\u4f5c\u53f0", (String)"AppPackageUtil_7", (String)"bos-devportal-plugin", (Object[])new Object[0]), WORKBENCH_ID, WORKBENCH_NUM);
        jsonArray.add((Object)workBenchObject);
        return jsonArray;
    }

    public static JSONObject putObjToArr(String name, String id, String num) {
        JSONObject homeObject = new JSONObject();
        homeObject.put(SOURCE_NAME, (Object)name);
        homeObject.put(SOURCE_ID, (Object)id);
        homeObject.put(SOURCE_NUMBER, (Object)num);
        return homeObject;
    }

    public static void pushSourceToCollection(List<Map<String, Object>> sourceList, Map<String, Object> selectNodeMap, String bizParent, List<String> selectAppIdList, int num) {
        sourceList.add(selectNodeMap);
        String bizAppId = bizParent.split("#")[num];
        if (!selectAppIdList.contains(bizAppId)) {
            selectAppIdList.add(bizAppId);
        }
    }

    public static void getTreeNodeChildren(TreeNode treeNode, List<String> treeNodeList) {
        String treeNodeId = treeNode.getId();
        treeNodeList.add(treeNodeId);
        List childTreeNodeList = treeNode.getChildren();
        if (childTreeNodeList != null) {
            for (TreeNode childTreeNode : childTreeNodeList) {
                AppPackageUtil.getTreeNodeChildren(childTreeNode, treeNodeList);
            }
        }
    }

    public static Map<Long, PortalSchemeFile> exportPageScheme(List<Long> mainPageIds) {
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        PreInsDataScriptBuilder builder1 = new PreInsDataScriptBuilder();
        PreInsDataScriptBuilder builder2 = new PreInsDataScriptBuilder();
        PreInsDataScriptBuilder builder3 = new PreInsDataScriptBuilder();
        HashMap map = new HashMap();
        HashMap map1 = new HashMap();
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        HashMap map3 = new HashMap();
        HashMap<Long, PortalSchemeFile> portalSchemeFileMap = new HashMap<Long, PortalSchemeFile>(mainPageIds.size());
        for (long mainPageId : mainPageIds) {
            StringBuilder sqlBuilder = new StringBuilder();
            String mainPageIdVal = String.valueOf(mainPageId);
            sqlBuilder.append("DELETE FROM T_BAS_CARDCONFIG_L WHERE FID IN (SELECT FID FROM T_BAS_CARDCONFIG WHERE FMAINPAGEID = ");
            sqlBuilder.append(mainPageIdVal);
            sqlBuilder.append(");\t\n");
            sqlBuilder.append("DELETE FROM T_BAS_CARDCONFIG WHERE FMAINPAGEID = ");
            sqlBuilder.append(mainPageIdVal);
            sqlBuilder.append(NEXTLINE);
            sqlBuilder.append("DELETE FROM T_BAS_MAINPAGELAYOUT_L WHERE FID = ");
            sqlBuilder.append(mainPageIdVal);
            sqlBuilder.append(NEXTLINE);
            sqlBuilder.append("DELETE FROM T_BAS_MAINPAGELAYOUT WHERE FID = ");
            sqlBuilder.append(mainPageIdVal);
            sqlBuilder.append(NEXTLINE);
            PortalSchemeFile portalSchemeFile = new PortalSchemeFile();
            portalSchemeFile.setFileName("wb_portal_scheme_" + mainPageId + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".sql");
            String selectField3 = "FPKID, FID, FLOCALEID, FCARDTITLE, FCUSTOMNAME  ";
            StringBuilder whereField3 = new StringBuilder();
            whereField3.append("fid in (select fid from t_bas_cardconfig where fmainpageid = ").append(mainPageId).append(')');
            try {
                map3.putAll(builder3.genInsertSQLScript(DBRoute.base, "t_bas_cardconfig_l", selectField3, whereField3.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map3.get("sql")))) {
                    sqlBuilder.append((String)map3.get("sql"));
                }
                if (map3.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map3.get("xml"));
                }
                map3.clear();
            }
            catch (Exception e) {
                AppPackageUtil.setErrorLog(e);
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXCEPTION, e.getMessage())});
            }
            String selectField2 = "FID, FUSERID, FTYPE, FCONFIG, FMAINPAGEID, FCARDID ";
            StringBuilder whereField2 = new StringBuilder();
            whereField2.append("FMAINPAGEID = ").append(mainPageId);
            try {
                map2.putAll(builder2.genInsertSQLScript(DBRoute.base, "t_bas_cardconfig", selectField2, whereField2.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map2.get("sql")))) {
                    AppPackageUtil.processExportCardConfig(map2);
                    sqlBuilder.append((String)map2.get("sql"));
                }
                if (map2.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map2.get("xml"));
                }
                map2.clear();
            }
            catch (Exception e) {
                AppPackageUtil.setErrorLog(e);
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXCEPTION, e.getMessage())});
            }
            String selectField1 = "FPKID, FID, FLOCALEID, FNAME ";
            StringBuilder whereField1 = new StringBuilder();
            whereField1.append("FID = ").append(mainPageId);
            try {
                map1.putAll(builder1.genInsertSQLScript(DBRoute.base, "t_bas_mainpagelayout_l", selectField1, whereField1.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map1.get("sql")))) {
                    sqlBuilder.append((String)map1.get("sql"));
                }
                if (map1.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map1.get("xml"));
                }
                map1.clear();
            }
            catch (Exception e) {
                AppPackageUtil.setErrorLog(e);
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXCEPTION, e.getMessage())});
            }
            String tableName = "t_bas_mainpagelayout";
            String selectField = "FID, FUSERID, FTYPE, FBIZAPPID, FLAYOUT, FNUMBER, FENABLE, FCUSTOMABLE, FISPRESET, FCREATORID, FCREATETIME, FMODIFIERID, FMODIFYTIME, FDISABLERID, FDISABLETIME, FSCHEMETYPE,FFORMNUM, FISMULTIORG ";
            StringBuilder whereField = new StringBuilder();
            whereField.append("FID = ").append(mainPageId);
            try {
                map.putAll(builder.genInsertSQLScript(DBRoute.base, tableName, selectField, whereField.toString(), null, null));
                if (StringUtils.isNotEmpty((CharSequence)((String)map.get("sql")))) {
                    sqlBuilder.append((String)map.get("sql"));
                }
                if (map.get("xml") != null) {
                    portalSchemeFile.getXmlMap().putAll((Map)map.get("xml"));
                }
                map.clear();
            }
            catch (Exception e) {
                AppPackageUtil.setErrorLog(e);
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format(KSQLEXCEPTION, e.getMessage())});
            }
            portalSchemeFile.setSql(sqlBuilder.toString());
            portalSchemeFileMap.put(mainPageId, portalSchemeFile);
        }
        return portalSchemeFileMap;
    }

    private static void processExportCardConfig(Map<String, Object> exportCardConfigSqlInfo) {
        AppPackageUtil.processExportQingCardConfig(exportCardConfigSqlInfo);
    }

    private static void processExportQingCardConfig(Map<String, Object> exportCardConfigSqlInfo) {
        String[] sqlArr;
        String allSql = (String)exportCardConfigSqlInfo.get("sql");
        if (StringUtils.isBlank((CharSequence)allSql)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String curSql : sqlArr = allSql.split(";")) {
            if (StringUtils.isBlank((CharSequence)curSql)) continue;
            StringBuilder curSqlSb = new StringBuilder(curSql);
            if (curSql.contains("INSERT INTO t_bas_cardconfig") && curSql.contains("'bos_card_qing'")) {
                int startIndex = curSql.indexOf("'{");
                int endIndex = curSql.lastIndexOf("}'");
                String configJsonStr = curSql.substring(startIndex + 1, endIndex + 1);
                String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"switchHomepageCardIdToPath", (Object[])new Object[]{configJsonStr});
                curSqlSb.replace(startIndex + 1, endIndex + 1, resultStr);
            }
            sb.append((CharSequence)curSqlSb).append(';').append(System.lineSeparator());
        }
        exportCardConfigSqlInfo.put("sql", sb.toString());
    }

    public static TreeNode geneConfNode(String parentId, String dataId, String nodeText) {
        String nodeId = String.format("%1$s#%2$s", parentId, dataId);
        return new TreeNode(parentId, nodeId, nodeText);
    }

    public static void createDataNode(DynamicObjectCollection dataColl, TreeNode parentNode) {
        for (DynamicObject data : dataColl) {
            TreeNode dataNode = AppPackageUtil.geneConfNode(parentNode.getId(), data.getPkValue().toString(), data.getLocaleString(SOURCE_NAME).getLocaleValue());
            parentNode.addChild(dataNode);
        }
    }

    public static Map<String, Object> expPreInsDataSql(@NotNull String entityNum, @NotNull List<String> pkList, String sqlFileName, @NotNull String expPath) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", true);
        try {
            File file = new File(expPath).getCanonicalFile();
            if (!file.exists()) {
                file.mkdirs();
            }
            sqlFileName = StringUtils.isNotBlank((CharSequence)sqlFileName) ? sqlFileName : String.format("%1$s_%2$s", entityNum, System.currentTimeMillis());
            String sqlContent = AppPackageUtil.genePreInsDataSqlContent(entityNum, pkList, null);
            logger.debug(String.format("\u751f\u6210\u9884\u7f6esql\u6587\u4ef6, \u540d\u79f0: %1$s, \u5927\u5c0f: %2$s", sqlFileName, sqlContent.length()));
            if (StringUtils.isNotBlank((CharSequence)sqlContent)) {
                String fullPathStr = String.format("%1$s%2$s%3$s", expPath, File.separator, sqlFileName);
                AppPackageUtil.saveFile(sqlContent, fullPathStr);
                resultMap.put("sqlfilename", sqlFileName);
            }
        }
        catch (IOException e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            resultMap.put("success", false);
            resultMap.put("message", errMsg);
            AppPackageUtil.setErrorLog(errMsg);
        }
        return resultMap;
    }

    public static String genePreInsDataSqlContent(@NotNull String entityNum, @NotNull List<String> pkList, Set<String> excludedFields) {
        StringBuilder fieldsBuilder = new StringBuilder();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
        String dbRouteKey = mainEntityType.getDBRouteKey();
        String tableName = mainEntityType.getAlias();
        Map propertyMap = mainEntityType.getAllFields();
        Set keySet = propertyMap.keySet();
        Iterator iterator = keySet.iterator();
        ArrayList<String> mulLangFieldList = new ArrayList<String>(10);
        ArrayList<String> mulBaseDataSqlList = new ArrayList<String>(10);
        while (iterator.hasNext()) {
            DynamicProperty fieldPrpo;
            String fieldKey = (String)iterator.next();
            boolean isExportFlag = true;
            if (excludedFields != null && !excludedFields.isEmpty()) {
                for (String excludedFieldkey : excludedFields) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)excludedFieldkey)) continue;
                    isExportFlag = false;
                    break;
                }
            }
            if (!isExportFlag || (fieldPrpo = mainEntityType.getProperty(fieldKey)) == null || StringUtils.isBlank((CharSequence)fieldPrpo.getAlias())) continue;
            if (fieldPrpo instanceof MuliLangTextProp) {
                mulLangFieldList.add(fieldPrpo.getAlias());
                continue;
            }
            if (fieldPrpo instanceof MulBasedataProp) {
                mulBaseDataSqlList.add(AppPackageUtil.geneMulBaseDataSql(pkList, fieldPrpo, null, null));
                continue;
            }
            fieldsBuilder.append(fieldPrpo.getAlias()).append(", ");
        }
        fieldsBuilder.deleteCharAt(fieldsBuilder.lastIndexOf(","));
        StringBuilder preInsDataSqlBuilder = new StringBuilder();
        preInsDataSqlBuilder.append(AppPackageUtil.genePreInsDataSql(pkList, dbRouteKey, tableName, fieldsBuilder.toString(), mulLangFieldList));
        for (String sqlStr : mulBaseDataSqlList) {
            preInsDataSqlBuilder.append(sqlStr).append("\r\n");
        }
        return preInsDataSqlBuilder.toString();
    }

    private static String geneMulBaseDataSql(List<String> pkList, DynamicProperty property, String orderByStr, String descStr) {
        StringBuilder sqlBuilder = new StringBuilder();
        String dbRouteKey = property.getParent().getDBRouteKey();
        String table = property.getAlias();
        String fieldStr = "FPKID, FID, FBASEDATAID";
        String whereStr = String.format("FID IN ('%s')", String.join((CharSequence)"','", pkList));
        String insertMulBaseDataSql = AppPackageUtil.genePreInsDataSql(dbRouteKey, table, fieldStr, whereStr, orderByStr, descStr);
        sqlBuilder.append(insertMulBaseDataSql).append("\r\n");
        return sqlBuilder.toString();
    }

    private static String genePreInsDataSql(List<String> pkList, String dbRouteKey, String tableName, String fieldsStr, List<String> mulLangFields) {
        StringBuilder sqlBuilder = new StringBuilder();
        String whereStr = String.format("FID IN ('%s')", String.join((CharSequence)"','", pkList));
        String insertSql = AppPackageUtil.genePreInsDataSql(dbRouteKey, tableName, fieldsStr, whereStr, null, null);
        sqlBuilder.append(insertSql).append("\r\n");
        if (mulLangFields != null && !mulLangFields.isEmpty()) {
            StringBuilder mulLangFieldBuilder = new StringBuilder("FPKID, FID, FLOCALEID, ");
            for (String fieldKey : mulLangFields) {
                mulLangFieldBuilder.append(fieldKey).append(", ");
            }
            mulLangFieldBuilder.deleteCharAt(mulLangFieldBuilder.lastIndexOf(","));
            String insertMulLangSql = AppPackageUtil.genePreInsDataSql(dbRouteKey, tableName + "_l", mulLangFieldBuilder.toString(), whereStr, null, null);
            sqlBuilder.append(insertMulLangSql).append("\r\n");
        }
        sqlBuilder.append("\r\n");
        return sqlBuilder.toString();
    }

    private static String genePreInsDataSql(String dbRouteKey, String tableName, String fieldsStr, String whereStr, String orderByStr, String descStr) {
        StringBuilder sqlBuilder = new StringBuilder();
        PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
        Map map = builder.genInsertSQLScript(DBRoute.of((String)dbRouteKey), tableName, fieldsStr, whereStr, orderByStr, descStr);
        String insertSql = (String)map.get("sql");
        sqlBuilder.append(insertSql).append("\r\n");
        return sqlBuilder.toString();
    }

    private static void saveFile(String content, String tmpExpPathStr) throws IOException {
        Path tmpExpPath = Paths.get(DevportalUtil.checkFilePath(tmpExpPathStr), new String[0]);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(tmpExpPath, new OpenOption[0]), StandardCharsets.UTF_8));
        writer.write(content);
        writer.newLine();
        writer.flush();
        writer.close();
    }

    public static void expSql(@NotNull String url, @NotNull String expPath, @NotNull String sqlFileName) {
        try {
            String sqlFileContent = AppPackageUtil.readFileContent(url);
            File expFile = new File(expPath).getCanonicalFile();
            if (!expFile.exists()) {
                expFile.mkdirs();
            }
            String sqlFullPath = String.format("%1$s%2$s%3$s", expPath, Character.valueOf(File.separatorChar), sqlFileName);
            AppPackageUtil.saveFile(sqlFileContent, sqlFullPath);
            logger.debug(String.format("\u6210\u529f\u5c06\u6587\u4ef6(%1$s)\u5bfc\u51fa\u5230\u76ee\u5f55: %2$s", sqlFileName, expPath));
        }
        catch (IOException e) {
            AppPackageUtil.setErrorLog(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new RuntimeException(e);
        }
    }

    public static String readFileContent(String url) throws IOException {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = cache.getInputStream(url);
        return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    public static String readFileContent(ZipInputStream zipIn) throws IOException {
        int readLength = -1;
        int len = 0;
        byte[] buff = new byte[0x1400000];
        while ((readLength = zipIn.read()) != -1) {
            buff[len] = (byte)readLength;
            ++len;
        }
        return new String(buff, 0, len, StandardCharsets.UTF_8);
    }

    public static byte[] readFileContentToByteArr(ZipInputStream zipIn) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int readLength = -1;
        byte[] buff = new byte[0x1400000];
        while ((readLength = zipIn.read(buff, 0, buff.length)) != -1) {
            bos.write(buff, 0, readLength);
        }
        byte[] resultArr = bos.toByteArray();
        bos.close();
        return resultArr;
    }

    public static Map<String, Object> deploySqlFile(String sqlFileContent, String sqlFileName, String type, String separator, String dbKey, String errorLevel, String plugin, String pkName, String appNum, String version) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            List<String> sqlList = AppPackageUtil.readSql(sqlFileContent, separator);
            resultMap = AppPackageUtil.exeSql(sqlList, sqlFileName, type, dbKey, errorLevel, plugin, pkName, appNum, version);
        }
        catch (IOException e) {
            String exceptionStr = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            AppPackageUtil.setErrorLog(exceptionStr);
            resultMap.put("success", false);
            resultMap.put("errorInfo", exceptionStr);
        }
        return resultMap;
    }

    private static List<String> readSql(String sqlFileContent, String separator) throws IOException {
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuilder sqlBulider = new StringBuilder();
        String line = null;
        boolean isFirstLine = true;
        boolean commentLine = false;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(sqlFileContent.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        while ((line = br.readLine()) != null) {
            if (line.length() <= 0) continue;
            if (isFirstLine && line.charAt(0) == '\ufeff') {
                line = line.substring(1);
                isFirstLine = false;
            }
            String temp = line.trim();
            if (commentLine) {
                if (!temp.endsWith("*/")) continue;
                commentLine = false;
                continue;
            }
            if (temp.startsWith("/*")) {
                if (temp.endsWith("*/")) continue;
                commentLine = true;
                continue;
            }
            if (temp.startsWith("--")) continue;
            if (!(temp.endsWith(separator) && separator.equals("GO") || Strings.isNullOrEmpty((String)temp))) {
                sqlBulider.append(' ').append(line).append(' ');
            }
            if (!temp.endsWith(separator)) continue;
            String curSql = sqlBulider.toString();
            if (curSql.contains("INSERT INTO t_bas_cardconfig") && curSql.contains("'bos_card_qing'")) {
                int startIndex = curSql.indexOf("'{");
                int endIndex = curSql.lastIndexOf("}'");
                String configJsonStr = curSql.substring(startIndex + 1, endIndex + 1);
                String resultStr = (String)DispatchServiceHelper.invokeBOSService((String)"qing", (String)"QingService", (String)"switchHomepageCardPathToId", (Object[])new Object[]{configJsonStr});
                sqlBulider.replace(startIndex + 1, endIndex + 1, resultStr);
            }
            sqlList.add(sqlBulider.toString());
            sqlBulider = new StringBuilder();
        }
        return sqlList;
    }

    private static Map<String, Object> exeSql(List<String> sqlList, String sqlFileName, String type, String dbKey, String errorLevel, String plugin, String pkName, String appNum, String version) {
        HashMap<String, String> sqlParamMap = new HashMap<String, String>();
        sqlParamMap.put(SOURCE_PKNAME, pkName);
        sqlParamMap.put("appname", appNum);
        sqlParamMap.put("version", version);
        sqlParamMap.put("ksqlname", sqlFileName);
        sqlParamMap.put(SOURCE_KDPKG_TYPE, type);
        sqlParamMap.put("dbkey", dbKey);
        sqlParamMap.put("el", errorLevel);
        if (StringUtils.isNotBlank((CharSequence)plugin)) {
            sqlParamMap.put("plugin", plugin);
        }
        Map resultMap = ((DeployService)ServiceFactory.getService(DeployService.class)).deploySql(sqlParamMap, sqlList);
        return resultMap;
    }

    private static void setErrorLog(String errorLog) {
        logger.error(errorLog);
    }

    private static void setErrorLog(Exception e) {
        logger.error((Throwable)e);
    }
}

