/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.devportal.business.hosting.ResultMessage;
import kd.bos.devportal.business.util.BizPageOperationUtil;
import kd.bos.devportal.business.util.DevportalVerify;
import kd.bos.devportal.business.util.ScriptOperationUtil;
import kd.bos.devportal.common.extplugin.IDevPortalUtilExtPlugin;
import kd.bos.devportal.common.extplugin.IPluginProxyUtil;
import kd.bos.devportal.common.extplugin.PluginProxyImpl;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.common.util.HttpClientUtils;
import kd.bos.devportal.util.DefaultDevPortalUtilExtPlugin;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.devportal.util.PageBuilder;
import kd.bos.entity.DBVersion;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.deploy.DeployScriptBinder;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.devportal.DevVerifyServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.portal.InitailVersionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.util.DevportalCommonUtil;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.FileUtils;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.kingscript.lib.crypto.meta.MetaCryptoUtil;

@SdkPublic
public class DevportalUtil {
    public static final Log logger = LogFactory.getLog(DevportalUtil.class);
    private static final String CODEMANAGE = "codemanage";
    private static final String SPACE = "   ";
    public static final String ERROR = "ERROR";
    public static final String NUMBER = "number";
    public static final String NOPATH = "NOPATH";
    public static final String BIZAPP = "bizapp";
    public static final String BIZUNIT = "bizunit";
    private static final String JSONTYPE = ".json";
    public static final String BIZPAGE = "bizpage";
    public static final String SUCCESS = "SUCCESS";
    public static final String VERSION = "version";
    public static final String MASTERID = "masterid";
    public static final String PARENTID = "parentid";
    public static final String BIZCLOUD = "bizcloud";
    public static final String BIZAPPID = "bizappid";
    public static final String INDUSTRY = "industry";
    public static final String CONFLICT = "CONFLICT";
    private static final String KDPKGS = "kdpkgs.xml";
    private static final String CHECK_SUM = "check_sum.json";
    public static final String ERRORCODE = "errorcode";
    private static final String MODELTYPE = "modeltype";
    public static final String ORITENENTISV = "kingdee";
    public static final String MODIFIERID = "modifierid";
    public static final String CREATEDATE = "createdate";
    public static final String MODIFYDATE = "modifydate";
    public static final String EXPORT_APP = "EXPORT_APP";
    private static final String BIZCLOUDID = "bizcloudid";
    public static final String DESCRIPTION = "description";
    public static final String EXPORT_PAGE = "EXPORT_PAGE";
    private static final String ERRORINFO = "errorInfo.txt";
    public static final String RUNTIMEERROR = "RUNTIMEERROR";
    public static final String EMPTY_COMMIT = "EMPTY COMMIT";
    public static final String CHECKIN_PAGE = "CHECKIN_PAGE";
    public static final String CHECKIN_APP = "CHECKIN_APP";
    public static final String EXPORT_CLOUD = "EXPORT_CLOUD";
    private static final String SEQUENCE_ASC = "sequence asc";
    private static final String KEY_ISFIRSTLOGIN = "isfirstlogin";
    public static final String MULTI_TXT_NAME = "multi_txt_name";
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String FORMNAME = "BOS_DEVPORTAL_BIZPAGELIST";
    public static final String USER_HOME = System.getProperty("user.home");
    private static final String IDE_UNIT_TEST_DETAIL = "ide_unit_test_detail";
    private static final String BOS_DEVPORTAL_SHORTCUT = "bos_devportal_shortcut";
    private static final String APPINFOXML = "appInfo.xml";
    private static final String RESOURCE = "resource";
    private static final String CUSTOM = "custom";
    private static final String UPLOADSOURCE = "uploadsource";
    private static final String KEY_ERROR = "error";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String CONTENT_TYPE = "Content-type";
    private static final String APPLICATION_JSONANDCHARSET = "application/json;charset=UTF-8";
    private static final String MC_SERVER_URL = "mc.server.url";
    private static final String IMAGE = "image";
    private static final String VISIBLE = "visible";
    private static final String SEQUENCE = "sequence";
    private static final String DEPLOYSTATUS = "deploystatus";
    private static final String BACKIMAGE = "backimage";
    private static final String DEVPORTALUTIL_29 = "DevportalUtil_29";
    private static final String MESSAGE = "message";
    private static final String KEY_SUCCESS = "success";
    private static final String MAINFORMNAME = "mainformname";
    private static final String MAINFORMID = "mainformid";
    private static final String NUMNOCONF = "numnoconf";
    private static final String USERID = "userid";
    private static final String PAGEID = "pageid";
    private static final String BOS_DEVP_FIRSTLOGIN = "bos_devp_firstlogin";
    private static final String PRINTMODEL = "PrintModel";
    private static final String BASEDATAFIELD = "basedatafield";
    private static final String ISEXTENDED = "isextended";
    private static final String ISINHERIT = "isinherit";
    private static final String ENABLED = "enabled";
    private static final String DEVTYPE = "devtype";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final int LOCK = 2;
    private static final int NOTLOCK = 1;
    private static final String UPPER_CASE_NUMBER = "Number";
    private static IPluginProxyUtil pluginProxyUtil = new PluginProxyImpl();

    private DevportalUtil() {
        throw new IllegalStateException("DevportalUtil cannot be instantiated");
    }

    public static String getNoPermissionTip() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"DevportalUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
    }

    public static void showFloatTip(IFormView formView, String tip) {
        JSONObject data = new JSONObject();
        data.put("isShow", (Object)"true");
        data.put("tipinfo", (Object)tip);
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("OPENFLOATTIPINFO", (Object)data);
    }

    public static JSONObject expFormMetadata(String formId, String exportPath, String sourceType) {
        JSONObject checkInMsg = new JSONObject();
        try {
            List list = MetadataDao.getFormDeployFile((String)formId);
            if (list != null && list.size() > 0) {
                String modelType = ((DeployFile)list.get(0)).getModelType();
                String pageIsv = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_formmeta", (String)"isv").getString("isv");
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                DevportalUtil.saveMetaFile(dymMeta, dymFileName, exportPath);
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    if (dymLangFileName.endsWith("zh_CN.dymx")) {
                        DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                        continue;
                    }
                    if ((!EXPORT_PAGE.equals(sourceType) || ORITENENTISV.equals(pageIsv)) && !StringUtils.equals((CharSequence)PRINTMODEL, (CharSequence)modelType)) continue;
                    DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                }
                DevportalUtil.savePageJsFile(formId, exportPath);
            }
        }
        catch (Exception e) {
            DevportalUtil.setInfoLog(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        return checkInMsg;
    }

    private static void savePageJsFile(String formId, String exportPath) {
        List<String> scriptIds = DevportalUtil.getSelfScriptId(formId);
        for (String scriptId : scriptIds) {
            DevportalUtil.expScriptMeta(scriptId, exportPath);
        }
    }

    private static List<String> getSelfScriptId(String formId) {
        BillFormAp billFormAp;
        FormMetadata mobMeta;
        AbstractMetadata meta = MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        if (!(meta instanceof FormMetadata)) {
            return Collections.emptyList();
        }
        FormMetadata formMetadata = (FormMetadata)meta;
        ArrayList<String> selfScriptIds = new ArrayList<String>(8);
        FormAp rootAp = formMetadata.getRootAp();
        List jsPlugins = rootAp.getJsPlugins();
        for (Plugin jsPlugin : jsPlugins) {
            if (jsPlugin.isInherit()) continue;
            selfScriptIds.add(jsPlugin.getFpk());
        }
        if (rootAp instanceof BillFormAp && (mobMeta = (billFormAp = (BillFormAp)rootAp).getMobMeta()) != null && mobMeta.getItems().size() > 0 && mobMeta.getItems().get(0) instanceof FormAp) {
            FormAp mobRootAp = (FormAp)mobMeta.getItems().get(0);
            for (Plugin jsPlugin : mobRootAp.getJsPlugins()) {
                if (jsPlugin.isInherit()) continue;
                selfScriptIds.add(jsPlugin.getFpk());
            }
        }
        return selfScriptIds;
    }

    public static JSONObject expFormMetadata(String formId, String bizAppId, String unitId, String exportPath, String sourceType) {
        JSONObject checkInMsg = new JSONObject();
        try {
            List list = MetadataDao.getFormDeployFile((String)formId, (String)bizAppId, (String)unitId);
            if (list != null && list.size() > 0) {
                String modelType = ((DeployFile)list.get(0)).getModelType();
                String pageIsv = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_formmeta", (String)"isv").getString("isv");
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                DevportalUtil.saveMetaFile(dymMeta, dymFileName, exportPath);
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    if (dymLangFileName.endsWith("zh_CN.dymx")) {
                        DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                        continue;
                    }
                    if ((!EXPORT_PAGE.equals(sourceType) || ORITENENTISV.equals(pageIsv)) && !StringUtils.equals((CharSequence)PRINTMODEL, (CharSequence)modelType)) continue;
                    DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                }
            }
        }
        catch (Exception e) {
            DevportalUtil.setInfoLog(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        return checkInMsg;
    }

    public static void exportScriptCallBack(String scriptId, IFormView formView) {
        DynamicObject[] objects;
        ArrayList<DeployFile> deployFileList = new ArrayList<DeployFile>(10);
        for (DynamicObject o : objects = BusinessDataReader.load((Object[])new String[]{scriptId}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((URL)DeployScriptBinder.class.getResource("/SystemEntity/ScriptEntity.xml")), (Boolean)false)) {
            DeployScript deploy = new DeployScript();
            String enginetype = o.getString("enginetype");
            String suffix = "1".equals(enginetype) ? ".ksc" : ".ks";
            deploy.getScripts().add(o);
            deployFileList.add(deploy.toDeployFile(o.getString(UPPER_CASE_NUMBER).toLowerCase() + suffix));
        }
        DeployFile df = (DeployFile)deployFileList.get(0);
        String jsFileName = df.getFileName();
        String content = df.getFileContent();
        byte[] fileBytes = MetaCryptoUtil.encrypt((byte[])content.getBytes(StandardCharsets.UTF_8));
        try (ByteArrayInputStream ins = new ByteArrayInputStream(fileBytes);){
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(jsFileName, (InputStream)ins, 5000);
            formView.openUrl(url);
            if (formView.toString().contains("bos_devp_script_ide") || formView.toString().contains("ide_register_ts_plugin")) {
                DevportalUtil.showFloatTip(formView, String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\uff0c\u5bfc\u51fa\u8def\u5f84\u4e3a%1$s\u7528\u6237\u540d%2$s", (String)"DevportalUtil_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "C:\\Users\\", "\\Downloads\u3002"));
            } else {
                formView.returnDataToParent((Object)"EXPORT_SUCCESS");
                formView.close();
            }
        }
        catch (Exception e) {
            DevportalUtil.setInfoLog(e.getMessage());
            formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"DevportalUtil_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static void expScriptMeta(String scriptId, String exportPath) {
        List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{scriptId});
        if (deployFileList.isEmpty()) {
            return;
        }
        DeployFile df = (DeployFile)deployFileList.get(0);
        String content = df.getFileContent();
        String jsFileName = df.getFileName().toLowerCase();
        String jsFileFullPath = AppUtils.getMetaXmlPath((String)jsFileName, (String)(exportPath = DevportalUtil.checkFilePath(exportPath)));
        File jsFile = new File(FileUtils.cleanString((String)jsFileFullPath));
        File jsFileAbovePath = jsFile.getParentFile();
        if (!jsFileAbovePath.exists()) {
            jsFileAbovePath.mkdirs();
        }
        Path customZipPath = Paths.get(FileUtils.cleanString((String)jsFileFullPath), new String[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(content);
        }
        catch (IOException e) {
            DevportalUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static void saveMetaFile(String dymMeta, String dymFileName, String exportPath) {
        String fullPath = AppUtils.getMetaXmlPath((String)dymFileName, (String)exportPath);
        String[] abovePath = fullPath.split(dymFileName);
        File fileAbovePath = new File(FileUtils.cleanString((String)abovePath[0]));
        if (!fileAbovePath.exists()) {
            fileAbovePath.mkdirs();
        }
        Path customZipPath = Paths.get(DevportalUtil.checkFilePath(FileUtils.cleanString((String)fullPath)), new String[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(customZipPath, new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(dymMeta);
        }
        catch (IOException e) {
            DevportalUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    private static List<String> getCollectedApps() {
        QFilter q1 = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        QFilter q3 = new QFilter(BIZPAGE, "=", (Object)" ");
        QFilter[] filters = new QFilter[]{q1, q3};
        DynamicObjectCollection querys = QueryServiceHelper.query((String)BOS_DEVPORTAL_SHORTCUT, (String)BIZAPP, (QFilter[])filters);
        ArrayList<String> collectedAppIds = new ArrayList<String>(querys.size());
        for (int i = 0; i < querys.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)querys.get(i);
            String bizAppId = dynamicObject.getString(BIZAPP);
            collectedAppIds.add(bizAppId);
        }
        return collectedAppIds;
    }

    public static String getSysExtendedCount(String id, String formNumber, String field) {
        QFilter q = new QFilter(field, "=", (Object)id);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "count(id) as countNumber";
        DynamicObject dyo = QueryServiceHelper.queryOne((String)formNumber, (String)selectFields, (QFilter[])filters);
        String countNmuber = dyo.getString("countNumber");
        return countNmuber;
    }

    public static String getParallelExtCountByIsv(String id, String formNumber, String parentId) {
        return DevportalUtil.getParallelInheritCountByIsv(id, formNumber, parentId, "2");
    }

    public static String getParallelInheritCountByIsv(String id, String formNumber, String parentId, String type) {
        QFilter q = new QFilter(parentId, "=", (Object)id);
        q.and(new QFilter("type", "=", (Object)type));
        String currentIsv = ISVService.getISVInfo().getId();
        QFilter qIsv = new QFilter("isv", "=", (Object)currentIsv);
        if (ORITENENTISV.equalsIgnoreCase(currentIsv)) {
            QFilter qIsvNull = new QFilter("isv", "is null", (Object)Boolean.TRUE);
            qIsvNull = qIsvNull.or(new QFilter("isv", "=", (Object)" "));
            qIsv = qIsv.or(qIsvNull);
        }
        QFilter[] filters = new QFilter[]{q, qIsv};
        String countNmuber = "0";
        if (QueryServiceHelper.exists((String)formNumber, (QFilter[])filters)) {
            countNmuber = "1";
        }
        return countNmuber;
    }

    public static void zipFiles(List<String> zipNames, String zipPath, String defaultAppPackageName) {
        String staticResourcePath;
        File staticResourceFile;
        String customResourcePath;
        File customResourceFile;
        String checkSum;
        File checkSumFile;
        String appInfo;
        File appInfoFile;
        String errorLog;
        File errorLogFile;
        JSONArray files = new JSONArray();
        String packageXML = FileUtils.cleanString((String)((zipPath = DevportalUtil.checkFilePath(zipPath)) + File.separator + KDPKGS));
        File packageXMLFile = new File(packageXML);
        if (packageXMLFile.exists()) {
            files.add((Object)packageXML);
        }
        if ((errorLogFile = new File(errorLog = FileUtils.cleanString((String)(zipPath + File.separator + ERRORINFO)))).exists()) {
            files.add((Object)errorLog);
        }
        if ((appInfoFile = new File(appInfo = FileUtils.cleanString((String)(zipPath + File.separator + APPINFOXML)))).exists()) {
            files.add((Object)appInfo);
        }
        if ((checkSumFile = new File(checkSum = FileUtils.cleanString((String)(zipPath + File.separator + CHECK_SUM)))).exists()) {
            files.add((Object)checkSum);
        }
        for (String zipName : zipNames) {
            String zipAppPath = FileUtils.cleanString((String)(zipPath + File.separator + "dm" + File.separator + zipName + ".zip"));
            File zipAppFile = new File(zipAppPath);
            if (!zipAppFile.exists()) continue;
            files.add((Object)zipAppPath);
        }
        String libPath = FileUtils.cleanString((String)(zipPath + File.separator + "jar"));
        File libFile = new File(libPath);
        if (libFile.exists()) {
            files.add((Object)libPath);
        }
        if ((customResourceFile = new File(customResourcePath = FileUtils.cleanString((String)(zipPath + File.separator + RESOURCE + File.separator + CUSTOM)))).exists()) {
            files.add((Object)customResourcePath);
        }
        if ((staticResourceFile = new File(staticResourcePath = FileUtils.cleanString((String)(zipPath + File.separator + RESOURCE + File.separator + UPLOADSOURCE)))).exists()) {
            files.add((Object)staticResourcePath);
        }
        String zipFilePath = FileUtils.cleanString((String)(zipPath + File.separator + defaultAppPackageName + ".zip"));
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevportalUtil.compressZipFile(files, out, zipNames);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void zipFiles(String zipName, String localPath, List<File> fileList) {
        JSONArray files = new JSONArray();
        String MetadataPath = FileUtils.cleanString((String)((localPath = DevportalUtil.checkFilePath(localPath)) + File.separator + "metadata"));
        File MetadataFile = new File(MetadataPath);
        if (MetadataFile.exists()) {
            files.add((Object)MetadataPath);
        }
        if (fileList != null && fileList.size() > 0) {
            for (File file : fileList) {
                try {
                    files.add((Object)file.getCanonicalPath());
                }
                catch (IOException e) {
                    DevportalUtil.setErrorLog(e);
                }
            }
        }
        String zipFilePath = FileUtils.cleanString((String)(localPath + File.separator + zipName + ".zip"));
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            DevportalUtil.zipFile(files, out, "");
        }
        catch (IOException e) {
            DevportalUtil.setErrorLog(e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static void zipFile(JSONArray files, ZipOutputStream out, String pathSign) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        DevportalUtil.setErrorLog(e);
                    }
                }
                DevportalUtil.zipFile(tempFiles, out, pathSign);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                DevportalUtil.setErrorLog(e);
            }
            Path zipFilePath = Paths.get(path, new String[0]);
            String fileName = file.getName();
            int t = -1;
            if (path == null) continue;
            if (path.contains("datamodel")) {
                t = path.indexOf("datamodel");
            }
            if (path.contains("jar") && path.endsWith(".zip") && !fileName.contains("jar")) {
                t = path.indexOf("jar");
            }
            if (StringUtils.isNotBlank((CharSequence)pathSign)) {
                if (path.contains(pathSign) && !path.contains(JSONTYPE)) {
                    t = path.indexOf("webapp");
                } else if (path.contains(JSONTYPE)) {
                    t = path.indexOf(pathSign);
                }
            } else if ((path.contains(CUSTOM) || path.contains(UPLOADSOURCE)) && path.endsWith(".zip") && !fileName.contains(CUSTOM) && !fileName.contains(UPLOADSOURCE)) {
                t = path.indexOf(RESOURCE);
            }
            if (t == -1) continue;
            if ((path = path.endsWith(JSONTYPE) ? path.substring(t + pathSign.length() + 1, path.length()) : path.substring(t, path.length())).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipFilePath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                DevportalUtil.setErrorLog(exception);
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private static void compressZipFile(JSONArray files, ZipOutputStream out, List<String> zipNames) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        DevportalUtil.setErrorLog(e);
                    }
                }
                DevportalUtil.zipFile(tempFiles, out, "");
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                DevportalUtil.setErrorLog(e);
            }
            if (path == null) continue;
            Path zipPath = Paths.get(path, new String[0]);
            int t = -1;
            if (path.contains(KDPKGS)) {
                t = path.indexOf(KDPKGS);
            }
            if (path.contains(ERRORINFO)) {
                t = path.indexOf(ERRORINFO);
            }
            if (path.contains(APPINFOXML)) {
                t = path.indexOf(APPINFOXML);
            }
            if (path.contains(CHECK_SUM)) {
                t = path.indexOf(CHECK_SUM);
            }
            if (path.endsWith(".zip")) {
                for (String zipName : zipNames) {
                    if (!path.endsWith(zipName + ".zip")) continue;
                    t = path.indexOf(zipName + ".zip");
                }
            }
            if (t == -1) continue;
            path = path.endsWith(".zip") ? path.substring(t - 3, path.length()) : path.substring(t, path.length());
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                DevportalUtil.setErrorLog(exception);
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    public static List<String> recursiveFiles(String path, List<String> fileList) {
        String checkPath = DevportalUtil.checkFilePath(path);
        String filePath = FileUtils.cleanString((String)checkPath);
        File file = new File(filePath);
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        for (File f : files) {
            String canonicalPath = null;
            try {
                canonicalPath = f.getCanonicalPath();
            }
            catch (IOException e) {
                DevportalUtil.setErrorLog(e);
            }
            if (f.isDirectory()) {
                DevportalUtil.recursiveFiles(canonicalPath, fileList);
                continue;
            }
            if (!f.isFile()) continue;
            fileList.add(canonicalPath);
        }
        return fileList;
    }

    public static String unZipSingleFile(String zipFileName, JSONObject unZipResult) {
        File file = new File(zipFileName);
        if (!file.exists()) {
            unZipResult.put(KEY_ERROR, (Object)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bfb\u53d6\u9700\u5bfc\u5165\u7684\u6587\u4ef6 %s\u3002", (String)"DevportalUtil_70", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), zipFileName));
            return "";
        }
        if (!zipFileName.endsWith(".zip")) {
            unZipResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6587\u4ef6\u5e94\u8be5\u662fzip\u6587\u4ef6\u3002", (String)"DevportalUtil_71", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return "";
        }
        String filePath = file.getParent();
        Path path = Paths.get(DevportalUtil.checkFilePath(zipFileName), new String[0]);
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 1);
                    File entryFile = new File(FileUtils.cleanString((String)(filePath + File.separator + name)));
                    entryFile.mkdirs();
                    continue;
                }
                String childFilePath = FileUtils.cleanString((String)(filePath + File.separator + entry.getName()));
                File child = new File(childFilePath);
                String childPath = child.getCanonicalPath();
                if (childPath.contains("\\")) {
                    childPath = childPath.replace('\\', '/');
                    child = new File(FileUtils.cleanString((String)childPath));
                }
                if (!child.getParentFile().exists()) {
                    child.getParentFile().mkdirs();
                }
                String checkChildFilePath = FileUtils.cleanString((String)childFilePath);
                Path customZipPath = Paths.get(DevportalUtil.checkFilePath(checkChildFilePath), new String[0]);
                OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    BufferedOutputStream out = new BufferedOutputStream(outputStream);
                    Throwable throwable2 = null;
                    try {
                        int n = 0;
                        byte[] buf = new byte[1024];
                        while ((n = in.read(buf)) != -1) {
                            out.write(buf, 0, n);
                        }
                        in.closeEntry();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            DevportalUtil.setErrorLog(e);
            unZipResult.put(KEY_ERROR, (Object)String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u65f6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"DevportalUtil_72", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), e.getMessage()));
            return "";
        }
        return filePath;
    }

    public static String getBizCloudNameById(String bizcloudid) {
        boolean flag = QueryServiceHelper.exists((String)"bos_devportal_bizcloud", (Object)bizcloudid);
        if (flag) {
            DynamicObject bizCloudName = BusinessDataServiceHelper.loadSingle((Object)bizcloudid, (String)"bos_devportal_bizcloud", (String)"name");
            return bizCloudName.getString("name");
        }
        return "";
    }

    public static String getBizAppNameById(String bizAppId) {
        return AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false).getName().toString();
    }

    public static String getBizUnitNameById(String bizAppId, String bizUnitId) {
        AppFunctionPacketElement unitObject = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        return unitObject.getName().toString();
    }

    public static String getBizUnitTypeById(String bizAppId, String bizUnitId) {
        AppFunctionPacketElement unitObject = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        return unitObject.getType();
    }

    public static void gotoEntityDesigner(IFormView view, String entityId) {
        String isv;
        boolean isHasPermisson = AppUtils.checkPagePermission((String)"bos_devn_appdetail", (String)"4715a0df000000ac");
        if (!isHasPermisson) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"DevportalUtil_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qFormId = new QFilter("form", "=", (Object)entityId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            String number = MetadataDao.getNumberById((String)entityId);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u8df3\u8f6c\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u201c%s\u201d\u3002", (String)"DevportalUtil_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), number));
            return;
        }
        String appId = pageRelInfo.getString(BIZAPP);
        DynamicObject pageInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)entityId, (String)"bos_formmeta");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_devpn_businessobj");
        showParameter.setCustomParam("entityId", (Object)entityId);
        showParameter.setCustomParam(NUMBER, pageInfo.get(NUMBER));
        showParameter.setCustomParam(BIZAPPID, (Object)appId);
        showParameter.setClientParam(MODELTYPE, pageInfo.get(MODELTYPE));
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        showParameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        showParameter.setStatus(OperationStatus.EDIT);
        if ("2".equals(pageInfo.getString("type")) && !"kdxk".equals(isv = pageInfo.getString("isv"))) {
            showParameter.setClientParam("ext", (Object)"true");
            showParameter.setCustomParam("ext", (Object)"true");
        }
        view.showForm(showParameter);
    }

    public static void gotoExtPageDesinger(IFormView view, String id, String pageNumber) {
        DevportalUtil.innerGotoPageDesinger(view, id, pageNumber, true);
    }

    public static void gotoPageDesinger(IFormView view, String id, String pageNumber) {
        DevportalUtil.innerGotoPageDesinger(view, id, pageNumber, false);
    }

    private static void innerGotoPageDesinger(IFormView view, String id, String pageNumber, boolean isForBizExt) {
        String isv;
        boolean isHasPermisson;
        if (!isForBizExt && !(isHasPermisson = AppUtils.checkPagePermission((String)pageNumber, (String)"4715a0df000000ac"))) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"DevportalUtil_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u8df3\u8f6c\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u201c%s\u201d\u3002", (String)"DevportalUtil_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageNumber));
            return;
        }
        String appId = pageRelInfo.getString(BIZAPP);
        DynamicObject pageInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_formmeta");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_formdesigner");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam(NUMBER, pageInfo.get(NUMBER));
        parameter.setCustomParam(BIZAPPID, (Object)appId);
        parameter.setClientParam(MODELTYPE, pageInfo.get(MODELTYPE));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        if (isForBizExt) {
            parameter.setClientParam("bizext", (Object)"true");
            parameter.setCustomParam("bizext", (Object)"true");
        } else if ("2".equals(pageInfo.getString("type")) && !"kdxk".equals(isv = pageInfo.getString("isv"))) {
            parameter.setClientParam("ext", (Object)"true");
            parameter.setCustomParam("ext", (Object)"true");
        }
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        view.showForm(parameter);
    }

    public static FormShowParameter createNewPageDesinger(IFormView view, String id, String pageNumber) {
        String isv;
        boolean isHasPermisson = AppUtils.checkPagePermission((String)pageNumber, (String)"4715a0df000000ac");
        if (!isHasPermisson) {
            view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5\u3002", (String)"DevportalUtil_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return null;
        }
        QFilter qFormId = new QFilter("form", "=", (Object)id);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{qFormId});
        if (StringUtils.isBlank((Object)pageRelInfo)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u9875\u9762\u8df3\u8f6c\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u201c%s\u201d\u3002", (String)"DevportalUtil_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), pageNumber));
            return null;
        }
        String appId = pageRelInfo.getString(BIZAPP);
        DynamicObject pageInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"bos_formmeta");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devpn_formdesign");
        parameter.setCustomParam("id", (Object)id);
        parameter.setCustomParam(NUMBER, pageInfo.get(NUMBER));
        parameter.setCustomParam(BIZAPPID, (Object)appId);
        parameter.setClientParam(MODELTYPE, pageInfo.get(MODELTYPE));
        parameter.setClientParam("modelver", (Object)DomainModelType.getVersion());
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        if ("2".equals(pageInfo.getString("type")) && !"kdxk".equals(isv = pageInfo.getString("isv"))) {
            parameter.setClientParam("ext", (Object)"true");
            parameter.setCustomParam("ext", (Object)"true");
        }
        return parameter;
    }

    public static void gotoNewPageDesinger(IFormView view, String id, String pageNumber) {
        FormShowParameter parameter = DevportalUtil.createNewPageDesinger(view, id, pageNumber);
        if (parameter != null) {
            view.showForm(parameter);
        }
    }

    public static int getMaxUnitSeq(String bizAppId, boolean flag) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List funcEles = appMetadata.getAppFunctionPackets();
        ArrayList<Integer> parentSeqList = new ArrayList<Integer>();
        ArrayList<Integer> childSeqList = new ArrayList<Integer>();
        for (AppFunctionPacketElement funcEle : funcEles) {
            String funcParentId = funcEle.getParentId();
            Integer functionSeq = funcEle.getSeq();
            if (StringUtils.isNotBlank((CharSequence)funcParentId)) {
                childSeqList.add(functionSeq);
                continue;
            }
            parentSeqList.add(functionSeq);
        }
        if (flag) {
            if (parentSeqList.size() > 0) {
                Collections.sort(parentSeqList);
                return (Integer)parentSeqList.get(parentSeqList.size() - 1);
            }
            return 0;
        }
        if (childSeqList.size() > 0) {
            Collections.sort(childSeqList);
            return (Integer)childSeqList.get(childSeqList.size() - 1);
        }
        return 0;
    }

    public static void expAppMetadata(String bizAppId, String exportPath, String sourceType) {
        List list = AppMetaServiceHelper.getAppDeployFile((String)bizAppId);
        if (list.size() > 0) {
            String appIsv = AppMetaServiceHelper.getIsvByAppId((String)bizAppId);
            String dymMeta = ((DeployFile)list.get(0)).getFileContent();
            String dymFileName = ((DeployFile)list.get(0)).getFileName();
            DevportalUtil.saveMetaFile(dymMeta, dymFileName, exportPath);
            for (int i = 1; i < list.size(); ++i) {
                String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                if (dymLangFileName.endsWith("zh_CN.appx")) {
                    DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                    continue;
                }
                if (!EXPORT_APP.equals(sourceType) || ORITENENTISV.equals(appIsv)) continue;
                DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
            }
        }
    }

    public static void expCloudMetadata(String cloudId, String exportPath, String sourceType) {
        List list = MetadataDao.getCloudDeployFile((String)cloudId);
        if (list.size() > 0) {
            String cloudIsv = BusinessDataServiceHelper.loadSingleFromCache((Object)cloudId, (String)"bos_devportal_bizcloud", (String)"isv").getString("isv");
            String dymMeta = ((DeployFile)list.get(0)).getFileContent();
            String dymFileName = ((DeployFile)list.get(0)).getFileName();
            DevportalUtil.saveMetaFile(dymMeta, dymFileName, exportPath);
            for (int i = 1; i < list.size(); ++i) {
                String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                if (dymLangFileName.endsWith("zh_CN.cldx")) {
                    DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
                    continue;
                }
                if (!EXPORT_CLOUD.equals(sourceType) || ORITENENTISV.equals(cloudIsv)) continue;
                DevportalUtil.saveMetaFile(dymLangMeta, dymLangFileName, exportPath);
            }
        }
    }

    public static JSONArray getUnitListData(String bizAppId) {
        JSONArray array = new JSONArray();
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        if (appMetadata != null) {
            String appType = appMetadata.getDevType();
            String codeManagerType = DevportalUtil.getCodeManageType();
            for (AppFunctionPacketElement funcPacket : appMetadata.getAppFunctionPackets()) {
                JSONObject jsonObject = new JSONObject();
                String unitId = funcPacket.getId();
                jsonObject.put("id", (Object)unitId);
                jsonObject.put("seq", (Object)funcPacket.getSeq());
                jsonObject.put(NUMBER, (Object)funcPacket.getNumber());
                jsonObject.put("name", (Object)funcPacket.getName().toString());
                jsonObject.put(DESCRIPTION, (Object)funcPacket.getDescription());
                jsonObject.put(BIZAPPID, (Object)appMetadata.getId());
                jsonObject.put(PARENTID, (Object)funcPacket.getParentId());
                jsonObject.put("unittype", (Object)funcPacket.getType());
                jsonObject.put("children", (Object)new JSONArray());
                jsonObject.put("apptype", (Object)appType);
                jsonObject.put(CODEMANAGE, (Object)codeManagerType);
                array.add((Object)jsonObject);
            }
        }
        return array;
    }

    public static JSONArray getAppsInCloud(String bizCloudId) {
        JSONArray bizAppObjects = new JSONArray();
        QFilter q = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        DynamicObject[] appObjects = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number", (QFilter[])filters, (String)SEQUENCE_ASC);
        for (int i = 0; i < appObjects.length; ++i) {
            JSONObject app = new JSONObject();
            app.put("id", (Object)appObjects[i].getString("id"));
            app.put("name", (Object)appObjects[i].getLocaleString("name").toString());
            app.put(NUMBER, (Object)appObjects[i].getString(NUMBER));
            bizAppObjects.add((Object)app);
        }
        return bizAppObjects;
    }

    public static void locateResourcePos(JSONObject arg, IFormView view, String resourceType) {
        String bizUnitId = arg.getString("bizunitid");
        String bizPageId = arg.getString("bizpageid");
        String bizAppId = arg.getString(BIZAPPID);
        JSONArray unitItems = DevportalUtil.getUnitListData(bizAppId);
        JSONObject targetUnit = null;
        for (int i = 0; i < unitItems.size(); ++i) {
            JSONObject unit = unitItems.getJSONObject(i);
            if (!bizUnitId.equals(unit.getString("id"))) continue;
            targetUnit = unit;
            break;
        }
        if (targetUnit == null) {
            view.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6240\u5c5e\u529f\u80fd\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8df3\u8f6c\u3002", (String)"DevportalUtil_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        DevportalUtil.changeTabToDev(arg, view, appMetadata);
        String bizAppNumber = appMetadata.getNumber();
        String appPageID = bizAppNumber + view.getParentView().getPageId();
        JSONObject dataSource = new JSONObject();
        dataSource.put("type", (Object)resourceType);
        ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("CHANGE_DATASOURCETYPE", (Object)dataSource);
        ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("REFRESH_UNIT_LIST", (Object)unitItems);
        JSONObject data = new JSONObject();
        data.put("selectedUnit", (Object)bizUnitId);
        data.put("selectedUnitName", (Object)targetUnit.getString("name"));
        data.put("selectedUnitType", (Object)targetUnit.getString("unittype"));
        ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("INIT_SELECTEDUNITID", (Object)data);
        ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("INIT_SELECTEDUNITNAME", (Object)data);
        ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("INIT_SELECTEDUNITTYPE", (Object)data);
        data.put("id", (Object)bizPageId);
        if ("page".equals(resourceType)) {
            ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("INIT_SELECTEDPAGE", (Object)data);
            JSONArray pageItems = DevportalUtil.getSelectedUnitPages(bizAppId, bizUnitId, null, null, null);
            ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("REFRESH_PAGE_LIST", (Object)pageItems);
            ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("INIT_LOCATEDTARGET", (Object)bizPageId);
        }
        ((IClientViewProxy)view.getView(appPageID).getService(IClientViewProxy.class)).addAction("RESET_RESOURCEFILTER", (Object)"");
        view.sendFormAction(view.getView(appPageID));
    }

    public static void changeTabToDev(JSONObject arg, IFormView view, AppMetadata appMetadata) {
        if (arg == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"changeTabToDev\u65b9\u6cd5\u63a5\u6536\u524d\u7aef\u6570\u636e\u4f20\u9012\u5f02\u5e38\u3002", (String)"DevportalUtil_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = arg.getString(BIZAPPID);
        String bizCloudId = arg.getString(BIZCLOUDID);
        Boolean isNeedGuide = arg.getBoolean("isneedguide");
        if (StringUtils.isBlank((CharSequence)bizCloudId)) {
            bizCloudId = appMetadata.getBizCloudID();
        }
        String bizAppType = appMetadata.getDevType();
        String bizAppNumber = appMetadata.getNumber();
        String bizAppName = appMetadata.getName().toString();
        String appPageID = bizAppNumber + view.getParentView().getPageId();
        IFormView childView = view.getView(appPageID);
        if ("2".equals(bizAppType)) {
            if (childView == null) {
                DevportalUtil.OpenAppTab(appPageID, bizAppId, bizAppName, "BOS_DEVP_DEVPMANAGER", bizCloudId, view, isNeedGuide);
            } else {
                childView.activate();
                view.sendFormAction(childView);
            }
        } else if (childView == null) {
            DevportalUtil.OpenAppTab(appPageID, bizAppId, bizAppName, FORMNAME, bizCloudId, view, isNeedGuide);
        } else {
            childView.activate();
            view.sendFormAction(childView);
        }
    }

    public static void OpenAppTab(String appPageID, String bizAppId, String bizAppName, String bizFormNumber, String bizCloudId, IFormView view, Boolean isNeedGuide) {
        IFormView parentView = view.getParentView();
        String appListPageId = view.getPageId();
        FormShowParameter bizAppManagerParameter = new FormShowParameter();
        bizAppManagerParameter.getOpenStyle().setTargetKey("tabap");
        bizAppManagerParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        bizAppManagerParameter.setFormId(bizFormNumber);
        bizAppManagerParameter.setCaption(bizAppName);
        bizAppManagerParameter.setPageId(appPageID);
        bizAppManagerParameter.setCustomParam("apppageid", (Object)appPageID);
        bizAppManagerParameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        bizAppManagerParameter.setCustomParam(BIZCLOUDID, (Object)bizCloudId);
        bizAppManagerParameter.setCustomParam("isneedguide", (Object)isNeedGuide);
        bizAppManagerParameter.setCustomParam("applistpageid", (Object)appListPageId);
        parentView.showForm(bizAppManagerParameter);
        view.sendFormAction(parentView);
    }

    public static List<ComboItem> getOrgFuncComboItems() {
        ArrayList<ComboItem> modleItem = new ArrayList<ComboItem>();
        List orgInfoList = OrgUnitServiceHelper.getOrgBizSelectorList();
        for (Map orgInfoMap : orgInfoList) {
            for (Map.Entry orgInfo : orgInfoMap.entrySet()) {
                String orgNum = (String)orgInfo.getKey();
                String orgName = (String)orgInfo.getValue();
                modleItem.add(new ComboItem(new LocaleString(orgName), orgNum));
            }
        }
        return modleItem;
    }

    public static List<ComboItem> getDBRouteComboItems(String cloudNum) {
        List<String> dbRouteKeys;
        DynamicObject cloudObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizcloud", (String)"number,isv", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)cloudNum)});
        if (!DevportalUtil.acctIsvIsKingdee() && !ORITENENTISV.equals(cloudObj.getString("isv"))) {
            cloudNum = "secd";
        }
        if (!(dbRouteKeys = DevportalUtil.getDBRoutesByCloudNumber(cloudNum)).contains(cloudNum = cloudNum.toLowerCase())) {
            dbRouteKeys.add(cloudNum);
        }
        ArrayList<ComboItem> dbRouteItem = new ArrayList<ComboItem>(dbRouteKeys.size());
        Iterator<String> iterator = dbRouteKeys.iterator();
        while (iterator.hasNext()) {
            String key;
            String name = key = iterator.next();
            if (key.trim().equalsIgnoreCase(cloudNum)) {
                name = String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4(%s)", (String)"DevportalUtil_24", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), cloudNum);
            }
            dbRouteItem.add(new ComboItem(new LocaleString(name), key));
        }
        return dbRouteItem;
    }

    public static List<String> getDBRoutesByCloudNumber(String cloudNumber) {
        ArrayList<String> rt = new ArrayList<String>();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(CONTENT_TYPE, APPLICATION_JSONANDCHARSET);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cloud", cloudNumber);
        String host = System.getProperty(MC_SERVER_URL);
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONArray data;
                JSONObject resp;
                String param = JSONUtils.toString(params);
                String sHttpResponse = HttpClientUtils.postjson((String)(host + "/login/getdbroutebycloud"), header, (String)param);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && ((resp = JSONObject.parseObject((String)sHttpResponse)).getInteger(ERRORCODE) == 100 || resp.getInteger(ERRORCODE) == 101) && (data = resp.getJSONArray("data")) != null) {
                    for (int i = 0; i < data.size(); ++i) {
                        JSONObject obj = (JSONObject)data.get(i);
                        rt.add(obj.getString("routeKey"));
                    }
                }
            }
            catch (IOException e) {
                DevportalUtil.setErrorLog(e);
                throw new KDBizException(e.getMessage());
            }
            catch (JSONException exception) {
                DevportalUtil.setErrorLog((Exception)((Object)exception));
            }
        }
        return rt;
    }

    public static JSONArray getAppsInfoByCloudId(String bizCloudId, IFormView view) {
        QFilter q = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        return DevportalUtil.getAppsInfoByFilters(filters, view);
    }

    public static boolean checkIsvPermission(String resIsv) {
        boolean ret = false;
        String acctIsv = ISVService.getISVInfo().getId();
        if (acctIsv != null && acctIsv.equals(resIsv)) {
            ret = true;
        }
        return ret;
    }

    public static boolean isExtendApp(String type) {
        return "2".equals(type);
    }

    public static boolean acctIsvIsKingdee() {
        String acctIsv = ISVService.getISVInfo().getId();
        return ORITENENTISV.equals(acctIsv);
    }

    public static String autoIsvNumber(String number) {
        String isv = AppUtils.getDeveloperInfo();
        number = number.toLowerCase(Locale.ENGLISH);
        return DevportalUtil.autoIsvNumber(number, isv);
    }

    public static String autoIsvNumber(String number, String isv) {
        PluginProxy proxy = pluginProxyUtil.create((Object)new DefaultDevPortalUtilExtPlugin(), IDevPortalUtilExtPlugin.class);
        List numberList = proxy.callReplaceIfPresent(o -> o.autoISVNumber(number, isv));
        return (String)numberList.get(0);
    }

    public static String autoFormName(String formName) {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (metaDataUtil.checkName(formName)) {
            int i = 0;
            String name = formName;
            while (metaDataUtil.checkName(name)) {
                name = formName + ++i;
            }
            formName = name;
        }
        return formName;
    }

    public static String autoFormNumber(String formNumber, String tag) {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        if (formNumber.length() <= 25) {
            if (metaDataUtil.checkNumber(formNumber)) {
                int i = 0;
                String number = formNumber;
                while (metaDataUtil.checkNumber(number)) {
                    number = formNumber + ++i;
                }
                formNumber = number;
            }
        } else {
            int tag_len = tag.length();
            formNumber = formNumber.substring(0, 25 - tag_len) + tag;
            int i = 0;
            while (metaDataUtil.checkNumber(formNumber)) {
                int i_len = String.valueOf(++i).length();
                formNumber = formNumber.substring(0, 25 - tag_len - i_len) + tag + i;
            }
        }
        return formNumber;
    }

    public static String getAppVerion(String appNum) {
        String version = DBVersion.getVer();
        if (StringUtils.isNotBlank((CharSequence)appNum)) {
            String appVer;
            QFilter filter = new QFilter(NUMBER, "=", (Object)appNum);
            if (QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{filter})) {
                version = "";
            }
            if (StringUtils.isNotBlank((CharSequence)(appVer = DBVersion.getAppVer((String)appNum)))) {
                version = appVer;
            }
        }
        return version;
    }

    private static Map<String, String> getAppVersionMap(Set<String> appNumbers) {
        if (appNumbers.isEmpty()) {
            return new HashMap<String, String>();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fappid,fdbversion from T_BAS_APPVERSION", new Object[0]);
        sql.append("where", new Object[0]);
        sql.appendIn("fappid", appNumbers.toArray());
        Map map1 = (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)sql, rs -> {
            HashMap<String, String> m = new HashMap<String, String>(10);
            while (rs.next()) {
                m.put(rs.getString("fappid"), rs.getString("fdbversion"));
            }
            return m;
        });
        HashMap<String, String> map = new HashMap<String, String>(appNumbers.size());
        String value = "1.5.0";
        for (String number : appNumbers) {
            String version = (String)map1.get(number);
            if (version == null) {
                version = value;
            }
            map.put(number, version);
        }
        return map;
    }

    public static JSONArray getAppsInfoByFilters(QFilter[] filters, IFormView view) {
        String selectFields = "id,sequence,number,name,description,version,visible,type,deploystatus,isv,bizcloud,image,backimage,masterid,industry,metadata";
        filters = RunModeServiceHelper.getAppIdBlacklistFilters((QFilter[])filters, (String)"id");
        filters = DevportalUtil.getPermissionListFilter(filters);
        Map appQueryResult = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)selectFields, (QFilter[])filters, (String)SEQUENCE_ASC);
        String tenantIsv = ISVService.getISVInfo().getId();
        List<String> collectApps = DevportalUtil.getCollectedApps();
        String dbVersion = DBVersion.getVer();
        HashSet<String> appNumbers = new HashSet<String>(appQueryResult.size());
        JSONArray appItemInfoArray = new JSONArray();
        Iterator iterator = appQueryResult.keySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject appObject = (DynamicObject)appQueryResult.get(iterator.next());
            String appNumber = appObject.getString(NUMBER);
            appNumbers.add(appNumber);
        }
        Map<String, String> appVersionMap = DevportalUtil.getAppVersionMap(appNumbers);
        String codeManage = DevportalUtil.getCodeManageType();
        Iterator iterator2 = appQueryResult.keySet().iterator();
        while (iterator2.hasNext()) {
            DynamicObject industry;
            DynamicObject appObject = (DynamicObject)appQueryResult.get(iterator2.next());
            JSONObject appItem = new JSONObject();
            String bizAppId = appObject.getString("id");
            String devType = appObject.getString("type");
            String masterId = appObject.getString(MASTERID);
            ILocaleString name = appObject.getLocaleString("name");
            String image = appObject.getString(IMAGE);
            String appNumber = appObject.getString(NUMBER);
            String appVersion = appObject.getString(VERSION);
            String version = dbVersion;
            if (StringUtils.isNotBlank((CharSequence)appVersion)) {
                version = appVersion;
            }
            if ((industry = appObject.getDynamicObject(INDUSTRY)) != null) {
                String industryName = industry.getLocaleString("name").toString();
                appItem.put(INDUSTRY, (Object)industryName);
                String industrySimpleName = industry.getLocaleString("simplename").toString();
                appItem.put("industryshort", (Object)industrySimpleName);
            }
            if ("2".equals(devType) && StringUtils.isNotBlank((CharSequence)masterId)) {
                DynamicObject masterObj = (DynamicObject)appQueryResult.get(masterId);
                String masterName = "";
                if (masterObj != null) {
                    masterName = masterObj.getLocaleString("name").toString();
                } else {
                    AppMetadata masterAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)masterId, (boolean)false);
                    if (masterAppMeta != null) {
                        masterName = masterAppMeta.getName().toString();
                    } else {
                        logger.debug("appid=" + bizAppId + "appname" + name.toString());
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)masterName)) {
                    appItem.put("mastername", (Object)masterName);
                }
            }
            String appIsv = appObject.getString("isv");
            appItem.put("id", (Object)bizAppId);
            appItem.put("type", (Object)devType);
            appItem.put("isv", (Object)appIsv);
            appItem.put("seq", (Object)appObject.getString(SEQUENCE));
            appItem.put("name", (Object)(name == null ? "" : name.toString()));
            appItem.put(NUMBER, (Object)appObject.getString(NUMBER));
            appItem.put(DESCRIPTION, (Object)appObject.getLocaleString(DESCRIPTION).toString());
            appItem.put(VERSION, (Object)version);
            appItem.put(VISIBLE, (Object)appObject.getBoolean(VISIBLE));
            appItem.put(DEPLOYSTATUS, (Object)appObject.getString(DEPLOYSTATUS));
            String bizCloudId = appObject.getString("bizcloud_id");
            appItem.put(BIZCLOUDID, (Object)bizCloudId);
            appItem.put(IMAGE, (Object)image);
            appItem.put(BACKIMAGE, (Object)appObject.getString(BACKIMAGE));
            appItem.put(CODEMANAGE, (Object)codeManage);
            appItem.put("iscollected", (Object)(collectApps.contains(bizAppId) ? 1 : 0));
            appItem.put("countNumber", (Object)0);
            appItem.put("isowner", (Object)(appIsv.equals(tenantIsv) ? Boolean.TRUE : Boolean.FALSE));
            appItemInfoArray.add((Object)appItem);
        }
        return appItemInfoArray;
    }

    public static QFilter[] getPermissionListFilter(QFilter[] filters) {
        if (!DevportalUtil.isVerifyPermission()) {
            return filters;
        }
        Set apps = DevVerifyServiceHelper.getPermissionAppByUser((Long)RequestContext.get().getCurrUserId());
        if (apps != null) {
            ArrayList<QFilter> list = new ArrayList<QFilter>(Arrays.asList(filters));
            QFilter qFilter = new QFilter("id", "in", (Object)apps);
            list.add(qFilter);
            filters = list.toArray(new QFilter[list.size()]);
        }
        logger.debug("getPermissionListFilter() apps: " + apps);
        return filters;
    }

    public static boolean isVerifyPermission() {
        Object devPermission = DevportalVerify.getParameter((String)"dev_permission");
        Object devNoPermission = DevportalVerify.getParameter((String)"dev_nopermission");
        logger.debug("dev_permission: " + devPermission + " dev_nopermission: " + devNoPermission);
        if (devPermission == null || devNoPermission == null) {
            return false;
        }
        return (Boolean)devPermission != false && (Boolean)devNoPermission != false;
    }

    @Deprecated
    public static String getCodeManageType(DynamicObject dynamicObject) {
        return DevportalUtil.getCodeManageType();
    }

    public static String getCodeManageTypeByBizAppId(String bizAppId) {
        return DevportalUtil.getCodeManageType();
    }

    public static String getCodeManageType() {
        if (DevportalUtil.isDevelopEnv()) {
            return DevportalUtil.isGitManageType() ? "git" : "svn";
        }
        return "none";
    }

    public static JSONArray getCloudsInfo(IFormView view) {
        return DevportalUtil.getCloudsInfo();
    }

    public static JSONArray getCloudsInfo() {
        JSONArray cloudItemArray = new JSONArray();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String selectFields = "id,sequence,number,name,description,version,type,visible,creater,createdate,modifier,modifydate,image,backimage,isv,industry";
        QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)"id");
        Map cloudObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)selectFields, (QFilter[])filters, (String)SEQUENCE_ASC);
        String codeManagerType = DevportalUtil.getCodeManageType();
        Iterator iterator = cloudObjects.keySet().iterator();
        while (iterator.hasNext()) {
            DynamicObject industry;
            DynamicObject cloudObject = (DynamicObject)cloudObjects.get(iterator.next());
            if ("2HGKCE94QELW".equalsIgnoreCase(cloudObject.getString("id"))) continue;
            JSONObject cloudItem = new JSONObject();
            cloudItem.put("id", (Object)cloudObject.getString("id"));
            cloudItem.put("seq", (Object)cloudObject.getString(SEQUENCE));
            cloudItem.put(NUMBER, (Object)cloudObject.getString(NUMBER));
            cloudItem.put("name", (Object)cloudObject.getLocaleString("name").toString());
            cloudItem.put(DESCRIPTION, (Object)cloudObject.getLocaleString(DESCRIPTION).toString());
            cloudItem.put(VERSION, (Object)cloudObject.getString(VERSION));
            cloudItem.put("type", (Object)cloudObject.getString("type"));
            cloudItem.put(VISIBLE, (Object)cloudObject.getBoolean(VISIBLE));
            cloudItem.put("creater", (Object)cloudObject.getString("creater"));
            if (cloudObject.get(CREATEDATE) != null) {
                cloudItem.put(CREATEDATE, (Object)sdf.format(cloudObject.get(CREATEDATE)));
            }
            cloudItem.put("modifier", cloudObject.get("modifier"));
            if (cloudObject.get(MODIFYDATE) != null) {
                cloudItem.put(MODIFYDATE, (Object)sdf.format(cloudObject.get(MODIFYDATE)));
            }
            if ((industry = cloudObject.getDynamicObject(INDUSTRY)) != null) {
                String industrySimpleName = industry.getLocaleString("simplename").toString();
                cloudItem.put("industryshort", (Object)industrySimpleName);
            }
            cloudItem.put(IMAGE, (Object)cloudObject.getString(IMAGE));
            cloudItem.put(BACKIMAGE, (Object)cloudObject.getString(BACKIMAGE));
            String cloudIsv = cloudObject.getString("isv");
            cloudItem.put("isv", (Object)cloudIsv);
            boolean isOwner = DevportalUtil.checkIsvPermission(cloudIsv);
            cloudItem.put("isowner", (Object)isOwner);
            cloudItem.put(CODEMANAGE, (Object)codeManagerType);
            cloudItemArray.add((Object)cloudItem);
        }
        return cloudItemArray;
    }

    public static void deleteAppConfirm(String bizAppId, String bizAppNumber, String bizAppName, String jSessionId, IFormView view, AbstractFormPlugin plugin) {
        String appPageID;
        IFormView childView;
        String resIsv = AppUtils.getIsvByAppId((String)bizAppId);
        if (ORITENENTISV.equals(resIsv) && !DevportalUtil.checkIsvPermission(resIsv)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"DevportalUtil_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObject appObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bizAppId, (String)BOS_DEVPORTAL_BIZAPP, (String)"type,deploystatus");
        String appType = appObject.getString("type");
        String deployStatus = appObject.getString(DEPLOYSTATUS);
        if (!"2".equals(appType) && "2".equals(deployStatus)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5df2\u542f\u7528\uff0c\u8bf7\u5148\u7981\u7528\u5e94\u7528\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DevportalUtil_25", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(PARENTID, "=", (Object)bizAppId)};
        boolean exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters);
        if (exists) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5b58\u5728\u6269\u5c55\u5e94\u7528\uff0c\u8bf7\u5148\u5220\u9664\u6269\u5c55\u5e94\u7528\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DevportalUtil_26", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        QFilter[] filter = new QFilter[]{new QFilter("refapp", "=", (Object)bizAppId)};
        boolean flag = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filter);
        if (flag) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5df2\u88ab\u5173\u8054\uff0c\u8bf7\u5148\u89e3\u9664\u5173\u8054\u5173\u7cfb\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DevportalUtil_27", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (view.getParentView() != null && (childView = view.getView(appPageID = bizAppNumber + view.getParentView().getPageId())) != null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5df2\u5728\u9875\u7b7e\u4e2d\u6253\u5f00\uff0c\u8bf7\u5148\u5173\u95ed\u5e94\u7528\u9875\u7b7e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DevportalUtil_28", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_delbizapp");
        parameter.setCaption(String.format(ResManager.loadKDString((String)"\u5220\u9664 \"%s\"", (String)"DevportalUtil_81", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizAppName));
        parameter.setCustomParam(MESSAGE, (Object)String.format(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u5e94\u7528\u201c%s\u201d\u7684\u5168\u90e8\u5185\u5bb9\u5417\uff1f", (String)"DevportalUtil_30", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizAppName));
        parameter.setCustomParam(BIZAPPID, (Object)bizAppId);
        parameter.setCustomParam("jsessionid", (Object)jSessionId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "deleteAllAPPCallBack"));
        view.showForm(parameter);
    }

    public static Map<String, Object> deletePage(String formId, String bizUnitId, Boolean isCollection, String bizAppId, String bizAppType, String delType, String objectId) {
        Map<String, Object> result = new HashMap<String, Object>();
        try (TXHandle tx = TX.required((String)"mdl_BizPageListPlugin_deletePage");){
            DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)"bos_formmeta", (String)"masterid,type");
            try {
                QFilter f1;
                QFilter[] filters = null;
                if (bizUnitId != null) {
                    f1 = new QFilter(BIZUNIT, "=", (Object)bizUnitId);
                    QFilter f2 = new QFilter("form", "=", (Object)formId);
                    filters = new QFilter[]{f1, f2};
                } else {
                    f1 = new QFilter("form", "=", (Object)formId);
                    filters = new QFilter[]{f1};
                }
                DynamicObject dyc = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"id", (QFilter[])filters);
                if (dyc != null) {
                    String pkId = dyc.getString("id");
                    Object[] pkIds = new String[]{pkId};
                    MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bos_devportal_unitrelform");
                    DeleteServiceHelper.delete((IDataEntityType)met, (Object[])pkIds);
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u8868\u5355\u548c\u529f\u80fd\u5206\u7ec4\u7684\u5173\u8054\u5173\u7cfb", "DevportalUtil_73", BOS_DEVPORTAL_PLUGIN);
                    AppUtils.addOpLog((String)objectId, (String)"delete", (String)objectId, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                }
                if (isCollection.booleanValue()) {
                    QFilter f3 = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    QFilter f4 = new QFilter(BIZPAGE, "=", (Object)formId);
                    QFilter[] filterssc = new QFilter[]{f3, f4};
                    DynamicObjectCollection shortcutCollection = QueryServiceHelper.query((String)BOS_DEVPORTAL_SHORTCUT, (String)"id", (QFilter[])filterssc);
                    Iterator dyt = shortcutCollection.iterator();
                    Object[] showcutIds = new String[shortcutCollection.size()];
                    int i = 0;
                    while (dyt.hasNext()) {
                        String showcutId;
                        showcutIds[i] = showcutId = ((DynamicObject)dyt.next()).getString("id");
                        ++i;
                        MultiLangEnumBridge opNameFormCollect = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
                        MultiLangEnumBridge opDescFormCollect = new MultiLangEnumBridge("\u5220\u9664\u8868\u5355\u7684\u6536\u85cf", "DevportalUtil_74", BOS_DEVPORTAL_PLUGIN);
                        AppUtils.addOpLog((String)objectId, (String)"delete", (String)objectId, (String)"1", (MultiLangEnumBridge)opNameFormCollect, (MultiLangEnumBridge)opDescFormCollect, (String[])new String[0]);
                    }
                    try (TXHandle h = TX.requiresNew((String)"DevportalUtil.deleteShoutcut");){
                        try {
                            MainEntityType shortcutMet = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_SHORTCUT);
                            DeleteServiceHelper.delete((IDataEntityType)shortcutMet, (Object[])showcutIds);
                        }
                        catch (Exception e) {
                            logger.info(e.getMessage(), (Object)e);
                            h.markRollback();
                            result.put(MESSAGE, e.getMessage());
                        }
                    }
                }
                DynamicObject obj = DevportalUtil.createRecycleBinFormData(formId, ResManager.loadKDString((String)"\u5728\u5f00\u53d1\u8005\u95e8\u6237\u4e2d\u901a\u8fc7\u8868\u5355\u5220\u9664\u64cd\u4f5c", (String)"DevportalUtil_75", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5c06\u5220\u9664\u7684\u8868\u5355\u5b58\u5165\u56de\u6536\u7ad9\u3002", "DevportalUtil_76", BOS_DEVPORTAL_PLUGIN);
                AppUtils.addOpLog((String)objectId, (String)"delete", (String)objectId, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                result = MetadataDao.delFormMetadata((String)formId);
                if (result.get(KEY_SUCCESS) != null) {
                    String returnInfo = "";
                    if (!((Boolean)result.get(KEY_SUCCESS)).booleanValue()) {
                        returnInfo = result.get(MESSAGE) != null ? (String)result.get(MESSAGE) : ResManager.loadKDString((String)"\u5143\u6570\u636e\u5b58\u5728\u4f9d\u8d56\u5173\u7cfb\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DevportalUtil_77", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
                        throw new KDException(BosErrorCode.deleteFailed, new Object[]{returnInfo});
                    }
                }
                MultiLangEnumBridge opNameApp = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
                MultiLangEnumBridge opDescApp = new MultiLangEnumBridge("\u5220\u9664\u8868\u5355", "DevportalUtil_78", BOS_DEVPORTAL_PLUGIN);
                AppUtils.addOpLog((String)objectId, (String)"delete", (String)objectId, (String)"1", (MultiLangEnumBridge)opNameApp, (MultiLangEnumBridge)opDescApp, (String[])new String[0]);
            }
            catch (Exception exception) {
                tx.markRollback();
                logger.info(exception.getMessage(), (Object)exception);
                result.put(MESSAGE, exception.getMessage());
            }
            try {
                ArrayList<String> formIdList = new ArrayList<String>();
                String devType = pageObject.getString("type");
                if ("2".equals(devType)) {
                    formId = pageObject.getString(MASTERID);
                    formIdList.add(formId);
                    MetadataDao.clearSubRuntimeMeta(formIdList);
                    MetadataDao.rebuildRuntimeMetaById((String)formId);
                }
            }
            catch (Exception e) {
                logger.info(e.getMessage(), (Object)e);
                result.put("rebuildruntimemeta", ResManager.loadKDString((String)"\u8fd0\u884c\u671f\u5143\u6570\u636e\u7f13\u5b58\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u6e05\u7406\u3002", (String)"DevportalUtil_79", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        return result;
    }

    public static void deleteAppSource(String bizAppId, String bizAppNum, String pageId, String index, String bizcloudid, IFormView view) {
        block60: {
            Object dynamicObject3;
            String selectUnittestFileds = "id";
            QFilter unittestFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
            QFilter[] unittestFilters = new QFilter[]{unittestFilter};
            DynamicObjectCollection docUnittests = QueryServiceHelper.query((String)IDE_UNIT_TEST_DETAIL, (String)selectUnittestFileds, (QFilter[])unittestFilters);
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)IDE_UNIT_TEST_DETAIL);
            ArrayList<String> unitIds = new ArrayList<String>();
            for (DynamicObject dynamicObject2 : docUnittests) {
                unitIds.add(dynamicObject2.getString("id"));
            }
            DeleteServiceHelper.delete((IDataEntityType)met, (Object[])unitIds.toArray());
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u5355\u5143\u6d4b\u8bd5", "DevportalUtil_32", BOS_DEVPORTAL_PLUGIN);
            AppUtils.addOpLog((String)BOS_DEVPORTAL_BIZAPP, (String)"delete", (String)BOS_DEVPORTAL_BIZAPP, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
            Object[] params = new SqlParameter[]{new SqlParameter(":FBIZAPPID", 12, (Object)bizAppId)};
            String sql = "SELECT FID FROM T_META_FORMDESIGN WHERE FBIZAPPID = ? ORDER BY CHARINDEX(FID, FENTITYID) ASC, LENGTH(FINHERITPATH) DESC";
            List formPKs = null;
            try {
                formPKs = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

                    public List<String> handle(ResultSet rs) throws SQLException {
                        ArrayList<String> list = new ArrayList<String>(40);
                        while (rs.next()) {
                            list.add(rs.getString(1));
                        }
                        return list;
                    }
                });
            }
            catch (Exception e) {
                DevportalUtil.setInfoLog(e.getMessage());
                String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            if (formPKs != null) {
                QFilter bizFilter = new QFilter(BIZAPP, "=", (Object)bizAppId);
                QFilter[] filters = new QFilter[]{bizFilter};
                long logId = DB.genGlobalLongId();
                for (String id : formPKs) {
                    boolean collectPageExists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])filters);
                    boolean checkDeleteResource = AppUtils.checkDeleteResource((String)id, (String)bizAppId, (IFormView)view, (String)"page", (String)"deleteapp");
                    if (!checkDeleteResource) continue;
                    DevportalUtil.writeLog(id, null, logId);
                    DevportalUtil.deletePage(id, null, collectPageExists, bizAppId, null, "APP_TYPE", BOS_DEVPORTAL_BIZAPP);
                }
            }
            String selectScriptFields = "id";
            QFilter scriptFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
            QFilter[] scriptFilters = new QFilter[]{scriptFilter};
            DynamicObjectCollection docScriptIds = QueryServiceHelper.query((String)IDE_PLUGINSCRIPT, (String)selectScriptFields, (QFilter[])scriptFilters);
            MainEntityType scriptMet = EntityMetadataCache.getDataEntityType((String)IDE_PLUGINSCRIPT);
            ArrayList<String> scriptIds = new ArrayList<String>();
            ArrayList<DynamicObject> recycleBins = new ArrayList<DynamicObject>();
            for (Object dynamicObject3 : docScriptIds) {
                String scriptId = dynamicObject3.getString("id");
                boolean checkDeleteResource = AppUtils.checkDeleteResource((String)scriptId, (String)bizAppId, (IFormView)view, (String)"script", (String)"deleteapp");
                if (!checkDeleteResource) continue;
                scriptIds.add(scriptId);
                DynamicObject obj = DevportalUtil.createRecycleBinScriptData(scriptId, ResManager.loadKDString((String)"\u5728\u5f00\u53d1\u8005\u95e8\u6237\u4e2d\u901a\u8fc7\u5e94\u7528\u5220\u9664\u64cd\u4f5c", (String)"DevportalUtil_33", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                recycleBins.add(obj);
            }
            TraceSpan span = Tracer.create((String)"DevportalUtil", (String)"deleteAllApp");
            dynamicObject3 = null;
            try (TXHandle h = TX.requiresNew((String)"DevportalUtil.deleteAllApp");){
                try {
                    SaveServiceHelper.save((DynamicObject[])recycleBins.toArray(new DynamicObject[recycleBins.size()]));
                    DeleteServiceHelper.delete((IDataEntityType)scriptMet, (Object[])scriptIds.toArray(new String[scriptIds.size()]));
                }
                catch (Exception e) {
                    h.markRollback();
                    DevportalUtil.setInfoLog(e.getMessage());
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
                }
            }
            catch (Throwable throwable) {
                dynamicObject3 = throwable;
                throw throwable;
            }
            finally {
                if (span != null) {
                    if (dynamicObject3 != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)dynamicObject3).addSuppressed(throwable);
                        }
                    } else {
                        span.close();
                    }
                }
            }
            JSONObject deleteMsg = DevportalUtil.deleteAppChecking(bizAppId);
            if (deleteMsg.isEmpty()) {
                try (TraceSpan span2 = Tracer.create((String)"DevportalUtil", (String)"deleteAllApp");
                     TXHandle h = TX.requiresNew((String)"DevportalUtil.deleteAllApp");){
                    try {
                        DynamicObject obj = DevportalUtil.createRecycleBinAppData(bizAppId, bizAppNum, ResManager.loadKDString((String)"\u5728\u5f00\u53d1\u8005\u95e8\u6237\u4e2d\u901a\u8fc7\u5e94\u7528\u5220\u9664\u64cd\u4f5c", (String)"DevportalUtil_33", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                        DevportalUtil.deleteApp(bizAppId, index, bizcloudid, view);
                        break block60;
                    }
                    catch (Exception e) {
                        h.markRollback();
                        DevportalUtil.setInfoLog(e.getMessage());
                        throw new KDException((Throwable)e, BosErrorCode.deleteFailed, new Object[]{e.getMessage()});
                    }
                }
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam(BIZCLOUDID, (Object)bizcloudid);
            parameter.setFormId("bos_devp_deleteappmsg");
            parameter.setCaption(ResManager.loadKDString((String)"\u5e94\u7528\u5220\u9664\u7ed3\u679c", (String)"DevportalUtil_34", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            parameter.setCustomParam("deletemsg", (Object)deleteMsg);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(parameter);
        }
    }

    public static JSONObject deleteAppChecking(String bizAppId) {
        QFilter scriptFilter;
        QFilter[] scriptFilters;
        String selectScriptFields;
        DynamicObjectCollection docScripts;
        QFilter formFilter;
        QFilter[] formFilters;
        String selectFormFields;
        DynamicObjectCollection docForms;
        JSONObject deleteMsg = new JSONObject();
        JSONArray pageArray = new JSONArray();
        JSONArray scriptArray = new JSONArray();
        JSONArray unittestArray = new JSONArray();
        String selectUnittestFields = MULTI_TXT_NAME;
        QFilter unittestFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId);
        QFilter[] unittestFilters = new QFilter[]{unittestFilter};
        DynamicObjectCollection docUnittest = QueryServiceHelper.query((String)IDE_UNIT_TEST_DETAIL, (String)selectUnittestFields, (QFilter[])unittestFilters);
        if (!docUnittest.isEmpty()) {
            for (int i = 0; i < docUnittest.size(); ++i) {
                unittestArray.add(((DynamicObject)docUnittest.get(i)).get(MULTI_TXT_NAME));
            }
        }
        if (!(docForms = QueryServiceHelper.query((String)"bos_formmeta", (String)(selectFormFields = "name"), (QFilter[])(formFilters = new QFilter[]{formFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId)}))).isEmpty()) {
            for (int i = 0; i < docForms.size(); ++i) {
                pageArray.add(((DynamicObject)docForms.get(i)).get("name"));
            }
        }
        if (!(docScripts = QueryServiceHelper.query((String)IDE_PLUGINSCRIPT, (String)(selectScriptFields = "txt_scriptname"), (QFilter[])(scriptFilters = new QFilter[]{scriptFilter = new QFilter(BIZAPPID, "=", (Object)bizAppId)}))).isEmpty()) {
            for (int i = 0; i < docScripts.size(); ++i) {
                scriptArray.add(((DynamicObject)docScripts.get(i)).get("txt_scriptname"));
            }
        }
        if (!(unittestArray.isEmpty() && pageArray.isEmpty() && scriptArray.isEmpty())) {
            deleteMsg.put("unittest", (Object)unittestArray);
            deleteMsg.put("page", (Object)pageArray);
            deleteMsg.put("script", (Object)scriptArray);
        }
        return deleteMsg;
    }

    private static void deleteApp(String bizAppId, String index, String bizCloudId, IFormView view) {
        QFilter q = new QFilter(BIZAPP, "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{q};
        boolean exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_SHORTCUT, (QFilter[])filters);
        if (exists) {
            String shortcutId = QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_SHORTCUT, (String)"id", (QFilter[])filters).getString("id");
            Object[] shortcutIds = new String[]{shortcutId};
            MainEntityType shortcutMet = EntityMetadataCache.getDataEntityType((String)BOS_DEVPORTAL_SHORTCUT);
            try (TXHandle h = TX.requiresNew((String)"DevportalUtil.deleteShoutcut");){
                try {
                    DeleteServiceHelper.delete((IDataEntityType)shortcutMet, (Object[])shortcutIds);
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u53d6\u6d88\u5e94\u7528\u7684\u6536\u85cf", "DevportalUtil_35", BOS_DEVPORTAL_PLUGIN);
                    AppUtils.addOpLog((String)BOS_DEVPORTAL_BIZAPP, (String)"delete", (String)BOS_DEVPORTAL_BIZAPP, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
                }
                catch (Exception e) {
                    h.markRollback();
                    DevportalUtil.setInfoLog(e.getMessage());
                    throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{e.getMessage()});
                }
            }
        }
        AppMetaServiceHelper.deleteApp((String)bizAppId);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", DEVPORTALUTIL_29, BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5220\u9664\u4e1a\u52a1\u5e94\u7528", "DevportalUtil_36", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)BOS_DEVPORTAL_BIZAPP, (String)"delete", (String)BOS_DEVPORTAL_BIZAPP, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DevportalUtil_37", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
    }

    public static boolean saveAppInfo(DynamicObject appObject, IFormView view) {
        FormShowParameter fsp = view.getFormShowParameter();
        String mainForm = appObject.getString(MAINFORMNAME);
        String dependency = appObject.getString("dependency");
        String appId = appObject.getString("id");
        boolean fromDatabase = appObject.getDataEntityState().getFromDatabase();
        if (fromDatabase) {
            DynamicObject cloudInfo = BizCloudServiceHelp.getBizCloudByAppID((String)appId);
            String beforeCloudId = (String)cloudInfo.get("id");
            String updateAfterCloudId = ((DynamicObject)appObject.get(BIZCLOUD)).getString(0);
            if ("0".equals(appObject.get("type")) && beforeCloudId != null && !beforeCloudId.equals(updateAfterCloudId)) {
                DevportalUtil.autoUpdateExtendApps(appObject);
            }
        }
        if (StringUtils.isBlank((CharSequence)mainForm)) {
            appObject.set(MAINFORMID, (Object)" ");
            appObject.set(MAINFORMNAME, (Object)" ");
        }
        if (StringUtils.isBlank((CharSequence)dependency)) {
            appObject.set("dependencyid", (Object)" ");
            appObject.set("dependency", (Object)" ");
        }
        String number = appObject.getString(NUMBER);
        String appIsv = AppUtils.getDeveloperInfo();
        number = DevportalUtil.autoIsvNumber(number, appIsv);
        appObject.set(NUMBER, (Object)number);
        StringBuilder sb = DevportalUtil.checkAppProperties(appObject, fsp);
        if (sb.length() > 0) {
            view.showTipNotification(sb.toString());
            return false;
        }
        JSONObject errorMessage = DevportalUtil.saveMetaOfApp(appObject, fsp);
        if (errorMessage.containsKey((Object)ResultMessage.RESULT.toString())) {
            view.showTipNotification(errorMessage.getString(ResultMessage.RESULT.toString()));
            return false;
        }
        return true;
    }

    private static void autoUpdateExtendApps(DynamicObject appObject) {
        String type = appObject.getString("type");
        String appId = appObject.getString("id");
        String cloudId = ((DynamicObject)appObject.get(9)).getString(0);
        QFilter[] filters = new QFilter[]{new QFilter(PARENTID, "=", (Object)appId)};
        QFilter[] filters1 = new QFilter[]{new QFilter(MASTERID, "=", (Object)appId)};
        boolean exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters);
        if ("0".equals(type) && exists) {
            DynamicObjectCollection extendApps = QueryServiceHelper.query((String)BOS_DEVPORTAL_BIZAPP, (String)"id, masterid, number", (QFilter[])filters1);
            String sql = "update t_meta_bizapp set fbizcloudid = ? where fid = ?";
            for (DynamicObject extendApp : extendApps) {
                Object[] saveParams = new Object[]{new SqlParameter("fbizcloudid", 12, (Object)cloudId), new SqlParameter("fid", 12, (Object)((String)extendApp.get("id")))};
                DB.update((DBRoute)DBRoute.meta, (String)sql, (Object[])saveParams);
            }
        }
    }

    public static JSONObject saveMetaOfApp(DynamicObject appObject, FormShowParameter fsp) {
        JSONObject message = new JSONObject();
        Map resultMap = new HashMap();
        AppMetadata appMetadata = new AppMetadata();
        if (OperationStatus.ADDNEW.equals((Object)fsp.getStatus()) && StringUtils.isBlank((CharSequence)appObject.getString(PARENTID))) {
            appObject.set("id", (Object)DBServiceHelper.genStringId());
            appMetadata = DevportalUtil.createNewAppMeta(appObject);
            resultMap = AppMetaServiceHelper.save((AppMetadata)appMetadata);
        } else {
            resultMap = AppMetaServiceHelper.save((DynamicObject)appObject);
        }
        if (resultMap.size() > 0 && !Boolean.parseBoolean(resultMap.get(KEY_SUCCESS).toString())) {
            message.put(ResultMessage.RESULT.toString(), (Object)resultMap.get(MESSAGE).toString());
        }
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u4fdd\u5b58", "DevportalUtil_38", BOS_DEVPORTAL_PLUGIN);
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u4fdd\u5b58\u4e1a\u52a1\u5e94\u7528", "DevportalUtil_39", BOS_DEVPORTAL_PLUGIN);
        AppUtils.addOpLog((String)BOS_DEVPORTAL_BIZAPP, (String)"save", (String)BOS_DEVPORTAL_BIZAPP, (String)"1", (MultiLangEnumBridge)opName, (MultiLangEnumBridge)opDesc, (String[])new String[0]);
        return message;
    }

    public static JSONObject configAppHome(IFormView view, DynamicObject appObject, FormShowParameter fsp) {
        JSONObject message = new JSONObject();
        IDataEntityType dt = appObject.getDataEntityType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(dt);
        cacheManager.removeByPrimaryKey(new Object[]{appObject.getPkValue()});
        String bizAppId = appObject.getString("id");
        if (StringUtils.isBlank((CharSequence)appObject.getString(PARENTID))) {
            try {
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                if (appMetadata != null) {
                    String formId = appObject.getString(MAINFORMID);
                    String formName = appObject.getString(MAINFORMNAME);
                    appMetadata.getAppElement().setMainFormID(formId);
                    appMetadata.getAppElement().setMainFormName(formName);
                    AppMetaServiceHelper.save((AppMetadata)appMetadata);
                } else {
                    message.put(ResultMessage.RESULT.toString(), (Object)ResManager.loadKDString((String)"\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"DevportalUtil_41", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                DevportalUtil.setInfoLog(e.getMessage());
                message.put(ResultMessage.RESULT.toString(), (Object)e.getMessage());
            }
        }
        return message;
    }

    public static JSONObject saveMetaOfPage(IFormView view, DynamicObject appObject, FormShowParameter fsp) {
        JSONObject message;
        block17: {
            Map<String, Object> pageContent;
            MetaDataUtil metaDataUtil;
            Throwable throwable;
            TXHandle tx;
            String bizAppId;
            block18: {
                JSONObject jSONObject;
                block19: {
                    block20: {
                        message = new JSONObject();
                        bizAppId = appObject.getString("id");
                        if (!OperationStatus.ADDNEW.equals((Object)fsp.getStatus()) || !StringUtils.isBlank((CharSequence)appObject.getString(PARENTID))) break block17;
                        tx = TX.required((String)"mdl_DevportalUtil_saveMetaOfPage");
                        throwable = null;
                        if (!StringUtils.isNotBlank((CharSequence)bizAppId)) break block17;
                        metaDataUtil = new MetaDataUtil();
                        pageContent = DevportalUtil.createNewPage(view, bizAppId, appObject);
                        if (pageContent != null) break block18;
                        message.put(ResultMessage.RESULT.toString(), (Object)ResManager.loadKDString((String)"\u5e94\u7528\u5df2\u521b\u5efa\u6210\u529f\uff0c\u4f46\u662f\u5e94\u7528\u9996\u9875\u521b\u5efa\u5931\u8d25\u3002\u8bf7\u68c0\u67e5\u5e94\u7528\u9996\u9875\u7f16\u7801\u662f\u5426\u5df2\u5b58\u5728\uff0c\u5e76\u5355\u72ec\u521b\u5efa\u5e94\u7528\u9996\u9875\u5e76\u8fdb\u884c\u5e94\u7528\u9996\u9875\u8bbe\u7f6e\u5373\u53ef\u3002", (String)"DevportalUtil_40", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                        jSONObject = message;
                        if (tx == null) break block19;
                        if (throwable == null) break block20;
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block19;
                    }
                    tx.close();
                }
                return jSONObject;
            }
            try {
                try {
                    metaDataUtil.save(pageContent);
                    String formId = (String)pageContent.get("id");
                    String formName = (String)pageContent.get("caption");
                    appObject.set(MAINFORMID, (Object)formId);
                    appObject.set(MAINFORMNAME, (Object)formName);
                    AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                    DynamicObject[] unitRelFormObjects = DevportalUtil.createUnitRelFormObject(appMetadata, bizAppId, formId);
                    SaveServiceHelper.save((DynamicObject[])unitRelFormObjects);
                }
                catch (Exception e) {
                    DevportalUtil.setInfoLog(e.getMessage());
                    message.put(ResultMessage.RESULT.toString(), (Object)e.getMessage());
                    tx.markRollback();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        return message;
    }

    public static Map<String, Object> createNewPage(IFormView view, String appId, DynamicObject appObject) {
        return DevportalUtil.createNewPage(appId, appObject);
    }

    public static Map<String, Object> createNewPage(String appId, DynamicObject appObject) {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        HashMap<String, String> map = new HashMap<String, String>();
        String pageNumber = appObject.getString(NUMBER) + "_apphome";
        LocaleString bizAppName = LocaleString.fromMap((Map)appObject.getLocaleString("name"));
        HashMap<String, String> pageNameLocals = new HashMap<String, String>();
        pageNameLocals.put(Lang.zh_CN.name(), String.format(ResManager.loadKDString((String)"%s_\u5e94\u7528\u9996\u9875", (String)"DevportalUtil_42", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizAppName.getLocaleValue_zh_CN()));
        pageNameLocals.put(Lang.zh_TW.name(), String.format(ResManager.loadKDString((String)"%s_\u61c9\u7528\u9996\u9801", (String)"DevportalUtil_43", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), bizAppName.getLocaleValue_zh_TW()));
        pageNameLocals.put(Lang.en_US.name(), bizAppName.getLocaleValue_en() + "_AppHome");
        LocaleString pageName = LocaleString.fromMap(pageNameLocals);
        map.put("modelType", "DynamicFormModel");
        map.put("id", pageNumber);
        map.put("name", (String)pageName);
        map.put("parentId", "/8T+06O/GOEH");
        map.put(BIZAPPID, appId);
        Map pageContent = metaDataUtil.createBlankModel(map);
        return pageContent;
    }

    public static AppMetadata createNewAppMeta(DynamicObject appObject) {
        HashMap<String, String> nameLocals = new HashMap<String, String>();
        nameLocals.put(Lang.zh_CN.name(), ResManager.loadKDString((String)"\u9996\u9875", (String)"DevportalUtil_44", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        nameLocals.put(Lang.zh_TW.name(), ResManager.loadKDString((String)"\u9996\u9801", (String)"DevportalUtil_45", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        nameLocals.put(Lang.en_US.name(), "Home");
        LocaleString name = LocaleString.fromMap(nameLocals);
        DynamicObject unitObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devp_metadataunit");
        unitObject.set("seq", (Object)1);
        unitObject.set(NUMBER, (Object)"MainPage");
        unitObject.set("name", (Object)name);
        unitObject.set("isleaf", (Object)0);
        unitObject.set(BIZAPP, appObject.get("id"));
        unitObject.set("parentunit", (Object)" ");
        unitObject.set("parentunitid", (Object)" ");
        unitObject.set(DESCRIPTION, (Object)" ");
        if ("3".equals(appObject.getString("type"))) {
            unitObject.set("type", (Object)"3");
        } else {
            unitObject.set("type", (Object)"1");
        }
        DynamicObject[] objects = new DynamicObject[]{appObject, unitObject};
        AppMetadata appMetadata = AppMetaServiceHelper.convertDynamicObjectsToAppMetadata((DynamicObject[])objects);
        return appMetadata;
    }

    public static StringBuilder checkAppProperties(DynamicObject appObject, FormShowParameter fsp) {
        Map<String, Object> retMap;
        StringBuilder errorMsg = new StringBuilder();
        String localeId = RequestContext.get().getLang().toString();
        Boolean isEmpty = Boolean.TRUE;
        ILocaleString map = appObject.getLocaleString("name");
        if (map.get(localeId) != null && !((String)map.get(localeId)).trim().isEmpty()) {
            isEmpty = Boolean.FALSE;
        }
        if (isEmpty.booleanValue()) {
            errorMsg.append(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_48", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)appObject.getString("bizcloud_id"))) {
            if ("bos_devp_model_layout".equals(fsp.getFormId())) {
                errorMsg.append(ResManager.loadKDString((String)"\u6a21\u677f\u5e93\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_80", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                errorMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_52", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        }
        if (StringUtils.isBlank((CharSequence)appObject.getString("refapp"))) {
            appObject.set("refappid", (Object)"");
        }
        if (StringUtils.isBlank((CharSequence)appObject.getString(SEQUENCE))) {
            errorMsg.append(ResManager.loadKDString((String)"\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_46", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (StringUtils.isBlank((CharSequence)appObject.getString(NUMBER))) {
            errorMsg.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_47", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (StringUtils.isBlank((CharSequence)appObject.getString(VERSION))) {
            errorMsg.append(ResManager.loadKDString((String)"\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_49", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (StringUtils.isBlank((CharSequence)appObject.getString(DEPLOYSTATUS))) {
            errorMsg.append(ResManager.loadKDString((String)"\u53d1\u5e03\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_51", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (errorMsg.length() == 0 && (retMap = DevportalUtil.checkNumberDup(appObject, fsp.getStatus())).size() > 0) {
            errorMsg.append(retMap.get(ResultMessage.RESULT.toString()));
        }
        return errorMsg;
    }

    private static Map<String, Object> checkNumberDup(DynamicObject currentApp, OperationStatus operationStatus) {
        String id;
        QFilter q3;
        QFilter q2;
        QFilter[] filters;
        boolean exists;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String regex = "[a-z0-9_]+";
        String number = currentApp.getString(NUMBER);
        Boolean flag = Pattern.matches(regex, number);
        if (!flag.booleanValue()) {
            retMap.put(ResultMessage.MESSAGE.toString(), NUMNOCONF);
            retMap.put(ResultMessage.RESULT.toString(), ResManager.loadKDString((String)"\u7f16\u7801\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DevportalUtil_55", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return retMap;
        }
        if (number.startsWith("_") || number.endsWith("_")) {
            retMap.put(ResultMessage.MESSAGE.toString(), NUMNOCONF);
            retMap.put(ResultMessage.RESULT.toString(), ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"DevportalUtil_56", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return retMap;
        }
        if (number.length() > 25) {
            retMap.put(ResultMessage.MESSAGE.toString(), NUMNOCONF);
            retMap.put(ResultMessage.RESULT.toString(), ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002", (String)"DevportalUtil_57", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            QFilter q22 = new QFilter(NUMBER, "=", (Object)number);
            QFilter[] filters2 = new QFilter[]{q22};
            boolean exists2 = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters2);
            if (exists2) {
                retMap.put(ResultMessage.MESSAGE.toString(), "numexists");
                retMap.put(ResultMessage.RESULT.toString(), ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DevportalUtil_58", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return retMap;
            }
        } else if (OperationStatus.EDIT.equals((Object)operationStatus) && (exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])(filters = new QFilter[]{q2 = new QFilter(NUMBER, "=", (Object)number), q3 = new QFilter("id", "!=", (Object)(id = currentApp.getPkValue().toString()))})))) {
            retMap.put(ResultMessage.MESSAGE.toString(), "numexists");
            retMap.put(ResultMessage.RESULT.toString(), ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DevportalUtil_58", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return retMap;
        }
        return retMap;
    }

    public static DynamicObject[] createUnitRelFormObject(AppMetadata appMetadata, String appId, String formId) {
        List appFunctionPackets = appMetadata.getAppFunctionPackets();
        if (appFunctionPackets == null || appFunctionPackets.size() == 0) {
            return new DynamicObject[0];
        }
        String unitId = ((AppFunctionPacketElement)appFunctionPackets.get(0)).getId();
        DynamicObject unitRelForm = BusinessDataServiceHelper.newDynamicObject((String)"bos_devportal_unitrelform");
        unitRelForm.set(BIZAPP, (Object)appId);
        unitRelForm.set(BIZUNIT, (Object)unitId);
        unitRelForm.set("form", (Object)formId);
        DynamicObject[] unitRelForms = new DynamicObject[]{unitRelForm};
        return unitRelForms;
    }

    public static boolean saveAppInfo(IDataModel model, IFormView view) {
        if (DevportalUtil.saveAppInfo(model.getDataEntity(), view)) {
            model.setDataChanged(false);
            return true;
        }
        return false;
    }

    public static int getMaxSeq(String bizCloudId) {
        int maxSeq = 0;
        String selectFields = "id,sequence";
        QFilter q = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)selectFields, (QFilter[])filters, (String)"sequence desc", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            maxSeq = dynamicObjects[0].getInt(SEQUENCE);
        }
        return maxSeq;
    }

    public static String getClassNameByBizUnitId(String bizAppId, String bizUnitId, String scriptNumber) {
        AppFunctionPacketElement bizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        String bizUnitNumber = bizUnitInfo.getNumber();
        String parentUnitNumber = null;
        if (bizUnitInfo.getParentId().trim().length() != 0) {
            String parentBizUnitId = bizUnitInfo.getParentId();
            AppFunctionPacketElement parentBizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)parentBizUnitId, (String)bizAppId, (boolean)false);
            parentUnitNumber = parentBizUnitInfo.getNumber();
        }
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appInfo.getNumber();
        String BizCloudId = appInfo.getBizCloudID();
        String bizCloudNumber = (String)BusinessDataServiceHelper.loadSingleFromCache((Object)BizCloudId, (String)"bos_devportal_bizcloud", (String)NUMBER).get(NUMBER);
        String isv = ISVService.getISVInfo().getId();
        String className = null;
        className = parentUnitNumber == null ? isv + "." + bizCloudNumber + "." + bizAppNumber + "." + bizUnitNumber + "." + scriptNumber : isv + "." + bizCloudNumber + "." + bizAppNumber + "." + parentUnitNumber + "." + bizUnitNumber + "." + scriptNumber;
        return className.toLowerCase();
    }

    public static Boolean isFirstLogin(Long userId, String formId) {
        Boolean isFirstLogin = Boolean.FALSE;
        QFilter userFilter = new QFilter(USERID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(PAGEID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userFilter, formIdFilter};
        DynamicObject useInfo = BusinessDataServiceHelper.loadSingle((String)BOS_DEVP_FIRSTLOGIN, (String)KEY_ISFIRSTLOGIN, (QFilter[])filters);
        if (useInfo == null || !useInfo.getBoolean(KEY_ISFIRSTLOGIN)) {
            isFirstLogin = Boolean.TRUE;
        }
        return isFirstLogin;
    }

    public static void updateFirstLoginFlag(long userId, String formId) {
        QFilter userFilter = new QFilter(USERID, "=", (Object)userId);
        QFilter formIdFilter = new QFilter(PAGEID, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userFilter, formIdFilter};
        DynamicObject useInfo = BusinessDataServiceHelper.loadSingle((String)BOS_DEVP_FIRSTLOGIN, (String)KEY_ISFIRSTLOGIN, (QFilter[])filters);
        if (useInfo == null) {
            useInfo = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVP_FIRSTLOGIN);
            String id = Uuid8.generateShortUuid();
            useInfo.set("id", (Object)id);
            useInfo.set(USERID, (Object)userId);
            useInfo.set(PAGEID, (Object)formId);
        }
        useInfo.set(KEY_ISFIRSTLOGIN, (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{useInfo});
    }

    public static Map<String, Object> getGuideItemData(String icourl, String title, String content, String step, int tiptop, int tipleft, String pageId, String key, int showPos, String extendPic, int alltop, int allleft, int arrowOffset, int picShowPos) {
        HashMap<String, Object> guideItem = new HashMap<String, Object>();
        HashMap<String, Object> tip = new HashMap<String, Object>();
        tip.put("icourl", icourl);
        tip.put("title", title);
        tip.put("content", content);
        tip.put("step", step);
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", tiptop);
        offset.put("left", tipleft);
        tip.put("offset", offset);
        tip.put("arrowOffset", arrowOffset);
        guideItem.put("tip", tip);
        guideItem.put(PAGEID, pageId);
        guideItem.put("key", key);
        guideItem.put("showPos", showPos);
        guideItem.put("picShowPos", picShowPos);
        guideItem.put("extendPic", extendPic);
        HashMap<String, Integer> alloffset = new HashMap<String, Integer>();
        alloffset.put("top", alltop);
        alloffset.put("left", allleft);
        guideItem.put("offset", alloffset);
        return guideItem;
    }

    public static String getDefalutCloudId(JSONArray array) {
        String defaultCloudId = null;
        for (int i = 0; i < array.size(); ++i) {
            JSONObject bizCloudInfo = array.getJSONObject(i);
            String bizCloudId = bizCloudInfo.getString("id");
            QFilter q = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
            QFilter[] filters = new QFilter[]{q};
            Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])filters);
            if (loadFromCache.size() <= 0) continue;
            defaultCloudId = bizCloudId;
            break;
        }
        return defaultCloudId;
    }

    public static JSONArray getBizAppIds(String bizAppId) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String appType = appMetadata.getDevType();
        String inheritPath = appMetadata.getInheritPath();
        JSONArray appIds = new JSONArray();
        if ("2".equals(appType)) {
            if (StringUtils.isBlank((CharSequence)inheritPath)) {
                inheritPath = appMetadata.getParentId();
            }
            if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
                if (inheritPath.contains(",")) {
                    String[] inheritPaths;
                    for (String inherit : inheritPaths = inheritPath.split(",")) {
                        appIds.add((Object)inherit);
                    }
                } else {
                    appIds.add((Object)inheritPath);
                }
            }
        }
        appIds.add((Object)bizAppId);
        return appIds;
    }

    public static JSONArray getDbInstanceList() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(CONTENT_TYPE, APPLICATION_JSONANDCHARSET);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dataCenterId", RequestContext.get().getAccountId());
        String host = System.getProperty(MC_SERVER_URL);
        JSONArray data = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)host)) {
            try {
                JSONObject resp;
                String sHttpResponse = MCApiUtil.callMcApiService((String)"/kapi/app/mc/GetDbInstanceListService", (String)"text/json", header, params, (int)60);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger(ERRORCODE) == 100) {
                    data = resp.getJSONArray("data");
                }
            }
            catch (Exception e) {
                logger.error("getDbInstanceList\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        JSONArray newData = new JSONArray();
        for (Object datum : data) {
            if (((Boolean)((JSONObject)datum).get((Object)"readonly")).booleanValue()) continue;
            newData.add(datum);
        }
        return newData;
    }

    public static JSONObject getDbInstanceInfo(String routeKey) {
        JSONObject data = new JSONObject();
        String dbInstanceInfo = SessionManager.getCurrent().get(routeKey + "_dbinstanceinfo");
        if (StringUtils.isNotBlank((CharSequence)dbInstanceInfo)) {
            data = JSONObject.parseObject((String)dbInstanceInfo);
        } else {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put(CONTENT_TYPE, APPLICATION_JSONANDCHARSET);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("DCID", RequestContext.get().getAccountId());
            params.put("routeKey", routeKey);
            String host = System.getProperty(MC_SERVER_URL);
            if (StringUtils.isNotBlank((CharSequence)host)) {
                try {
                    JSONObject resp;
                    String sHttpResponse = MCApiUtil.callMcApiService((String)"/kapi/app/mc/GetDbInstanceInfoService", (String)"text/json", header, params, (int)60);
                    if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && (resp = JSONObject.parseObject((String)sHttpResponse)).getInteger(ERRORCODE) == 100) {
                        data = resp.getJSONObject("data");
                    }
                }
                catch (Exception e) {
                    logger.error("getDbInstanceList\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            if (data != null && data.size() > 0) {
                SessionManager.getCurrent().put(routeKey + "_dbinstanceinfo", data.toJSONString());
            }
        }
        return data;
    }

    public static StringBuilder validateNameAndNumber(String number, ILocaleString name, boolean isPrintTemplate) {
        MetaDataUtil metaDataUtil = new MetaDataUtil();
        StringBuilder buffer = new StringBuilder();
        String regex = "[a-z0-9_]+";
        if (StringUtils.isBlank((CharSequence)number)) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u3002", (String)"DevportalUtil_59", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.endsWith("_devportal")) {
            buffer.append(ResManager.loadKDString((String)"\u4e3a\u4e86\u533a\u5206SVN\u811a\u672c\u6587\u4ef6\u547d\u540d\uff0c\u7f16\u7801\u4e0d\u80fd\u4ee5\u201c_devportal\u201d\u7ed3\u5c3e\u3002", (String)"DevportalUtil_60", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (!Pattern.matches(regex, number)) {
            buffer.append(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5fc5\u987b\u7531\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"DevportalUtil_61", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.startsWith("_") || number.endsWith("_")) {
            buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\u6216\u7ed3\u5c3e\u3002", (String)"DevportalUtil_62", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (number.length() > 25) {
            if (isPrintTemplate) {
                if (number.length() > 36) {
                    buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc736\u4e2a\u5b57\u7b26\u3002\r\n", (String)"DevportalUtil_63", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                }
            } else {
                buffer.append(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u5f97\u8d85\u8fc725\u4e2a\u5b57\u7b26\u3002\r\n", (String)"DevportalUtil_64", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            }
        } else if (metaDataUtil.checkNumber(number)) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8f93\u5165\u7f16\u7801\uff0c\u8be5\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DevportalUtil_65", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)name) || name.isEmpty()) {
            buffer.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"DevportalUtil_66", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        return buffer;
    }

    public static StringBuilder validateNameNumberAndEntity(String number, ILocaleString name, String pagemetaid) {
        StringBuilder buffer = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)pagemetaid)) {
            buffer.append(ResManager.loadKDString((String)"\u9875\u9762\u5143\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DevportalUtil_67", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
        StringBuilder bf = DevportalUtil.validateNameAndNumber(number, name, false);
        buffer.append((CharSequence)bf);
        return buffer;
    }

    public static Map<String, Object> copyMobleForm(String templageFormId, String bizAppId, String bizUnitId, String number, LocaleString fromName) {
        return PageBuilder.copyMobleForm((String)templageFormId, (String)bizAppId, (String)bizUnitId, (String)number, (LocaleString)fromName);
    }

    public static Map<String, Object> buildNewPage(Map<String, Object> map, String bizAppId, String bizUnitId, IFormView view, boolean isPrintTemplate) {
        return PageBuilder.buildNewPage(map, (String)bizAppId, (String)bizUnitId, (IFormView)view, (boolean)isPrintTemplate);
    }

    public static Map<String, Object> buildNewLayout(Map<String, Object> map, String bizAppId, String bizUnitId, IFormView view, boolean isPrintTemplate) {
        return PageBuilder.buildNewLayout(map, (String)bizAppId, (String)bizUnitId, (IFormView)view, (boolean)isPrintTemplate);
    }

    public static Map<String, Object> buildNewQueryModel(Map<String, Object> map, String bizAppId, String bizUnitId, IFormView view) {
        return PageBuilder.buildNewQueryModel(map, (String)bizAppId, (String)bizUnitId, (IFormView)view);
    }

    public static DynamicObject createRecycleBinAppData(String appId, String bizAppNum, String operation) {
        try {
            DynamicObject newDynamicObject = new DynamicObject();
            JSONObject obj = new JSONObject();
            List list = MetadataDao.getAppDeployFile((String)appId);
            if (list != null && list.size() > 0) {
                String dymMeta = ((DeployFile)list.get(0)).getFileContent();
                String dymFileName = ((DeployFile)list.get(0)).getFileName();
                obj.put(dymFileName, (Object)dymMeta);
                for (int i = 1; i < list.size(); ++i) {
                    String dymLangMeta = ((DeployFile)list.get(i)).getFileContent();
                    String dymLangFileName = ((DeployFile)list.get(i)).getFileName();
                    obj.put(dymLangFileName, (Object)dymLangMeta);
                }
                newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_devp_recyclebin");
                String id = Uuid16.create().toString();
                newDynamicObject.set("id", (Object)id);
                newDynamicObject.set("delid", (Object)appId);
                newDynamicObject.set("delnumber", (Object)bizAppNum);
                newDynamicObject.set("operation", (Object)String.format(ResManager.loadKDString((String)"%s,\u5c06\u5e94\u7528\u5220\u9664\u3002", (String)"DevportalUtil_68", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), operation));
                newDynamicObject.set("type", (Object)"app");
                newDynamicObject.set("operator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                newDynamicObject.set(CREATEDATE, (Object)Timestamp.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
                newDynamicObject.set("deldata", (Object)obj);
            }
            return newDynamicObject;
        }
        catch (Exception e) {
            DevportalUtil.setInfoLog(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
    }

    public static DynamicObject createRecycleBinFormData(String formId, String operation) {
        return BizPageOperationUtil.createRecycleBinFormData((String)formId, (String)operation);
    }

    public static DynamicObject createRecycleBinScriptData(String scriptId, String operation) {
        return ScriptOperationUtil.createRecycleBinScriptData((String)scriptId, (String)operation);
    }

    public static boolean createJsonFile(String jsonString, String filePath, String fileName) {
        boolean flag = true;
        String fullPath = FileUtils.cleanString((String)(filePath + File.separator + fileName + JSONTYPE));
        File file = new File(fullPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        jsonString = DevportalUtil.formatJson(jsonString);
        Path customZipPath = Paths.get(FileUtils.cleanString((String)DevportalUtil.checkFilePath(fullPath)), new String[0]);
        try (OutputStream outputStream = Files.newOutputStream(customZipPath, new OpenOption[0]);
             OutputStreamWriter write = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            write.write(jsonString);
            write.flush();
        }
        catch (Exception e) {
            DevportalUtil.setErrorLog(e);
            flag = false;
        }
        return flag;
    }

    public static String formatJson(String json) {
        StringBuilder result = new StringBuilder();
        int length = json.length();
        int number = 0;
        char key = '\u0000';
        for (int i = 0; i < length; ++i) {
            key = json.charAt(i);
            if (key == '[' || key == '{') {
                if (i - 1 > 0 && json.charAt(i - 1) == ':') {
                    result.append('\n');
                    result.append(DevportalUtil.indent(number));
                }
                result.append(key);
                result.append('\n');
                result.append(DevportalUtil.indent(++number));
                continue;
            }
            if (key == ']' || key == '}') {
                result.append('\n');
                result.append(DevportalUtil.indent(--number));
                result.append(key);
                if (i + 1 >= length || json.charAt(i + 1) == ',') continue;
                result.append('\n');
                continue;
            }
            result.append(key);
        }
        return result.toString();
    }

    private static String indent(int number) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < number; ++i) {
            result.append(SPACE);
        }
        return result.toString();
    }

    public static List<String> getAllAppIds(String inheritPath, String bizAppId) {
        ArrayList<String> appIdList = new ArrayList<String>();
        List<Object> inheritList = Collections.emptyList();
        if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
            String[] inheritPathArr = inheritPath.split(",");
            inheritList = Arrays.asList(inheritPathArr);
        }
        if (!inheritList.isEmpty()) {
            appIdList.addAll(inheritList);
        }
        appIdList.add(bizAppId);
        return appIdList;
    }

    public static String selectSourceVersion(String sql, SqlParameter[] params, final String defaultVal) {
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return defaultVal;
            }
        });
    }

    public static void insertDevVersion(List<String> sqlList) {
        ArrayList list = new ArrayList();
        sqlList.forEach(sql -> list.add(new SqlObject(sql, null)));
        if (list.size() > 0) {
            try {
                for (SqlObject sqlObject : list) {
                    DB.execute((DBRoute)DBRoute.meta, (String)sqlObject.getSql(), null);
                }
            }
            catch (Exception e) {
                DevportalUtil.setInfoLog(e.getMessage());
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s. sql:%s", e.getMessage(), "insertAppVersion")});
            }
        }
    }

    public static JSONArray getSelectedUnitPages(String bizAppId, String bizUnitId, String deviceType, String bizPageModelType, String sortBizPageGroupType) {
        JSONArray appIds = DevportalUtil.getBizAppIds(bizAppId);
        QFilter unitRelFormFilter = new QFilter(BIZUNIT, "=", (Object)bizUnitId);
        QFilter appRelFormFilter = new QFilter(BIZAPP, "in", (Object)appIds);
        QFilter[] unitRelFormFilters = new QFilter[]{unitRelFormFilter, appRelFormFilter};
        String unitrelformFields = "bizapp,bizunit,form";
        JSONArray pageArray = new JSONArray();
        try (DataSet unitRelFormDataSet = QueryServiceHelper.queryDataSet((String)"bos_devportal_unitrelform", (String)"bos_devportal_unitrelform", (String)unitrelformFields, (QFilter[])unitRelFormFilters, (String)"form asc");){
            pageArray = DevportalUtil.pageListSQLCondition(bizAppId, bizUnitId, deviceType, bizPageModelType, sortBizPageGroupType, unitRelFormDataSet, appIds);
        }
        Object devLock = DevportalVerify.getParameter((String)"dev_form_lock");
        if (devLock != null && ((Boolean)devLock).booleanValue()) {
            Set lockForm = DevVerifyServiceHelper.getAllLockForm();
            for (Object object : pageArray) {
                String number = (String)((JSONObject)object).get((Object)NUMBER);
                ((JSONObject)object).put("accountType", (Object)"sys");
                if (lockForm.contains(number)) {
                    ((JSONObject)object).put("locking", (Object)2);
                    continue;
                }
                ((JSONObject)object).put("locking", (Object)1);
            }
        }
        return pageArray;
    }

    public static JSONArray pageListSQLCondition(String bizAppId, String bizUnitId, String deviceType, String bizPageModelType, String sortBizPageGroupType, DataSet unitRelFormDataSet, JSONArray appIds) {
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        List appFunctionPacketList = appMetadata.getAppFunctionPackets();
        JSONArray jsonArray = new JSONArray();
        boolean isSevenVersion = InitailVersionServiceHelper.isInitailVersion((int)7);
        if (appFunctionPacketList != null && appFunctionPacketList.size() > 0) {
            AppFunctionPacketElement unitObject = (AppFunctionPacketElement)appFunctionPacketList.get(0);
            String unitType = unitObject.getType();
            QFilter deviceMobFilter = null;
            if ("web".equals(deviceType)) {
                deviceMobFilter = new QFilter(MODELTYPE, "not like", (Object)"Mob%");
            } else if ("phone".equals(deviceType)) {
                deviceMobFilter = new QFilter(MODELTYPE, "like", (Object)"Mob%");
            }
            QFilter pageModelFilter = null;
            QFilter pageModelFilter1 = null;
            QFilter pageModelFilter2 = null;
            QFilter pageModelFilter3 = null;
            QFilter pageModelFilter4 = null;
            QFilter pageModelFilter5 = null;
            QFilter[] formMetaFilters = null;
            QFilter appRelFormFilter = new QFilter(BIZAPPID, "in", (Object)appIds);
            boolean pclayout = false;
            if (StringUtils.isNotBlank((CharSequence)bizPageModelType)) {
                if (bizPageModelType.startsWith("Parameter")) {
                    pageModelFilter = new QFilter(MODELTYPE, "like", (Object)"Parameter%");
                    formMetaFilters = new QFilter[]{deviceMobFilter, pageModelFilter, appRelFormFilter};
                } else if ("AllFormModel".equals(bizPageModelType)) {
                    if (isSevenVersion) {
                        pageModelFilter = new QFilter(MODELTYPE, "!=", (Object)PRINTMODEL);
                        formMetaFilters = new QFilter[]{deviceMobFilter, appRelFormFilter, pageModelFilter};
                    } else {
                        formMetaFilters = new QFilter[]{deviceMobFilter, appRelFormFilter};
                    }
                } else if ("OthersModel".equals(bizPageModelType)) {
                    pageModelFilter = new QFilter(MODELTYPE, "=", (Object)"WidgetFormModel");
                    pageModelFilter1 = new QFilter(MODELTYPE, "=", (Object)"UserGuideFormModel");
                    pageModelFilter2 = new QFilter(MODELTYPE, "=", (Object)"MobUserGuideFormModel");
                    pageModelFilter3 = new QFilter(MODELTYPE, "=", (Object)"BalanceModel");
                    pageModelFilter4 = new QFilter(MODELTYPE, "=", (Object)"QueryListModel");
                    pageModelFilter5 = new QFilter(MODELTYPE, "=", (Object)"LogBillFormModel");
                    formMetaFilters = new QFilter[]{deviceMobFilter, appRelFormFilter, pageModelFilter.or(pageModelFilter1).or(pageModelFilter2).or(pageModelFilter3).or(pageModelFilter4).or(pageModelFilter5)};
                } else if ("PCLayoutModel".equals(bizPageModelType)) {
                    pageModelFilter = new QFilter(MODELTYPE, "!=", (Object)PRINTMODEL);
                    pageModelFilter1 = new QFilter(MODELTYPE, "!=", (Object)"QueryListModel");
                    formMetaFilters = new QFilter[]{deviceMobFilter, pageModelFilter, pageModelFilter1, appRelFormFilter};
                    pclayout = true;
                } else {
                    if (PRINTMODEL.equals(bizPageModelType) && isSevenVersion) {
                        return jsonArray;
                    }
                    pageModelFilter = new QFilter(MODELTYPE, "=", (Object)bizPageModelType);
                    formMetaFilters = new QFilter[]{deviceMobFilter, pageModelFilter, appRelFormFilter};
                }
            } else if (isSevenVersion) {
                formMetaFilters = new QFilter[]{new QFilter(MODELTYPE, "!=", (Object)PRINTMODEL)};
            }
            String formMetaFields = "id,number,name,modeltype,version,basedatafield,type,parentid,createdate,modifydate,modifierid,masterid,isextended,isinherit,enabled";
            long userId = Long.parseLong(RequestContext.get().getUserId());
            QFilter shortcutFilter = new QFilter("user", "=", (Object)userId);
            QFilter[] shortcutFilters = new QFilter[]{shortcutFilter};
            String shortcutFields = "bizapp,bizpage";
            String orderby = sortBizPageGroupType + " asc";
            if (StringUtils.isNotBlank((CharSequence)sortBizPageGroupType)) {
                if (CREATEDATE.equals(sortBizPageGroupType) || MODIFYDATE.equals(sortBizPageGroupType)) {
                    orderby = sortBizPageGroupType + " desc";
                }
            } else {
                orderby = "number asc";
            }
            try (DataSet formMetaDataSet = QueryServiceHelper.queryDataSet((String)"bos_formmeta", (String)"bos_formmeta", (String)formMetaFields, (QFilter[])formMetaFilters, (String)"number asc");
                 DataSet shortcutDataSet = QueryServiceHelper.queryDataSet((String)BOS_DEVPORTAL_SHORTCUT, (String)BOS_DEVPORTAL_SHORTCUT, (String)shortcutFields, (QFilter[])shortcutFilters, (String)"bizpage asc");){
                jsonArray = DevportalUtil.getPageListSQL(bizAppId, unitType, unitRelFormDataSet, formMetaDataSet, shortcutDataSet, orderby, pclayout);
            }
        }
        return jsonArray;
    }

    public static JSONArray getPageListSQL(String bizAppId, String unitType, DataSet unitRelFormDataSet, DataSet formMetaDataSet, DataSet shortcutDataSet, String orderby, boolean layout) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String appType = metadata.getDevType();
        Long industryId = metadata.getIndustryId();
        boolean isIndustry = industryId != null && industryId != 0L;
        try (DataSet result = unitRelFormDataSet.join(formMetaDataSet, JoinType.INNER).on("form", "id").select(new String[]{BIZUNIT, "form", BIZAPP}, new String[]{"id", NUMBER, "name", MODELTYPE, VERSION, BASEDATAFIELD, "type", PARENTID, CREATEDATE, MODIFYDATE, MODIFIERID, MASTERID, ISEXTENDED, ISINHERIT, ENABLED}).finish().join(shortcutDataSet, JoinType.LEFT).on("form", BIZPAGE).select(new String[]{"id", NUMBER, "name", BIZUNIT, MODELTYPE, VERSION, BASEDATAFIELD, "type", PARENTID, CREATEDATE, MODIFYDATE, MODIFIERID, MASTERID, ISEXTENDED, ISINHERIT, ENABLED, BIZAPP}, new String[]{BIZPAGE}).finish().orderBy(new String[]{orderby});){
            DynamicObject[] formObjs;
            JSONArray pageArray = new JSONArray();
            HashSet<Long> userIds = new HashSet<Long>();
            HashMap<String, ILocaleString> nofoundformName = new HashMap<String, ILocaleString>(16);
            String codeManageType = DevportalUtil.getCodeManageTypeByBizAppId(bizAppId);
            for (Row row : result) {
                String formId = row.getString("id");
                String basedatafield = row.getString(BASEDATAFIELD);
                DynamicObject[] modeltype = row.getString(MODELTYPE);
                if (layout && formId.equals(basedatafield) || layout && modeltype.startsWith("Mob")) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)formId);
                jsonObject.put(NUMBER, (Object)row.getString(NUMBER));
                if (StringUtils.isBlank((CharSequence)row.getString("name"))) {
                    jsonObject.put("name", (Object)"");
                    nofoundformName.put(formId, null);
                } else {
                    jsonObject.put("name", (Object)row.getString("name"));
                }
                jsonObject.put("bizunitid", (Object)row.getString(BIZUNIT));
                if (modeltype.startsWith("Mob")) {
                    jsonObject.put("ismobile", (Object)Boolean.TRUE);
                } else {
                    jsonObject.put("ismobile", (Object)Boolean.FALSE);
                }
                jsonObject.put(VERSION, (Object)row.getString(VERSION));
                Boolean enabled = row.getBoolean(ENABLED);
                jsonObject.put(ENABLED, (Object)enabled);
                MetaDataUtil metaDataUtil = new MetaDataUtil();
                String parentId = row.getString(PARENTID);
                jsonObject.put(PARENTID, (Object)parentId);
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    jsonObject.put("parentnumber", (Object)metaDataUtil.getNumberById(parentId));
                }
                String entityId = row.getString(BASEDATAFIELD);
                jsonObject.put("entityid", (Object)entityId);
                if (!formId.equals(entityId) && ("BillFormModel".equals(modeltype) || "BaseFormModel".equals(modeltype))) {
                    jsonObject.put("isLayout", (Object)Boolean.TRUE);
                    jsonObject.put(MODELTYPE, (Object)"PCLayout");
                } else {
                    jsonObject.put("isLayout", (Object)Boolean.FALSE);
                    jsonObject.put(MODELTYPE, (Object)modeltype);
                    if (PRINTMODEL.equals(modeltype) && !formId.equals(entityId) && StringUtils.isNotBlank((CharSequence)entityId)) {
                        jsonObject.put("parentnumber", (Object)metaDataUtil.getNumberById(entityId));
                        jsonObject.put(PARENTID, (Object)entityId);
                    }
                }
                boolean isextended = row.getBoolean(ISEXTENDED);
                boolean isinherit = row.getBoolean(ISINHERIT);
                jsonObject.put(ISEXTENDED, (Object)isextended);
                jsonObject.put(ISINHERIT, (Object)isinherit);
                String devType = row.getString("type");
                if (StringUtils.isBlank((CharSequence)devType)) {
                    devType = "0";
                }
                if ("2".equals(appType)) {
                    if ("2".equals(devType) && row.getString(BIZAPP).equals(bizAppId)) {
                        jsonObject.put(DEVTYPE, (Object)"2");
                    } else if ("0".equals(devType) && row.getString(BIZAPP).equals(bizAppId)) {
                        jsonObject.put(DEVTYPE, (Object)"3");
                    } else {
                        jsonObject.put(DEVTYPE, (Object)"1");
                        if ("2".equals(devType)) {
                            jsonObject.put("tag", (Object)"2");
                        }
                    }
                } else {
                    jsonObject.put(DEVTYPE, (Object)devType);
                }
                if (unitType != null) {
                    jsonObject.put("unitType", (Object)unitType);
                }
                if (row.getDate(CREATEDATE) != null) {
                    jsonObject.put(CREATEDATE, (Object)sdf.format(row.getDate(CREATEDATE)));
                }
                if (row.getDate(MODIFYDATE) != null) {
                    jsonObject.put(MODIFYDATE, (Object)sdf.format(row.getDate(MODIFYDATE)));
                } else {
                    jsonObject.put(MODIFYDATE, jsonObject.get((Object)CREATEDATE));
                }
                boolean isCollection = false;
                if (row.getString(BIZAPP) != null && row.getString(BIZPAGE) != null) {
                    isCollection = true;
                }
                jsonObject.put("isCollection", (Object)isCollection);
                String modifierid = row.getString(MODIFIERID);
                if (StringUtils.isNotBlank((CharSequence)modifierid)) {
                    userIds.add(Long.valueOf(modifierid));
                    jsonObject.put(MODIFIERID, (Object)modifierid);
                }
                jsonObject.put(MASTERID, (Object)row.getString(MASTERID));
                jsonObject.put(CODEMANAGE, (Object)codeManageType);
                jsonObject.put("isindustry", (Object)isIndustry);
                pageArray.add((Object)jsonObject);
            }
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)userIds.toArray())};
            Map userObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])filters);
            QFilter[] formIdFilter = new QFilter[]{new QFilter("id", "in", (Object)nofoundformName.keySet().toArray())};
            for (DynamicObject formObj : formObjs = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id,name", (QFilter[])formIdFilter)) {
                nofoundformName.put(formObj.getPkValue().toString(), formObj.getLocaleString("name"));
            }
            for (int i = 0; i < pageArray.size(); ++i) {
                JSONObject pageItem = pageArray.getJSONObject(i);
                String modifierid = pageItem.getString(MODIFIERID);
                boolean hasFindUser = false;
                ILocaleString name = (ILocaleString)nofoundformName.get(pageItem.getString("id"));
                if (name != null) {
                    pageItem.put("name", (Object)name.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)modifierid)) {
                    Iterator iterator = userObjects.keySet().iterator();
                    while (iterator.hasNext()) {
                        DynamicObject userObject = (DynamicObject)userObjects.get(iterator.next());
                        if (!modifierid.equals(userObject.getString("id"))) continue;
                        pageItem.put("modifiername", (Object)userObject.getString("name"));
                        pageItem.remove((Object)MODIFIERID);
                        hasFindUser = true;
                        break;
                    }
                    if (hasFindUser) continue;
                    pageItem.put("modifiername", (Object)ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"DevportalUtil_69", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                    pageItem.remove((Object)MODIFIERID);
                    continue;
                }
                pageItem.remove((Object)MODIFIERID);
            }
            JSONArray jSONArray = pageArray;
            return jSONArray;
        }
    }

    public static TreeNode buildNode(TreeNode pnode, List<TreeNode> childNode) {
        HashMap<String, TreeNode> leafNodeMap = new HashMap<String, TreeNode>();
        DevportalUtil.getLeafNodes(leafNodeMap, pnode);
        for (int i = 0; i < childNode.size(); ++i) {
            TreeNode cnode = childNode.get(i);
            String parentID = cnode.getParentid();
            TreeNode parNode = (TreeNode)leafNodeMap.get(parentID);
            if (parNode == null) continue;
            int seq = 0;
            if (parNode.getChildren() != null) {
                seq = parNode.getChildren().size();
            }
            parNode.addChild(seq, cnode);
        }
        return pnode;
    }

    public static void getLeafNodes(Map<String, TreeNode> map, TreeNode node) {
        if (node.getChildren() != null) {
            for (TreeNode childNode : node.getChildren()) {
                DevportalUtil.getLeafNodes(map, childNode);
            }
        } else {
            map.put(node.getId(), node);
            return;
        }
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public static String filenameFilter(String str) {
        Pattern FilePattern = Pattern.compile("[\\\\/:*?\"<>|]");
        return str == null ? null : FilePattern.matcher(str).replaceAll("");
    }

    public static boolean isDevelopEnv() {
        return DevportalCommonUtil.isDevelopEnv();
    }

    public static boolean isGitManageType() {
        return DevportalCommonUtil.isGitManageType();
    }

    public static String getGitCommonRemoteUrl() {
        return DevportalCommonUtil.getGitCommonRemoteUrl();
    }

    public static boolean isGitMultiParallel() {
        return DevportalCommonUtil.isGitMultiParallel();
    }

    private static void writeLog(String formId, String formNumber, long logId) {
        try {
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, 6, logId, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            DevportalUtil.setInfoLog(e.getMessage());
        }
    }

    public static Long getUserByAppId(String bizAppId) {
        String field = "creater";
        QFilter filter = new QFilter("id", "=", (Object)bizAppId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)field, (QFilter[])filters);
        if (app != null) {
            DynamicObject user = (DynamicObject)app.get("creater");
            return user == null ? null : (Long)user.get("id");
        }
        return null;
    }

    public static boolean isInheritByFormId(String formId) {
        boolean flag = false;
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)formId)};
        String sql = "select FTYPE, FPARENTID from T_META_ENTITYDESIGN Where FId = ?";
        Map formMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>(2);
                while (rs.next()) {
                    map.put("type", rs.getString("FTYPE"));
                    map.put("parentId", rs.getString("FPARENTID"));
                }
                return map;
            }
        });
        String type = "";
        String parentId = "";
        String isTemplate = "";
        if (formMap != null && !formMap.isEmpty()) {
            type = (String)formMap.get("type");
            parentId = (String)formMap.get("parentId");
        }
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            Object[] params1 = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)parentId)};
            String sql1 = "select FISTEMPLATE from T_META_ENTITYDESIGN Where FId = ?";
            isTemplate = (String)DB.query((DBRoute)DBRoute.meta, (String)sql1, (Object[])params1, (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws SQLException {
                    String template = "";
                    while (rs.next()) {
                        template = rs.getString("FISTEMPLATE");
                    }
                    return template;
                }
            });
        }
        if ("0".equals(type) && StringUtils.isNotBlank((CharSequence)parentId) && "0".equals(isTemplate)) {
            flag = true;
        }
        return flag;
    }

    public static void gotoDesigner(IFormView formView, String formId) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)formId)};
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (String)MODELTYPE, (QFilter[])filters);
        String modelType = "";
        if (dynamicObject != null) {
            modelType = dynamicObject.getString(MODELTYPE);
        }
        switch (modelType) {
            case "BaseFormModel": 
            case "BillFormModel": 
            case "DynamicFormModel": {
                DevportalUtil.gotoNewPageDesinger(formView, formId, "bos_devn_appdetail");
                break;
            }
            default: {
                DevportalUtil.gotoPageDesinger(formView, formId, "bos_devn_appdetail");
            }
        }
    }

    private static void setErrorLog(Exception e) {
        logger.error((Throwable)e);
    }

    private static void setInfoLog(String infoMes) {
        logger.info(infoMes);
    }

    public static String checkPageIsExist(String inheritPath, String number) {
        if (StringUtils.isBlank((CharSequence)inheritPath)) {
            return null;
        }
        Object[] ids = inheritPath.split(",");
        Map metaMap = BusinessDataServiceHelper.loadFromCache((Object[])ids, (String)"bos_formmeta");
        if (metaMap.size() == ids.length) {
            return null;
        }
        ArrayList<Object> notExistIds = new ArrayList<Object>(ids.length);
        for (Object id : ids) {
            DynamicObject object = (DynamicObject)metaMap.get(id);
            if (object != null) continue;
            notExistIds.add(id);
        }
        if (!notExistIds.isEmpty()) {
            String errIds = StringUtils.join((Object[])notExistIds.toArray(), (String)",");
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u9875\u9762%1$s\u7684\u7236\u9875\u9762Id\u3010%2$s\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5\u3002", (String)"PageImportTask_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), number, errIds);
        }
        return null;
    }
}

