/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.newdevportal.table;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.entity.DBVersion;
import kd.bos.entity.EntityObjectReader;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.newdevportal.table.ConstaintType;
import kd.bos.newdevportal.table.DataDictExportTask;
import kd.bos.newdevportal.table.DesignerColumn;
import kd.bos.newdevportal.table.DesignerConstaint;
import kd.bos.newdevportal.table.DesignerTable;
import kd.bos.newdevportal.table.TableInfoProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class DataDictExcelExporter {
    private static final Log log = LogFactory.getLog(DataDictExcelExporter.class);
    private DynamicObjectCollection allSelectedCloudApps;
    private String bizVersion;
    private String fileNameNoExt;
    private List<String> appIds;
    private DataDictExportTask task;
    public static final String COSMIC_BOS = "cosmic_bos";
    public static final String CCS_PREFIX = "constellation_";
    private static final String FIELD_NAME_CLOUD_ID = "cloudId";
    private static final String FIELD_NAME_CLOUD_NAME = "cloudName";
    private static final String FIELD_NAME_CLOUD_NUMBER = "cloudNumber";
    private static final String FIELD_NAME_DBROUTE = "dbroute";
    private static final String FIELD_NAME_ENTITY_ID = "id";
    private static final String FIELD_NAME_ENTITY_NUMBER = "number";
    private static final String FIELD_NAME_ENTITY_NAME = "name";
    private static final String FIELD_NAME_APP_ID = "appId";
    private static final String FIELD_NAME_MASTER_ID = "masterid";
    private static final String FIELD_NAME_APP_NAME = "appName";
    private static final String FIELD_NAME_APP_NUMBER = "appNumber";
    private static final String FIELD_NAME_ENTITY_DENTITYID = "dentityid";
    private static final String FIELD_NAME_ENTITY_TABLENAME = "tablename";
    private static final String FIELD_NAME_ENTITY_PKFIELDNAME = "pkfieldname";
    private static final String FIELD_NAME_ENTITY_PKFIELDTYPE = "pkfieldtype";
    private static final String FIELD_NAME_ENTITY_MODELTYPE = "modeltype";
    private static final String DEFAULT_TABLE_NAME = "t_isv_xxx";
    private static final String BOS_DEVPORTAL_NEW_PLUGIN = "bos-devportal-new-plugin";

    public DataDictExcelExporter(List<String> appIds, DataDictExportTask task) {
        this.appIds = appIds;
        this.task = task;
        QFilter qIds = new QFilter(FIELD_NAME_ENTITY_ID, "in", this.appIds);
        QFilter[] filters = new QFilter[]{qIds};
        String selectFields = "id as appId,masterid,number as appNumber,name as appName,bizcloud.id as cloudId,bizcloud.number as cloudNumber,bizcloud.name as cloudName,dbroute, inheritpath";
        this.allSelectedCloudApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters, (String)"bizcloud.sequence asc, sequence asc");
        this.bizVersion = this.getBizVersion();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
        String currDateTime = dateFormat.format(new Date());
        this.fileNameNoExt = String.format(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79%1$s\u6570\u636e\u5b57\u5178\u5bfc\u51fa_%2$s", (String)"DataDictExcelExporter_1", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), this.bizVersion, currDateTime);
    }

    public String exportExcel() throws IOException {
        List<DynamicObject> clouds = this.getDistinctClouds();
        ArrayList<String> urls = new ArrayList<String>(clouds.size());
        for (int i = 0; i < clouds.size(); ++i) {
            double step = 100.0 / (double)clouds.size();
            double start = Math.max(step * (double)i, 5.0);
            DynamicObject cloud = clouds.get(i);
            urls.add(this.exportExcelByCloud(cloud, start, step));
        }
        return this.packageCloudZip(urls.toArray(new String[0]));
    }

    public String exportExcelByCloud(DynamicObject cloud, double start, double step) throws IOException {
        String zipUrl = "";
        log.debug("exportExcel begin ==============================");
        ByteArrayInputStream stream = null;
        try (ByteArrayOutputStream fileOut = new ByteArrayOutputStream();
             SXSSFWorkbook workbook = this.createExcelByCloud(cloud, start, step);){
            workbook.write((OutputStream)fileOut);
            byte[] bytes = fileOut.toByteArray();
            stream = new ByteArrayInputStream(bytes);
            workbook.dispose();
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
        String cloudName = cloud.getString(FIELD_NAME_CLOUD_NAME);
        try {
            zipUrl = this.packageExcelZip(cloudName, stream);
        }
        catch (Exception ex) {
            throw new KDException((Throwable)ex, new ErrorCode("DataDicUploadCloudExcelError", String.format("cloud name:%s", cloudName)), new Object[0]);
        }
        if (stream != null) {
            stream.close();
        }
        log.debug("exportExcel ending =============================");
        return zipUrl;
    }

    private String packageExcelZip(String fileName, ByteArrayInputStream stream) throws IOException {
        String zipFileName = String.format("%s.xlsx", fileName);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (BufferedInputStream in = new BufferedInputStream(stream);){
            String string = tempFileCache.saveAsUrl(zipFileName, (InputStream)in, 7200);
            return string;
        }
    }

    private String packageCloudZip(String[] cloudUrls) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String zipFileName = String.format("%s.zip", this.fileNameNoExt);
        return tempFileCache.compress(zipFileName, cloudUrls, 7200);
    }

    private SXSSFWorkbook createExcelByCloud(DynamicObject cloud, double start, double step) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(ResManager.loadKDString((String)"\u8868\u76ee\u5f55", (String)"DataDictExcelExporter_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        sheet.addMergedRegion(new CellRangeAddress(1, 1, 1, 7));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 1, 4));
        sheet.addMergedRegion(new CellRangeAddress(3, 3, 5, 6));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 1, 4));
        sheet.addMergedRegion(new CellRangeAddress(4, 4, 5, 6));
        SXSSFRow titleRow = sheet.createRow(1);
        Cell titleCell = titleRow.createCell(1);
        titleCell.setCellValue(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79", (String)"DataDictExcelExporter_2", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        CellStyle titleStyle = workbook.createCellStyle();
        Font titleFont = workbook.createFont();
        titleFont.setColor(IndexedColors.GREEN.getIndex());
        titleFont.setFontName("simsun");
        titleFont.setFontHeightInPoints((short)26);
        titleStyle.setFont(titleFont);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCell.setCellStyle(titleStyle);
        SXSSFRow versionRow = sheet.createRow(3);
        Cell versionCell = versionRow.createCell(1);
        versionCell.setCellValue(ResManager.loadKDString((String)"\u7cfb\u7edf\u7248\u672c\uff1a", (String)"DataDictExcelExporter_3", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        Cell versionCell1 = versionRow.createCell(5);
        versionCell1.setCellValue(this.getBizVersion());
        CellStyle versionStyle = workbook.createCellStyle();
        Font versionFont = workbook.createFont();
        versionFont.setFontName("simsun");
        versionFont.setFontHeightInPoints((short)10);
        versionStyle.setAlignment(HorizontalAlignment.LEFT);
        versionStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        versionStyle.setFont(versionFont);
        versionCell.setCellStyle(versionStyle);
        versionCell1.setCellStyle(versionStyle);
        SXSSFRow dataRow = sheet.createRow(4);
        Cell dataCell = dataRow.createCell(1);
        dataCell.setCellValue(ResManager.loadKDString((String)"\u6587\u6863\u751f\u6210\u65e5\u671f\uff1a", (String)"DataDictExcelExporter_4", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        Cell dataCell1 = dataRow.createCell(5);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String data = format.format(new Date());
        dataCell1.setCellValue(data);
        dataCell.setCellStyle(versionStyle);
        dataCell1.setCellStyle(versionStyle);
        SXSSFRow countRow = sheet.createRow(5);
        Font countFont = workbook.createFont();
        countFont.setFontName("simsun");
        countFont.setColor(IndexedColors.WHITE.getIndex());
        countFont.setFontHeightInPoints((short)10);
        XSSFCellStyle headerCellStyle = workbook.getXSSFWorkbook().createCellStyle();
        headerCellStyle.setAlignment(HorizontalAlignment.LEFT);
        byte[] colorRgb = new byte[]{-90, -90, -90};
        headerCellStyle.setFillForegroundColor(new XSSFColor(colorRgb));
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerCellStyle.setFont(countFont);
        Cell headerCell = countRow.createCell(1);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u7f16\u53f7", (String)"DataDictExcelExporter_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        headerCell = countRow.createCell(2);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u4e91", (String)"DataDictExcelExporter_9", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        headerCell = countRow.createCell(3);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u5e94\u7528", (String)"DataDictExcelExporter_10", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        headerCell = countRow.createCell(4);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"DataDictExcelExporter_11", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        headerCell = countRow.createCell(5);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u8868\u540d", (String)"DataDictExcelExporter_12", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        headerCell = countRow.createCell(6);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d", (String)"DataDictExcelExporter_13", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        headerCell = countRow.createCell(7);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u5173\u8054\u8868", (String)"DataDictExcelExporter_14", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle((CellStyle)headerCellStyle);
        this.setTableInfo(workbook, sheet, cloud, start, step);
        return workbook;
    }

    private void setTableInfo(SXSSFWorkbook workbook, SXSSFSheet sheet, DynamicObject cloudObject, double start, double step) {
        List<DynamicObject> clouds = Collections.singletonList(cloudObject);
        HashMap<Integer, String> seqs = new HashMap<Integer, String>(16);
        HashMap<Integer, String> cloudNames = new HashMap<Integer, String>(clouds.size());
        HashMap<Integer, String> appNames = new HashMap<Integer, String>(16);
        HashMap<Integer, String> entityNames = new HashMap<Integer, String>(16);
        HashMap<String, String> entitiesMap = new HashMap<String, String>(16);
        HashMap<Integer, String> tableNames = new HashMap<Integer, String>(16);
        HashMap<Integer, String> tableIds = new HashMap<Integer, String>(16);
        HashMap<String, Integer> assTabSort = new HashMap<String, Integer>(16);
        HashMap<Integer, String> assTables = new HashMap<Integer, String>(16);
        HashMap tablesInfoMap = new HashMap(16);
        HashMap<Integer, String> sheetNames = new HashMap<Integer, String>(16);
        String cloudName = cloudObject.getString(FIELD_NAME_CLOUD_NAME);
        int seq = 0;
        int countSize = 0;
        this.task.feedbackProgress((int)(start + 0.15 * step), String.format(ResManager.loadKDString((String)"\u6784\u5efa%s\u6570\u636e\u4fe1\u606f", (String)"DataDictExcelExporter_17", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), cloudName), null);
        for (DynamicObject cloud : clouds) {
            seqs.put(++countSize, String.valueOf(++seq));
            cloudNames.put(countSize, cloud.getString(FIELD_NAME_CLOUD_NAME));
            List<DynamicObject> apps = this.getAppsByCloudId(cloudObject.getString(FIELD_NAME_CLOUD_ID));
            int curStep = 0;
            for (DynamicObject app : apps) {
                String masterId = app.getString(FIELD_NAME_MASTER_ID);
                if (StringUtils.isNotBlank((CharSequence)masterId)) continue;
                String appId = app.getString(FIELD_NAME_APP_ID);
                String appName = app.getString(FIELD_NAME_APP_NAME);
                String dbRoute = app.getString(FIELD_NAME_DBROUTE);
                List<String> appIds = this.getAppIdsBy(appId);
                TableInfoProvider provider = TableInfoProvider.create((DBRoute)DBRoute.of((String)(dbRoute == null ? "sys" : dbRoute)));
                List tableInfos = provider.getTableInfoByAppId(appIds);
                int tableCount = 1;
                if (tableInfos.isEmpty()) continue;
                seqs.put(++countSize, String.valueOf(++seq));
                appNames.put(countSize, appName);
                int progress = (int)(start + (0.15 + 0.6 * (double)curStep / (double)apps.size()) * step);
                ++curStep;
                HashSet<String> existsEntities = new HashSet<String>(16);
                List<DynamicObject> entities = this.getEntitiesByApp(appIds);
                for (DynamicObject entity : entities) {
                    String entityNumber = entity.getString(FIELD_NAME_ENTITY_NUMBER);
                    String entityName = entity.getString(FIELD_NAME_ENTITY_NAME);
                    String entityLongName = entityName + "-" + entityNumber;
                    List tables = tableInfos.stream().filter(t -> entityNumber.equalsIgnoreCase(t.getOwnerEntityNum())).collect(Collectors.toList());
                    if (tables.isEmpty() || StringUtils.isBlank((CharSequence)entityName) || !existsEntities.add(entityLongName)) continue;
                    if (entityLongName.length() > 31) {
                        entityLongName = StringUtils.substring((String)entityLongName, (int)0, (int)30);
                    }
                    String nameReg = "(\\*|/|:|\\\\|\\[|\\]|\\?)";
                    String sheetName = entityLongName.replaceAll(nameReg, "_");
                    entitiesMap.put(entityNumber, sheetName);
                    tablesInfoMap.put(sheetName, tables);
                    boolean isFirst = true;
                    for (DesignerTable table : tables) {
                        if (DEFAULT_TABLE_NAME.equalsIgnoreCase(table.getCode())) continue;
                        this.task.feedbackProgress(progress, String.format(ResManager.loadKDString((String)"\u6784\u5efa\u4fe1\u606f\uff1a%1$s_%2$s_%3$s_%4$s(%5$s/%6$s)", (String)"DataDictExcelExporter_29", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), cloud.getString(FIELD_NAME_CLOUD_NAME), appName, entityName, table.getCode(), tableCount++, tableInfos.size()), null);
                        ++countSize;
                        if (isFirst) {
                            seqs.put(countSize, String.valueOf(++seq));
                            isFirst = false;
                        } else {
                            seqs.put(countSize, null);
                        }
                        tableNames.put(countSize, table.getName());
                        entityNames.put(countSize, entityName);
                        sheetNames.put(countSize, sheetName);
                        tableIds.put(countSize, table.getCode());
                        assTabSort.put(table.getCode(), countSize);
                    }
                }
            }
        }
        Collection values = tableIds.values();
        SqlBuilder extDataSql = new SqlBuilder();
        extDataSql.append("select ftablename, fdata from t_meta_tablediction where ", new Object[0]).appendIn("ftablename", values.toArray());
        assTables = values.isEmpty() ? new HashMap(10) : (Map)DB.query((DBRoute)DBRoute.meta, (SqlBuilder)extDataSql, rs -> {
            HashMap<Integer, String> ext = new HashMap<Integer, String>();
            while (rs.next()) {
                String tableName = rs.getString("ftablename");
                try {
                    String extData = rs.getString("fdata");
                    if (!StringUtils.isNotBlank((CharSequence)extData)) continue;
                    Map data = (Map)SerializationUtils.fromJsonString((String)extData, Map.class);
                    Object ptable = data.get("parenttable");
                    Integer assSort = (Integer)assTabSort.get(tableName);
                    ext.put(assSort, ptable.toString());
                }
                catch (Exception e) {
                    log.error("\u6570\u636e\u8868\u63cf\u8ff0\u67e5\u8be2\u5931\u8d25:" + e.getMessage(), (Throwable)e);
                }
            }
            return ext;
        });
        HashMap<String, Integer> tableHyperLinkMap = new HashMap<String, Integer>();
        XSSFCellStyle titelHyperlinkCellStyle = DataDictExcelExporter.createHyperlinkCellStyle(workbook);
        CreationHelper creationHelper = workbook.getCreationHelper();
        CellStyle titleCellStyle = workbook.createCellStyle();
        Font rowFont = workbook.createFont();
        rowFont.setFontName("simsun");
        rowFont.setFontHeightInPoints((short)10);
        titleCellStyle.setAlignment(HorizontalAlignment.LEFT);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        titleCellStyle.setFont(rowFont);
        XSSFCellStyle headerCellStyle = workbook.getXSSFWorkbook().createCellStyle();
        Font headerFont = workbook.createFont();
        headerFont.setFontName("simsun");
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        headerFont.setFontHeightInPoints((short)10);
        headerCellStyle.setAlignment(HorizontalAlignment.LEFT);
        byte[] headerColorRgb = new byte[]{-90, -90, -90};
        headerCellStyle.setFillForegroundColor(new XSSFColor(headerColorRgb));
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headerCellStyle.setFont(headerFont);
        XSSFCellStyle cellStyle = workbook.getXSSFWorkbook().createCellStyle();
        Font countFont = workbook.createFont();
        countFont.setFontName("simsun");
        countFont.setFontHeightInPoints((short)10);
        cellStyle.setFont(countFont);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        byte[] countColorRgb = new byte[]{-14, -14, -14};
        cellStyle.setFillForegroundColor(new XSSFColor(countColorRgb));
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFCellStyle hyperlinkCellStyle = DataDictExcelExporter.createHyperlinkCellStyle(workbook);
        hyperlinkCellStyle.setFillForegroundColor(new XSSFColor(countColorRgb));
        hyperlinkCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.task.feedbackProgress((int)(start + 0.75 * step), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210%s\u6570\u636e\u8868\u4fe1\u606f", (String)"DataDictExcelExporter_15", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), cloudName), null);
        for (Map.Entry info : tablesInfoMap.entrySet()) {
            String sheetName = (String)info.getKey();
            this.buildTableInfo(workbook, sheetName, (List)info.getValue(), tableHyperLinkMap, entitiesMap, titleCellStyle, (CellStyle)titelHyperlinkCellStyle, (CellStyle)headerCellStyle, (CellStyle)cellStyle, (CellStyle)hyperlinkCellStyle, creationHelper);
        }
        this.task.feedbackProgress((int)(start + 0.85 * step), String.format(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210%s\u8868\u76ee\u5f55\u4fe1\u606f", (String)"DataDictExcelExporter_16", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]), cloudName), null);
        this.buildHomeDic(workbook, sheet, countSize, seqs, cloudNames, appNames, entityNames, tableNames, tableIds, assTables, tableHyperLinkMap, sheetNames);
    }

    private void buildTableInfo(SXSSFWorkbook workbook, String sheetName, List<DesignerTable> tables, Map<String, Integer> tableHyperLinkMap, Map<String, String> entitiesMap, CellStyle titleCellStyle, CellStyle titleHyperlinkCellStyle, CellStyle headerCellStyle, CellStyle cellStyle, CellStyle hyperlinkCellStyle, CreationHelper creationHelper) {
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setColumnWidth(1, 1280);
        sheet.setColumnWidth(2, 3840);
        sheet.setColumnWidth(10, 11520);
        int firstRow = 0;
        int countRow = 0;
        for (DesignerTable table : tables) {
            List cols = table.getCols();
            if (cols.isEmpty()) continue;
            firstRow = this.buildTableTitle(sheet, firstRow, table, tableHyperLinkMap, titleCellStyle, titleHyperlinkCellStyle, headerCellStyle, creationHelper);
            ArrayList pkColumns = new ArrayList();
            for (DesignerConstaint constaint : table.getConstaints()) {
                if (!ConstaintType.Primary.equal(constaint.getConstaintType())) continue;
                pkColumns.addAll(constaint.getRefCols());
            }
            int seq = 0;
            countRow += 4;
            for (DesignerColumn col : cols) {
                ++seq;
                SXSSFRow row = sheet.createRow(countRow);
                for (int cellNum = 1; cellNum < 11; ++cellNum) {
                    Cell cell = row.createCell(cellNum);
                    if (cellNum == 1) {
                        cell.setCellValue((double)seq);
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 2) {
                        cell.setCellValue(col.getCode());
                        cell.setCellStyle(cellStyle);
                        cellStyle.setWrapText(false);
                        continue;
                    }
                    if (cellNum == 3) {
                        cell.setCellValue(col.getName());
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 4) {
                        cell.setCellValue(col.getType());
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 5) {
                        if (col.getLength() > 0L) {
                            cell.setCellValue((double)col.getLength());
                        }
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 6) {
                        if (col.getScale() > 0) {
                            cell.setCellValue((double)col.getScale());
                        }
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 7) {
                        if (pkColumns.contains(col.getName())) {
                            cell.setCellValue(ResManager.loadKDString((String)"\u662f", (String)"DataDictExcelExporter_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                        } else {
                            cell.setCellValue(ResManager.loadKDString((String)"\u5426", (String)"DataDictExcelExporter_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                        }
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 8) {
                        if (col.isNotnull()) {
                            cell.setCellValue(ResManager.loadKDString((String)"\u662f", (String)"DataDictExcelExporter_18", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                        } else {
                            cell.setCellValue(ResManager.loadKDString((String)"\u5426", (String)"DataDictExcelExporter_19", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
                        }
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    if (cellNum == 9) {
                        cell.setCellValue(col.getDefValue());
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    String comment = col.getComment().getLocaleValue();
                    cell.setCellValue(comment);
                    boolean isBase = col.isBase();
                    if (isBase) {
                        String entityNumber = comment.split(" ")[1];
                        if (entitiesMap.containsKey(entityNumber)) {
                            Hyperlink hyperlink = creationHelper.createHyperlink(HyperlinkType.DOCUMENT);
                            hyperlink.setAddress(String.format("'%1$s'!A1", entitiesMap.get(entityNumber)));
                            cell.setHyperlink(hyperlink);
                            cell.setCellStyle(hyperlinkCellStyle);
                            continue;
                        }
                        cell.setCellStyle(cellStyle);
                        continue;
                    }
                    cellStyle.setWrapText(true);
                    cell.setCellStyle(cellStyle);
                }
                ++countRow;
            }
        }
    }

    private int buildTableTitle(SXSSFSheet entitySheet, int firstRow, DesignerTable table, Map<String, Integer> tableHyperLinkMap, CellStyle titleCellStyle, CellStyle titleHyperlinkCellStyle, CellStyle headerCellStyle, CreationHelper creationHelper) {
        entitySheet.addMergedRegion(new CellRangeAddress(firstRow + 1, firstRow + 1, 1, 3));
        entitySheet.addMergedRegion(new CellRangeAddress(firstRow + 1, firstRow + 1, 4, 5));
        entitySheet.addMergedRegion(new CellRangeAddress(firstRow + 2, firstRow + 2, 1, 3));
        entitySheet.addMergedRegion(new CellRangeAddress(firstRow + 2, firstRow + 2, 4, 5));
        SXSSFRow row = entitySheet.createRow(firstRow++);
        Cell row1Cell11 = row.createCell(7);
        row1Cell11.setCellValue(ResManager.loadKDString((String)"\u8fd4\u56de\u4e3b\u76ee\u5f55", (String)"DataDictExcelExporter_7", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        Hyperlink titleHyperlink = creationHelper.createHyperlink(HyperlinkType.DOCUMENT);
        String homeDic = ResManager.loadKDString((String)"\u8868\u76ee\u5f55", (String)"DataDictExcelExporter_0", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]);
        titleHyperlink.setAddress(String.format("'%s'!A2", homeDic));
        row1Cell11.setHyperlink(titleHyperlink);
        row1Cell11.setCellStyle(titleHyperlinkCellStyle);
        SXSSFRow row1 = entitySheet.createRow(firstRow++);
        Cell row1Cell = row1.createCell(1);
        row1Cell.setCellValue(ResManager.loadKDString((String)"\u8868\u540d\uff1a", (String)"DataDictExcelExporter_5", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        Cell row1Cell1 = row1.createCell(4);
        row1Cell1.setCellValue(table.getName());
        tableHyperLinkMap.put(table.getCode(), firstRow);
        row1Cell.setCellStyle(titleCellStyle);
        row1Cell1.setCellStyle(titleCellStyle);
        SXSSFRow dataRow = entitySheet.createRow(firstRow++);
        Cell dataCell = dataRow.createCell(1);
        dataCell.setCellValue(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\uff1a", (String)"DataDictExcelExporter_6", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        Cell dataCell1 = dataRow.createCell(4);
        dataCell1.setCellValue(table.getCode());
        dataCell.setCellStyle(titleCellStyle);
        dataCell1.setCellStyle(titleCellStyle);
        SXSSFRow countRow = entitySheet.createRow(firstRow++);
        Cell headerCell = countRow.createCell(1);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u7f16\u53f7", (String)"DataDictExcelExporter_8", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(2);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u5217\u540d", (String)"DataDictExcelExporter_20", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(3);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u5217\u6807\u9898", (String)"DataDictExcelExporter_21", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(4);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"DataDictExcelExporter_22", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(5);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u957f\u5ea6", (String)"DataDictExcelExporter_23", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(6);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u7cbe\u5ea6", (String)"DataDictExcelExporter_24", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(7);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"DataDictExcelExporter_25", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(8);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u975e\u7a7a", (String)"DataDictExcelExporter_26", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(9);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c", (String)"DataDictExcelExporter_27", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        headerCell = countRow.createCell(10);
        headerCell.setCellValue(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"DataDictExcelExporter_28", (String)BOS_DEVPORTAL_NEW_PLUGIN, (Object[])new Object[0]));
        headerCell.setCellStyle(headerCellStyle);
        return firstRow += table.getCols().size();
    }

    private static XSSFCellStyle createHyperlinkCellStyle(SXSSFWorkbook workbook) {
        XSSFCellStyle cellStyle = workbook.getXSSFWorkbook().createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("Calibri");
        font.setFontHeightInPoints((short)11);
        font.setUnderline((byte)1);
        font.setColor(IndexedColors.BLUE.getIndex());
        cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        cellStyle.setFont(font);
        return cellStyle;
    }

    private void buildHomeDic(SXSSFWorkbook workbook, SXSSFSheet sheet, int countSize, Map<Integer, String> seqs, Map<Integer, String> cloudNames, Map<Integer, String> appNames, Map<Integer, String> entityNames, Map<Integer, String> tableNames, Map<Integer, String> tableIds, Map<Integer, String> assTables, Map<String, Integer> tableHyperLinkMap, Map<Integer, String> sheetNames) {
        sheet.setColumnWidth(1, 1280);
        int countRow = countSize + 6;
        countSize = 0;
        XSSFCellStyle cellStyle = workbook.getXSSFWorkbook().createCellStyle();
        for (int rowNum = 6; rowNum < countRow; ++rowNum) {
            ++countSize;
            Font countFont = workbook.createFont();
            countFont.setFontName("simsun");
            countFont.setFontHeightInPoints((short)10);
            cellStyle.setFont(countFont);
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
            SXSSFRow row = sheet.createRow(rowNum);
            for (int cellNum = 1; cellNum < 8; ++cellNum) {
                byte[] colorRgb;
                Cell cell = row.createCell(cellNum);
                if (cellNum == 1) {
                    cell.setCellValue(seqs.get(countSize));
                    cell.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                if (cellNum == 2) {
                    String cloudName = cloudNames.get(countSize);
                    cell.setCellValue(cloudName);
                    if (StringUtils.isNotBlank((CharSequence)cloudName)) {
                        colorRgb = new byte[]{-39, -39, -39};
                        cellStyle.setFillForegroundColor(new XSSFColor(colorRgb));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    cell.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                if (cellNum == 3) {
                    String appName = appNames.get(countSize);
                    if (StringUtils.isNotBlank((CharSequence)appName)) {
                        colorRgb = new byte[]{-14, -14, -14};
                        cellStyle.setFillForegroundColor(new XSSFColor(colorRgb));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    cell.setCellValue(appNames.get(countSize));
                    cell.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                if (cellNum == 4) {
                    String entityName = entityNames.get(countSize);
                    if (StringUtils.isNotBlank((CharSequence)entityName)) {
                        colorRgb = new byte[]{-21, -21, -21};
                        cellStyle.setFillForegroundColor(new XSSFColor(colorRgb));
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    cell.setCellValue(entityName);
                    cell.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                if (cellNum == 5) {
                    String tableName = tableNames.get(countSize);
                    if (StringUtils.isNotBlank((CharSequence)tableName)) {
                        Integer position = tableHyperLinkMap.get(tableIds.get(countSize));
                        cell.setCellValue(tableNames.get(countSize));
                        XSSFCellStyle hyperlinkCellStyle = DataDictExcelExporter.createHyperlinkCellStyle(workbook);
                        CreationHelper creationHelper = workbook.getCreationHelper();
                        Hyperlink hyperlink = creationHelper.createHyperlink(HyperlinkType.DOCUMENT);
                        hyperlink.setAddress(String.format("'%1$s'!A%2$s", sheetNames.get(countSize), position));
                        cell.setHyperlink(hyperlink);
                        byte[] colorRgb2 = new byte[]{-21, -21, -21};
                        hyperlinkCellStyle.setFillForegroundColor(new XSSFColor(colorRgb2));
                        hyperlinkCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cell.setCellStyle((CellStyle)hyperlinkCellStyle);
                        continue;
                    }
                    cell.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                if (cellNum == 6) {
                    cell.setCellValue(tableIds.get(countSize));
                    cell.setCellStyle((CellStyle)cellStyle);
                    continue;
                }
                cell.setCellValue(assTables.get(countSize));
                cell.setCellStyle((CellStyle)cellStyle);
            }
        }
        sheet.trackAllColumnsForAutoSizing();
        sheet.autoSizeColumn(2, true);
        sheet.autoSizeColumn(3, true);
        sheet.autoSizeColumn(4, true);
        sheet.autoSizeColumn(5, true);
        sheet.autoSizeColumn(6, true);
        sheet.autoSizeColumn(7, true);
    }

    private List<DynamicObject> getDistinctClouds() {
        return this.allSelectedCloudApps.stream().filter(this.distinctByCloud(p -> p.getString(FIELD_NAME_CLOUD_ID))).collect(Collectors.toList());
    }

    private <T> Predicate<T> distinctByCloud(Function<? super T, Object> cloudExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            Object apply = cloudExtractor.apply(t);
            if (apply != null) {
                return map.putIfAbsent(apply, Boolean.TRUE) == null;
            }
            return false;
        };
    }

    private List<DynamicObject> getAppsByCloudId(String cloudId) {
        return this.allSelectedCloudApps.stream().filter(d -> cloudId != null && cloudId.equalsIgnoreCase(d.getString(FIELD_NAME_CLOUD_ID))).collect(Collectors.toList());
    }

    private List<String> getAppIdsBy(String appId) {
        return this.allSelectedCloudApps.stream().filter(d -> d.getString(FIELD_NAME_APP_ID).equalsIgnoreCase(appId) || d.getString(FIELD_NAME_MASTER_ID).equalsIgnoreCase(appId)).map(t -> t.getString(FIELD_NAME_APP_ID)).collect(Collectors.toList());
    }

    private List<DynamicObject> getEntitiesByApp(List<String> appIds) {
        ArrayList<String> selectFields = new ArrayList<String>(4);
        selectFields.add(FIELD_NAME_ENTITY_ID);
        selectFields.add(FIELD_NAME_ENTITY_NUMBER);
        selectFields.add(FIELD_NAME_ENTITY_NAME);
        selectFields.add(FIELD_NAME_ENTITY_DENTITYID);
        selectFields.add(FIELD_NAME_ENTITY_TABLENAME);
        selectFields.add(FIELD_NAME_ENTITY_PKFIELDNAME);
        selectFields.add(FIELD_NAME_ENTITY_PKFIELDTYPE);
        selectFields.add(FIELD_NAME_ENTITY_MODELTYPE);
        ArrayList<DynamicObject> r = new ArrayList<DynamicObject>(16);
        QFilter modelTypeFilter = new QFilter(FIELD_NAME_ENTITY_MODELTYPE, "in", Arrays.asList("BaseFormModel", "BillFormModel"));
        QFilter isTemplateFilter = new QFilter("istemplate", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{modelTypeFilter, isTemplateFilter};
        for (String id : appIds) {
            Map entityInfos = EntityObjectReader.loadEntityObjectsInApp((String)id, selectFields, (QFilter[])filters);
            for (Map.Entry entryItem : entityInfos.entrySet()) {
                DynamicObject entityInfo = (DynamicObject)entryItem.getValue();
                r.add(entityInfo);
            }
        }
        return r;
    }

    private String getBizVersion() {
        List versions = IndustryVersionServiceHelper.getVersionInfos();
        String bosVer = "";
        StringBuilder bizVer = new StringBuilder("V");
        for (IndustryVersionInfo version : versions) {
            if (COSMIC_BOS.equals(version.getProductNumber())) {
                bosVer = version.getVersion();
                continue;
            }
            if (!version.getProductNumber().startsWith(CCS_PREFIX)) continue;
            bizVer.append(version.getVersion());
        }
        if (bizVer.length() == 1) {
            if (bosVer.length() > 0) {
                bizVer.append(bosVer);
            } else {
                bizVer.append(DBVersion.getVer());
            }
        }
        return bizVer.toString();
    }
}

