/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.webapi;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.gptas.qa.QACache;
import kd.bos.gptas.qa.QASessionCache;
import kd.bos.gptas.qa.QAUtil;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.LLMData;
import kd.bos.gptas.qa.model.QAModel;
import kd.bos.gptas.qa.model.UserHistoryMessage;
import kd.bos.gptas.utils.QaUserTrackUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;

@ApiController(value="gptasqa", desc="\u77e5\u8bc6\u95ee\u7b54")
public class QAService {
    private static final Log logger = LogFactory.getLog(QAService.class);
    private static final Pattern pattern = Pattern.compile("#+(\\d+?)#+");
    private static final Pattern patternFile = Pattern.compile("_(\\d+?).txt");
    private static final long TASK_MAX_TIME = 90000L;
    public static final int STREAM_WAIT_TIME = 300;

    @ApiPostMapping(value="qa")
    public CustomApiResult<QAModel> qa(@ApiParam(value="\u95ee\u9898", example="\u5982\u4f55\u65b0\u5efa\u5355\u636e?", required=true) @ApiParam(value="\u95ee\u9898", example="\u5982\u4f55\u65b0\u5efa\u5355\u636e?", required=true) String question, @ApiParam(value="\u63d0\u793a\u8bed\u7f16\u7801", example="", required=true) @ApiParam(value="\u63d0\u793a\u8bed\u7f16\u7801", example="", required=true) String number, @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1, Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99 ") @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1, Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99 ") Integer clientType, @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") String userType, @ApiParam(value="\u5bf9\u8bddId", example="") @ApiParam(value="\u5bf9\u8bddId", example="") String chatSessionId, @ApiParam(value="\u7528\u6237id") @ApiParam(value="\u7528\u6237id") String uid) {
        try {
            String prompt;
            logger.info("begin qa question:" + question + " prompt:" + number);
            QaUserTrackUtil.recordUserAction((String)"qa", (Integer)clientType, (String)uid, (String)userType);
            QAModel result = new QAModel();
            QASessionCache qaSessionCache = new QASessionCache(chatSessionId);
            List userHistoryMessageList = qaSessionCache.getHistoryMessage();
            if (UserHistoryMessage.isNextQuestion((List)userHistoryMessageList)) {
                String summaryPrompt = QAUtil.buildSummaryPrompt((String)question, (List)userHistoryMessageList);
                question = QAUtil.invokePromptService((Object)"gptas-default", (String)summaryPrompt, (String)"");
                prompt = QAUtil.buildNextPrompt((String)question, (String)number, (String)chatSessionId);
            } else {
                prompt = QAUtil.buildPrompt((String)question, (String)number, (String)chatSessionId);
            }
            String answer = QAUtil.invokePromptService((Object)"gptas-default", (String)prompt, (String)chatSessionId);
            result.setRefFileList(QAModel.parseRefFileList((String)answer, (boolean)true));
            result.setQuestion(question);
            result.setAnswer(QAModel.removeRefFile((String)answer));
            qaSessionCache.putHistoryMessage(question, prompt, answer);
            return CustomApiResult.success((Object)result);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"001", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="qaPolling")
    public CustomApiResult<LLMAPIMsg> qaPolling(@ApiParam(value="\u95ee\u9898", example="\u5982\u4f55\u65b0\u5efa\u5355\u636e?", required=false) @ApiParam(value="\u95ee\u9898", example="\u5982\u4f55\u65b0\u5efa\u5355\u636e?", required=false) String question, @ApiParam(value="\u77e5\u8bc6\u5e93\u7f16\u7801", example="", required=false) @ApiParam(value="\u77e5\u8bc6\u5e93\u7f16\u7801", example="", required=false) String number, @ApiParam(value="\u8bf7\u6c42Id", example="", required=false) @ApiParam(value="\u8bf7\u6c42Id", example="", required=false) String requestId, @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1, Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99") @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1, Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99") Integer clientType, @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") String userType, @ApiParam(value="\u5bf9\u8bddId", example="") @ApiParam(value="\u5bf9\u8bddId", example="") String chatSessionId, @ApiParam(value="\u63d0\u793a\u8bcd\u6a21\u7248\u7c7b\u578b \u9ed8\u8ba4: QA\u95ee\u7b54", example="1:\u751f\u6210\u4ee3\u7801 2:\u751f\u6210\u6ce8\u91ca 3:\u4ee3\u7801\u4f18\u5316 4:\u4ee3\u7801\u89e3\u91ca") @ApiParam(value="\u63d0\u793a\u8bcd\u6a21\u7248\u7c7b\u578b \u9ed8\u8ba4: QA\u95ee\u7b54", example="1:\u751f\u6210\u4ee3\u7801 2:\u751f\u6210\u6ce8\u91ca 3:\u4ee3\u7801\u4f18\u5316 4:\u4ee3\u7801\u89e3\u91ca") Integer promptTemplateType, @ApiParam(value="\u7528\u6237id") @ApiParam(value="\u7528\u6237id") String uid) {
        QACache qaCache = new QACache(requestId).save();
        QASessionCache qaSessionCache = new QASessionCache(chatSessionId);
        if (qaCache.getTaskId() == null) {
            String prompt;
            if (StringUtils.isBlank((CharSequence)number)) {
                qaCache.release();
                return CustomApiResult.fail((String)"102", (String)"number can't be empty.");
            }
            if (StringUtils.isBlank((CharSequence)question)) {
                qaCache.release();
                return CustomApiResult.fail((String)"103", (String)"question can't be empty.");
            }
            QaUserTrackUtil.recordUserAction((String)"qaPolling", (Integer)clientType, (String)uid, (String)userType);
            logger.info("start invoke PromptServiceAsync requestId :" + requestId);
            List userHistoryMessageList = qaSessionCache.getHistoryMessage();
            if (UserHistoryMessage.isNextQuestion((List)userHistoryMessageList)) {
                String summaryPrompt = QAUtil.buildSummaryPrompt((String)question, (List)userHistoryMessageList);
                question = QAUtil.invokePromptService((Object)"gptas-default", (String)summaryPrompt, (String)"");
                prompt = QAUtil.buildNextPrompt((String)question, (String)number, (String)chatSessionId);
            } else {
                prompt = QAUtil.buildPrompt((String)question, (String)number, (String)chatSessionId, (Integer)promptTemplateType);
            }
            qaSessionCache.putHistoryMessageInput(question, prompt);
            String taskId = QAUtil.invokePromptServiceAsync((String)"gptas-default", (String)prompt, (String)chatSessionId);
            qaCache.setTaskId(taskId).save();
        }
        long ts = System.currentTimeMillis();
        LLMAPIMsg combine = null;
        qaCache.initReservedCharacters();
        do {
            if (qaCache.isStop()) {
                return CustomApiResult.fail((String)"102", (String)"stop data");
            }
            String llmData = qaCache.popLLMData();
            if (StringUtils.isNotBlank((CharSequence)llmData)) {
                logger.info("get data {}", (Object)llmData);
                LLMAPIMsg mapData = (LLMAPIMsg)JSON.parseObject((String)llmData, LLMAPIMsg.class);
                if (!mapData.isStatus()) {
                    qaCache.release();
                    return CustomApiResult.fail((String)"101", (String)mapData.getErrMsg());
                }
                String preReserved = qaCache.getReservedCharacters();
                mapData.getData().setLlmValue(qaCache.reservedLLMValue(mapData.getData().getLlmValue(), mapData.getData().isEnd()));
                logger.info("get data {} reseved:{} refList:{},prev:{} ", new Object[]{mapData.getData().getLlmValue(), qaCache.getReservedCharacters(), qaCache.getRef(), preReserved});
                if (combine == null) {
                    combine = mapData;
                } else {
                    combine.getData().setEnd(mapData.getData().isEnd());
                    combine.getData().concatLLMValue(mapData.getData().getLlmValue());
                    combine.setErrCode(mapData.getErrCode());
                    combine.setErrMsg(mapData.getErrMsg());
                    combine.setStatus(mapData.isStatus());
                }
                if (System.currentTimeMillis() - ts < 300L && !QAService.isEnd(mapData)) continue;
                qaCache.saveRef();
                if (QAService.isEnd(mapData)) {
                    String[] ref = qaCache.getRef();
                    if (ref != null && ref.length > 0) {
                        ArrayList<Long> list = new ArrayList<Long>(16);
                        for (String s : ref) {
                            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                            list.add(Long.parseLong(s));
                        }
                        combine.getData().getRefFileList().addAll(QAModel.parseRefFileList(list, (boolean)true));
                    }
                    logger.info(" put Last RefFile to cache {}", (Object)combine.getData().getRefFileList().size());
                    qaSessionCache.putLastRefFile(combine.getData().getRefFileList());
                    qaSessionCache.putHistoryMessageAssistant(combine.getData().getLlmValue(), combine.getData().isEnd());
                    qaCache.release();
                }
                return this.getPollingReturn(combine, qaSessionCache);
            }
            if (combine != null) {
                qaCache.saveRef();
                return this.getPollingReturn(combine, qaSessionCache);
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() - ts <= 90000L);
        qaCache.release();
        return CustomApiResult.fail((String)"101", (String)"no data");
    }

    private CustomApiResult<LLMAPIMsg> getPollingReturn(LLMAPIMsg msg, QASessionCache qaSessionCache) {
        qaSessionCache.putHistoryMessageAssistant(msg.getData().getLlmValue(), msg.getData().isEnd());
        return CustomApiResult.success((Object)msg);
    }

    @ApiPostMapping(value="qaFeedback")
    public CustomApiResult<String> qaFeedback(@ApiParam(value="\u53cd\u9988\u7f16\u53f7") @ApiParam(value="\u53cd\u9988\u7f16\u53f7") String billNo, @ApiParam(value="\u95ee\u9898") @ApiParam(value="\u95ee\u9898") String question, @ApiParam(value="\u7b54\u6848") @ApiParam(value="\u7b54\u6848") String answer, @ApiParam(value="\u70b9\u8e29\u7c7b\u578b \u70b9\uff1aB, \u8e29\uff1aC", example=" \u70b9\uff1aB, \u8e29\uff1aC") @ApiParam(value="\u70b9\u8e29\u7c7b\u578b \u70b9\uff1aB, \u8e29\uff1aC", example=" \u70b9\uff1aB, \u8e29\uff1aC") String type, @ApiParam(value="\u52a9\u624b\u7f16\u7801") @ApiParam(value="\u52a9\u624b\u7f16\u7801") String grouptype, @ApiParam(value="\u5173\u8054\u6587\u4ef6ID") @ApiParam(value="\u5173\u8054\u6587\u4ef6ID") List<Long> knlIds, @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1,Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99 ") @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1,Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99 ") Integer clientType, @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") String userType, @ApiParam(value="\u95ee\u9898\u7c7b\u578b") @ApiParam(value="\u95ee\u9898\u7c7b\u578b") List<String> fdbkType, @ApiParam(value="\u53cd\u9988\u63cf\u8ff0") @ApiParam(value="\u53cd\u9988\u63cf\u8ff0") String fdbkDesc, @ApiParam(value="\u5f00\u53d1\u52a9\u624b") @ApiParam(value="\u5f00\u53d1\u52a9\u624b") Long assistantId, @ApiParam(value="\u7528\u6237id") @ApiParam(value="\u7528\u6237id") String uid) {
        QaUserTrackUtil.recordUserAction((String)"qaFeedback", (Integer)clientType, (String)uid, (String)userType);
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("question", question);
        params.put("answer", answer);
        params.put("api", "true");
        params.put("action", "QA_DISP_" + grouptype);
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            params.put("billno", billNo);
        }
        ArrayList list = CollectionUtils.isEmpty(knlIds) ? new ArrayList(10) : new ArrayList<Long>(knlIds);
        QAUtil.saveQAResult(params, (Long)assistantId, (String)type, (Integer)clientType, list, fdbkType, (String)fdbkDesc);
        return CustomApiResult.success((Object)"OK");
    }

    @ApiPostMapping(value="qaEmbedding")
    public CustomApiResult<List<Map<String, String>>> qaEmbedding(@ApiParam(value="\u77e5\u8bc6\u5e93\u7f16\u7801", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93\u7f16\u7801", required=true) String corpusNumber, @ApiParam(value="\u7528\u6237\u95ee\u9898", required=true) @ApiParam(value="\u7528\u6237\u95ee\u9898", required=true) String question, @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1, Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99 ") @ApiParam(value="\u5ba2\u6237\u7aef\u7c7b\u578b", example="Web\u7aef\uff1a1, Idea\uff1a2, vsCode:3, \u4fa7\u8fb9\u680f: 4, \u5176\u4ed6\uff1a99 ") Integer clientType, @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") @ApiParam(value="\u7528\u6237\u7c7b\u578b", example="\u91d1\u8776\u5ba2\u6237: 1, \u91d1\u8776\u96c6\u56e2: 2, \u4ea4\u4ed8\u4f19\u4f34: 3, \u91d1\u8776\u4f19\u4f34: 4, ISV\u4f19\u4f34: 5, \u5176\u4ed6\u4f19\u4f34: 6, \u9662\u6821\u4eba\u5458: 7, \u4f01\u4e1a\u4eba\u5458: 8, \u5176\u4ed6\u4eba\u5458: 9") String userType, @ApiParam(value="\u7528\u6237id") @ApiParam(value="\u7528\u6237id") String uid) {
        try {
            QaUserTrackUtil.recordUserAction((String)"qaEmbedding", (Integer)clientType, (String)uid, (String)userType);
            QFilter qFilter = new QFilter("number", "=", (Object)corpusNumber);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"corpus_libs");
            Map mapCorpus = BusinessDataReader.loadFromCache((DynamicObjectType)type, (QFilter[])new QFilter[]{qFilter});
            Optional first = mapCorpus.values().stream().findFirst();
            if (!first.isPresent()) {
                return CustomApiResult.fail((String)"101", (String)("corpus_libs number not exists. " + corpusNumber));
            }
            MilvusDao milvusDao = MilvusDao.createByKM((String)((DynamicObject)first.get()).getString("indexmethod"));
            List result = milvusDao.search(Collections.singletonList(((DynamicObject)first.get()).getLong("id")), question);
            ArrayList chunkList = new ArrayList(16);
            for (Chunk chunk : result) {
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("doc_id", String.valueOf(chunk.getId()));
                map.put("content", String.valueOf(chunk.getChunk()));
                map.put("scores", String.valueOf(chunk.getScores()));
                chunkList.add(map);
            }
            return CustomApiResult.success(chunkList);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"109", (String)ex.getMessage());
        }
    }

    private static boolean isEnd(LLMAPIMsg response) {
        LLMData data = response.getData();
        if (data != null) {
            return data.isEnd();
        }
        return false;
    }
}

