/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.EntryViewType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.commonfield.DropdownItem;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.upload.UploadOption;
import kd.bos.url.UrlService;

public class DropdownMenuEditPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
RowClickEventListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIMAGE_KEY = "fimagekey";
    private static final String FOPERATION_KEY = "foperationkey";
    private static final String LIST_BOXAP = "listboxap";
    private static final String TITLE = "ftitle";
    private static final String VALUE = "value";
    private static final String UPLOAD_CONFIG = "uploadconfig";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CONTEXT = "context";
    public static final String PARAM_PROPERTY_NAME = "propertyName";
    private static final String ITEM_ID = "itemId";
    private static final String FILTER = "filter";
    private static final String SORT = "sort";
    private static final String KEY_LOCK = "flock";
    String entryKey = "entryentity";
    private static final String LASTOPS = "lastops";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", FIMAGE_KEY, "uploadConfig"});
        TextEdit opSelect = (TextEdit)this.getControl(FOPERATION_KEY);
        opSelect.addButtonClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Listbox listbox = (Listbox)this.getView().getControl(LIST_BOXAP);
        listbox.addListboxClickListener((ListboxClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addPackageDataListener(this::handlePackageDataEvent);
    }

    public void afterBindData(EventObject e) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(ENTRY_ENTITY, "setColEditorProp", new Object[]{KEY_LOCK, "isDynamicOption", true});
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setColumnProperty(KEY_LOCK, SORT, (Object)false);
        grid.setColumnProperty(KEY_LOCK, FILTER, (Object)false);
    }

    private void handlePackageDataEvent(PackageDataEvent packageDataEvent) {
        Object ctl = packageDataEvent.getSource();
        int rowIndex = packageDataEvent.getRowIndex();
        if (ctl instanceof Control && KEY_LOCK.equals(((Control)ctl).getKey())) {
            String cache = this.getPageCache().get("oriDropdownItems_cache");
            HashMap<String, Object> map = StringUtils.isNotBlank((CharSequence)cache) ? (Map)SerializationUtils.fromJsonString((String)cache, Map.class) : new HashMap(16);
            packageDataEvent.setComboList(this.getComboItemsForMultiCombo(rowIndex, map));
        }
    }

    private List<Object> getComboItemsForMultiCombo(int rowIndex, Map<String, Object> map) {
        String locks;
        String id = (String)this.getModel().getValue("fid", rowIndex);
        boolean newDisable = false;
        boolean editDisable = false;
        boolean viewDisable = false;
        boolean submitDisable = false;
        boolean auditDisable = false;
        if (map.containsKey(id) && StringUtils.isNotBlank((CharSequence)(locks = (String)map.get(id)))) {
            if (locks.contains("new")) {
                newDisable = true;
            }
            if (locks.contains("edit")) {
                editDisable = true;
            }
            if (locks.contains("view")) {
                viewDisable = true;
            }
            if (locks.contains("submit")) {
                submitDisable = true;
            }
            if (locks.contains("audit")) {
                auditDisable = true;
            }
        }
        return Arrays.asList(this.createComboItem(ResManager.loadKDString((String)"\u65b0\u589e\u9501\u5b9a", (String)"DropdownMenuEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "new", newDisable), this.createComboItem(ResManager.loadKDString((String)"\u4fee\u6539\u9501\u5b9a", (String)"DropdownMenuEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "edit", editDisable), this.createComboItem(ResManager.loadKDString((String)"\u67e5\u770b\u9501\u5b9a", (String)"DropdownMenuEditPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "view", viewDisable), this.createComboItem(ResManager.loadKDString((String)"\u63d0\u4ea4\u9501\u5b9a", (String)"DropdownMenuEditPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "submit", submitDisable), this.createComboItem(ResManager.loadKDString((String)"\u5ba1\u6838\u9501\u5b9a", (String)"DropdownMenuEditPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "audit", auditDisable));
    }

    private ComboItem createComboItem(String localeString, String value, boolean disable) {
        ComboItem item = new ComboItem(new LocaleString(localeString), value);
        item.setDisable(disable);
        return item;
    }

    public void entryRowClick(RowClickEvent evt) {
        String id = (String)this.getModel().getValue("fid", evt.getRow());
        String cache = this.getPageCache().get("oriDropdownItems_cache");
        Map idSet = StringUtils.isNotBlank((CharSequence)cache) ? (Map)SerializationUtils.fromJsonString((String)cache, Map.class) : new HashMap(16);
        String isLock = "false";
        if (idSet.containsKey(id)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btndel"});
            isLock = "true";
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btndel"});
        }
        this.getPageCache().put("currentRowIsLock", isLock);
    }

    private void setEntryFieldSX(String entryKey, String fldKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", new Object[]{fldKey, "sx", false});
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)(value instanceof List ? value : new ArrayList());
        this.getView().getPageCache().put(LASTOPS, this.getView().getParentView().getPageCache().get(LASTOPS));
        if (items != null && items.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow(this.entryKey, items.size());
            int i = 0;
            String rootUrl = UrlService.getDomainContextUrl();
            for (Map item : items) {
                model.setValue("fid", item.get("Id"), rowIndexs[i]);
                model.setValue("fkey", item.get("Key"), rowIndexs[i]);
                model.setValue(FOPERATION_KEY, item.get("OperationKey"), rowIndexs[i]);
                model.setValue(TITLE, item.get("Title"), rowIndexs[i]);
                model.setValue("fsubtitle", item.get("SubTitle"), rowIndexs[i]);
                model.setValue("fbackground", item.get("Background"), rowIndexs[i]);
                model.setValue("fisswitch", item.get("IsSwitch"), rowIndexs[i]);
                model.setValue("fistheme", item.get("IsTheme"), rowIndexs[i]);
                model.setValue("fismerge", item.get("IsMerge"), rowIndexs[i]);
                model.setValue(KEY_LOCK, item.get("Lock"), rowIndexs[i]);
                model.setValue("fvisible", item.get("Visible"), rowIndexs[i]);
                if (StringUtils.isNotBlank(item.get("ImageKey"))) {
                    model.setValue(FIMAGE_KEY, (Object)(rootUrl + item.get("ImageKey")), rowIndexs[i]);
                }
                model.setValue("uploadable", item.get("Uploadable"), rowIndexs[i]);
                model.setValue(UPLOAD_CONFIG, item.get("UploadConfig"), rowIndexs[i]);
                ++i;
            }
        }
        this.initLockRows(items);
        Listbox listbox = (Listbox)this.getControl(LIST_BOXAP);
        ArrayList<ListboxItem> listboxItems = new ArrayList<ListboxItem>();
        listboxItems.add(new ListboxItem("table", ResManager.loadKDString((String)"\u8868\u683c\u89c6\u56fe", (String)"DropdownMenuEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        listboxItems.add(new ListboxItem("tile", ResManager.loadKDString((String)"\u5e73\u94fa\u89c6\u56fe", (String)"DropdownMenuEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        listbox.addItems(listboxItems);
    }

    private void initLockRows(List<Map<String, Object>> items) {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        Map<String, Object> map = this.initBaseProps();
        if (!map.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LIST_BOXAP});
            this.setEntryFieldSX(ENTRY_ENTITY, FOPERATION_KEY);
            this.setEntryFieldSX(ENTRY_ENTITY, UPLOAD_CONFIG);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.entryKey);
            int j = 0;
            for (DynamicObject en : entryEntity) {
                if (map.containsKey(en.getString("fid"))) {
                    this.getView().setEnable(Boolean.FALSE, j, new String[]{"fkey", "uploadable"});
                }
                ++j;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> initBaseProps() {
        String mainEntityId;
        Object listCustData;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam(ITEM_ID);
        if (context.get(0) instanceof List) {
            listCustData = (List)context.get(0);
            mainEntityId = (String)((Map)listCustData.get(0)).get("Id");
        } else {
            if (!(context.get(0) instanceof Map)) return Collections.emptyMap();
            listCustData = (Map)context.get(0);
            mainEntityId = (String)listCustData.get("Id");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (StringUtils.isNotBlank((CharSequence)mainEntityId)) {
            ExtLockTypeEnum lockType;
            List isvList;
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)mainEntityId, (MetaCategory)MetaCategory.Form);
            ControlAp item = formMetadata.getItem(itemId);
            String controlIsv = "";
            if (item == null) {
                FormMetadata listMeta;
                FormAp rootAp = formMetadata.getRootAp();
                if (rootAp instanceof BillFormAp && (listMeta = ((BillFormAp)rootAp).getListMeta()) != null) {
                    List items = listMeta.getItems();
                    Optional<ControlAp> first = items.stream().filter(i -> itemId.equals(i.getId())).findFirst();
                    if (!first.isPresent()) return Collections.emptyMap();
                    item = first.get();
                    controlIsv = item.getIsv();
                }
            } else {
                controlIsv = item.getIsv();
            }
            if ((isvList = DesignerUtils.ISV_LIST).contains(controlIsv) && !StringUtils.equals((CharSequence)controlIsv, (CharSequence)formMetadata.getIsv()) && ExtLockTypeEnum.speciallock.equals((Object)(lockType = ExtensibleDao.getExtLockType((AbstractMetadata)formMetadata, (String)"Field", (String)formMetadata.getModelType(), (String)itemId, (String)"DropdownItems"))) && item instanceof BarItemAp) {
                List dropdownItems = ((BarItemAp)item).getDropdownItems();
                for (DropdownItem dropdownItem : dropdownItems) {
                    if (!isvList.contains(dropdownItem.getIsv()) || StringUtils.equals((CharSequence)dropdownItem.getIsv(), (CharSequence)formMetadata.getIsv())) continue;
                    map.put(dropdownItem.getId(), dropdownItem.getLock());
                }
            }
        }
        this.getPageCache().put("oriDropdownItems_cache", SerializationUtils.toJsonString(map));
        return map;
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("deleteentry".equals(e.getOperateKey())) {
            String cache = this.getPageCache().get("oriDropdownItems_cache");
            Map mapping = StringUtils.isNotBlank((CharSequence)cache) ? (Map)SerializationUtils.fromJsonString((String)cache, Map.class) : new HashMap(16);
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length > 0) {
                int currentRow = selectRows[0];
                String id = (String)this.getModel().getValue("fid", currentRow);
                if (mapping.containsKey(id)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"btndel"});
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "foperationkey": {
                this.showOperationSelector(evt);
                break;
            }
            case "fimagekey": {
                this.showImageSelector(evt);
                break;
            }
            case "uploadconfig": {
                this.showUploadConfigForm();
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void showImageSelector(EventObject evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectImage"));
        this.getView().showForm(parameter);
    }

    private void showOperationSelector(EventObject evt) {
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_operationselect");
        parameter.setCustomParam(CONTEXT, (Object)context);
        parameter.setCustomParam(PARAM_PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParam(PARAM_PROPERTY_NAME));
        parameter.setCustomParam("formContext", this.getView().getFormShowParameter().getCustomParam("formContext"));
        parameter.setCustomParam("isList", this.getView().getFormShowParameter().getCustomParam("isList"));
        parameter.setCustomParam(VALUE, this.getModel().getValue(FOPERATION_KEY));
        parameter.setCustomParam("designerPageId", this.getView().getFormShowParameter().getCustomParam("designerPageId"));
        parameter.setCustomParam("formId", (Object)this.getView().getFormShowParameter().getParentFormId());
        parameter.setCustomParam("metaType", this.getView().getFormShowParameter().getCustomParam("metaType"));
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        parameter.setCustomParam("designerEntityId", this.getView().getFormShowParameter().getCustomParam("designerEntityId"));
        parameter.setCustomParam("lastEntityVersion", this.getView().getFormShowParameter().getCustomParam("lastEntityVersion"));
        parameter.setCustomParam("isLock", (Object)this.getPageCache().get("currentRowIsLock"));
        parameter.setCustomParam("bizext", this.getView().getParentView().getFormShowParameter().getCustomParam("bizext"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOperation"));
        this.getView().showForm(parameter);
    }

    private void showUploadConfigForm() {
        IDataModel model = this.getModel();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_uploadconfig");
        String uploadconfigstr = (String)model.getValue(UPLOAD_CONFIG, model.getEntryCurrentRowIndex(ENTRY_ENTITY));
        parameter.setCustomParam(VALUE, (Object)JSON.parseObject((String)(StringUtils.isNotBlank((CharSequence)uploadconfigstr) ? uploadconfigstr : null)));
        parameter.setCustomParam("isLock", (Object)this.getPageCache().get("currentRowIsLock"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, UPLOAD_CONFIG));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        IDataModel model = this.getModel();
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
        int rowKey = grid.getEntryState().getFocusRow();
        if ("selectOperation".equalsIgnoreCase(actionId)) {
            Object retData = evt.getReturnData();
            if (retData instanceof Map) {
                model.setValue(FOPERATION_KEY, (Object)((String)((Map)retData).get(VALUE)), rowKey);
                model.setValue(TITLE, (Object)((String)((Map)retData).get("opName")), rowKey);
            } else {
                model.setValue(FOPERATION_KEY, ((Map)((List)retData).get(0)).get(VALUE), rowKey);
                model.setValue(TITLE, ((Map)((List)retData).get(0)).get("opName"), rowKey);
            }
            this.getView().getPageCache().put(LASTOPS, this.getView().getPageCache().get(VALUE));
        } else if ("selectImage".equalsIgnoreCase(actionId)) {
            Map imgData = (Map)evt.getReturnData();
            String rootUrl = UrlService.getDomainContextUrl();
            model.setValue(FIMAGE_KEY, (Object)(rootUrl + imgData.get(VALUE)), rowKey);
        } else if (UPLOAD_CONFIG.equalsIgnoreCase(actionId)) {
            model.setValue(UPLOAD_CONFIG, (Object)JSON.toJSONString(((Map)evt.getReturnData()).get(VALUE)), model.getEntryCurrentRowIndex(ENTRY_ENTITY));
        }
    }

    private void returnData() {
        String rootUrl;
        HashSet<String> allItems = new HashSet<String>(16);
        this.getView().getParentView().getPageCache().put(LASTOPS, this.getView().getPageCache().get(VALUE));
        String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID);
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (context.size() >= 2 && context.get(1) instanceof List) {
            List formItems = (List)context.get(1);
            formItems.forEach(formItem -> {
                List dropdownItems = (List)formItem.get("DropdownItems");
                if (dropdownItems != null && !dropdownItems.isEmpty() && !itemId.equals(formItem.get("Id"))) {
                    dropdownItems.forEach(item -> {
                        if (item.containsKey("Key")) {
                            allItems.add((String)item.get("Key"));
                        }
                    });
                }
            });
        }
        if ((rootUrl = UrlService.getDomainContextUrl()).endsWith("/")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        ArrayList<DropdownItem> currItems = new ArrayList<DropdownItem>(10);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(this.entryKey);
        for (int i = 0; i < rowCount; ++i) {
            DropdownItem item = new DropdownItem((String)model.getValue("fkey", i), (String)model.getValue(TITLE, i), (String)model.getValue("fsubtitle", i), (String)model.getValue(FOPERATION_KEY, i), (String)model.getValue("fbackground", i), (String)model.getValue(KEY_LOCK, i), (String)model.getValue("fvisible", i));
            String id = (String)model.getValue("fid", i);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                item.setId(id);
            }
            String imageKey = (String)model.getValue(FIMAGE_KEY, i);
            imageKey = StringUtils.substringAfter((String)imageKey, (String)rootUrl);
            if (StringUtils.isBlank((CharSequence)item.getVisible())) {
                item.setVisible("");
            }
            item.setIsSwitch(((Boolean)model.getValue("fisswitch", i)).booleanValue());
            item.setIsMerge(((Boolean)model.getValue("fismerge", i)).booleanValue());
            item.setIsTheme(((Boolean)model.getValue("fistheme", i)).booleanValue());
            item.setImageKey(imageKey);
            item.setUploadable(((Boolean)model.getValue("uploadable", i)).booleanValue());
            item.setIndex(i + 1);
            Object uploadconfigstr = model.getValue(UPLOAD_CONFIG, i);
            item.setUploadConfig(this.getUploadConfig(JSON.parseObject((String)(StringUtils.isNotBlank((Object)uploadconfigstr) ? uploadconfigstr.toString() : null))));
            if (allItems.contains(item.getKey())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u6807\u8bc6\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"DropdownMenuEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (item.isUploadable() && StringUtils.isNotEmpty((CharSequence)item.getOperationKey())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u201c\u4e0a\u4f20\u6587\u4ef6\u6309\u94ae\u201d\u5f00\u542f\u65f6\uff0c\u201c\u64cd\u4f5c\u4ee3\u7801\u201d\u65e0\u9700\u586b\u5199\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"DropdownMenuEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            allItems.add(item.getKey());
            currItems.add(item);
        }
        DropdownMenuJsonSerializer dropdownJson = new DropdownMenuJsonSerializer();
        dropdownJson.setItems(currItems);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(DropdownMenuJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapCombo = serializer.serializeToMap((Object)dropdownJson, null);
        HashMap para = new HashMap();
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put(PARAM_PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PARAM_PROPERTY_NAME));
        para.put(VALUE, mapCombo.containsKey("Items") ? mapCombo.get("Items") : currItems);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private UploadOption getUploadConfig(JSONObject jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        UploadOption conf = new UploadOption();
        conf.setMultiple(jsonObj.getBooleanValue("Multiple"));
        conf.setSuffix(jsonObj.getString("Suffix"));
        conf.setLimitCount(jsonObj.getIntValue("LimitCount"));
        conf.setLimitSize((long)jsonObj.getIntValue("LimitSize"));
        conf.setUrl(jsonObj.getString("Url"));
        return conf;
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        AbstractGrid grid;
        AbstractGrid.GridState state;
        EntryViewType viewType;
        String itemId;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        if (entryGrid.getSelectRows().length == 0 && this.getModel().getEntryRowCount(ENTRY_ENTITY) > 0) {
            entryGrid.selectRows(0, true);
        }
        if ("table".equals(itemId = listboxEvent.getItemId())) {
            AbstractGrid grid2 = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
            AbstractGrid.GridState state2 = grid2.getEntryState();
            EntryViewType viewType2 = state2.getEntryViewType();
            if (EntryViewType.TiledView.equals((Object)viewType2)) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.invokeControlMethod(this.entryKey, "switchGridView", new Object[]{EntryViewType.GridView.getValue()});
                state2.setEntryViewType(EntryViewType.GridView);
            }
        } else if ("tile".equals(itemId) && EntryViewType.GridView.equals((Object)(viewType = (state = (grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY)).getEntryState()).getEntryViewType()))) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod(this.entryKey, "switchGridView", new Object[]{EntryViewType.TiledView.getValue()});
            state.setEntryViewType(EntryViewType.TiledView);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "foperationkey": {
                this.showOperationSelector((EventObject)evt);
                break;
            }
            case "fimagekey": {
                this.showImageSelector((EventObject)evt);
                break;
            }
            case "btnadd": {
                break;
            }
        }
    }

    private void switchToTiledView() {
        Listbox listbox = (Listbox)this.getControl(LIST_BOXAP);
        listbox.activeItem("tile");
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        AbstractGrid.GridState state = grid.getEntryState();
        EntryViewType viewType = state.getEntryViewType();
        if (EntryViewType.GridView.equals((Object)viewType)) {
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.invokeControlMethod(this.entryKey, "switchGridView", new Object[]{EntryViewType.TiledView.getValue()});
            state.setEntryViewType(EntryViewType.TiledView);
        }
    }

    public static class DropdownMenuJsonSerializer {
        private List<DropdownItem> items = new ArrayList<DropdownItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=DropdownItem.class)
        public List<DropdownItem> getItems() {
            return this.items;
        }

        public void setItems(List<DropdownItem> items) {
            this.items = items;
        }
    }
}

