/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.designer.property.alias.NetCtrlOperationConverter;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class MultiOperationSelectPlugin
extends AbstractFormPlugin
implements EntryGridColAllCheckedListener,
RowClickEventListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final String OPERATION_KEY = "OperationKey";
    private static final String FCODE = "fcode";
    private static final String IS_EXT = "2";
    private static final String IS_CHECK = "ischeck";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addColAllCheckedListener((EntryGridColAllCheckedListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void lockExtensibleEntryRow() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String devType = entityMetadata.getDevType();
        if (IS_EXT.equals(devType)) {
            List operationList = entityMetadata.getRootEntity().getOperations();
            HashMap<String, String> opIsv = new HashMap<String, String>(operationList.size());
            for (Operation op : operationList) {
                opIsv.put(op.getId(), op.getIsv());
            }
            List isvList = DesignerUtils.ISV_LIST;
            HashSet<Integer> lockRows = new HashSet<Integer>(10);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_KEY);
            for (DynamicObject dynamicObject : entryEntity) {
                ExtLockTypeEnum extLockType;
                String opId = dynamicObject.getString("fid");
                if (!isvList.contains(opIsv.get(opId)) || StringUtils.equals((CharSequence)entityMetadata.getIsv(), (CharSequence)((CharSequence)opIsv.get(opId))) || !"lock".equals((extLockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Operation", (String)entityMetadata.getModelType(), (String)opId, (String)"network")).toString()) && (!"speciallock".equals(extLockType.toString()) || !dynamicObject.getBoolean(IS_CHECK))) continue;
                Object obj = dynamicObject.get("seq");
                Integer row = obj instanceof Integer ? (Integer)obj - 1 : Integer.parseInt((String)obj) - 1;
                lockRows.add(row);
            }
            if (!lockRows.isEmpty()) {
                this.getPageCache().put("lock_cache", SerializationUtils.toJsonString(lockRows));
                for (Integer row : lockRows) {
                    this.getView().setEnable(Boolean.FALSE, row.intValue(), new String[]{IS_CHECK});
                }
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
            entryGrid.setColumnProperty(IS_CHECK, "isFixed", (Object)Boolean.TRUE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List ctx = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (ctx.isEmpty()) {
            return;
        }
        List operations = (List)((Map)ctx.get(0)).get("Operations");
        IDataModel model = this.getModel();
        int[] rows = model.batchCreateNewEntryRow(ENTRY_KEY, operations.size());
        HashSet operationSet = new HashSet();
        Object values = this.getView().getFormShowParameter().getCustomParam("value");
        if (values instanceof List) {
            List oprationChecks = (List)values;
            oprationChecks.forEach(op -> operationSet.add((String)op.get("Id")));
        }
        int i = 0;
        for (Map op2 : operations) {
            model.setValue("fid", op2.get("Id"), rows[i]);
            model.setValue(FCODE, op2.get("Key"), rows[i]);
            model.setValue("fname", op2.get("Name"), rows[i]);
            model.setValue("ftype", op2.get("OperationType"), rows[i]);
            boolean isCheck = operationSet.contains(op2.get("Id"));
            model.setValue(IS_CHECK, (Object)isCheck, rows[i]);
            ++i;
        }
        this.markColumnSelectAllStatus(IS_CHECK);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        grid.setColumnProperty(IS_CHECK, "filter", (Object)false);
        grid.setColumnProperty(IS_CHECK, "sort", (Object)false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockExtensibleEntryRow();
    }

    public void click(EventObject evt) {
        if ("btnok".equals(((Control)evt.getSource()).getKey())) {
            HashMap<String, Object> para = new HashMap<String, Object>(16);
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            ArrayList operations = new ArrayList(10);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_KEY);
            HashSet<Integer> checkRows = new HashSet<Integer>(16);
            for (DynamicObject dynamicObject : entryEntity) {
                Integer row = (Integer)dynamicObject.get("seq") - 1;
                boolean isCheck = dynamicObject.getBoolean(IS_CHECK);
                if (!isCheck) continue;
                checkRows.add(row);
            }
            IDataModel model = this.getModel();
            for (Integer row : checkRows) {
                HashMap<String, Object> op = new HashMap<String, Object>();
                String id = (String)model.getValue("fid", row.intValue());
                op.put("Id", StringUtils.isBlank((CharSequence)id) ? Uuid16.create().toString() : id);
                op.put("_Type_", "NetCtrlOperation");
                op.put("GroupId", "default_netctrl");
                op.put(OPERATION_KEY, model.getValue(FCODE, row.intValue()));
                op.put("Key", op.get(OPERATION_KEY));
                operations.add(op);
            }
            para.put("value", operations);
            para.put("alias", new NetCtrlOperationConverter().convert(operations));
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String columnName = e.getProperty().getName();
        this.markColumnSelectAllStatus(columnName);
    }

    private void markColumnSelectAllStatus(String columnName) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTRY_KEY);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().findProperty(ENTRY_KEY);
        ConcurrentHashMap<String, String> allCheckedCol = new ConcurrentHashMap<String, String>();
        for (IDataEntityProperty prop : entryProp.getDynamicCollectionItemPropertyType().getProperties()) {
            if (!(prop instanceof BooleanProp)) continue;
            allCheckedCol.put(prop.getName(), prop.getName());
        }
        for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
            if (columnName != null) {
                if (!columnName.equals(ctlKey.getKey())) continue;
                this.setGridColAllValue(columnName, false);
                continue;
            }
            this.setGridColAllValue((String)ctlKey.getKey(), false);
        }
        for (DynamicObject dym : cols) {
            allCheckedCol.forEach((k, v) -> {
                if (!dym.getBoolean(k.toLowerCase())) {
                    allCheckedCol.remove(k);
                }
            });
        }
        if (cols.size() > 0) {
            for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
                this.setGridColAllValue((String)ctlKey.getKey(), true);
            }
        }
    }

    private void setGridColAllValue(String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(ENTRY_KEY, "setGridColAllValue", new Object[]{ret});
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        boolean oldValue;
        int i;
        e.setCancel(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        int startIndex = 0;
        int endIndex = entryGrid.getModel().getEntryRowCount(ENTRY_KEY);
        String lock_cache = this.getPageCache().get("lock_cache");
        List rows = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)lock_cache)) {
            rows = (List)SerializationUtils.fromJsonString((String)lock_cache, List.class);
        }
        HashSet<Integer> updateRows = new HashSet<Integer>(10);
        this.getModel().beginInit();
        if (rows != null && !rows.isEmpty()) {
            for (i = startIndex; i < endIndex; ++i) {
                if (rows.contains(i) || (oldValue = ((Boolean)this.getModel().getValue(e.getColKey(), i)).booleanValue()) == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                updateRows.add(i);
            }
        } else {
            for (i = startIndex; i < endIndex; ++i) {
                oldValue = (Boolean)this.getModel().getValue(e.getColKey(), i);
                if (oldValue == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                updateRows.add(i);
            }
        }
        this.getModel().endInit();
        for (Integer row : updateRows) {
            this.getView().updateView(IS_CHECK, row.intValue());
        }
        this.setGridColAllValue(e.getColKey(), e.isChecked());
    }

    public void entryRowClick(RowClickEvent evt) {
        int row;
        String lock_cache = this.getPageCache().get("lock_cache");
        List lockList = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)lock_cache)) {
            lockList = (List)SerializationUtils.fromJsonString((String)lock_cache, List.class);
        }
        if (lockList.contains(row = evt.getRow()) || row < 0) {
            return;
        }
        boolean isCheck = (Boolean)this.getModel().getValue(IS_CHECK, row);
        if (isCheck) {
            this.getModel().setValue(IS_CHECK, (Object)false, row);
        } else {
            this.getModel().setValue(IS_CHECK, (Object)true, row);
        }
    }
}

