/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class OperationListEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_DOWN = "btndown";
    private static final String BTN_UP = "btnup";
    private static final String VALUE = "value";
    private static final String FTYPE = "ftype";
    private static final String OPERATION_TYPE = "OperationType";
    private static final String FCODE = "fcode";
    private static final String FNAME = "fname";
    private static final String META_TYPE = "metaType";
    private static final String ROW_KEY = "RowKey";
    private static final String IS_EXT = "2";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_NEW, BTN_EDIT, BTN_DEL, "btnok", BTN_DOWN, BTN_UP});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_KEY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List ops = (List)(value instanceof List ? value : new ArrayList());
        if (ops.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowKeys = model.batchCreateNewEntryRow(ENTRY_KEY, ops.size());
            int i = 0;
            for (Map op : ops) {
                model.setValue("fid", op.get("Id"), rowKeys[i]);
                model.setValue(FTYPE, op.get(OPERATION_TYPE), rowKeys[i]);
                model.setValue(FCODE, op.get("Key"), rowKeys[i]);
                model.setValue(FNAME, op.get("Name"), rowKeys[i++]);
            }
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)ops));
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnnew": {
                this.addOperation();
                break;
            }
            case "btnedit": {
                this.editOperation();
                break;
            }
            case "btndel": {
                this.deleteOperation();
                break;
            }
            case "btndown": {
                this.move(-1);
                break;
            }
            case "btnup": {
                this.move(1);
                break;
            }
            case "btnok": {
                this.close();
                break;
            }
        }
    }

    private void move(int step) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey > 0 && step > 0) {
            this.getModel().moveEntryRowUp(ENTRY_KEY, rowKey);
        } else if (rowKey < this.getModel().getEntryRowCount(ENTRY_KEY) - 1 && step < 0) {
            this.getModel().moveEntryRowDown(ENTRY_KEY, rowKey);
        }
    }

    private void close() {
        IFormView formView;
        FormDesigner designer;
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        List<Map<String, Object>> ops = this.getOps();
        para.put(VALUE, ops);
        para.put("alias", this.getOperationAlias(ops));
        this.getView().returnDataToParent(para);
        this.getView().close();
        if ("subformdesigner".equals(this.getView().getFormShowParameter().getCloseCallBack().getControlKey()) && (designer = (FormDesigner)(formView = this.getView().getView((String)this.getView().getFormShowParameter().getCustomParam("designerPageId"))).getControl("formdesigner")) != null) {
            designer.setProperty(para);
            this.getView().sendFormAction(formView);
        }
    }

    private String getOperationAlias(List<Map<String, Object>> ops) {
        StringBuilder alias = new StringBuilder();
        if (ops != null && !ops.isEmpty()) {
            for (Map<String, Object> op : ops) {
                alias.append(alias.length() == 0 ? alias.toString() : ",").append(op.get("Name"));
            }
        }
        return alias.toString();
    }

    private void addOperation() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_operationedit");
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        parameter.setCustomParam("MetaContext", (Object)context);
        parameter.setCustomParam("formId", (Object)this.getView().getFormShowParameter().getParentFormId());
        parameter.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        parameter.setCustomParam("Ops", this.getOps());
        parameter.setCustomParam("buttonOpType", (Object)"isNewOp");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "new"));
        this.getView().showForm(parameter);
    }

    private void editOperation() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey >= 0) {
            String opKey = (String)this.getModel().getValue(FCODE, rowKey);
            if (opKey == null) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ide_operationedit");
            Map<String, Object> currentOp = this.getCurrentOp(opKey);
            currentOp.put(ROW_KEY, rowKey);
            parameter.setCustomParam("op", currentOp);
            parameter.setCustomParam("Ops", this.getOps());
            parameter.setCustomParam("formId", (Object)this.getView().getFormShowParameter().getParentFormId());
            List context = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
            parameter.setCustomParam("MetaContext", (Object)context);
            parameter.setCustomParam(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            parameter.setCustomParam("buttonOpType", (Object)"isEditOp");
            parameter.setCustomParam("opId", currentOp.get("Id"));
            parameter.setCustomParam("entityId", this.getView().getFormShowParameter().getCustomParam("itemId"));
            parameter.setCustomParam("modelType", this.getView().getFormShowParameter().getCustomParam("modelType"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit"));
            this.getView().showForm(parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OperationListEditPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> getCurrentOp(String key) {
        List<Map<String, Object>> ops = this.getOps();
        for (Map<String, Object> op : ops) {
            if (!key.equalsIgnoreCase((String)op.get("Key"))) continue;
            return op;
        }
        return new HashMap<String, Object>();
    }

    private List<Map<String, Object>> getOps() {
        List ops = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(VALUE), Map.class);
        return ops;
    }

    private void appendOp(Map<String, Object> op) {
        List<Map<String, Object>> ops = this.getOps();
        ops.add(op);
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString(ops));
    }

    private int editOp(Map<String, Object> opEdit) {
        List<Map<String, Object>> ops = this.getOps();
        int i = 0;
        int index = -1;
        for (Map<String, Object> op : ops) {
            if (opEdit.get("Id").equals(op.get("Id"))) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            ops.set(index, opEdit);
            this.getPageCache().put(VALUE, SerializationUtils.toJsonString(ops));
        }
        return index;
    }

    private void deleteOperation() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            String opKey = (String)this.getModel().getValue(FCODE, rowIndex);
            List<Map<String, Object>> ops = this.getOps();
            for (int i = 0; i < ops.size(); ++i) {
                Map<String, Object> item = ops.get(i);
                if (!opKey.equalsIgnoreCase((String)item.get("Key"))) continue;
                ops.remove(i);
                RowClickEvent evt = new RowClickEvent((Object)this, rowIndex - 1);
                this.entryRowClick(evt);
                this.getPageCache().put(VALUE, SerializationUtils.toJsonString(ops));
                this.getModel().deleteEntryRow(ENTRY_KEY, rowIndex);
                break;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"OperationListEditPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        Map op = (Map)e.getReturnData();
        if (e.getActionId().equals("new")) {
            String opType = (String)op.get(OPERATION_TYPE);
            List<Map<String, Object>> ops = this.getOps();
            if (ops != null) {
                for (Map<String, Object> operation : ops) {
                    if (!opType.equals(operation.get(OPERATION_TYPE))) continue;
                    String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
                    EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
                    ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Operation", (String)entityMetadata.getModelType(), (String)((String)operation.get("Id")), (String)"repetition");
                    if ("defaults".equals(lockType.toString())) {
                        lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Operation", (String)entityMetadata.getModelType(), (String)opType, (String)"repetition");
                    }
                    if (!"lock".equals(lockType.toString())) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u64cd\u4f5c\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u65b0\u589e\u3002", (String)"OperationListEditPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]), opType));
                    return;
                }
            }
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
            this.getModel().setValue(FTYPE, (Object)opType, rowIndex);
            this.getModel().setValue(FCODE, op.get("Key"), rowIndex);
            this.getModel().setValue(FNAME, op.get("Name"), rowIndex);
            this.appendOp(op);
        } else if (e.getActionId().equals("edit")) {
            int rowKey = (Integer)op.get(ROW_KEY);
            this.getModel().setValue(FTYPE, op.get(OPERATION_TYPE), rowKey);
            this.getModel().setValue(FCODE, op.get("Key"), rowKey);
            this.getModel().setValue(FNAME, op.get("Name"), rowKey);
            op.remove(ROW_KEY);
            this.editOp(op);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnnew": {
                this.addOperation();
                break;
            }
            case "btnedit": {
                this.editOperation();
                break;
            }
            case "btndel": {
                this.deleteOperation();
                break;
            }
            case "btndown": {
                this.move(-1);
                break;
            }
            case "btnup": {
                this.move(1);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        List isvList;
        int row = evt.getRow();
        if (row < 0) {
            return;
        }
        String opId = (String)this.getModel().getValue("fid", row);
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        String isv = metadata.getIsv();
        String pkId = metadata.getRootEntity().getPkId();
        String lockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)modelType, (String)pkId, (String)"Operations").toString();
        List<Map<String, Object>> ops = this.getOps();
        if (CollectionUtils.isEmpty(ops)) {
            return;
        }
        String opIsv = "";
        for (Map<String, Object> op : ops) {
            if (!StringUtils.isNotBlank((CharSequence)opId) || !opId.equals(op.get("Id"))) continue;
            opIsv = String.valueOf(op.get("IsvFlag"));
            break;
        }
        if ((isvList = DesignerUtils.ISV_LIST).contains(opIsv) && !StringUtils.equals((CharSequence)isv, (CharSequence)opIsv)) {
            if ("lock".equals(lockType) || "speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{BTN_DEL});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_DEL});
        }
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        RowClickEvent evt = new RowClickEvent((Object)this, arg0.getRow());
        this.entryRowClick(evt);
        this.editOperation();
    }
}

