/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.ParentBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.filter.CustomBaseDataFilterColumnAp;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.util.CollectionUtils;

public class RefPropsEdit
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final String F_TARGET_PROPS = "ftargetprops";
    private static final String FIELD_TREE = "FieldTree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String CURRENT_ADD_NODES = "addNodes";
    private static final String FTNAME = "ftname";
    private static final String SEARCH_AP = "searchap";
    private static final String FIELDTREE = "fieldtree";
    private static final String VERIFY_REF_QUANTITY = "verifyRefQuantity";
    private static final String REF_MAX_QUANTITY = "refMaxQuantity";
    private static final String CURRENCY = "currency";
    private static final String UNIT = "unit";
    public static final String BASEREFSET = "baserefset";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btnremove"});
        EntryGrid grid = (EntryGrid)this.getControl(F_TARGET_PROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(FIELDTREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search searchEdit = (Search)this.getControl(SEARCH_AP);
        searchEdit.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (item == null || item.isEmpty()) {
            return;
        }
        Object obj = item.get(0);
        List fldlist = obj instanceof List ? (List)item.get(0) : item;
        String modelType = this.getModelType();
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        Object ctrl = template.deserializeFromMap((Map)fldlist.get(0), null);
        String entityId = "";
        if (ctrl instanceof CustomBaseDataFilterColumnAp) {
            entityId = ((CustomBaseDataFilterColumnAp)ctrl).getBaseEntityId();
        } else if (ctrl instanceof MulBasedataField) {
            entityId = ((MulBasedataField)ctrl).getBaseEntityId();
        } else if (ctrl instanceof ParentBasedataField) {
            List listCustData = (List)item.get(1);
            for (Map map : listCustData) {
                String type = (String)map.get("_Type_");
                if (!"BaseEntity".equals(type)) continue;
                entityId = (String)map.get("Id");
                break;
            }
        } else if (ctrl instanceof IBasedataField) {
            entityId = ((IBasedataField)ctrl).getBaseEntityId();
        }
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return;
        }
        EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
        option.setIncludeAllMasterProps(true);
        option.addInvalidClassTypes(BasedataPropField.class);
        TreeNode fullTree = FormTreeBuilder.buildEntityFieldsTree((EntityMetadata)entityMetadata, (EntityFieldTreeBuildOption)option);
        option.setIncludeBDPropPK(true);
        option.setSpecialTreatmentMulBDProp(true);
        option.setTestIncludeFiledNumber(true);
        String number = MetadataDao.getNumberById((String)MetadataDao.getMasterId((String)entityId));
        this.getPageCache().put("entityNumber", number);
        TreeNode root = FormTreeBuilder.buildRefEntityTree((String)number, (PropTreeBuildOption)option);
        ArrayList<TreeNode> childrenId = new ArrayList<TreeNode>(root.getChildren().size());
        for (TreeNode node : root.getChildren()) {
            childrenId.add(node);
        }
        for (TreeNode node : childrenId) {
            node.setParentid(root.getId());
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.addNode(root);
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (value == null || StringUtils.isBlank(value)) {
            value = new ArrayList();
        }
        List refProps = (List)value;
        Set<String> baseRef = this.initBaseRefProps();
        ArrayList<String> checkNodeIds = new ArrayList<String>();
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        for (Object refprop : refProps) {
            String nodeId = (String)refprop.get("Name");
            if (nodeId == null) continue;
            checkNodeIds.add(nodeId);
            TreeNode treeNode = root.getTreeNode(nodeId, 16);
            if (treeNode == null) continue;
            if (baseRef != null && baseRef.contains(nodeId)) {
                treeNode.setDisabled(true);
            }
            checkNodes.add(treeNode);
        }
        tree.checkNodes(checkNodes);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        IDataModel model = this.getModel();
        model.deleteEntryData(F_TARGET_PROPS);
        for (Map refProp : refProps) {
            String name = (String)refProp.get("Name");
            TreeNode node = root.getTreeNode(name, 16);
            if (node == null) {
                node = fullTree.getTreeNode(name, 16);
            }
            if (node == null) continue;
            int rowindex = model.createNewEntryRow(F_TARGET_PROPS);
            model.setValue(FTNAME, (Object)node.getId(), rowindex);
            model.setValue("ftdisplayname", (Object)node.getText(), rowindex);
        }
        int refMaxQuantity = this.getRefMaxQuantity();
        if (refProps.size() > refMaxQuantity) {
            this.getPageCache().put(VERIFY_REF_QUANTITY, "false");
        }
        this.getPageCache().put(REF_MAX_QUANTITY, String.valueOf(refMaxQuantity));
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put("disableBatchCheck", true);
        this.getView().updateControlMetadata(FIELDTREE, prop);
    }

    private Set<String> initBaseRefProps() {
        List isvList;
        Field field;
        Set<String> props = new HashSet<String>(16);
        List item = (List)this.getView().getFormShowParameter().getCustomParam("context");
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        List listCustData = (List)item.get(1);
        String mainEntityId = (String)((Map)listCustData.get(0)).get("Id");
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)mainEntityId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata != null && (field = entityMetadata.getFieldById(itemId)) != null && (isvList = DesignerUtils.ISV_LIST).contains(field.getIsv()) && !StringUtils.equals((CharSequence)field.getIsv(), (CharSequence)entityMetadata.getIsv())) {
            props = ExtensibleDao.getBasePropIds((IPageCache)this.getPageCache(), (MetaCategory)MetaCategory.Entity, (String)mainEntityId, (String)itemId, (String)"RefProps");
        }
        return props;
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (F_TARGET_PROPS.equals(source.getKey())) {
            this.delete();
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnremove".equals(key)) {
            this.delete();
        } else if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        Object nodeId;
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        HashMap<String, String> addNodes = null;
        String addNodeStr = this.getPageCache().get(CURRENT_ADD_NODES);
        if (StringUtils.isNotBlank((CharSequence)addNodeStr)) {
            addNodes = (HashMap<String, String>)SerializationUtils.fromJsonString((String)addNodeStr, Map.class);
        }
        if ((nodeId = evt.getNodeId()) == null || StringUtils.isBlank((CharSequence)nodeId.toString())) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        TreeNode node = root.getTreeNode(nodeId.toString(), 16);
        if (evt.getChecked().booleanValue()) {
            ArrayList<TreeNode> currCheckNodes = new ArrayList<TreeNode>(2);
            if (node == null || node.getChildren() != null) {
                return;
            }
            currCheckNodes.add(node);
            if (this.refQuantityExceedsLimit(currCheckNodes.size() + checkNodes.size(), false)) {
                List treeNode = currCheckNodes.stream().map(TreeNode::getId).collect(Collectors.toList());
                tree.uncheckNodes(treeNode);
                return;
            }
            for (TreeNode checkNode : currCheckNodes) {
                int row = model.createNewEntryRow(F_TARGET_PROPS);
                model.setValue(FTNAME, (Object)checkNode.getId(), row);
                model.setValue("ftdisplayname", (Object)checkNode.getText(), row);
            }
            checkNodes.add(nodeId.toString());
            if (addNodes == null) {
                addNodes = new HashMap<String, String>(10);
            }
            addNodes.put(node.getId(), node.getText());
        } else {
            for (int i = model.getEntryRowCount(F_TARGET_PROPS) - 1; i >= 0; --i) {
                if (!nodeId.toString().equals(model.getValue(FTNAME, i))) continue;
                model.deleteEntryRows(F_TARGET_PROPS, new int[]{i});
            }
            checkNodes.remove(nodeId.toString());
            if (addNodes != null) {
                addNodes.remove(node.getId());
            }
        }
        model.endInit();
        this.getView().updateView(F_TARGET_PROPS);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodes));
        if (addNodes != null) {
            this.getPageCache().put(CURRENT_ADD_NODES, SerializationUtils.toJsonString((Object)addNodes));
        }
    }

    protected void returnData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(F_TARGET_PROPS);
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)this.getView().getPageCache().get("isCancel"))) {
            if (this.refQuantityExceedsLimit(entryEntity.size(), false)) {
                return;
            }
            boolean showConfirm = this.isShowConfirm();
            if (showConfirm) {
                return;
            }
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        ArrayList fieldList = new ArrayList();
        for (DynamicObject field : this.getModel().getEntryEntity(F_TARGET_PROPS)) {
            HashMap<String, Object> fMap = new HashMap<String, Object>();
            fMap.put("_Type_", "RefProp");
            fMap.put("Name", field.get(FTNAME));
            fieldList.add(fMap);
        }
        para.put("RefProps", SerializationUtils.toJsonString(fieldList));
        ArrayList<HashMap<String, Object>> paras = new ArrayList<HashMap<String, Object>>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", fieldList);
        paras.add(para);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(F_TARGET_PROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"RefPropsEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        Set<String> nameSet = this.initBaseRefProps();
        if (!nameSet.isEmpty()) {
            for (int row : rows) {
                String name = (String)this.getModel().getValue(FTNAME, row);
                if (!nameSet.contains(name)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6269\u5c55\u5355\u4ec5\u80fd\u5220\u9664\u672c\u5355\u6dfb\u52a0\u5f15\u7528\u3002", (String)"RefPropsEdit_2", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue(FTNAME, row));
        }
        model.deleteEntryRows(F_TARGET_PROPS, rows);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.uncheckNodes(nodeIds);
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        checkNodes.removeAll(nodeIds);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodes));
        String addNodeStr = this.getPageCache().get(CURRENT_ADD_NODES);
        if (StringUtils.isNotBlank((CharSequence)addNodeStr)) {
            Map addNodes = (Map)SerializationUtils.fromJsonString((String)addNodeStr, Map.class);
            for (String nodeId : nodeIds) {
                addNodes.remove(nodeId);
            }
            this.getPageCache().put(CURRENT_ADD_NODES, SerializationUtils.toJsonString((Object)addNodes));
        }
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        if (StringUtils.isBlank((CharSequence)modelType)) {
            modelType = "DynamicFormModel";
        }
        return modelType;
    }

    public void search(SearchEnterEvent evt) {
        Search source = (Search)evt.getSource();
        if (StringUtils.equals((CharSequence)SEARCH_AP, (CharSequence)source.getKey())) {
            String searchText = evt.getText();
            this.doSearch(searchText);
        }
    }

    private void doSearch(String searchText) {
        String treeNode_cache = this.getPageCache().get(FIELD_TREE);
        if (StringUtils.isBlank((CharSequence)treeNode_cache)) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNode_cache, TreeNode.class);
        TreeView treeView = (TreeView)this.getView().getControl(FIELDTREE);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            List<TreeNode> childrenNode = this.getChildrenNode(searchText, root);
            root.setChildren(childrenNode);
        }
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        List checkNodesId = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        for (String str : checkNodesId) {
            TreeNode treeNode = root.getTreeNode(str, 16);
            if (treeNode == null) continue;
            checkNodes.add(treeNode);
        }
        treeView.updateNode(root);
        treeView.checkNodes(checkNodes);
    }

    private List<TreeNode> getChildrenNode(String searchText, TreeNode parentNode) {
        ArrayList<TreeNode> childrenNodes = new ArrayList<TreeNode>();
        if (parentNode != null && parentNode.getChildren() != null) {
            for (TreeNode childrenNode : parentNode.getChildren()) {
                List<TreeNode> subChildrenNodes = this.getChildrenNode(searchText, childrenNode);
                if (!subChildrenNodes.isEmpty()) {
                    childrenNode.setChildren(subChildrenNodes);
                    childrenNode.setIsOpened(true);
                    childrenNodes.add(childrenNode);
                    continue;
                }
                if (!childrenNode.getText().contains(searchText)) continue;
                childrenNodes.add(childrenNode);
            }
        }
        return childrenNodes;
    }

    private int getRefMaxQuantity() {
        String refMaxQuantity = this.getPageCache().get(REF_MAX_QUANTITY);
        if (StringUtils.isBlank((CharSequence)refMaxQuantity)) {
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BASEDATA_REFERENCING_PROPERTY ", new DistributeCacheHAPolicy(true, true));
            refMaxQuantity = (String)cache.get(CacheKeyUtil.getAcctId() + ".refMaxQuantity");
        }
        if (StringUtils.isNotBlank((CharSequence)refMaxQuantity)) {
            return Integer.parseInt(refMaxQuantity);
        }
        return 50;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) {
            this.getView().getPageCache().put("isCancel", "true");
            this.returnData();
            return;
        }
        String value = messageBoxClosedEvent.getCustomVaule();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        List addNodes = SerializationUtils.fromJsonStringToList((String)value, TreeNode.class);
        this.checkControlNodes(addNodes, false);
        this.getPageCache().remove(CURRENT_ADD_NODES);
    }

    private boolean isShowConfirm() {
        String addNodeStr = this.getPageCache().get(CURRENT_ADD_NODES);
        String entityNumber = this.getPageCache().get("entityNumber");
        if (StringUtils.isBlank((CharSequence)addNodeStr) || StringUtils.isBlank((CharSequence)entityNumber)) {
            return false;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        Map addNodes = (Map)SerializationUtils.fromJsonString((String)addNodeStr, Map.class);
        HashMap<String, TreeNode> needAddNodes = new HashMap<String, TreeNode>(addNodes.size());
        HashSet needAddControlFiled = new HashSet(addNodes.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (Map.Entry node : addNodes.entrySet()) {
            boolean isAdd;
            Tuple<DynamicProperty, String> controlField = this.getControlField((String)node.getKey(), entityType);
            if (controlField == null || !(isAdd = this.addControlNodes(root, checkNodes, needAddNodes, controlField))) continue;
            needAddControlFiled.add(node.getValue());
        }
        if (!CollectionUtils.isEmpty(needAddControlFiled) && !CollectionUtils.isEmpty(needAddNodes)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("addControlProp", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1{%s}\u6b63\u786e\u663e\u793a\u6e90\u5355\u7cbe\u5ea6\uff0c\u5efa\u8bae\u52fe\u9009\u5173\u8054\u5b57\u6bb5\uff0c\u662f\u5426\u786e\u8ba4\u52fe\u9009\uff1f", (String)"RefPropsEdit_3", (String)"bos-designer-plugin", (Object[])new Object[0]), StringUtils.join((Object[])needAddControlFiled.toArray(), (String)"/")), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, SerializationUtils.toJsonString(needAddNodes.values()));
            return true;
        }
        if (!CollectionUtils.isEmpty(needAddNodes)) {
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
            nodes.addAll(needAddNodes.values());
            this.checkControlNodes(nodes, true);
        }
        return false;
    }

    private boolean refQuantityExceedsLimit(int total, boolean isReturn) {
        int refMaxQuantity;
        boolean verifyRefQuantity;
        boolean bl = verifyRefQuantity = !StringUtils.equals((CharSequence)"false", (CharSequence)this.getPageCache().get(VERIFY_REF_QUANTITY));
        if (verifyRefQuantity && total > (refMaxQuantity = this.getRefMaxQuantity())) {
            if (!isReturn) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u7684\u5f15\u7528\u5c5e\u6027\u6570\u91cf\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u51cf\u5c11\u5f15\u7528\u6570\u91cf\u3002", (String)"RefPropsEdit_1", (String)"bos-designer-plugin", (Object[])new Object[0]), refMaxQuantity));
            }
            return true;
        }
        return false;
    }

    private Tuple<DynamicProperty, String> getControlField(String id, MainEntityType entityType) {
        String[] split = id.split("\\.");
        DynamicProperty property = entityType.getProperty(split[0]);
        if (split.length == 1) {
            DynamicProperty controlProperty = this.getControlProp((IDataEntityProperty)property, entityType);
            if (controlProperty != null) {
                return new Tuple((Object)controlProperty, (Object)controlProperty.getName());
            }
        } else if (split.length == 2) {
            BasedataEntityType basedataEntityType;
            DynamicProperty controlProperty;
            IDataEntityType complexType = null;
            if (property instanceof BasedataProp) {
                complexType = ((BasedataProp)property).getComplexType();
                if (complexType != null && property instanceof MasterBasedataProp) {
                    complexType = EntityMetadataCache.getDataEntityType((String)complexType.getName());
                }
            } else if (property instanceof MulBasedataProp) {
                complexType = ((MulBasedataProp)property).getComplexType();
            }
            if (complexType instanceof BasedataEntityType && (controlProperty = this.getControlProp((IDataEntityProperty)(basedataEntityType = (BasedataEntityType)complexType).getProperty(split[1]), (MainEntityType)((BasedataEntityType)complexType))) != null) {
                return new Tuple((Object)controlProperty, (Object)String.format("%s.%s", split[0], controlProperty.getName()));
            }
        }
        return null;
    }

    private DynamicProperty getControlProp(IDataEntityProperty property, MainEntityType entityType) {
        DateTimeProp dateTimeProp;
        DynamicProperty controlProperty = null;
        if (property instanceof DecimalProp) {
            DecimalProp decimalProp = (DecimalProp)property;
            if (StringUtils.isNotBlank((CharSequence)decimalProp.getControlPropName())) {
                controlProperty = entityType.getProperty(decimalProp.getControlPropName());
            }
        } else if (property instanceof DateTimeProp && StringUtils.isNotBlank((CharSequence)(dateTimeProp = (DateTimeProp)property).getRelateOrg())) {
            controlProperty = entityType.getProperty(dateTimeProp.getRelateOrg());
        }
        return controlProperty;
    }

    private boolean addControlNodes(TreeNode root, List<String> checkNodes, Map<String, TreeNode> needAddNodes, Tuple<DynamicProperty, String> controlProp) {
        boolean isNeedAdd;
        block4: {
            block5: {
                block3: {
                    isNeedAdd = false;
                    if (!(controlProp.item1 instanceof CurrencyProp)) break block3;
                    TreeNode treeNode = root.getTreeNode((String)controlProp.item2, 16);
                    for (TreeNode child : treeNode.getChildren()) {
                        if (checkNodes.contains(child.getId()) || needAddNodes.containsKey(child.getId()) || !child.getId().contains("amtprecision") && !child.getId().contains("priceprecision") && !child.getId().contains("sign")) continue;
                        needAddNodes.put(child.getId(), child);
                        isNeedAdd = true;
                    }
                    break block4;
                }
                if (!(controlProp.item1 instanceof UnitProp)) break block5;
                TreeNode treeNode = root.getTreeNode((String)controlProp.item2, 16);
                for (TreeNode child : treeNode.getChildren()) {
                    if (checkNodes.contains(child.getId()) || needAddNodes.containsKey(child.getId()) || !child.getId().contains("precision") && !child.getId().contains("precisionaccount") && !child.getId().contains("conversiontype")) continue;
                    needAddNodes.put(child.getId(), child);
                    isNeedAdd = true;
                }
                break block4;
            }
            if (!(controlProp.item1 instanceof OrgProp)) break block4;
            TreeNode treeNode = root.getTreeNode((String)controlProp.item2, 16);
            for (TreeNode child : treeNode.getChildren()) {
                if (checkNodes.contains(child.getId()) || needAddNodes.containsKey(child.getId()) || !StringUtils.equals((CharSequence)String.format("%s.%s", controlProp.item2, "id"), (CharSequence)child.getId())) continue;
                needAddNodes.put(child.getId(), child);
                isNeedAdd = false;
            }
        }
        return isNeedAdd;
    }

    private void checkControlNodes(List<TreeNode> addNodes, boolean isReturn) {
        if (!CollectionUtils.isEmpty(addNodes)) {
            List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
            if (this.refQuantityExceedsLimit(addNodes.size() + checkNodes.size(), isReturn)) {
                return;
            }
            for (TreeNode checkNode : addNodes) {
                int row = this.getModel().createNewEntryRow(F_TARGET_PROPS);
                this.getModel().setValue(FTNAME, (Object)checkNode.getId(), row);
                this.getModel().setValue("ftdisplayname", (Object)checkNode.getText(), row);
                checkNodes.add(checkNode.getId());
            }
            if (!isReturn) {
                TreeView treeView = (TreeView)this.getView().getControl(FIELDTREE);
                treeView.checkNodes(addNodes);
                this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)checkNodes));
                this.getView().updateView(F_TARGET_PROPS);
            }
        }
    }
}

