/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.devportal.common.kingscript.KingScriptType;
import kd.bos.devportal.common.kingscript.TSShowFormUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.isv.ISVService;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;

public class RegistKSPlugin
extends AbstractListPlugin
implements ClickListener,
HyperLinkClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String BIZ_PAGE_ID = "bizpageid";
    private static final String CLASSNAME = "classname";
    private static final String SCRIPT_TYPE = "scripttype";
    private static final String SCRIPT_NUMBER = "scriptnumber";
    private static final String SCRIPT_NAME = "scriptname";
    private static final String TXT_SCRIPT_NUMBER = "txt_scriptnumber";
    private static final String SCRIPT_ID = "scriptid";
    private static final String DESCRIPTION = "description";
    private static final String SELETED_INDEX = "seletedindex";
    private static final String NUMBER = "number";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BIZ_CLOUD_ID = "bizcloudid";

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"exit", "ok", "kde"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        try (EntityTraceSpan span = EntityTracer.create((String)"RegistKSPlugin", (String)"afterCreateNewData", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            boolean isMulti;
            String bizPageNumber = (String)this.getView().getFormShowParameter().getCustomParam("bizpagenumber");
            String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_APP_ID);
            String inheritPath = "";
            String bizPageId = "";
            if (StringUtils.isNotBlank((CharSequence)bizPageNumber)) {
                bizPageId = this.getPageIdByPageNumber(bizPageNumber);
                this.getPageCache().put(BIZ_PAGE_ID, bizPageId);
            }
            JSONArray appIds = new JSONArray();
            String loadExtendAppIds = this.getView().getFormShowParameter().getCustomParam("loadExtendAppIds") == null ? "false" : (String)this.getView().getFormShowParameter().getCustomParam("loadExtendAppIds");
            span.addLocaleTag("loadExtendAppIds", (Object)loadExtendAppIds);
            if ("true".equals(loadExtendAppIds) && StringUtils.isNotBlank((CharSequence)bizAppId)) {
                span.addLocaleTag("bizAppId", (Object)bizAppId);
                appIds.addAll(this.getExtendAppIds(bizAppId));
                span.addLocaleTag("appIds", (Object)appIds);
            } else {
                if (StringUtils.isNotBlank((CharSequence)bizAppId)) {
                    AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
                    inheritPath = appMeta.getInheritPath();
                } else {
                    if (StringUtils.isBlank((CharSequence)bizPageNumber)) {
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)bizPageId)) {
                        DynamicObject appObject = BizAppServiceHelp.getBizAppByFormID((String)bizPageId);
                        if (appObject == null) {
                            return;
                        }
                        bizAppId = appObject.getString("id");
                        inheritPath = appObject.getString("inheritpath");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
                    if (inheritPath.contains(",")) {
                        String[] inheritPaths;
                        for (String inherit : inheritPaths = inheritPath.split(",")) {
                            appIds.add((Object)inherit);
                        }
                    } else {
                        appIds.add((Object)inheritPath);
                    }
                }
            }
            appIds.add((Object)bizAppId);
            String engineType = (String)this.getView().getFormShowParameter().getCustomParam("engineType");
            engineType = StringUtils.isBlank((CharSequence)engineType) ? "0" : engineType;
            QFilter engine = new QFilter("enginetype", "=", (Object)engineType);
            if ("1".equals(engineType)) {
                String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
                String scriptType = KingScriptType.getScriptType((IFormView)this.getView(), (String)modelType, this::getBillScriptType);
                engine.and(new QFilter("cbox_script_type", "=", (Object)scriptType));
            }
            String currentISV = ISVServiceHelper.getISVInfo().getId();
            engine.and(new QFilter("isv", "=", (Object)currentISV));
            QFilter[] filters = new QFilter[]{new QFilter(BIZ_APP_ID, "in", (Object)appIds), engine};
            DynamicObject[] scriptInfos = BusinessDataServiceHelper.load((String)"ide_pluginscript", (String)"id,txt_scriptname,txt_scriptnumber,description,cbox_script_type,classname,bizunitid,bizappid", (QFilter[])filters, (String)CLASSNAME);
            if (scriptInfos.length == 0) {
                return;
            }
            JSONArray rowInfos = this.getRowInfos(scriptInfos);
            String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
            List plugins = SerializationUtils.fromJsonStringToList((String)value, Map.class);
            if (rowInfos.size() > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, rowInfos.size());
                JSONArray selectedIndexs = new JSONArray();
                for (int i = 0; i < rowInfos.size(); ++i) {
                    JSONObject scriptInfo = rowInfos.getJSONObject(i);
                    String scriptType = scriptInfo.getString(SCRIPT_TYPE);
                    this.getModel().setValue(SCRIPT_NUMBER, scriptInfo.get((Object)CLASSNAME), i);
                    this.getModel().setValue(NUMBER, scriptInfo.get((Object)NUMBER), i);
                    this.getModel().setValue(SCRIPT_NAME, (Object)scriptInfo.getString(SCRIPT_NAME), i);
                    this.getModel().setValue(SCRIPT_TYPE, (Object)scriptType, i);
                    this.getModel().setValue(SCRIPT_ID, (Object)scriptInfo.getString(SCRIPT_ID), i);
                    this.getModel().setValue(BIZ_APP_ID, (Object)scriptInfo.getString(BIZ_APP_ID), i);
                    this.getModel().setValue(DESCRIPTION, (Object)scriptInfo.getString(DESCRIPTION), i);
                    boolean isSelected = this.getIsSelectedRow(plugins, scriptInfo.getString(SCRIPT_ID));
                    if (!isSelected) continue;
                    selectedIndexs.add((Object)i);
                }
                if (selectedIndexs.size() > 0) {
                    this.getPageCache().put(SELETED_INDEX, selectedIndexs.toJSONString());
                }
            }
            boolean bl = isMulti = !Boolean.FALSE.equals(this.getView().getFormShowParameter().getCustomParam("scriptmulti"));
            if (!isMulti) {
                this.disableEntryMulti();
            }
        }
    }

    private Set<String> getExtendAppIds(String bizAppId) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{new QFilter("masterid", "=", (Object)bizAppId), new QFilter("isv", "=", (Object)ISVService.getISVInfo().getId())};
        Map dynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)selectFields, (QFilter[])filters);
        HashSet<String> extendAppIds = new HashSet<String>();
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects.values()) {
                String id = dynamicObject.getString("id");
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                extendAppIds.add(id);
            }
        }
        return extendAppIds;
    }

    private void disableEntryMulti() {
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put("ismul", false);
        this.getView().updateControlMetadata(ENTRY_ENTITY, prop);
    }

    private String getBillScriptType(IFormView view) {
        String designerName = this.getSubDesignerName();
        String type = "2";
        if (StringUtils.isNotBlank((CharSequence)designerName)) {
            switch (designerName) {
                case "MobListMeta": 
                case "ListMeta": {
                    type = "3";
                    break;
                }
                case "MobMeta": {
                    type = "2";
                }
            }
        }
        return type;
    }

    private String getSubDesignerName() {
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        return propertyEditHelper.getSubDesignerName(this.getView());
    }

    public void afterBindData(EventObject e) {
        String engineType;
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_ENTITY);
        String rowIndexStr = this.getPageCache().get(SELETED_INDEX);
        if (StringUtils.isNotBlank((CharSequence)rowIndexStr)) {
            JSONArray selectedIndexs = (JSONArray)JSONArray.parse((String)rowIndexStr);
            int[] rowIndex = new int[selectedIndexs.size()];
            for (int i = 0; i < selectedIndexs.size(); ++i) {
                rowIndex[i] = selectedIndexs.getIntValue(i);
            }
            grid.selectRows(rowIndex, rowIndex[0]);
        }
        if ("1".equals(engineType = (String)this.getView().getFormShowParameter().getCustomParam("engineType"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"kde", "vectorap"});
        }
    }

    private JSONArray getRowInfos(DynamicObject[] scriptInfos) {
        String scriptTypeFilter = (String)this.getView().getFormShowParameter().getCustomParam("scripttypefilter");
        if (scriptInfos.length <= 0) {
            return new JSONArray();
        }
        JSONArray rowInfos = new JSONArray();
        for (int i = 0; i < scriptInfos.length; ++i) {
            String scriptType;
            DynamicObject scriptInfo = scriptInfos[i];
            String className = scriptInfo.getString(CLASSNAME);
            if ((className == null || className.trim().length() == 0) && (className = this.getClassNameByBizUnitId(scriptInfo.getString(BIZ_APP_ID), scriptInfo.getString("bizunitid"), scriptInfo.getString(TXT_SCRIPT_NUMBER))) == null || !KingScriptType.isKingScript((String)(scriptType = scriptInfo.getString("cbox_script_type")), (String)scriptTypeFilter)) continue;
            JSONObject rowInfo = this.addRowInfo(scriptType, className, scriptInfo);
            rowInfos.add((Object)rowInfo);
        }
        return rowInfos;
    }

    private JSONObject addRowInfo(String scriptType, String className, DynamicObject scriptInfo) {
        JSONObject rowInfo = new JSONObject();
        String scriptTypeName = KingScriptType.getScriptNameByIndex((String)scriptType);
        rowInfo.put(CLASSNAME, (Object)className);
        rowInfo.put(SCRIPT_NAME, (Object)scriptInfo.getString("txt_scriptname"));
        rowInfo.put(SCRIPT_TYPE, (Object)scriptTypeName);
        rowInfo.put(SCRIPT_ID, (Object)scriptInfo.getString("id"));
        rowInfo.put(BIZ_APP_ID, (Object)scriptInfo.getString(BIZ_APP_ID));
        rowInfo.put(DESCRIPTION, (Object)scriptInfo.getString(DESCRIPTION));
        rowInfo.put(NUMBER, (Object)scriptInfo.getString(TXT_SCRIPT_NUMBER));
        return rowInfo;
    }

    private String getClassNameByBizUnitId(String bizAppId, String bizUnitId, String scriptNumber) {
        AppFunctionPacketElement bizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
        if (bizUnitInfo == null) {
            return null;
        }
        String bizUnitNumber = bizUnitInfo.getNumber();
        String parentUnitNumber = null;
        if (bizUnitInfo != null && bizUnitInfo.getParentId().trim().length() != 0) {
            String parentBizUnitId = bizUnitInfo.getParentId();
            AppFunctionPacketElement parentBizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)parentBizUnitId, (String)bizAppId, (boolean)false);
            parentUnitNumber = parentBizUnitInfo.getNumber();
        }
        AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String bizAppNumber = appInfo.getNumber();
        String BizCloudId = appInfo.getBizCloudID();
        String bizCloudNumber = (String)BusinessDataServiceHelper.loadSingleFromCache((Object)BizCloudId, (String)"bos_devportal_bizcloud", (String)NUMBER).get(NUMBER);
        String className = null;
        className = parentUnitNumber == null ? bizCloudNumber + "." + bizAppNumber + "." + bizUnitNumber + "." + scriptNumber : bizCloudNumber + "." + bizAppNumber + "." + parentUnitNumber + "." + bizUnitNumber + "." + scriptNumber;
        return className.toLowerCase();
    }

    private boolean getIsSelectedRow(List<Map<String, Object>> plugins, String scriptId) {
        boolean isSelected = false;
        for (Map<String, Object> plugin : plugins) {
            if (plugin.get("Type") == null || 1 != (Integer)plugin.get("Type") || plugin.get("FPK") == null || !plugin.get("FPK").toString().equals(scriptId)) continue;
            isSelected = true;
        }
        return isSelected;
    }

    private String getPageIdByPageNumber(String bizPageNumber) {
        QFilter q = new QFilter(NUMBER, "=", (Object)bizPageNumber);
        QFilter[] filters = new QFilter[]{q};
        Map pageObjects = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,number", (QFilter[])filters);
        if (pageObjects.size() > 0) {
            return ((DynamicObject)pageObjects.values().toArray()[0]).getString("id");
        }
        return null;
    }

    @Deprecated
    public static String getScriptNameByIndex(String index) {
        switch (index) {
            case "1": {
                return ResManager.loadKDString((String)"\u8868\u5355\u63d2\u4ef6", (String)"RegistKSPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u5355\u636e\u63d2\u4ef6", (String)"RegistKSPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u5217\u8868\u63d2\u4ef6", (String)"RegistKSPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u64cd\u4f5c\u63d2\u4ef6", (String)"RegistKSPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "5": {
                return ResManager.loadKDString((String)"\u5355\u5143\u6d4b\u8bd5\u63d2\u4ef6", (String)"RegistKSPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "6": {
                return ResManager.loadKDString((String)"\u5de5\u5177\u7c7b\u811a\u672c", (String)"RegistKSPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "7": {
                return ResManager.loadKDString((String)"\u6d41\u7a0b\u63d2\u4ef6", (String)"RegistKSPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "8": {
                return ResManager.loadKDString((String)"web\u5355\u636eAPI\u63d2\u4ef6", (String)"RegistKSPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "9": {
                return ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5355\u636e\u63d2\u4ef6", (String)"RegistKSPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "10": {
                return ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u63d2\u4ef6", (String)"RegistKSPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "11": {
                return ResManager.loadKDString((String)"\u5355\u636e\u53cd\u5199\u63d2\u4ef6", (String)"RegistKSPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
            case "12": {
                return ResManager.loadKDString((String)"\u6253\u5370\u63d2\u4ef6", (String)"RegistKSPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
        }
        return "";
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "exit": {
                this.exit();
                break;
            }
            case "ok": {
                this.confirm(e);
                break;
            }
            case "kde": {
                this.gotoKDE();
                break;
            }
        }
    }

    private void gotoKDE() {
        String bizPageNumber = (String)this.getView().getFormShowParameter().getCustomParam("bizpagenumber");
        if (StringUtils.isBlank((CharSequence)bizPageNumber)) {
            return;
        }
        String bizPageId = this.getPageIdByPageNumber(bizPageNumber);
        if (StringUtils.isBlank((CharSequence)bizPageId)) {
            return;
        }
        DynamicObject appObject = BizAppServiceHelp.getBizAppByFormID((String)bizPageId);
        if (appObject == null) {
            return;
        }
        String bizAppId = appObject.getString("id");
        DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)bizAppId);
        if (cloudObject == null) {
            return;
        }
        String bizCloudId = cloudObject.getString("id");
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setFormId("bos_devp_kde");
        parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
        parameter.setCustomParam(BIZ_CLOUD_ID, (Object)bizCloudId);
        parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        this.getView().showForm(parameter);
    }

    private void exit() {
        this.getView().close();
    }

    private void confirm(EventObject e) {
        ArrayList<Map> newPlugins = new ArrayList<Map>(10);
        String value = (String)this.getView().getFormShowParameter().getCustomParam("value");
        List plugins = SerializationUtils.fromJsonStringToList((String)value, Map.class);
        for (Map plugin : plugins) {
            if (plugin.get("FPK") != null) continue;
            newPlugins.add(plugin);
        }
        AbstractGrid grid = (AbstractGrid)this.getControl(ENTRY_ENTITY);
        int[] selectIndex = grid.getEntryState().getSelectedRows();
        String engineType = (String)this.getView().getFormShowParameter().getCustomParam("engineType");
        int type = "1".equals(engineType) ? 4 : 1;
        for (int i = 0; i < selectIndex.length; ++i) {
            String bizAppId = this.getModel().getValue(BIZ_APP_ID, selectIndex[i]).toString();
            String scriptId = this.getModel().getValue(SCRIPT_ID, selectIndex[i]).toString();
            String className = this.getModel().getValue(SCRIPT_NUMBER, selectIndex[i]).toString();
            String scriptName = this.getModel().getValue(SCRIPT_NAME, selectIndex[i]).toString();
            String description = this.getModel().getValue("Description", selectIndex[i]).toString();
            HashMap<String, Object> plugin = new HashMap<String, Object>();
            plugin.put("Description", description);
            plugin.put("ClassName", className);
            plugin.put("ScriptName", scriptName);
            plugin.put("FPK", scriptId);
            plugin.put("BizAppId", bizAppId);
            plugin.put("Enabled", true);
            plugin.put("Type", type);
            newPlugins.add(plugin);
        }
        this.getView().returnDataToParent(newPlugins);
        this.getView().close();
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        String fieldName = arg.getFieldName();
        if (SCRIPT_NUMBER.equals(fieldName)) {
            int rowIndex = arg.getRowIndex();
            String bizPageId = this.getPageCache().get(BIZ_PAGE_ID);
            String bizAppId = this.getModel().getValue(BIZ_APP_ID, rowIndex).toString();
            ArrayList<String> scriptIds = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)bizPageId)) {
                AbstractMetadata metadata = null;
                try {
                    metadata = MetadataDao.readMeta((String)bizPageId, (MetaCategory)MetaCategory.Form);
                    bizAppId = metadata.getBizappId();
                }
                catch (Exception e) {
                    throw new KDBizException(e.getMessage());
                }
                List list = null;
                if (metadata instanceof FormMetadata) {
                    list = ((FormMetadata)metadata).getRootAp().getPlugins();
                } else if (metadata instanceof PrintMetadata) {
                    list = ((PrintMetadata)metadata).getRootAp().getPlugins();
                }
                Objects.requireNonNull(list);
                String fScriptId = "";
                if (list != null) {
                    for (Plugin plugin : list) {
                        fScriptId = plugin.getFpk();
                        scriptIds.add(fScriptId);
                    }
                }
            }
            String bizCloudId = this.getModel().getValue(BIZ_CLOUD_ID, rowIndex).toString();
            String bizScriptId = this.getModel().getValue(SCRIPT_ID, rowIndex).toString();
            String engineType = (String)this.getView().getFormShowParameter().getCustomParam("engineType");
            engineType = StringUtils.isBlank((CharSequence)engineType) ? "0" : engineType;
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.NewWindow);
            parameter.setFormId("bos_devp_kde");
            parameter.setCustomParam(BIZ_APP_ID, (Object)bizAppId);
            parameter.setCustomParam(BIZ_CLOUD_ID, (Object)bizCloudId);
            parameter.setCustomParam("fromProFormDesigner", this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
            parameter.setCustomParam("bizscriptid", (Object)bizScriptId);
            parameter.setCustomParam("bizpagenumber", this.getView().getFormShowParameter().getCustomParam("bizpagenumber"));
            if (StringUtils.isNotBlank(scriptIds) && scriptIds.contains(bizScriptId)) {
                parameter.setCustomParam("bizformid", (Object)bizPageId);
            }
            if ("1".equals(engineType)) {
                parameter.setShowTitle(false);
                parameter.setShowClose(false);
                parameter.setFormId("ide_register_ts_plugin");
                String serviceAppid = TSShowFormUtil.getTSEditerServiceAppid((String)((String)parameter.getCustomParam(BIZ_APP_ID)), (String)((String)parameter.getCustomParam("bizpagenumber")));
                parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
            }
            this.getView().showForm(parameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(BIZ_PAGE_ID);
        this.getPageCache().remove(SELETED_INDEX);
    }
}

