/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.CultureInfoUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.AuditParameter;
import kd.bos.metadata.entity.operation.Operation;

public class AuditParaEditPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("MetaContext");
        if (formContext == null) {
            return;
        }
        Map parameter = (Map)this.getView().getFormShowParameter().getCustomParams().get("Parameter");
        this.updateComboItems((List)formContext.get(0), parameter);
        this.setCheckDataCombo(parameter);
        this.lockPropertyByBusExt();
    }

    private void lockPropertyByBusExt() {
        String lockType = (String)this.getView().getFormShowParameter().getCustomParam("lockType");
        if ("speciallock".equals(lockType)) {
            List operations;
            EntityMetadata parentMetadata;
            String parentId;
            EntityMetadata entityMetadata;
            this.getView().setEnable(Boolean.FALSE, new String[]{"auditstatusfield", "auditstatus", "checkdataversion"});
            String value = "";
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
            if (StringUtils.isNotBlank((CharSequence)entityId) && (entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity)) != null && StringUtils.isNotBlank((CharSequence)(parentId = entityMetadata.getParentId())) && (parentMetadata = (EntityMetadata)MetadataDao.readMeta((String)parentId, (MetaCategory)MetaCategory.Entity)) != null && (operations = parentMetadata.getRootEntity().getOperations()) != null && !operations.isEmpty()) {
                Operation operation;
                AuditParameter parameter;
                String opId = (String)this.getView().getFormShowParameter().getCustomParam("opId");
                Optional<Operation> first = operations.stream().filter(op -> opId.equals(op.getId())).findFirst();
                if (first.isPresent() && (parameter = (AuditParameter)(operation = first.get()).getParameter()) != null) {
                    value = parameter.getCommentFieldId();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"auditcommentfield"});
            }
        }
    }

    private void updateComboItems(List<Map<String, Object>> formContext, Map<String, Object> parameter) {
        ArrayList<ComboItem> statusFieldItems = new ArrayList<ComboItem>();
        HashMap<String, List> statusItems = new HashMap<String, List>();
        ArrayList<ComboItem> commentFieldItems = new ArrayList<ComboItem>();
        if (formContext != null) {
            for (Map<String, Object> field : formContext) {
                String fieldType = field.get("_Type_").toString();
                String fieldId = field.get("Id").toString();
                if (fieldType.equalsIgnoreCase("BillStatusField")) {
                    statusFieldItems.add(new ComboItem(new LocaleString(CultureInfoUtils.getDefaultLCId(), field.get("Name").toString()), fieldId));
                    Object itemsObj = field.get("StatusItems");
                    List items = itemsObj instanceof List ? (List)itemsObj : new ArrayList();
                    statusItems.put(fieldId, items);
                }
                if (!fieldType.equalsIgnoreCase("TextField")) continue;
                commentFieldItems.add(new ComboItem(new LocaleString(CultureInfoUtils.getDefaultLCId(), field.get("Name").toString()), field.get("Id").toString()));
            }
            this.getPageCache().put("statusItems", SerializationUtils.toJsonString(statusItems));
            ComboEdit combo = (ComboEdit)this.getView().getControl("AuditStatusField");
            combo.setComboItems(statusFieldItems);
            combo = (ComboEdit)this.getView().getControl("AuditCommentField");
            combo.setComboItems(commentFieldItems);
        }
        if (!statusFieldItems.isEmpty()) {
            String statusFieldId = parameter != null && parameter.containsKey("StatusFieldId") ? parameter.get("StatusFieldId").toString() : ((ComboItem)statusFieldItems.get(0)).getValue();
            this.getModel().setValue("AuditStatusField", (Object)statusFieldId);
            ComboEdit statusCombo = (ComboEdit)this.getView().getControl("AuditStatus");
            List<ComboItem> statusComboItems = this.getComboItemsFromMaps((List)statusItems.get(statusFieldId));
            statusCombo.setComboItems(statusComboItems);
            if (!statusComboItems.isEmpty()) {
                this.getModel().setValue("AuditStatus", parameter != null && parameter.containsKey("Value") ? parameter.get("Value") : statusComboItems.get(0).getValue());
            }
        }
        if (!commentFieldItems.isEmpty()) {
            this.getModel().setValue("AuditCommentField", parameter != null && parameter.containsKey("CommentFieldId") ? parameter.get("CommentFieldId") : ((ComboItem)commentFieldItems.get(0)).getValue());
        }
    }

    public List<ComboItem> getComboItemsFromMaps(List<Map<String, Object>> list) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (list != null) {
            for (Map<String, Object> map : list) {
                items.add(new ComboItem(new LocaleString(CultureInfoUtils.getDefaultLCId(), map.get("statusname").toString()), map.get("statuskey").toString()));
            }
        }
        return items;
    }

    public void propertyChanged(PropertyChangedArgs event) {
        if (event.getProperty().getName().equalsIgnoreCase("auditstatusfield")) {
            String value = event.getChangeSet()[0].getNewValue().toString();
            ComboEdit combo = (ComboEdit)this.getView().getControl("auditstatus");
            Map statusItems = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("statusItems"), Map.class);
            List<ComboItem> statusComboItems = this.getComboItemsFromMaps((List)statusItems.get(value));
            combo.setComboItems(statusComboItems);
            if (!statusComboItems.isEmpty()) {
                this.getModel().setValue("auditstatus", (Object)statusComboItems.get(0).getValue());
            }
        }
    }

    private void setCheckDataCombo(Map<String, Object> parameter) {
        List<String> enableOps = Arrays.asList("save", "submit", "audit");
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object opType = params.getOrDefault("OpType", null);
        if (opType == null || !enableOps.contains(opType.toString())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"checkdataversion"});
        } else {
            Boolean checkDataVersion = parameter != null ? parameter.getOrDefault("CheckDataVersion", false) : Boolean.valueOf(false);
            this.getView().getModel().setValue("checkdataversion", (Object)checkDataVersion);
        }
    }
}

