/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizScriptService;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCacheUtils;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployScript;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.ScriptClassInfo;
import kd.bos.script.ScriptExecutor;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sdk.kingscript.engine.KingScriptEngine;

public class BizScriptServiceImpl
implements BizScriptService {
    private static Integer LIMITSIZ = 0x100000;
    private static final String IDE_PLUGINSCRIPT = "ide_pluginscript";
    private static final String TXT_SCRIPTNUMBER = "txt_scriptnumber";
    private static final String CONTEXT = "context";
    private static final String FILECONTENT = "filecontent";
    private static final String FILENAME = "filename";
    private static Log logger = LogFactory.getLog(BizScriptServiceImpl.class);
    private static JSONArray scriptLogIds = new JSONArray();

    public String getScriptNumberByClassName(String classname) {
        if (classname == null) {
            return ResManager.loadKDString((String)"\u9875\u9762classname\u4e3a\u7a7a\uff0c\u9700\u8981\u5728kde\u91cc\u91cd\u65b0\u4fdd\u5b58\u811a\u672c", (String)"622137642120642560", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]);
        }
        QFilter[] filters1 = new QFilter[]{new QFilter("classname", "=", (Object)classname)};
        DynamicObject scriptObject1 = BusinessDataServiceHelper.loadSingleFromCache((String)IDE_PLUGINSCRIPT, (QFilter[])filters1);
        if (scriptObject1 != null) {
            return scriptObject1.getString(TXT_SCRIPTNUMBER);
        }
        String tempScriptNumber = classname.substring(classname.lastIndexOf(46) + 1, classname.length());
        JSONObject scirptMap = new JSONObject();
        QFilter[] filters = new QFilter[]{new QFilter(TXT_SCRIPTNUMBER, "like", (Object)tempScriptNumber)};
        DynamicObject[] scripts = BusinessDataServiceHelper.load((String)IDE_PLUGINSCRIPT, (String)"txt_scriptnumber,bizunitid,bizappid", (QFilter[])filters);
        for (int i = 0; i < scripts.length; ++i) {
            DynamicObject scriptObject = scripts[i];
            String scriptNumber = scriptObject.getString(TXT_SCRIPTNUMBER);
            String bizUnitId = scriptObject.getString("bizunitid");
            String bizAppId = scriptObject.getString("bizappid");
            AppFunctionPacketElement bizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)bizUnitId, (String)bizAppId, (boolean)false);
            String bizUnitNumber = bizUnitInfo.getNumber();
            String parentUnitNumber = null;
            if (bizUnitInfo.getParentId().trim().length() != 0) {
                String parentBizUnitId = bizUnitInfo.getParentId();
                AppFunctionPacketElement parentBizUnitInfo = AppMetaServiceHelper.getFunctionPacketById((String)parentBizUnitId, (String)bizAppId, (boolean)false);
                parentUnitNumber = parentBizUnitInfo.getNumber();
            }
            AppMetadata appInfo = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
            String bizAppNumber = appInfo.getNumber();
            String BizCloudId = appInfo.getBizCloudID();
            String bizCloudNumber = (String)BusinessDataServiceHelper.loadSingleFromCache((Object)BizCloudId, (String)"bos_devportal_bizcloud", (String)"number").get("number");
            String className = null;
            className = parentUnitNumber == null ? bizCloudNumber + "." + bizAppNumber + "." + bizUnitNumber + "." + scriptNumber : bizCloudNumber + "." + bizAppNumber + "." + parentUnitNumber + "." + bizUnitNumber + "." + scriptNumber;
            scirptMap.put(className.toLowerCase(), (Object)scriptNumber);
        }
        return scirptMap.getString(classname);
    }

    public String getScriptNumberByName(String scriptName) {
        DynamicObject bizScript = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptName, (String)IDE_PLUGINSCRIPT, (String)TXT_SCRIPTNUMBER);
        return bizScript.getString(TXT_SCRIPTNUMBER);
    }

    public DynamicObject getScriptByID(String bizScriptId) {
        DynamicObject bizScript = BusinessDataServiceHelper.loadSingleFromCache((Object)bizScriptId, (String)IDE_PLUGINSCRIPT);
        return bizScript;
    }

    public DynamicObjectCollection getScriptsByUnitID(String bizUnitId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizunitid", "=", (Object)bizUnitId)};
        DynamicObjectCollection bizScript = QueryServiceHelper.query((String)IDE_PLUGINSCRIPT, (String)"*", (QFilter[])filters);
        return bizScript;
    }

    public DynamicObjectCollection getScriptsByAppID(String bizAppId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizappid", "=", (Object)bizAppId)};
        DynamicObjectCollection bizScript = QueryServiceHelper.query((String)IDE_PLUGINSCRIPT, (String)"*", (QFilter[])filters);
        return bizScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ScriptClassInfo> getDefinedClasses(String ... requires) {
        ScriptExecutor executor = ScriptExecutor.create();
        executor.init(ctx -> ctx.require(requires));
        executor.begin();
        try {
            Set set = executor.getContext().getDefinedClasses();
            return set;
        }
        finally {
            executor.end();
        }
    }

    public String getScriptContentByFile(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployScript deployNew = (DeployScript)serializer.deserializeFromString(content, null);
        List dynamicObjects = deployNew.getScripts();
        return ((DynamicObject)dynamicObjects.get(0)).getString(CONTEXT);
    }

    public boolean updateScriptContent(String scriptId, String content, String svnmsg) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT);
        scriptInfo.set("txt_scriptcontext_tag", (Object)content);
        SaveServiceHelper.update((DynamicObject)scriptInfo);
        String bizAppId = scriptInfo.getString("bizappid");
        String bizUnitId = scriptInfo.getString("bizUnitId");
        List scriptDeployFile = MetadataDao.getScriptDeployFile((String[])new String[]{scriptId});
        if (scriptDeployFile.isEmpty()) {
            return false;
        }
        String scriptContent = ((DeployFile)scriptDeployFile.get(0)).getFileContent();
        MetadataDao.deployScript((String)scriptContent, (String)bizUnitId, (String)bizAppId);
        MetaCacheUtils.removeDistributeCache((String[])new String[]{scriptInfo.getString("classname")});
        return true;
    }

    public boolean gitUpdateScript(String scriptId, String content) {
        DynamicObject scriptInfo = BusinessDataServiceHelper.loadSingle((Object)scriptId, (String)IDE_PLUGINSCRIPT);
        if (scriptInfo == null) {
            return false;
        }
        String bizAppId = scriptInfo.getString("bizappid");
        String bizUnitId = scriptInfo.getString("bizUnitId");
        MetadataDao.deployScript((String)content, (String)bizUnitId, (String)bizAppId);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScript(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        try (KingScriptEngine engine = ProjectInitializerManager.getEngine((boolean)false);){
            String string = engine.load(path);
            return string;
        }
        catch (Exception e) {
            return ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u6c60\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002", (String)"BizScriptServiceImpl_1", (String)"bos-mservice-devportal", (Object[])new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScriptWithVersion(String path) {
        JSONObject scriptInfo = new JSONObject();
        if (StringUtils.isBlank((CharSequence)path)) {
            return this.getScriptInfo("200", "");
        }
        try (KingScriptEngine engine = ProjectInitializerManager.getEngine((boolean)false);){
            scriptInfo = engine.loadWithVersion(path);
            scriptInfo.put("code", (Object)"200");
            String string = scriptInfo.toJSONString();
            return string;
        }
        catch (Exception e) {
            return this.getScriptInfo("500", ResManager.loadKDString((String)"\u811a\u672c\u5f15\u64ce\u6c60\u6b63\u5728\u521d\u59cb\u5316\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5\u3002", (String)"BizScriptServiceImpl_1", (String)"bos-mservice-devportal", (Object[])new Object[0]));
        }
    }

    private String getScriptInfo(String code, String msg) {
        JSONObject scriptObj = new JSONObject();
        scriptObj.put("code", (Object)code);
        scriptObj.put("data", (Object)msg);
        return scriptObj.toJSONString();
    }

    public static String getSessionKeyForSvnDiff(String svnPath, String uuid) {
        return BizScriptServiceImpl.getSessionKey(svnPath, uuid) + "_SvnDiff";
    }

    public static String getSessionKey(String svnPath, String uuid) {
        String substring;
        String[] split2;
        String re = "((http|https|svn|file)://)(([a-zA-Z0-9._-]+)|([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}))(([a-zA-Z]{2,6})|(:[0-9]{1,4})?)";
        String sessionKey = "";
        Pattern pattern = Pattern.compile(re);
        Matcher matcher = pattern.matcher(svnPath);
        sessionKey = matcher.matches() ? svnPath : ((split2 = svnPath.split(re)).length > 1 ? (substring = svnPath.substring(0, svnPath.length() - split2[1].length())) : split2[0]);
        String userId = RequestContext.get().getUserId();
        return sessionKey + uuid + userId;
    }

    public boolean updatePageContent(String formId, String content) {
        QFilter qFormId = new QFilter("form", "=", (Object)formId);
        DynamicObject pageRelInfo = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizunit,bizapp", (QFilter[])new QFilter[]{qFormId});
        String bizUnitId = pageRelInfo.getString("bizunit");
        String bizAppId = pageRelInfo.getString("bizapp");
        MetadataDao.deployMetadata((String)content, (String)bizUnitId, (String)bizAppId);
        MetadataDao.rebuildRuntimeMetaById((String)formId);
        return true;
    }

    public boolean updateCardContent(String cardId, String content) {
        MetadataDao.deployCard((String)content);
        return false;
    }

    public boolean updateAppContent(String bizAppId, String content) {
        AppMetaServiceHelper.deployAppMetadata((String)content);
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        MetadataDao.cleanAppCache((String)bizAppId, (String)appMeta.getMasterId());
        return true;
    }

    public String getScriptContentByID(String scriptId) {
        DynamicObject bizScript = BusinessDataServiceHelper.loadSingleFromCache((Object)scriptId, (String)IDE_PLUGINSCRIPT);
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        result.put("scriptobject", bizScript);
        return SerializationUtils.toJsonString(result);
    }

    public String getPageContentByID(String formId) {
        HashMap<String, Object> pageObject = new HashMap<String, Object>();
        ArrayList files = new ArrayList();
        List list = MetadataDao.getFormDeployFile((String)formId);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> fileObject = new HashMap<String, String>();
                String fileName = ((DeployFile)list.get(i)).getFileName();
                if (StringUtils.isNotBlank((CharSequence)fileName) && (fileName.endsWith(".en.dymx") || fileName.endsWith(".en_US.dymx") || fileName.endsWith(".zh_TW.dymx"))) continue;
                fileObject.put(FILECONTENT, ((DeployFile)list.get(i)).getFileContent());
                fileObject.put(FILENAME, fileName);
                files.add(fileObject);
            }
            pageObject.put(FILENAME, ((DeployFile)list.get(0)).getFileName());
            pageObject.put(FILECONTENT, files);
        }
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("pageobject", pageObject);
        return SerializationUtils.toJsonString(result);
    }

    public String getAppContentByID(String appId) {
        HashMap<String, Object> appObject = new HashMap<String, Object>();
        ArrayList files = new ArrayList();
        List list = AppMetaServiceHelper.getAppDeployFile((String)appId);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> fileObject = new HashMap<String, String>();
                String fileName = ((DeployFile)list.get(i)).getFileName();
                if (StringUtils.isNotBlank((CharSequence)fileName) && (fileName.endsWith(".en.appx") || fileName.endsWith(".en_US.appx") || fileName.endsWith(".zh_TW.appx"))) continue;
                fileObject.put(FILECONTENT, ((DeployFile)list.get(i)).getFileContent());
                fileObject.put(FILENAME, fileName);
                files.add(fileObject);
            }
            appObject.put(FILENAME, ((DeployFile)list.get(0)).getFileName());
            appObject.put(FILECONTENT, files);
        }
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("appobject", appObject);
        return SerializationUtils.toJsonString(result);
    }

    public String getCloudContentByID(String cloudId) {
        HashMap<String, Object> cloudObject = new HashMap<String, Object>();
        ArrayList files = new ArrayList();
        List list = AppMetaServiceHelper.getCloudDeployFile((String)cloudId);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, String> fileObject = new HashMap<String, String>();
                String fileName = ((DeployFile)list.get(i)).getFileName();
                if (StringUtils.isNotBlank((CharSequence)fileName) && (fileName.endsWith(".en.cldx") || fileName.endsWith(".en_US.cldx") || fileName.endsWith(".zh_TW.cldx"))) continue;
                fileObject.put(FILECONTENT, ((DeployFile)list.get(i)).getFileContent());
                fileObject.put(FILENAME, fileName);
                files.add(fileObject);
            }
            cloudObject.put(FILENAME, ((DeployFile)list.get(0)).getFileName());
            cloudObject.put(FILECONTENT, files);
        }
        HashMap<String, HashMap<String, Object>> result = new HashMap<String, HashMap<String, Object>>();
        result.put("cloudobject", cloudObject);
        return SerializationUtils.toJsonString(result);
    }

    public String getNewScriptFileContent(String scriptId, String content) {
        List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{scriptId});
        DeployFile df = (DeployFile)deployFileList.get(0);
        String localContent = df.getFileContent();
        DcxmlSerializer serializer = new DcxmlSerializer(DeployScript.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployScript deployNew = (DeployScript)serializer.deserializeFromString(localContent, null);
        List dynamicObjects = deployNew.getScripts();
        ((DynamicObject)dynamicObjects.get(0)).set(CONTEXT, (Object)content);
        return serializer.serializeToString((Object)deployNew, null);
    }

    public String getScriptLogs() {
        String sessionId = RequestContext.get().getGlobalSessionId();
        QFilter filter1 = new QFilter("sessionid", "=", (Object)sessionId);
        QFilter filter2 = new QFilter("id", "not in", (Object)scriptLogIds);
        DynamicObject[] scriptLogs = BusinessDataServiceHelper.load((String)"bos_devp_scriptoperatelog", (String)"currenttime,data", (QFilter[])new QFilter[]{filter1, filter2});
        if (scriptLogs.length > 0) {
            for (DynamicObject dynamicObject : scriptLogs) {
                scriptLogIds.add(dynamicObject.get("id"));
            }
        }
        return SerializationUtils.toJsonString((Object)scriptLogs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScriptFileByPath(String localFilePath) {
        Path path = Paths.get(BizScriptServiceImpl.checkFilePath(localFilePath), new String[0]);
        try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
            String content;
            byte[] bt = new byte[LIMITSIZ.intValue()];
            int len = inStream.read(bt);
            String string = content = new String(bt, 0, len, StandardCharsets.UTF_8);
            return string;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return "";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public void gitSaveScriptFile(String id, String metaDataGitRepository) {
        List deployFileList = MetadataDao.getScriptDeployFile((String[])new String[]{id});
        DeployFile df = (DeployFile)deployFileList.get(0);
        String fileName = df.getFileName();
        String fileContent = df.getFileContent();
        GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
    }

    public void gitSaveFormFile(String id, String metaDataGitRepository) {
        List list = MetadataDao.getFormDeployFile((String)id);
        for (int i = 0; i < list.size(); ++i) {
            String fileName = ((DeployFile)list.get(i)).getFileName();
            String fileContent = ((DeployFile)list.get(i)).getFileContent();
            GitOperationUtil.saveFile((String)fileName, (String)fileContent, (String)metaDataGitRepository);
        }
    }

    public boolean saveFileToLocal(String fileName, String content, String metaDataGitRepository) {
        try {
            GitOperationUtil.saveFile((String)fileName, (String)content, (String)metaDataGitRepository);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        return true;
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }

    public DynamicObject gitGetCurrentUser(String fieldName) {
        return BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user", (String)fieldName);
    }

    public String getPageFile(String filePath) {
        int position = 0;
        String[] bufstring = new String[1024];
        try (FileReader fileReader = new FileReader(filePath);
             BufferedReader br = new BufferedReader(fileReader);){
            String line = null;
            while ((line = br.readLine()) != null) {
                bufstring[position] = line;
                ++position;
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return "";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        StringBuilder remoteCon = new StringBuilder();
        for (int i = 0; i < position; ++i) {
            remoteCon.append(bufstring[i]);
            remoteCon.append('\n');
        }
        return remoteCon.toString();
    }

    public boolean getDebugParameter() {
        Object kdedebug = SystemParamServiceHelper.getPublicParameter((String)"kdedebug");
        return kdedebug == null ? false : (Boolean)kdedebug;
    }
}

