/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.server.http.packet.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum QuerySqlType {
    settingsSQL,
    showTablesSQL,
    showCreateTableSQL,
    showOtherSQL,
    querySQL,
    useSQL;

    public static Pattern showTablePattern;
    public static Pattern settingsPattern;
    public static Pattern showOtherPattern;
    public static Pattern usePattern;

    public static QuerySqlType findQuerySqlType(String sql) {
        Matcher showTableMatcher = showTablePattern.matcher(sql);
        if (showTableMatcher.find()) {
            return showTablesSQL;
        }
        Matcher settingsPatternMatcher = settingsPattern.matcher(sql);
        if (settingsPatternMatcher.find()) {
            return settingsSQL;
        }
        Matcher showOtherPatternMatcher = showOtherPattern.matcher(sql);
        if (showOtherPatternMatcher.find()) {
            return showOtherSQL;
        }
        Matcher usePatternMatcher = usePattern.matcher(sql);
        if (usePatternMatcher.find()) {
            return useSQL;
        }
        return querySQL;
    }

    static {
        showTablePattern = Pattern.compile("^(/\\*.*?\\*/)?(show)(\\s+)(tables)(\\s*)$", 2);
        settingsPattern = Pattern.compile("^(/\\*.*?\\*/)?(set)(\\s+)(\\w+)(\\s*)(=*)(\\s*)(\\w+)", 2);
        showOtherPattern = Pattern.compile("^(/\\*.*?\\*/)?(((show)(\\s+)((schemas|databases|sessions|(CHARACTER(\\s+)SET(\\s*))|(column(\\s+)from(\\s*)(.*))|(procedure(\\s+)status)))))(\\s*)$", 2);
        usePattern = Pattern.compile("^(/\\*.*?\\*/)?(use)(\\s+)");
    }
}

