/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class Abs
extends BaseScalarEvaluation {
    private static final long serialVersionUID = -1895475760032209858L;
    private ScalarEvaluation child;

    public Abs(ScalarEvaluation child) {
        this.child = child;
        this.type = TYPECOERCION.higherPrecision4NumberType(child.getType(), DataTypeFactory.instance.buildInt());
    }

    public Object eval(Object[] inputs) {
        BigDecimal value = EvaluationUtil.toBigDecimal(this.child.getType(), this.child.eval(inputs));
        this.checkScalarSubQueryValue(value);
        return EvaluationUtil.convertResult(this.type, value.abs());
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.child});
    }
}

