/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.TypeCoercion;

public abstract class BaseScalarEvaluation
implements ScalarEvaluation {
    private static final long serialVersionUID = -3481598424784047749L;
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final String VERSION = System.getProperty("flydb.version", "FlyDB-V1.0.Beta");
    protected static final TypeCoercion TYPECOERCION = new TypeCoercion();
    protected DataType type;
    protected Context context;

    public DataType getType() {
        return this.type;
    }

    public void setContext(Context context) {
        this.context = context;
        List<ScalarEvaluation> child = this.getChild();
        if (child != null && !child.isEmpty()) {
            for (ScalarEvaluation item : child) {
                item.setContext(context);
            }
        }
    }

    protected List<ScalarEvaluation> getChild() {
        return Collections.emptyList();
    }

    protected void checkScalarSubQueryValue(Object ... value) {
        EvaluationUtil.checkScalarSubQueryValue(value);
    }
}

