/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class Ceiling
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 5814799896641028142L;
    private ScalarEvaluation child;

    public Ceiling(ScalarEvaluation child) {
        this.child = child;
        this.type = DataTypeFactory.instance.getMaxPrecisionDecimal();
    }

    public Object eval(Object[] inputs) {
        Object value = this.child.eval(inputs);
        if (value == null) {
            return null;
        }
        this.checkScalarSubQueryValue(value);
        BigDecimal bigDecimal = EvaluationUtil.toBigDecimal(this.child.getType(), value);
        return bigDecimal.setScale(0, RoundingMode.CEILING);
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.child});
    }
}

