/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManager;
import kd.bos.flydb.core.interpreter.algox.DataSetOutputManagers;
import kd.bos.flydb.core.interpreter.algox.DataSetReader;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataType;

public class DataSetLiteral
extends BaseScalarEvaluation {
    private final String cursorId;
    private transient Long count;
    private transient Object scalarValue;

    public DataSetLiteral(String cursorId, DataType dataType) {
        this.cursorId = cursorId;
        this.type = dataType;
    }

    public Object eval(Object[] inputs) {
        Throwable throwable;
        DataSetReader reader;
        DataSetOutputManager manager;
        if (this.count == null) {
            manager = DataSetOutputManagers.get();
            reader = manager.createReader(this.cursorId);
            throwable = null;
            try {
                this.count = reader.getCount();
                if (this.count == 1L) {
                    this.scalarValue = reader.read(1, 0, 0).get(0);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        if (this.count == 0L) {
            return null;
        }
        if (this.count == 1L) {
            return this.scalarValue;
        }
        if (this.count > Integer.MAX_VALUE) {
            throw Exceptions.of((ErrorCode)ErrorCode.SubQueryDataCountOverflow, (Object[])new Object[]{Integer.MAX_VALUE});
        }
        manager = DataSetOutputManagers.get();
        reader = manager.createReader(this.cursorId);
        throwable = null;
        try {
            List list = reader.read(this.count.intValue(), 0, 0);
            return list;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (reader != null) {
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }
}

