/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;

public class Divide
extends BaseScalarEvaluation {
    private static final long serialVersionUID = -1191430475566879825L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public Divide(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = TYPECOERCION.higherPrecision4NumberType(left.getType(), right.getType());
    }

    public Object eval(Object[] inputs) {
        Object leftValue = this.left.eval(inputs);
        Object rightValue = this.right.eval(inputs);
        this.checkScalarSubQueryValue(leftValue, rightValue);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        BigDecimal l = EvaluationUtil.toBigDecimal(this.left.getType(), leftValue);
        BigDecimal r = EvaluationUtil.toBigDecimal(this.right.getType(), rightValue);
        if (BigDecimal.ZERO.compareTo(r) == 0) {
            return null;
        }
        return EvaluationUtil.convertResult(this.type, l.divide(r, RoundingMode.DOWN));
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

