/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.EvaluationUtil;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;

public class LT
extends BaseScalarEvaluation {
    private static final long serialVersionUID = -4968791512077714948L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public LT(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = DataTypeFactory.instance.buildBoolean();
    }

    public Object eval(Object[] inputs) {
        Object leftValue = this.left.eval(inputs);
        Object rightValue = this.right.eval(inputs);
        if (leftValue == null || rightValue == null) {
            return null;
        }
        this.checkScalarSubQueryValue(leftValue, rightValue);
        SqlTypeCategory typeCategory = this.left.getType().getCategory();
        switch (typeCategory) {
            case NUMBER: {
                return EvaluationUtil.compareNumber((Number)leftValue, (Number)rightValue) < 0;
            }
            case STRING: {
                return ((String)leftValue).compareTo(rightValue.toString()) < 0;
            }
            case DATE: {
                return EvaluationUtil._compareDate(leftValue, rightValue, this.left.getType().getTypeName()) < 0;
            }
            case BOOLEAN: {
                return EvaluationUtil.compareBoolean((Boolean)leftValue, (Boolean)rightValue) < 0;
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.OperatorNotSupported, (Object[])new Object[]{"LT", this.left.getType().getCategory(), "<", this.right.getType().getCategory()});
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

