/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.interpreter.scalar;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.scalar.BaseScalarEvaluation;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.sql.type.DataTypeFactory;

public class ToChar
extends BaseScalarEvaluation {
    private static final long serialVersionUID = 4185152601788385017L;
    private ScalarEvaluation left;
    private ScalarEvaluation right;

    public ToChar(ScalarEvaluation left, ScalarEvaluation right) {
        this.left = left;
        this.right = right;
        this.type = DataTypeFactory.instance.buildString();
    }

    public Object eval(Object[] inputs) {
        DateTimeFormatter formatter;
        Comparable<ChronoLocalDate> result;
        Object value = this.left.eval(inputs);
        Object format = this.right.eval(inputs);
        this.checkScalarSubQueryValue(value, format);
        if (value == null) {
            return null;
        }
        if (format == null) {
            return String.valueOf(value);
        }
        if (value instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)value;
            result = date.toLocalDate();
            formatter = DateTimeFormatter.ofPattern(format.toString());
        } else if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            result = timestamp.toLocalDateTime();
            formatter = DateTimeFormatter.ofPattern(format.toString());
        } else if (value.getClass().equals(Date.class)) {
            result = ((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            formatter = DateTimeFormatter.ofPattern(format.toString());
        } else if (value instanceof LocalDate) {
            result = (LocalDate)value;
            formatter = DateTimeFormatter.ofPattern(format.toString());
        } else if (value instanceof LocalDateTime) {
            result = ((LocalDateTime)value).toLocalDate();
            formatter = DateTimeFormatter.ofPattern(format.toString());
        } else {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedDateType, (Object[])new Object[]{value.getClass(), "TO_CHAR"});
        }
        return formatter.format((TemporalAccessor)((Object)result));
    }

    @Override
    protected List<ScalarEvaluation> getChild() {
        return Lists.newArrayList((Object[])new ScalarEvaluation[]{this.left, this.right});
    }
}

