/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.optimize;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.ServerOption;
import kd.bos.flydb.common.config.ABCConfiguration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.interpreter.ScalarEvaluationCompiler;
import kd.bos.flydb.core.interpreter.bind.BindableAggregate;
import kd.bos.flydb.core.interpreter.bind.BindableFilter;
import kd.bos.flydb.core.interpreter.bind.BindableJoin;
import kd.bos.flydb.core.interpreter.bind.BindableNode;
import kd.bos.flydb.core.interpreter.bind.BindableProject;
import kd.bos.flydb.core.interpreter.bind.BindableSort;
import kd.bos.flydb.core.interpreter.bind.BindableTableScan;
import kd.bos.flydb.core.interpreter.bind.BindableUnion;
import kd.bos.flydb.core.interpreter.scalar.ScalarEvaluation;
import kd.bos.flydb.core.optimize.rbo.Planner;
import kd.bos.flydb.core.rel.Aggregate;
import kd.bos.flydb.core.rel.Filter;
import kd.bos.flydb.core.rel.Join;
import kd.bos.flydb.core.rel.Project;
import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rel.Sort;
import kd.bos.flydb.core.rel.TableScan;
import kd.bos.flydb.core.rel.Union;
import kd.bos.flydb.core.rex.BaseRexNodeVisitor;
import kd.bos.flydb.core.rex.BaseRexNodeVisitor1;
import kd.bos.flydb.core.rex.RexCall;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexLiteral;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.rex.RexSubQuery;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.TupleDataType;

public final class OptimizeHelp {
    private OptimizeHelp() {
    }

    public static BindableNode optimize(RelNode relNode) {
        relNode = OptimizeHelp.trim(relNode);
        BindableNode bindableNode = OptimizeHelp.optimize0(relNode);
        Context context = Contexts.get();
        ABCConfiguration configuration = ServerConfig.getSessionABCConfiguration((String)context.getSessionId());
        if (configuration.getBool((Option)ServerOption.EnableRBO).booleanValue()) {
            Planner planner = new Planner((RelNode)bindableNode);
            planner.optimize();
            bindableNode = (BindableNode)planner.getRoot();
        }
        return bindableNode;
    }

    public static BindableNode optimizeConstExpression(BindableNode bindableNode) {
        if (!bindableNode.getInputList().isEmpty()) {
            for (RelNode relNode : bindableNode.getInputList()) {
                OptimizeHelp.optimizeConstExpression((BindableNode)relNode);
            }
        }
        if (bindableNode instanceof BindableProject) {
            BindableProject bindableProject = (BindableProject)bindableNode.cast(BindableProject.class);
            for (int i = 0; i < bindableProject.exprList.size(); ++i) {
                RexNode rexNode = bindableProject.exprList.get(i);
                if (!rexNode.isConstExpression()) continue;
                Object value = OptimizeHelp.optimizeConstExpression0(rexNode);
                bindableProject.exprList.set(i, (RexNode)new RexLiteral(rexNode.getType(), value));
            }
        } else if (bindableNode instanceof BindableFilter) {
            BindableFilter bindableFilter = (BindableFilter)bindableNode.cast(BindableFilter.class);
            if (bindableFilter.condition.isConstExpression()) {
                Object value = OptimizeHelp.optimizeConstExpression0(bindableFilter.condition);
                bindableFilter.condition = new RexLiteral(bindableFilter.condition.getType(), value);
            }
        }
        return bindableNode;
    }

    private static Object optimizeConstExpression0(RexNode rexNode) {
        if (rexNode instanceof RexCall) {
            ScalarEvaluationCompiler scalarEvaluationCompiler = new ScalarEvaluationCompiler(Contexts.get());
            ScalarEvaluation compile = scalarEvaluationCompiler.compile(rexNode);
            return compile.eval(new Object[0]);
        }
        if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode.cast(RexLiteral.class);
            return rexLiteral.getValue();
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[]{rexNode.getClass().getName()});
    }

    private static BindableNode optimize0(RelNode relNode) {
        BindableNode bindableNode = OptimizeHelp.convert(relNode);
        if (bindableNode != null && !relNode.getInputList().isEmpty()) {
            List inputList = relNode.getInputList();
            ArrayList<BindableNode> bindableNodeList = new ArrayList<BindableNode>(inputList.size());
            for (RelNode value : inputList) {
                BindableNode node = OptimizeHelp.optimize0(value);
                bindableNodeList.add(node);
            }
            for (int i = 0; i < bindableNodeList.size(); ++i) {
                bindableNode.replaceInput(i, (RelNode)bindableNodeList.get(i));
            }
        }
        return bindableNode;
    }

    private static RelNode trim(RelNode root) {
        BitSet input = new BitSet();
        for (int i = 0; i < root.getRowType().getFieldCount(); ++i) {
            input.set(i);
        }
        return OptimizeHelp.trim0((RelNode)root, (BitSet)input).node;
    }

    /*
     * WARNING - void declaration
     */
    private static TrimResult trim0(RelNode node, BitSet input) {
        if (node instanceof Union) {
            Union union = (Union)node.cast(Union.class);
            TrimResult left = OptimizeHelp.trimSingleChild((RelNode)union, input, 0);
            TrimResult right = OptimizeHelp.trimSingleChild((RelNode)union, input, 1);
            HashMap<Integer, Integer> reMapper = new HashMap<Integer, Integer>();
            int sourceFieldCount = union.getRowType().getFieldCount();
            ArrayList<String> newFieldName = new ArrayList<String>(sourceFieldCount);
            ArrayList<DataType> newFieldType = new ArrayList<DataType>(sourceFieldCount);
            DataType sourceType = union.getRowType();
            for (int i = 0; i < input.size(); ++i) {
                if (!input.get(i)) continue;
                reMapper.put(i, newFieldName.size());
                DataTypeField field = sourceType.getField(i);
                newFieldName.add(field.getName());
                newFieldType.add(field.getType());
            }
            return new TrimResult((RelNode)new Union((List)Lists.newArrayList((Object[])new RelNode[]{left.node, right.node}), (DataType)new TupleDataType(sourceType.id(), newFieldName, newFieldType), union.isAll()), reMapper);
        }
        if (node instanceof Project) {
            RexRefMapper mapper;
            Project project = (Project)node.cast(Project.class);
            InputRefCollector collector = new InputRefCollector();
            for (int i = 0; i < project.exprList.size(); ++i) {
                if (!input.get(i)) continue;
                RexNode expr = project.exprList.get(i);
                expr.accept((RexNodeVisitor1)collector);
            }
            if (project.getInputList().isEmpty()) {
                HashMap<Integer, Integer> newMapping = new HashMap<Integer, Integer>();
                mapper = new RexRefMapper(newMapping);
                ArrayList<Object> newExprList = new ArrayList<Object>(project.exprList.size());
                for (int i = 0; i < project.exprList.size(); ++i) {
                    newMapping.put(i, i);
                    newExprList.add(project.exprList.get(i).accept((RexNodeVisitor)mapper));
                }
                return new TrimResult((RelNode)new Project(null, new RexNodeList(newExprList), project.getRowType()), newMapping);
            }
            TrimResult trimResult = OptimizeHelp.trimSingleChild((RelNode)project, collector.bitSet);
            mapper = new RexRefMapper(trimResult.mapper);
            ArrayList<Object> newExprList = new ArrayList<Object>(project.exprList.size());
            ArrayList<String> newNameList = new ArrayList<String>(project.exprList.size());
            ArrayList<DataType> newTypeList = new ArrayList<DataType>(project.exprList.size());
            List sourceFieldList = project.getRowType().getFieldList();
            HashMap<Integer, Integer> newMapping = new HashMap<Integer, Integer>();
            for (int i = 0; i < project.exprList.size(); ++i) {
                if (!input.get(i)) continue;
                newExprList.add(project.exprList.get(i).accept((RexNodeVisitor)mapper));
                newNameList.add(((DataTypeField)sourceFieldList.get(i)).getName());
                newTypeList.add(((DataTypeField)sourceFieldList.get(i)).getType());
                newMapping.put(i, newMapping.size());
            }
            return new TrimResult((RelNode)new Project(trimResult.node, new RexNodeList(newExprList), (DataType)new TupleDataType(project.getRowType().id(), newNameList, newTypeList)), newMapping);
        }
        if (node instanceof Sort) {
            Sort sort = (Sort)node.cast(Sort.class);
            if (sort.sortItemList.isEmpty()) {
                TrimResult trimResult = OptimizeHelp.trimSingleChild((RelNode)sort, input);
                return new TrimResult((RelNode)new Sort(trimResult.node, sort.offset, sort.limit, Collections.emptyList()), trimResult.mapper);
            }
            InputRefCollector collector = new InputRefCollector(input);
            for (Sort.SortItem sortItem : sort.sortItemList) {
                sortItem.expression.accept((RexNodeVisitor1)collector);
            }
            TrimResult trimResult = OptimizeHelp.trimSingleChild((RelNode)sort, collector.bitSet);
            RexRefMapper mapper = new RexRefMapper(trimResult.mapper);
            ArrayList<Sort.SortItem> newSortList = new ArrayList<Sort.SortItem>(sort.sortItemList.size());
            for (Sort.SortItem item1 : sort.sortItemList) {
                RexNode expr = (RexNode)item1.expression.accept((RexNodeVisitor)mapper);
                Sort.SortItem item2 = new Sort.SortItem(item1.ordering, expr);
                newSortList.add(item2);
            }
            return new TrimResult((RelNode)new Sort(trimResult.node, sort.offset, sort.limit, newSortList), trimResult.mapper);
        }
        if (node instanceof Filter) {
            Filter filter = (Filter)node.cast(Filter.class);
            if (filter.condition == null) {
                TrimResult trimResult = OptimizeHelp.trimSingleChild((RelNode)filter, input);
                return new TrimResult((RelNode)filter, trimResult.mapper);
            }
            InputRefCollector collector = new InputRefCollector(input);
            filter.condition.accept((RexNodeVisitor1)collector);
            TrimResult trimResult = OptimizeHelp.trimSingleChild((RelNode)filter, collector.bitSet);
            RexRefMapper mapper = new RexRefMapper(trimResult.mapper);
            RexNode condition2 = (RexNode)filter.condition.accept((RexNodeVisitor)mapper);
            return new TrimResult((RelNode)new Filter(trimResult.node, condition2), trimResult.mapper);
        }
        if (node instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)node.cast(Aggregate.class);
            int count = aggregate.groupList.size() + aggregate.aggCallList.size();
            BitSet bitSet = new BitSet();
            HashMap<Integer, Integer> newMapping = new HashMap<Integer, Integer>();
            for (int i = 0; i < count; ++i) {
                bitSet.set(i);
                newMapping.put(i, i);
            }
            OptimizeHelp.trimSingleChild((RelNode)aggregate, bitSet);
            return new TrimResult((RelNode)aggregate, newMapping);
        }
        if (node instanceof TableScan) {
            TableScan tableScan = (TableScan)node.cast(TableScan.class);
            ArrayList<Integer> projectList = new ArrayList<Integer>(tableScan.getRowType().getFieldCount());
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(tableScan.getRowType().getFieldCount());
            List fieldList = tableScan.getRowType().getFieldList();
            ArrayList<String> fieldNameList = new ArrayList<String>(fieldList.size());
            ArrayList<DataType> fieldTypeList = new ArrayList<DataType>(fieldList.size());
            if (input.isEmpty()) {
                input = new BitSet();
                input.set(0);
            }
            for (int i = 0; i < tableScan.getRowType().getFieldCount(); ++i) {
                if (!input.get(i)) continue;
                map.put(i, map.size());
                projectList.add(i);
                DataTypeField field = (DataTypeField)fieldList.get(i);
                fieldNameList.add(field.getName());
                fieldTypeList.add(field.getType());
            }
            int[] project = new int[projectList.size()];
            for (int i = 0; i < projectList.size(); ++i) {
                project[i] = (Integer)projectList.get(i);
            }
            BindableTableScan newTableScan = new BindableTableScan(tableScan.table, project, null, fieldNameList, fieldTypeList);
            return new TrimResult((RelNode)newTableScan, map);
        }
        if (node instanceof Join) {
            void var15_77;
            Join join = (Join)node.cast(Join.class);
            InputRefCollector collector = new InputRefCollector(input);
            if (join.condition != null) {
                join.condition.accept((RexNodeVisitor1)collector);
            }
            RelNode left = join.getInput(0);
            RelNode right = join.getInput(1);
            int leftCount = left.getRowType().getFieldCount();
            int rightCount = right.getRowType().getFieldCount();
            BitSet leftUsing = OptimizeHelp.getRange(collector.bitSet, 0, leftCount);
            TrimResult leftTrimResult = OptimizeHelp.trimSingleChild((RelNode)join, leftUsing, 0);
            BitSet rightUsing = OptimizeHelp.getRange(collector.bitSet, leftCount, leftCount + rightCount);
            TrimResult rightTrimResult = OptimizeHelp.trimSingleChild((RelNode)join, rightUsing, 1);
            HashMap<Integer, Integer> mapper = new HashMap<Integer, Integer>(32);
            for (Map.Entry<Integer, Integer> entry : leftTrimResult.mapper.entrySet()) {
                mapper.put(entry.getKey(), entry.getValue());
            }
            int newLeftCount = leftTrimResult.node.getRowType().getFieldCount();
            for (Map.Entry<Integer, Integer> entry : rightTrimResult.mapper.entrySet()) {
                mapper.put(entry.getKey() + leftCount, entry.getValue() + newLeftCount);
            }
            RexRefMapper rexRefMapper = new RexRefMapper(mapper);
            Object var15_75 = null;
            if (join.condition != null) {
                RexNode rexNode = (RexNode)join.condition.accept((RexNodeVisitor)rexRefMapper);
            }
            Join join2 = new Join(leftTrimResult.node, rightTrimResult.node, join.joinType, (RexNode)var15_77);
            return new TrimResult((RelNode)join2, mapper);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    private static BitSet getRange(BitSet bitSet, int start, int end) {
        BitSet result = new BitSet();
        for (int i = start; i < end; ++i) {
            if (!bitSet.get(i)) continue;
            result.set(i - start);
        }
        return result;
    }

    private static TrimResult trimSingleChild(RelNode node, BitSet inputBitSet) {
        return OptimizeHelp.trimSingleChild(node, inputBitSet, 0);
    }

    private static TrimResult trimSingleChild(RelNode node, BitSet inputBitSet, int i) {
        RelNode node1 = node.getInput(i);
        TrimResult trimResult = OptimizeHelp.trim0(node1, inputBitSet);
        if (node1 != trimResult.node) {
            node.replaceInput(i, trimResult.node);
        }
        return trimResult;
    }

    private static BindableNode convert(RelNode relNode) {
        if (relNode == null) {
            return null;
        }
        if (relNode instanceof BindableNode) {
            return (BindableNode)relNode.cast(BindableNode.class);
        }
        if (relNode instanceof TableScan) {
            return OptimizeHelp.convertTableScan((TableScan)relNode.cast(TableScan.class));
        }
        if (relNode instanceof Sort) {
            return OptimizeHelp.convertSort((Sort)relNode.cast(Sort.class));
        }
        if (relNode instanceof Project) {
            return OptimizeHelp.convertProject((Project)relNode.cast(Project.class));
        }
        if (relNode instanceof Join) {
            return OptimizeHelp.convertJoin((Join)relNode.cast(Join.class));
        }
        if (relNode instanceof Filter) {
            return OptimizeHelp.convertFilter((Filter)relNode.cast(Filter.class));
        }
        if (relNode instanceof Aggregate) {
            return OptimizeHelp.convertAggregate((Aggregate)relNode.cast(Aggregate.class));
        }
        if (relNode instanceof Union) {
            return OptimizeHelp.convertUnion((Union)relNode.cast(Union.class));
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected1, (Object[])new Object[]{relNode.getClass().getName()});
    }

    private static BindableNode convertUnion(Union union) {
        return new BindableUnion(union.getInputList(), union.getRowType(), union.all);
    }

    private static BindableNode convertTableScan(TableScan tableScan) {
        List fieldList = tableScan.getRowType().getFieldList();
        int[] project = new int[fieldList.size()];
        for (int i = 0; i < fieldList.size(); ++i) {
            project[i] = ((DataTypeField)fieldList.get(i)).getIndex();
        }
        return new BindableTableScan(tableScan.table, project, null, tableScan.getRowType());
    }

    private static BindableNode convertProject(Project project) {
        return new BindableProject(project.getInput(0), project.exprList, project.getRowType());
    }

    private static BindableSort convertSort(Sort sort) {
        return new BindableSort(sort.getInput(0), sort.offset, sort.limit, sort.sortItemList);
    }

    private static BindableJoin convertJoin(Join join) {
        return new BindableJoin(join.getInput(0), join.getInput(1), join.joinType, join.condition);
    }

    private static BindableFilter convertFilter(Filter filter) {
        return new BindableFilter(filter.getInput(0), filter.condition);
    }

    private static BindableAggregate convertAggregate(Aggregate aggregate) {
        return new BindableAggregate(aggregate.getInput(0), aggregate.groupList, aggregate.aggCallList, aggregate.getRowType());
    }

    private static class RexRefMapper
    extends BaseRexNodeVisitor<RexNode> {
        private final HashMap<Integer, Integer> mapping;

        public RexRefMapper(HashMap<Integer, Integer> mapping) {
            this.mapping = mapping;
        }

        protected RexNode visitChildren(RexNode rexNode) {
            if (rexNode instanceof RexCall) {
                return (RexNode)rexNode.accept((RexNodeVisitor)this);
            }
            if (rexNode instanceof RexNodeList) {
                return (RexNode)rexNode.accept((RexNodeVisitor)this);
            }
            if (rexNode instanceof RexInputRef) {
                return (RexNode)rexNode.accept((RexNodeVisitor)this);
            }
            if (rexNode instanceof RexSubQuery) {
                return (RexNode)rexNode.accept((RexNodeVisitor)this);
            }
            return rexNode;
        }

        public RexNode visitRexCall(RexCall call) {
            List list = call.getOperands();
            for (int i = 0; i < list.size(); ++i) {
                RexNode node1 = (RexNode)list.get(i);
                RexNode node2 = (RexNode)node1.accept((RexNodeVisitor)this);
                if (node2 == node1) continue;
                call.replaceOperand(i, node2);
            }
            call.buildDigest();
            return call;
        }

        public RexNode visitRexInputRef(RexInputRef inputRef) {
            return new RexInputRef(inputRef.getType(), this.mapping.get(inputRef.getIndex()).intValue());
        }

        public RexNode visitRexNodeList(RexNodeList nodeList) {
            if (nodeList == null || nodeList.isEmpty()) {
                return nodeList;
            }
            for (int i = 0; i < nodeList.size(); ++i) {
                RexNode item2;
                RexNode item1 = nodeList.get(i);
                if (item1 == (item2 = (RexNode)item1.accept((RexNodeVisitor)this))) continue;
                nodeList.set(i, item2);
            }
            return nodeList;
        }

        public RexNode visitRexSubQuery(RexSubQuery subQuery) {
            BindableNode sub = OptimizeHelp.optimize0(subQuery.getQuery());
            if (sub != subQuery.getQuery()) {
                subQuery.setQuery((RelNode)sub);
            }
            subQuery.buildDigest();
            return subQuery;
        }
    }

    private static class InputRefCollector
    extends BaseRexNodeVisitor1 {
        private BitSet bitSet = new BitSet();

        public InputRefCollector() {
        }

        public InputRefCollector(BitSet bitSet) {
            this.bitSet = bitSet;
        }

        public void visitRexInputRef(RexInputRef inputRef) {
            this.bitSet.set(inputRef.getIndex());
        }
    }

    private static class TrimResult {
        public final RelNode node;
        public final HashMap<Integer, Integer> mapper;

        public TrimResult(RelNode node, HashMap<Integer, Integer> mapper) {
            this.node = node;
            this.mapper = mapper;
        }
    }
}

