/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.parser;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.SqlSetOperator;
import kd.bos.flydb.core.sql.operator.SqlUnaryOperator;
import kd.bos.flydb.core.sql.parser.antlr4.SqlBaseVisitor;
import kd.bos.flydb.core.sql.parser.antlr4.SqlParser;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCaseWhenType;
import kd.bos.flydb.core.sql.tree.SqlConditionType;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlJoinType;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlNumericLiteral;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.tree.SqlShowVariables;
import kd.bos.flydb.core.sql.tree.SqlUse;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.util.KSqlTimeLiteralHandler;
import kd.bos.flydb.core.sql.util.Pair;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;

public class ASTBuilder
extends SqlBaseVisitor<SqlNode> {
    private final AtomicInteger parameterIndex = new AtomicInteger(0);

    public SqlNode visitQuerySpecification(SqlParser.QuerySpecificationContext ctx) {
        SqlNodeList keywordList = null;
        SqlNodeList selectList = this.handleSelectItem(ctx);
        SqlNode from = this.handleFrom(ctx);
        SqlNode where = this.handleCondition(ctx);
        SqlNodeList groupBy = this.handleGroupBy(ctx);
        SqlNode having = this.handleHaving(ctx);
        SqlNodeList windowDecls = null;
        SqlNodeList orderBy = null;
        SqlNode offset = null;
        SqlNode limit = null;
        SqlNodeList hints = null;
        return new SqlSelect(this.getPos((ParserRuleContext)ctx), keywordList, selectList, from, where, groupBy, having, windowDecls, orderBy, offset, limit, hints);
    }

    private SqlNodeList handleSelectItem(SqlParser.QuerySpecificationContext ctx) {
        SqlNodeList selects = new SqlNodeList(this.getPos((ParserRuleContext)ctx.selectItem().get(0)));
        for (SqlParser.SelectItemContext selectItem : ctx.selectItem()) {
            selects.add((SqlNode)selectItem.accept((ParseTreeVisitor)this));
        }
        return selects;
    }

    private SqlNode handleFrom(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.relation().size() > 1) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)this.getPos((ParserRuleContext)ctx.relation(1)), (Object[])new Object[]{"cross join"});
        }
        if (ctx.relation().size() == 1) {
            return (SqlNode)((SqlParser.RelationContext)ctx.relation().get(0)).accept((ParseTreeVisitor)this);
        }
        return null;
    }

    private SqlNode handleCondition(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.where == null) {
            return null;
        }
        return (SqlNode)ctx.where.accept((ParseTreeVisitor)this);
    }

    private SqlNodeList handleGroupBy(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.groupBy() == null) {
            return null;
        }
        return (SqlNodeList)ctx.groupBy().accept((ParseTreeVisitor)this);
    }

    private SqlNode handleHaving(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.having == null) {
            return null;
        }
        return (SqlNode)ctx.having.accept((ParseTreeVisitor)this);
    }

    public SqlNode visitSingleStatement(SqlParser.SingleStatementContext ctx) {
        return (SqlNode)ctx.statement().accept((ParseTreeVisitor)this);
    }

    public SqlNode visitQueryNoWith(SqlParser.QueryNoWithContext ctx) {
        SqlNode query = (SqlNode)ctx.queryTerm().accept((ParseTreeVisitor)this);
        SqlNodeList orderBy = null;
        SqlNumericLiteral offset = null;
        SqlNumericLiteral limit = null;
        if (ctx.sortItem() != null && ctx.sortItem().size() > 0) {
            ArrayList<Object> orderList = new ArrayList<Object>(ctx.sortItem().size());
            for (SqlParser.SortItemContext sortItemContext : ctx.sortItem()) {
                orderList.add(sortItemContext.accept((ParseTreeVisitor)this));
            }
            orderBy = new SqlNodeList(this.getPos((ParserRuleContext)ctx.sortItem(0)), orderList);
        }
        boolean i = false;
        if (ctx.LIMIT() != null) {
            List integerValues = ctx.INTEGER_VALUE();
            if (integerValues.size() == 1) {
                limit = new SqlNumericLiteral(this.getPos(ctx.INTEGER_VALUE(0).getSymbol()), Integer.valueOf(ctx.INTEGER_VALUE(0).getText()));
            } else {
                offset = new SqlNumericLiteral(this.getPos(ctx.INTEGER_VALUE(0).getSymbol()), Integer.valueOf(ctx.INTEGER_VALUE(0).getText()));
                limit = new SqlNumericLiteral(this.getPos(ctx.INTEGER_VALUE(1).getSymbol()), Integer.valueOf(ctx.INTEGER_VALUE(1).getText()));
            }
        }
        if (orderBy == null && offset == null && limit == null) {
            return query;
        }
        return new SqlOrderBy(this.getPos((ParserRuleContext)ctx), query, orderBy, offset, limit);
    }

    public SqlNode visitSortItem(SqlParser.SortItemContext ctx) {
        SqlNode sort = (SqlNode)ctx.expression().accept((ParseTreeVisitor)this);
        if (ctx.ordering == null) {
            return sort;
        }
        SqlKind sqlKind = SqlKind.ASCENDING;
        if (ctx.DESC() != null) {
            sqlKind = SqlKind.DESCENDING;
        }
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), new SqlNode[]{sort});
    }

    public SqlNode visitSelectSingle(SqlParser.SelectSingleContext ctx) {
        SqlNode select = (SqlNode)ctx.expression().accept((ParseTreeVisitor)this);
        SqlNode alias = null;
        if (ctx.identifier() != null) {
            alias = (SqlNode)ctx.identifier().accept((ParseTreeVisitor)this);
        }
        if (alias == null) {
            return select;
        }
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.AS, SqlOperators.of((SqlKind)SqlKind.AS), (List)Lists.newArrayList((Object[])new SqlNode[]{select, alias}));
    }

    private void handleNameParts(List<String> names, SqlNode node) {
        if (node instanceof SqlIdentifier) {
            names.addAll(((SqlIdentifier)node).getNames());
        } else if (node instanceof SqlNodeList) {
            SqlNodeList list = (SqlNodeList)node;
            for (SqlNode sqlNode : list) {
                this.handleNameParts(names, sqlNode);
            }
        }
    }

    public SqlNode visitDereference(SqlParser.DereferenceContext ctx) {
        ArrayList<String> names = new ArrayList<String>(ctx.children.size());
        for (ParseTree child : ctx.children) {
            SqlNode name = (SqlNode)child.accept((ParseTreeVisitor)this);
            this.handleNameParts(names, name);
        }
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), names);
    }

    public SqlNode visitColumnReference(SqlParser.ColumnReferenceContext ctx) {
        ArrayList<SqlNode> childNodeList = new ArrayList<SqlNode>();
        for (ParseTree child : ctx.children) {
            SqlNode name = (SqlNode)child.accept((ParseTreeVisitor)this);
            if (name == null) continue;
            childNodeList.add(name);
        }
        if (childNodeList.size() == 1) {
            return (SqlNode)childNodeList.get(0);
        }
        SqlNodeList sqlNodeList = new SqlNodeList(this.getPos((ParserRuleContext)ctx));
        sqlNodeList.addAll(childNodeList);
        return sqlNodeList;
    }

    public SqlNode visitParenthesizedExpression(SqlParser.ParenthesizedExpressionContext ctx) {
        return (SqlNode)this.visit((ParseTree)ctx.expression());
    }

    public SqlNode visitParameter(SqlParser.ParameterContext ctx) {
        return new SqlDynamicParam(this.getPos((ParserRuleContext)ctx), this.parameterIndex.getAndIncrement());
    }

    public SqlNode visitNullLiteral(SqlParser.NullLiteralContext ctx) {
        return new SqlLiteral(this.getPos((ParserRuleContext)ctx), null, DataTypeFactory.instance.buildNullType());
    }

    public SqlNode visitSelectAll(SqlParser.SelectAllContext ctx) {
        ArrayList<String> names = new ArrayList<String>();
        if (ctx.qualifiedName() != null) {
            SqlIdentifier identifier = (SqlIdentifier)ctx.qualifiedName().accept((ParseTreeVisitor)this);
            names.addAll(identifier.getNames());
        }
        if (ctx.ASTERISK() != null) {
            names.add("*");
        }
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), names);
    }

    public SqlNode visitUnquotedIdentifier(SqlParser.UnquotedIdentifierContext ctx) {
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new String[]{ctx.getText()}));
    }

    public SqlNode visitQuotedIdentifier(SqlParser.QuotedIdentifierContext ctx) {
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new String[]{ctx.getText()}));
    }

    public SqlNode visitBackQuotedIdentifier(SqlParser.BackQuotedIdentifierContext ctx) {
        String text = ctx.getText();
        text = text.substring(1, text.length() - 1);
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new String[]{text}));
    }

    public SqlNode visitDigitIdentifier(SqlParser.DigitIdentifierContext ctx) {
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new String[]{ctx.getText()}));
    }

    private SqlParserPosition getPos(ParserRuleContext parserRuleContext) {
        return new SqlParserPosition(parserRuleContext.getStart().getLine(), parserRuleContext.getStart().getStartIndex());
    }

    private SqlParserPosition getPos(Token token) {
        return new SqlParserPosition(token.getLine(), token.getStartIndex());
    }

    public SqlNode visitFunctionCall(SqlParser.FunctionCallContext ctx) {
        SqlIdentifier nameNode = (SqlIdentifier)ctx.qualifiedName().accept((ParseTreeVisitor)this);
        if (ctx.ASTERISK() != null) {
            SqlOperator operator = SqlOperators.unresolvedFunc((String)((String)nameNode.getNames().get(0)));
            return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.UNRESOLVED_FUNCTION, operator, new SqlNode[]{SqlIdentifier.createStar((SqlParserPosition)this.getPos(ctx.ASTERISK().getSymbol()))});
        }
        SqlOperator operator = SqlOperators.unresolvedFunc((String)((String)nameNode.getNames().get(0)));
        if (ctx.expression() != null) {
            ArrayList<Object> paramsNode = new ArrayList<Object>(ctx.expression().size());
            for (SqlParser.ExpressionContext expressionContext : ctx.expression()) {
                paramsNode.add(expressionContext.accept((ParseTreeVisitor)this));
            }
            return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.UNRESOLVED_FUNCTION, operator, paramsNode);
        }
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.UNRESOLVED_FUNCTION, operator, Collections.emptyList());
    }

    public SqlNode visitSimpleCase(SqlParser.SimpleCaseContext ctx) {
        SqlLiteral caseType = SqlCaseWhenType.SimpleCase.symbol(this.getPos((ParserRuleContext)ctx));
        SqlNode valueNode = null;
        Object elseNode = null;
        SqlParser.ValueExpressionContext valueExpressionContext = ctx.valueExpression();
        List whenClauseContexts = ctx.whenClause();
        if (valueExpressionContext != null) {
            valueNode = (SqlNode)valueExpressionContext.accept((ParseTreeVisitor)this);
        }
        ArrayList<Object> whenList = new ArrayList<Object>(whenClauseContexts.size());
        ArrayList<Object> thenList = new ArrayList<Object>(whenClauseContexts.size());
        for (SqlParser.WhenClauseContext whenClauseContext : whenClauseContexts) {
            whenList.add(whenClauseContext.condition.accept((ParseTreeVisitor)this));
            thenList.add(whenClauseContext.result.accept((ParseTreeVisitor)this));
        }
        SqlNodeList whenNodeList = new SqlNodeList(this.getPos((ParserRuleContext)((SqlParser.WhenClauseContext)whenClauseContexts.get((int)0)).condition), whenList);
        SqlNodeList thenNodeList = new SqlNodeList(this.getPos((ParserRuleContext)((SqlParser.WhenClauseContext)whenClauseContexts.get((int)0)).result), thenList);
        elseNode = ctx.elseExpression != null ? (SqlNode)ctx.elseExpression.accept((ParseTreeVisitor)this) : new SqlLiteral(this.getPos((ParserRuleContext)ctx), null, DataTypeFactory.instance.buildNullType());
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.CASE, SqlOperators.of((SqlKind)SqlKind.CASE), new SqlNode[]{caseType, valueNode, whenNodeList, thenNodeList, elseNode});
    }

    public SqlNode visitSearchedCase(SqlParser.SearchedCaseContext ctx) {
        SqlLiteral caseType = SqlCaseWhenType.SearchedCase.symbol(this.getPos((ParserRuleContext)ctx));
        Object elseNode = null;
        List whenClauseContexts = ctx.whenClause();
        ArrayList<Object> whenList = new ArrayList<Object>(whenClauseContexts.size());
        ArrayList<Object> thenList = new ArrayList<Object>(whenClauseContexts.size());
        for (SqlParser.WhenClauseContext whenClauseContext : whenClauseContexts) {
            whenList.add(whenClauseContext.condition.accept((ParseTreeVisitor)this));
            thenList.add(whenClauseContext.result.accept((ParseTreeVisitor)this));
        }
        SqlNodeList whenNodeList = new SqlNodeList(this.getPos((ParserRuleContext)((SqlParser.WhenClauseContext)whenClauseContexts.get((int)0)).condition), whenList);
        SqlNodeList thenNodeList = new SqlNodeList(this.getPos((ParserRuleContext)((SqlParser.WhenClauseContext)whenClauseContexts.get((int)0)).result), thenList);
        elseNode = ctx.elseExpression != null ? (SqlNode)ctx.elseExpression.accept((ParseTreeVisitor)this) : new SqlLiteral(this.getPos((ParserRuleContext)ctx), null, DataTypeFactory.instance.buildNullType());
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.CASE, SqlOperators.of((SqlKind)SqlKind.CASE), new SqlNode[]{caseType, whenNodeList, thenNodeList, elseNode});
    }

    public SqlNode visitDecimalLiteral(SqlParser.DecimalLiteralContext ctx) {
        return new SqlNumericLiteral(this.getPos((ParserRuleContext)ctx), new BigDecimal(ctx.DECIMAL_VALUE().getText()));
    }

    public SqlNode visitDoubleLiteral(SqlParser.DoubleLiteralContext ctx) {
        String numeric = ctx.DOUBLE_VALUE().getText();
        return new SqlNumericLiteral(this.getPos((ParserRuleContext)ctx), BigDecimal.valueOf(Double.parseDouble(numeric)));
    }

    public SqlNode visitIntegerLiteral(SqlParser.IntegerLiteralContext ctx) {
        String numeric = ctx.INTEGER_VALUE().getText();
        Long value = Long.parseLong(numeric);
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            return new SqlNumericLiteral(this.getPos((ParserRuleContext)ctx), value);
        }
        return new SqlNumericLiteral(this.getPos((ParserRuleContext)ctx), Integer.valueOf(value.intValue()));
    }

    public SqlNode visitBigIntLiteral(SqlParser.BigIntLiteralContext ctx) {
        String numeric = ctx.BIGINT_VALUE().getText();
        long value = Long.parseLong(numeric.substring(0, numeric.length() - 1));
        return new SqlNumericLiteral(this.getPos((ParserRuleContext)ctx), Long.valueOf(value));
    }

    public SqlNode visitKsqlTimeLiteral(SqlParser.KsqlTimeLiteralContext ctx) {
        String flag = ctx.IDENTIFIER().getText();
        String pattern = ctx.STRING().getText();
        Pair pair = KSqlTimeLiteralHandler.pair((String)flag, (String)pattern);
        return new SqlLiteral(this.getPos((ParserRuleContext)ctx), pair.getValue(), (DataType)pair.getType());
    }

    public SqlNode visitTypeConstructor(SqlParser.TypeConstructorContext ctx) {
        String typeName;
        SqlIdentifier type = (SqlIdentifier)ctx.identifier().accept((ParseTreeVisitor)this);
        SqlParserPosition pos = this.getPos((ParserRuleContext)ctx);
        String string = ctx.string().getText();
        switch (typeName = ((String)type.getNames().get(0)).toUpperCase(Locale.ENGLISH)) {
            case "TIME": 
            case "DATE": 
            case "DATETIME": {
                Pair pair = KSqlTimeLiteralHandler.pair((String)typeName, (String)string);
                return new SqlLiteral(pos, pair.getValue(), (DataType)pair.getType());
            }
        }
        throw new UnsupportedOperationException();
    }

    public SqlNode visitSpecialDateTimeFunction(SqlParser.SpecialDateTimeFunctionContext ctx) {
        if (ctx.precision != null) {
            throw new UnsupportedOperationException(ctx.name.getText());
        }
        switch (ctx.name.getType()) {
            case 42: {
                return new SqlLiteral(this.getPos((ParserRuleContext)ctx), (Object)LocalDate.now(), DataTypeFactory.instance.buildDate());
            }
            case 45: {
                return new SqlLiteral(this.getPos((ParserRuleContext)ctx), (Object)LocalDateTime.now(), DataTypeFactory.instance.buildDatetime());
            }
            case 111: {
                return new SqlLiteral(this.getPos((ParserRuleContext)ctx), (Object)LocalDateTime.now(), DataTypeFactory.instance.buildDatetime());
            }
            case 44: 
            case 110: {
                throw new UnsupportedOperationException(ctx.name.getText());
            }
        }
        throw new UnsupportedOperationException(ctx.name.getText());
    }

    public SqlNode visitBasicStringLiteral(SqlParser.BasicStringLiteralContext ctx) {
        String text = ctx.getText();
        text = text.substring(1, text.length() - 1);
        return new SqlLiteral(this.getPos((ParserRuleContext)ctx), (Object)text, DataTypeFactory.instance.buildString());
    }

    public SqlNode visitArithmeticUnary(SqlParser.ArithmeticUnaryContext ctx) {
        SqlNode value = (SqlNode)ctx.valueExpression().accept((ParseTreeVisitor)this);
        if (ctx.PLUS() != null) {
            return value;
        }
        SqlLiteral literal = new SqlLiteral(this.getPos((ParserRuleContext)ctx), (Object)"-");
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.UNARY, (SqlOperator)SqlUnaryOperator.operator, new SqlNode[]{literal, value});
    }

    public SqlNode visitArithmeticBinary(SqlParser.ArithmeticBinaryContext ctx) {
        SqlKind sqlKind = null;
        if (ctx.PLUS() != null) {
            sqlKind = SqlKind.PLUS;
        } else if (ctx.MINUS() != null) {
            sqlKind = SqlKind.MINUS;
        } else if (ctx.ASTERISK() != null) {
            sqlKind = SqlKind.TIMES;
        } else if (ctx.PERCENT() != null) {
            sqlKind = SqlKind.MOD;
        } else if (ctx.SLASH() != null) {
            sqlKind = SqlKind.DIVIDE;
        }
        ArrayList<Object> operandList = new ArrayList<Object>(ctx.valueExpression().size());
        for (SqlParser.ValueExpressionContext operand : ctx.valueExpression()) {
            operandList.add(operand.accept((ParseTreeVisitor)this));
        }
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), operandList);
    }

    public SqlNode visitLogicalBinary(SqlParser.LogicalBinaryContext ctx) {
        SqlKind sqlKind;
        if (ctx.AND() != null) {
            sqlKind = SqlKind.AND;
        } else if (ctx.OR() != null) {
            sqlKind = SqlKind.OR;
        } else {
            throw new UnsupportedOperationException();
        }
        ArrayList<Object> operandList = new ArrayList<Object>(2);
        for (SqlParser.BooleanExpressionContext booleanExpressionContext : ctx.booleanExpression()) {
            operandList.add(booleanExpressionContext.accept((ParseTreeVisitor)this));
        }
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), operandList);
    }

    public SqlNode visitTableName(SqlParser.TableNameContext ctx) {
        ArrayList names = new ArrayList(ctx.qualifiedName().identifier().size());
        for (SqlParser.IdentifierContext identifierContext : ctx.qualifiedName().identifier()) {
            SqlIdentifier node = (SqlIdentifier)identifierContext.accept((ParseTreeVisitor)this);
            names.addAll(node.getNames());
        }
        return new SqlIdentifier(this.getPos((ParserRuleContext)ctx), names);
    }

    public SqlNode visitAliasedRelation(SqlParser.AliasedRelationContext ctx) {
        SqlNode relation = (SqlNode)ctx.relationPrimary().accept((ParseTreeVisitor)this);
        if (ctx.identifier() != null) {
            SqlNode alias = (SqlNode)ctx.identifier().accept((ParseTreeVisitor)this);
            return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.AS, SqlOperators.of((SqlKind)SqlKind.AS), (List)Lists.newArrayList((Object[])new SqlNode[]{relation, alias}));
        }
        if (ctx.columnAliases() != null) {
            throw new UnsupportedOperationException();
        }
        return relation;
    }

    public SqlNode visitJoinRelation(SqlParser.JoinRelationContext ctx) {
        SqlLiteral joinTypeNode = null;
        SqlLiteral conditionTypeNode = null;
        SqlNode joinCriteria = null;
        SqlConditionType conditionType = null;
        if (ctx.NATURAL() != null) {
            conditionType = SqlConditionType.NATURAL;
        }
        if (ctx.CROSS() != null || ctx.JOIN() == null) {
            joinTypeNode = SqlJoinType.CROSS.symbol(this.getPos((ParserRuleContext)ctx));
            throw Exceptions.of((ErrorCode)ErrorCode.SyntaxError, (SqlParserPosition)this.getPos(ctx.CROSS().getSymbol()), (Object[])new Object[]{ctx.CROSS().getText()});
        }
        if (ctx.joinType() != null) {
            joinTypeNode = (SqlLiteral)ctx.joinType().accept((ParseTreeVisitor)this);
        }
        if (ctx.joinCriteria() != null) {
            if (ctx.joinCriteria().ON() != null) {
                conditionType = SqlConditionType.ON;
            }
            joinCriteria = (SqlNode)ctx.joinCriteria().accept((ParseTreeVisitor)this);
        }
        if (conditionType != null) {
            conditionTypeNode = conditionType.symbol(this.getPos((ParserRuleContext)ctx));
        }
        SqlNode left = (SqlNode)ctx.left.accept((ParseTreeVisitor)this);
        SqlNode right = ctx.right != null ? (SqlNode)ctx.right.accept((ParseTreeVisitor)this) : (SqlNode)ctx.rightRelation.accept((ParseTreeVisitor)this);
        return new SqlJoin(this.getPos((ParserRuleContext)ctx), left, joinTypeNode, conditionTypeNode, right, joinCriteria);
    }

    public SqlNode visitJoinCriteria(SqlParser.JoinCriteriaContext ctx) {
        return (SqlNode)ctx.booleanExpression().accept((ParseTreeVisitor)this);
    }

    public SqlNode visitJoinType(SqlParser.JoinTypeContext ctx) {
        if (ctx.INNER() != null) {
            return SqlJoinType.INNER.symbol(this.getPos((ParserRuleContext)ctx));
        }
        if (ctx.LEFT() != null) {
            return SqlJoinType.LEFT.symbol(this.getPos((ParserRuleContext)ctx));
        }
        if (ctx.RIGHT() != null) {
            return SqlJoinType.RIGHT.symbol(this.getPos((ParserRuleContext)ctx));
        }
        if (ctx.FULL() != null) {
            return SqlJoinType.FULL.symbol(this.getPos((ParserRuleContext)ctx));
        }
        throw new AssertionError((Object)ctx.getText());
    }

    public SqlNode visitPredicated(SqlParser.PredicatedContext ctx) {
        SqlNodeList nodeList;
        SqlNode left = (SqlNode)ctx.valueExpression.accept((ParseTreeVisitor)this);
        if (ctx.predicate() == null) {
            return left;
        }
        SqlNode right = (SqlNode)ctx.predicate().accept((ParseTreeVisitor)this);
        if (right instanceof SqlNodeList && !(nodeList = (SqlNodeList)right).isEmpty() && nodeList.get(0) instanceof SqlBasicCall) {
            SqlBasicCall call = (SqlBasicCall)nodeList.get(0);
            SqlKind callKind = call.getKind();
            if (callKind.isBelong(SqlKind.COMPARISON_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), new SqlNode[]{left, nodeList.get(1)});
            }
            if (callKind.isBelong(SqlKind.IN_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), new SqlNode[]{left, nodeList.get(1)});
            }
            if (call.isBelong(SqlKind.LIKE_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), new SqlNode[]{left, nodeList.get(1)});
            }
            if (call.isBelong(SqlKind.IS_NULL_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), new SqlNode[]{left});
            }
        }
        throw new UnsupportedOperationException("Unsupported Operation");
    }

    public SqlNode visitComparison(SqlParser.ComparisonContext ctx) {
        SqlNode call = (SqlNode)ctx.comparisonOperator().accept((ParseTreeVisitor)this);
        SqlNode right = (SqlNode)ctx.right.accept((ParseTreeVisitor)this);
        return new SqlNodeList(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new SqlNode[]{call, right}));
    }

    public SqlNode visitComparisonOperator(SqlParser.ComparisonOperatorContext ctx) {
        SqlKind sqlKind;
        if (ctx.EQ() != null) {
            sqlKind = SqlKind.EQUALS;
        } else if (ctx.NEQ() != null) {
            sqlKind = SqlKind.NOT_EQUALS;
        } else if (ctx.LT() != null) {
            sqlKind = SqlKind.LESS_THAN;
        } else if (ctx.LTE() != null) {
            sqlKind = SqlKind.LESS_THAN_OR_EQUALS;
        } else if (ctx.GT() != null) {
            sqlKind = SqlKind.GREATER_THAN;
        } else if (ctx.GTE() != null) {
            sqlKind = SqlKind.GREATER_THAN_OR_EQUALS;
        } else {
            throw new UnsupportedOperationException();
        }
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), Collections.emptyList());
    }

    public SqlNode visitBooleanValue(SqlParser.BooleanValueContext ctx) {
        return new SqlLiteral(this.getPos((ParserRuleContext)ctx), (Object)ctx.getText(), DataTypeFactory.instance.buildBoolean());
    }

    public SqlNode visitInList(SqlParser.InListContext ctx) {
        SqlKind sqlKind = SqlKind.IN;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.NOT_IN;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), Collections.emptyList());
        ArrayList<Object> inList = new ArrayList<Object>(ctx.expression().size());
        for (SqlParser.ExpressionContext expressionContext : ctx.expression()) {
            inList.add(expressionContext.accept((ParseTreeVisitor)this));
        }
        return new SqlNodeList(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new SqlNode[]{call, new SqlNodeList(this.getPos((ParserRuleContext)ctx.expression(0)), inList)}));
    }

    public SqlNode visitInSubquery(SqlParser.InSubqueryContext ctx) {
        SqlKind sqlKind = SqlKind.IN;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.NOT_IN;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), Collections.emptyList());
        return new SqlNodeList(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new SqlNode[]{call, (SqlNode)ctx.query().accept((ParseTreeVisitor)this)}));
    }

    public SqlNode visitSubqueryRelation(SqlParser.SubqueryRelationContext ctx) {
        return (SqlNode)ctx.query().accept((ParseTreeVisitor)this);
    }

    public SqlNode visitLike(SqlParser.LikeContext ctx) {
        SqlKind sqlKind = SqlKind.LIKE;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.NOT_LIKE;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), Collections.emptyList());
        if (ctx.ESCAPE() != null) {
            throw new UnsupportedOperationException();
        }
        return new SqlNodeList(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new SqlNode[]{call, (SqlNode)ctx.pattern.accept((ParseTreeVisitor)this)}));
    }

    public SqlNode visitNullPredicate(SqlParser.NullPredicateContext ctx) {
        SqlKind sqlKind = SqlKind.IS_NULL;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.IS_NOT_NULL;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), Collections.emptyList());
        return new SqlNodeList(this.getPos((ParserRuleContext)ctx), (List)Lists.newArrayList((Object[])new SqlNode[]{call}));
    }

    public SqlNode visitLogicalNot(SqlParser.LogicalNotContext ctx) {
        SqlKind sqlKind = SqlKind.NOT;
        SqlNode operand = (SqlNode)ctx.booleanExpression().accept((ParseTreeVisitor)this);
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, SqlOperators.of((SqlKind)sqlKind), new SqlNode[]{operand});
    }

    public SqlNode visitGroupBy(SqlParser.GroupByContext ctx) {
        ArrayList<Object> groupList = new ArrayList<Object>(ctx.groupingElement().size());
        for (SqlParser.GroupingElementContext elementContext : ctx.groupingElement()) {
            groupList.add(elementContext.accept((ParseTreeVisitor)this));
        }
        return new SqlNodeList(this.getPos((ParserRuleContext)ctx), groupList);
    }

    public SqlNode visitGroupingSet(SqlParser.GroupingSetContext ctx) {
        if (ctx.expression().size() > 1) {
            throw new UnsupportedOperationException();
        }
        return (SqlNode)ctx.expression(0).accept((ParseTreeVisitor)this);
    }

    public SqlNode visitCast(SqlParser.CastContext ctx) {
        SqlOperator operator = SqlOperators.of((SqlKind)SqlKind.FUNC_CAST);
        if (ctx.expression() == null) {
            throw new UnsupportedOperationException();
        }
        if (ctx.type() == null) {
            throw new UnsupportedOperationException();
        }
        SqlNode expression = (SqlNode)ctx.expression().accept((ParseTreeVisitor)this);
        SqlIdentifier type = (SqlIdentifier)ctx.type().accept((ParseTreeVisitor)this);
        if (type.getNames().size() > 1) {
            throw new UnsupportedOperationException("unsupported cast type");
        }
        SqlLiteral typeLiteral = new SqlLiteral(type.getPosition(), (Object)type.getLast(), DataTypeFactory.instance.buildString());
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), SqlKind.FUNC_CAST, operator, (List)Lists.newArrayList((Object[])new SqlNode[]{expression, typeLiteral}));
    }

    public SqlNode visitShowDatabases(SqlParser.ShowDatabasesContext ctx) {
        return new SqlShow(this.getPos((ParserRuleContext)ctx), SqlKind.SHOW_DATABASES);
    }

    public SqlNode visitShowSessions(SqlParser.ShowSessionsContext ctx) {
        return new SqlShow(this.getPos((ParserRuleContext)ctx), SqlKind.SHOW_SESSIONS);
    }

    public SqlNode visitShowColumns(SqlParser.ShowColumnsContext ctx) {
        SqlIdentifier from = null;
        if (ctx.qualifiedName() != null) {
            ArrayList names = new ArrayList(ctx.qualifiedName().identifier().size());
            for (SqlParser.IdentifierContext identifierContext : ctx.qualifiedName().identifier()) {
                SqlIdentifier node = (SqlIdentifier)identifierContext.accept((ParseTreeVisitor)this);
                names.addAll(node.getNames());
            }
            from = new SqlIdentifier(this.getPos((ParserRuleContext)ctx), names);
        }
        SqlNode where = ctx.where == null ? null : (SqlNode)ctx.where.accept((ParseTreeVisitor)this);
        return new SqlShow(this.getPos((ParserRuleContext)ctx), SqlKind.SHOW_COLUMNS, from, where);
    }

    public SqlNode visitShowTables(SqlParser.ShowTablesContext ctx) {
        SqlNode from = null;
        if (ctx.qualifiedName() != null) {
            from = (SqlNode)this.visitQualifiedName(ctx.qualifiedName());
        }
        SqlNode where = ctx.where == null ? null : (SqlNode)ctx.where.accept((ParseTreeVisitor)this);
        return new SqlShow(this.getPos((ParserRuleContext)ctx), SqlKind.SHOW_TABLES, from, where);
    }

    public SqlNode visitShowVariables(SqlParser.ShowVariablesContext ctx) {
        if (ctx.pattern == null) {
            return new SqlShowVariables(this.getPos((ParserRuleContext)ctx), ctx.GLOBAL() != null, null);
        }
        return new SqlShowVariables(this.getPos((ParserRuleContext)ctx), ctx.GLOBAL() != null, (SqlNode)ctx.pattern.accept((ParseTreeVisitor)this));
    }

    public SqlNode visitShowSchemas(SqlParser.ShowSchemasContext ctx) {
        SqlNode where = ctx.where == null ? null : (SqlNode)ctx.where.accept((ParseTreeVisitor)this);
        return new SqlShow(this.getPos((ParserRuleContext)ctx), SqlKind.SHOW_SCHEMAS, null, where);
    }

    public SqlNode visitUse(SqlParser.UseContext ctx) {
        ArrayList names = new ArrayList(ctx.identifier().size());
        for (SqlParser.IdentifierContext identifierContext : ctx.identifier()) {
            SqlIdentifier node = (SqlIdentifier)identifierContext.accept((ParseTreeVisitor)this);
            names.addAll(node.getNames());
        }
        return new SqlUse(this.getPos((ParserRuleContext)ctx), SqlKind.USE, names);
    }

    public SqlNode visitSetSessionVariable(SqlParser.SetSessionVariableContext ctx) {
        return new SqlSetVariable(this.getPos((ParserRuleContext)ctx), (SqlNode)ctx.key.accept((ParseTreeVisitor)this), (SqlNode)ctx.value.accept((ParseTreeVisitor)this));
    }

    public SqlNode visitSetOperation(SqlParser.SetOperationContext ctx) {
        SqlKind sqlKind;
        switch (ctx.operator.getType()) {
            case 202: {
                sqlKind = SqlKind.UNION;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SqlParser.SetQuantifierContext quantifier = ctx.setQuantifier();
        boolean isAll = quantifier != null && quantifier.ALL() != null;
        boolean isDistinct = quantifier != null && quantifier.DISTINCT() != null;
        SqlNode left = (SqlNode)ctx.left.accept((ParseTreeVisitor)this);
        SqlNode right = (SqlNode)ctx.right.accept((ParseTreeVisitor)this);
        String quantifierName = "";
        if (isAll) {
            quantifierName = " ALL";
        }
        if (isDistinct) {
            quantifierName = " DISTINCT";
        }
        SqlSetOperator sqlSetOperator = new SqlSetOperator(sqlKind.getName() + quantifierName, sqlKind, isAll);
        return new SqlBasicCall(this.getPos((ParserRuleContext)ctx), sqlKind, (SqlOperator)sqlSetOperator, new SqlNode[]{left, right});
    }

    public SqlNode visitSubquery(SqlParser.SubqueryContext ctx) {
        return (SqlNode)ctx.queryNoWith().accept((ParseTreeVisitor)this);
    }

    public SqlNode visitSubqueryExpression(SqlParser.SubqueryExpressionContext ctx) {
        return (SqlNode)ctx.query().accept((ParseTreeVisitor)this);
    }
}

