/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.embedding.kdai;

import kd.bos.gptas.adapter.embedding.kdai.service.KDAIEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.baidu.BaiduBgeLargeZhEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.baidu.BaiduEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.baidu.BaiduTao8KEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.doubao.DouBaoEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.doubao.DouBaoLargeEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.kingdee.KingdeeEmbeddingService;
import kd.bos.gptas.adapter.embedding.kdai.service.kingdeenew.KingdeeEmbedingNewService;
import kd.bos.gptas.adapter.embedding.kdai.service.openai.OpenAIEmbeddingService;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.embedding.EmbeddingFactory;
import kd.bos.gptas.common.embedding.exception.EmbeddingException;
import kd.bos.gptas.common.embedding.service.EmbeddingService;

public class KDAIEmbeddingFactory
implements EmbeddingFactory {
    public EmbeddingService getEmbeddingService(int dimension, String modelName) {
        KDAIEmbeddingService embeddingService;
        switch (modelName) {
            case "AZURE_EMBEDDING_ADA_002": {
                embeddingService = new OpenAIEmbeddingService(dimension);
                break;
            }
            case "BAIDU_EMBEDDING_V1": {
                embeddingService = new BaiduEmbeddingService(dimension);
                break;
            }
            case "BAIDU_EMBEDDING_BGE_LARGE_ZH": {
                embeddingService = new BaiduBgeLargeZhEmbeddingService(dimension);
                break;
            }
            case "BAIDU_EMBEDDING_TAO_8K": {
                embeddingService = new BaiduTao8KEmbeddingService(dimension);
                break;
            }
            case "KINGDEE_EMBEDDING": {
                embeddingService = new KingdeeEmbeddingService(dimension);
                break;
            }
            case "KINGDEE_EMBEDDING_NEW": {
                embeddingService = new KingdeeEmbedingNewService(dimension);
                break;
            }
            case "DOUBAO_EMBEDDING": {
                embeddingService = new DouBaoEmbeddingService(dimension);
                break;
            }
            case "DOUBAO_EMBEDDING_LARGE": {
                embeddingService = new DouBaoLargeEmbeddingService(dimension);
                break;
            }
            default: {
                throw new EmbeddingException(GptasErrorCode.EMBEDDING_MODEL_ERROR, "Unsupported embedding type: " + modelName);
            }
        }
        return embeddingService;
    }
}

