/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.embedding.kdai.service.doubao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.List;
import kd.bos.gptas.adapter.embedding.kdai.service.KDAIEmbeddingService;
import kd.bos.gptas.common.embedding.exception.EmbeddingException;
import kd.bos.gptas.common.embedding.model.EmbeddingVector;

public class DouBaoEmbeddingService
extends KDAIEmbeddingService {
    public static final int DIMENSION = 2560;
    public static final String MODEL_TYPE = "DOUBAO_EMBEDDING";

    public DouBaoEmbeddingService(int dimension) {
    }

    @Override
    protected List<EmbeddingVector> parseResponse(String response) throws EmbeddingException {
        JSONObject contentJson = JSON.parseObject((String)response);
        JSONArray jsonArray = contentJson.getJSONArray("data");
        ArrayList<EmbeddingVector> vectors = new ArrayList<EmbeddingVector>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            String embeddingString = jsonArray.getJSONObject(i).getString("embedding");
            List vectorData = (List)JSON.parseObject((String)embeddingString, (TypeReference)new TypeReference<List<Float>>(){}, (Feature[])new Feature[0]);
            EmbeddingVector vector = new EmbeddingVector();
            vector.setVector(vectorData);
            vector.setModel(MODEL_TYPE);
            vector.setDimension(2560);
            vectors.add(vector);
        }
        return vectors;
    }

    public String getModelType() {
        return MODEL_TYPE;
    }

    public int dimension() {
        return 2560;
    }

    public boolean supportBatch() {
        return false;
    }
}

