/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.rerank.kdai.service;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.adapter.rerank.kdai.service.KDAIRerankService;
import kd.bos.gptas.api.rerank.RerankResult;

public class HuaWeiRerankService
extends KDAIRerankService {
    public HuaWeiRerankService(String rerankNumber) {
        super(rerankNumber);
        this.MAX_BATCH_SIZE = 32;
    }

    @Override
    protected Map<String, Object> parseRequest(String content, int topK, List<String> documents) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("query", content);
        params.put("texts", documents);
        params.put("top_n", topK);
        return params;
    }

    @Override
    protected List<RerankResult> parseResponse(String response) {
        JSONArray jsonArray = JSONArray.parseArray((String)response);
        if (jsonArray == null || jsonArray.size() == 0) {
            return new ArrayList<RerankResult>(1);
        }
        ArrayList<RerankResult> rerankResults = new ArrayList<RerankResult>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            Float relevanceScore = jsonArray.getJSONObject(i).getFloat("score");
            Integer index = jsonArray.getJSONObject(i).getInteger("index");
            RerankResult rerankResult = new RerankResult();
            rerankResult.setRelevanceScore(relevanceScore.floatValue());
            rerankResult.setOriginIndex(index.intValue());
            rerankResult.setRank(i + 1);
            rerankResults.add(rerankResult);
        }
        return rerankResults;
    }
}

