/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.milvus.config;

import kd.bos.encrypt.Encrypters;
import kd.bos.session.SystemPropertyUtils;

public class MilvusConfig {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final int dimension;
    private final String embeddingName;
    private final long connectTimeoutMillis;
    private final long operationTimeoutMillis;

    private MilvusConfig(Builder builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.username = builder.username;
        this.password = builder.password;
        this.dimension = builder.dimension;
        this.embeddingName = builder.embeddingName;
        this.connectTimeoutMillis = builder.connectTimeoutMillis;
        this.operationTimeoutMillis = builder.operationTimeoutMillis;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String getEmbeddingName() {
        return this.embeddingName;
    }

    public long getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public long getOperationTimeoutMillis() {
        return this.operationTimeoutMillis;
    }

    public static Builder fromSystemProperties(String tenantId) {
        String host = SystemPropertyUtils.getProptyByTenant((String)"milvus.host", (String)tenantId);
        int port = SystemPropertyUtils.getInteger((String)tenantId, (String)"milvus.port", (Integer)19530);
        String username = SystemPropertyUtils.getProptyByTenant((String)"milvus.user", (String)tenantId);
        String password = SystemPropertyUtils.getProptyByTenant((String)"milvus.passwd", (String)tenantId);
        if (MilvusConfig.isEmpty(host) || MilvusConfig.isEmpty(username) || MilvusConfig.isEmpty(password)) {
            throw new IllegalStateException("Milvus configuration is incomplete. Required: milvus.host, milvus.user, milvus.passwd");
        }
        return new Builder().host(host).port(port).username(username).password(MilvusConfig.decodePassword(password));
    }

    private static boolean isEmpty(String text) {
        return text == null || text.trim().isEmpty();
    }

    private static String decodePassword(String password) {
        return Encrypters.isEncrypted((String)password) ? Encrypters.decode((String)password) : password;
    }

    public static class Builder {
        private String host;
        private int port = 19530;
        private String username;
        private String password;
        private int dimension = 1536;
        private String embeddingName;
        private long connectTimeoutMillis = 180000L;
        private long operationTimeoutMillis = 120000L;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder dimension(int dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder embeddingName(String embeddingName) {
            this.embeddingName = embeddingName;
            return this;
        }

        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder operationTimeoutMillis(long operationTimeoutMillis) {
            this.operationTimeoutMillis = operationTimeoutMillis;
            return this;
        }

        public MilvusConfig build() {
            return new MilvusConfig(this);
        }
    }
}

