/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.milvus.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.gptas.adapter.vectordb.milvus.config.MilvusConfig;
import kd.bos.gptas.adapter.vectordb.milvus.service.MilvusVectorStore;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.vectordb.exception.VectorException;
import kd.bos.gptas.common.vectordb.model.VectorChunk;
import kd.bos.gptas.common.vectordb.model.VectorQuery;
import kd.bos.gptas.common.vectordb.service.KnowledgeVectorStoreService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.Pair;

public class MilvusVectorStoreProxy
extends KnowledgeVectorStoreService {
    private static final Log log = LogFactory.getLog(MilvusVectorStoreProxy.class);
    private Map<String, MilvusVectorStore> milvusVectorStoreByFormId = new ConcurrentHashMap<String, MilvusVectorStore>();
    private final MilvusConfig config;

    public MilvusVectorStoreProxy(MilvusConfig config) {
        this.config = config;
    }

    public MilvusVectorStore initialize(String entityId) throws VectorException {
        log.info("Initializing new MilvusVectorStore for formId: {}", (Object)Objects.toString(entityId, "NULL"));
        try {
            MilvusVectorStore milvusVectorStore = new MilvusVectorStore(this.config, entityId);
            milvusVectorStore.initialize();
            log.info("Successfully initialized MilvusVectorStore for formId: {}", (Object)entityId);
            return milvusVectorStore;
        }
        catch (Exception e) {
            log.error("Failed to initialize MilvusVectorStore for formId: " + entityId, (Throwable)e);
            throw e;
        }
    }

    private MilvusVectorStore getMilvusVectorStore(String entityId) {
        boolean exists = this.milvusVectorStoreByFormId.containsKey(entityId);
        log.debug("Getting MilvusVectorStore for entityId: {}, exists: {}", (Object)entityId, (Object)exists);
        return this.milvusVectorStoreByFormId.computeIfAbsent(entityId, key -> this.initialize(entityId));
    }

    public List<VectorResult> doSearch(VectorQuery vectorQuery) throws VectorException {
        List entityIds = vectorQuery.getRepositoryIds();
        log.debug("Performing vector search across {} forms, topK: {}", (Object)entityIds.size(), (Object)vectorQuery.getTopK());
        List<VectorResult> result = entityIds.stream().flatMap(entityId -> {
            MilvusVectorStore milvusVectorStore = this.getMilvusVectorStore((String)entityId);
            return milvusVectorStore.doSearch(vectorQuery).stream();
        }).sorted(Comparator.comparingDouble(VectorResult::getScore)).limit(vectorQuery.getTopK()).collect(Collectors.toList());
        log.info("Search completed, found {} results across {} forms", (Object)result.size(), (Object)entityIds.size());
        return result;
    }

    public boolean store(VectorChunk vectorChunk) throws VectorException {
        return this.doStore(vectorChunk);
    }

    public boolean doStore(VectorChunk vectorChunk) throws VectorException {
        String entityId = vectorChunk.getChunk().getEntityId();
        log.debug("Storing single vector chunk for entityId: {}, chunkId: {}", (Object)entityId, (Object)vectorChunk.getChunk().getId());
        MilvusVectorStore milvusVectorStore = this.getMilvusVectorStore(entityId);
        boolean result = milvusVectorStore.store(vectorChunk);
        log.info("Vector chunk storage completed for entityId: {}, chunkId: {}, success: {}", new Object[]{entityId, vectorChunk.getChunk().getId(), result});
        return result;
    }

    public Pair<List<VectorChunk>, List<VectorChunk>> batchStore(List<VectorChunk> vectorChunks) throws VectorException {
        return this.doBatchStore(vectorChunks);
    }

    public Pair<List<VectorChunk>, List<VectorChunk>> doBatchStore(List<VectorChunk> vectorChunks) throws VectorException {
        log.debug("Starting batch store operation for {} chunks", (Object)vectorChunks.size());
        ArrayList successVectorChunks = new ArrayList();
        ArrayList failedVectorChunks = new ArrayList();
        LinkedHashMap<String, List> vectorChunksGroup = new LinkedHashMap<String, List>();
        for (VectorChunk vectorChunk : vectorChunks) {
            String formId = vectorChunk.getChunk().getEntityId();
            vectorChunksGroup.computeIfAbsent(formId, s -> new ArrayList()).add(vectorChunk);
        }
        log.debug("Grouped chunks into {} forms for batch storage", (Object)vectorChunksGroup.size());
        for (Map.Entry entry : vectorChunksGroup.entrySet()) {
            try {
                log.debug("Processing batch for formId: {}, chunks: {}", entry.getKey(), (Object)((List)entry.getValue()).size());
                MilvusVectorStore milvusVectorStore = this.getMilvusVectorStore((String)entry.getKey());
                Pair pair = milvusVectorStore.batchStore((List)entry.getValue());
                successVectorChunks.addAll((Collection)pair.getKey());
                failedVectorChunks.addAll((Collection)pair.getValue());
            }
            catch (VectorException e) {
                log.error("Batch storage failed for formId: " + (String)entry.getKey(), (Throwable)e);
                failedVectorChunks.addAll((Collection)entry.getValue());
            }
        }
        log.info("Batch store completed. Success: {}, Failed: {}", (Object)successVectorChunks.size(), (Object)failedVectorChunks.size());
        return new Pair(successVectorChunks, failedVectorChunks);
    }

    public void delete(String entityId, List<Long> chunkIds) throws VectorException {
        log.debug("Deleting {} chunks from entityId: {}", (Object)chunkIds.size(), (Object)entityId);
        MilvusVectorStore milvusVectorStore = this.getMilvusVectorStore(entityId);
        milvusVectorStore.delete(entityId, chunkIds);
    }

    public Map<String, List<?>> query(String entityId, List<Long> knowledgeIds, long start, long limit) {
        MilvusVectorStore milvusVectorStore = this.getMilvusVectorStore(entityId);
        return milvusVectorStore.query(entityId, knowledgeIds, start, limit);
    }

    public void deleteAll(String entityId) {
        MilvusVectorStore milvusVectorStore = this.getMilvusVectorStore(entityId);
        milvusVectorStore.deleteAll(entityId);
        this.milvusVectorStoreByFormId.remove(entityId);
    }

    public void close() {
        for (MilvusVectorStore milvusVectorStore : this.milvusVectorStoreByFormId.values()) {
            milvusVectorStore.close();
        }
    }

    public boolean supportVector() {
        return true;
    }

    public boolean supportFullText() {
        return false;
    }
}

