/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.vdb.service;

import java.util.List;
import kd.ai.vdb.Filter;
import kd.ai.vdb.objects.CollectionMeta;
import kd.ai.vdb.objects.DataType;
import kd.ai.vdb.objects.FieldMeta;
import kd.bos.gptas.adapter.vectordb.vdb.client.VDBClientWrapper;
import kd.bos.gptas.adapter.vectordb.vdb.service.VDBService;
import kd.bos.gptas.common.vectordb.model.VectorChunk;
import kd.bos.gptas.common.vectordb.model.VectorQuery;

class VDBCommonCollectionService
extends VDBService {
    private static final String KM_COLLECTION = "KM_COLLECTION";

    public VDBCommonCollectionService(VDBClientWrapper vdbClient, String formId) {
        super(vdbClient, formId);
    }

    @Override
    protected String getCollectionName() {
        return "KM_COLLECTION_" + this.vdbClient.getEmbeddingName() + "_" + this.vdbClient.getDimension();
    }

    @Override
    protected String getIDPrefix() {
        return this.collectionName;
    }

    @Override
    protected CollectionMeta buildCollectionMeta(String collectionName) {
        CollectionMeta collectionMeta = super.buildCollectionMeta(collectionName);
        collectionMeta.setName(this.getCollectionName());
        collectionMeta.addField(new FieldMeta("collectionName", DataType.STRING));
        return collectionMeta;
    }

    @Override
    protected List<Filter> getFilterList(VectorQuery query) {
        List<Filter> filters = super.getFilterList(query);
        filters.add(Filter.equal((String)"collectionName", (Object)this.collectionName));
        return filters;
    }

    @Override
    protected void doDelete(List<Long> chunkIds) {
        Object[] idArray = new Object[chunkIds.size()];
        for (int i = 0; i < chunkIds.size(); ++i) {
            idArray[i] = this.collectionName + "_" + chunkIds.get(i);
        }
        this.vdbClient.delete(this.getCollectionName(), idArray);
    }

    @Override
    protected Object[] createRowData(VectorChunk chunk) {
        Object[] row = super.createRowData(chunk);
        row[0] = this.collectionName + "_" + row[0];
        Object[] newRow = new Object[row.length + 1];
        System.arraycopy(row, 0, newRow, 0, row.length);
        newRow[row.length] = this.collectionName;
        return newRow;
    }

    @Override
    public void deleteAll(String entityId) {
        Filter filter = Filter.equal((String)"collectionName", (Object)this.collectionName);
        this.vdbClient.delete(this.getCollectionName(), filter);
    }
}

