/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.adapter.vectordb.vdb.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.vdb.objects.CollectionData;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.SimilarityType;
import kd.bos.gptas.api.vector.VectorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VDBServiceConverter {
    private static final Logger log = LoggerFactory.getLogger(VDBServiceConverter.class);
    private String formId;

    public VDBServiceConverter(String formId) {
        this.formId = formId;
    }

    public List<VectorResult> toVectorResults(CollectionData collectionData, String idPrefix) {
        int i;
        if (collectionData == null || collectionData.size() == 0) {
            log.debug("Empty CollectionData, returning empty result list");
            return Collections.emptyList();
        }
        ArrayList<VectorResult> results = new ArrayList<VectorResult>(collectionData.size());
        for (i = 0; i < collectionData.size(); ++i) {
            Object knowledgeIdObj;
            VectorResult result = new VectorResult();
            Chunk chunk = new Chunk();
            try {
                Object idObj = null;
                if (collectionData.getMeta().getIdField() != null) {
                    idObj = collectionData.getId(i);
                } else if (collectionData.getMeta().contains("_id")) {
                    idObj = collectionData.getValue(i, "_id");
                }
                if (idObj != null) {
                    if (idObj instanceof String) {
                        try {
                            String trueId = (String)idObj;
                            if (trueId.startsWith(idPrefix + "_")) {
                                trueId = trueId.substring(idPrefix.length() + 1);
                            }
                            chunk.setId(Long.valueOf(Long.parseLong(trueId)));
                        }
                        catch (NumberFormatException e) {
                            chunk.setId(Long.valueOf(idObj.hashCode()));
                        }
                    } else if (idObj instanceof Number) {
                        chunk.setId(Long.valueOf(((Number)idObj).longValue()));
                    }
                }
            }
            catch (Exception e) {
                log.debug("Unable to get ID for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            chunk.setEntityId(this.formId);
            try {
                if (collectionData.getMeta().contains("vector") && (knowledgeIdObj = collectionData.getValue(i, "vector")) instanceof float[]) {
                    float[] data = (float[])knowledgeIdObj;
                    ArrayList<Float> list = new ArrayList<Float>(data.length);
                    for (float f : data) {
                        list.add(Float.valueOf(f));
                    }
                    chunk.setVector(list);
                }
            }
            catch (Exception e) {
                log.debug("Unable to get vector for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            try {
                if (collectionData.getMeta().contains("title") && (knowledgeIdObj = collectionData.getValue(i, "title")) instanceof String) {
                    chunk.setTitle((String)knowledgeIdObj);
                }
            }
            catch (Exception e) {
                log.debug("Unable to get title for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            try {
                if (collectionData.getMeta().contains("knowledgeId") && (knowledgeIdObj = collectionData.getValue(i, "knowledgeId")) instanceof Number) {
                    chunk.setKnowledgeId(Long.valueOf(((Number)knowledgeIdObj).longValue()));
                }
            }
            catch (Exception e) {
                log.debug("Unable to get knowledgeId for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            try {
                Object chunkTypeObj;
                if (collectionData.getMeta().contains("repoId") && (chunkTypeObj = collectionData.getValue(i, "repoId")) instanceof String) {
                    chunk.setChunkType((String)chunkTypeObj);
                }
            }
            catch (Exception e) {
                log.debug("Unable to get chunkType for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            result.setChunk(chunk);
            try {
                Object scoreObj = null;
                if (collectionData.getMeta().getScoreField() != null) {
                    scoreObj = collectionData.getValue(i, collectionData.getMeta().getScoreField().getName());
                } else if (collectionData.getMeta().contains("_score")) {
                    scoreObj = collectionData.getValue(i, "_score");
                }
                if (scoreObj instanceof Number) {
                    result.setScore(((Number)scoreObj).floatValue());
                }
            }
            catch (Exception e) {
                log.debug("Unable to get score for row {}: {}", (Object)i, (Object)e.getMessage());
            }
            result.setSimilarityType(SimilarityType.COSINE.name());
            results.add(result);
        }
        results.sort((a, b) -> Float.compare(b.getScore(), a.getScore()));
        for (i = 0; i < results.size(); ++i) {
            ((VectorResult)results.get(i)).setRank(i + 1);
        }
        log.debug("Converted {} CollectionData rows to {} VectorResults", (Object)collectionData.size(), (Object)results.size());
        return results;
    }
}

