/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.api.vector;

import java.util.Objects;

public class KMSearchOption {
    private final boolean enabledRerank;
    private final String rerankNumber;
    private final boolean enabledChunkSeqRank;
    private final boolean enabledPermission;
    private final String appId;

    private KMSearchOption(Builder builder) {
        this.enabledRerank = builder.enabledRerank;
        this.rerankNumber = builder.rerankNumber;
        this.enabledChunkSeqRank = builder.enabledChunkSeqRank;
        this.enabledPermission = builder.enabledPermission;
        this.appId = builder.appId;
        this.validate();
    }

    private void validate() {
        if (this.enabledRerank && this.rerankNumber == null) {
            throw new IllegalStateException("When rerank is enabled, rerank model must not be empty");
        }
    }

    public boolean isEnabledRerank() {
        return this.enabledRerank;
    }

    public String getRerankNumber() {
        return this.rerankNumber;
    }

    public boolean isEnabledChunkSeqRank() {
        return this.enabledChunkSeqRank;
    }

    public boolean isEnabledPermission() {
        return this.enabledPermission;
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean hasValidAppId() {
        return this.appId != null && !this.appId.trim().isEmpty();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static KMSearchOption defaults() {
        return new Builder().build();
    }

    public static KMSearchOption withRerankOnly(String rerankNumber) {
        return KMSearchOption.builder().enableRerank(true).rerankName(rerankNumber).enabledChunkSeqRank(true).build();
    }

    public static KMSearchOption withPermissionOnly(String appId) {
        return KMSearchOption.builder().enablePermission(true).appId(appId).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KMSearchOption)) {
            return false;
        }
        KMSearchOption that = (KMSearchOption)o;
        return this.enabledRerank == that.enabledRerank && this.enabledPermission == that.enabledPermission && Objects.equals(this.appId, that.appId);
    }

    public int hashCode() {
        return Objects.hash(this.enabledRerank, this.enabledPermission, this.appId);
    }

    public String toString() {
        return "KMSearchOption{enabledRerank=" + this.enabledRerank + ", enabledPermission=" + this.enabledPermission + ", appId='" + this.appId + '\'' + '}';
    }

    public static class Builder {
        private boolean enabledRerank;
        private String rerankNumber;
        private boolean enabledChunkSeqRank;
        private boolean enabledPermission;
        private String appId;

        private Builder() {
        }

        public Builder enableRerank(boolean enabled) {
            this.enabledRerank = enabled;
            return this;
        }

        public Builder rerankName(String rerankNumber) {
            this.rerankNumber = rerankNumber;
            return this;
        }

        public Builder enabledChunkSeqRank(boolean enabled) {
            this.enabledChunkSeqRank = enabled;
            return this;
        }

        public Builder enablePermission(boolean enabled) {
            this.enabledPermission = enabled;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public KMSearchOption build() {
            return new KMSearchOption(this);
        }
    }
}

