/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.km.base.GroupTreeNode;
import kd.ai.km.service.KMDataService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.id.ID;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TemplateGroupTreeEditPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(TemplateGroupTreeEditPlugin.class);
    private static final KMDataService kmDataService = KMDataService.create();
    private static final String TREE_COLUMNS = "id,number,longnumber,name,level,parent,visiblerange,visiblerole_tag,visibleorg_tag,visibleuser_tag,effectivelogic";
    private static final String FLEX_PANEL_AP = "flexpanelap";
    private static final String FLEX_PANEL_NODATA = "flexpanelnodata";
    private static final String NODE_KEY = "nodeKey";
    private static final String TREE_NODE_DATA_EDIT = "tree_node_data_edit";
    private static final String CURRENT_TREE_NODE = "current_tree_node";
    private static final String MULBASEDATAUSER = "mulbasedatauser";
    private static final String COMBOFIELD = "combofield";
    private static final String MULBASEDATAROLE = "mulbasedatarole";
    private static final String MULBASEDATAORG = "mulbasedataorg";
    private static final String RADIOGROUPFIELD = "radiogroupfield";
    private static final String PUBLIC = "public";
    private static final String DETETE_NODE_ID = "detete_node_id";
    private static final String DETETE_NEW_DATA_NODE_ID = "detete_new_data_node_id";
    private static final String DELETE_NODE_CALL_BACK = "deleteNodeCallBack";
    private static final String GROUP_ENTITY = "groupEntity";
    public static final String VISIBLEROLE = "visiblerole_tag";
    public static final String VISIBLEORG = "visibleorg_tag";
    public static final String VISIBLEUSER = "visibleuser_tag";
    private static final String PARENT_KEY = "parentKey";
    private static final String PARENT_LONG_NUMBER = "parentLongNumber";
    private static final String LONG_NUMBER = "longNumber";
    private CustomControl customControl;

    public void initialize() {
        super.initialize();
        this.customControl = (CustomControl)this.getView().getControl("customcontrolap");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl(MULBASEDATAORG);
        if (orgEdit != null) {
            orgEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    evt.getFormShowParameter().setCustomParam("orgFuncId", (Object)"01");
                }
            });
        }
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        List enabledLangs = InteServiceHelper.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangs) {
            if (enabledLang.number.equals(RequestContext.get().getLang().name())) {
                enabledLang.setIsDefault(Boolean.valueOf(true));
                continue;
            }
            enabledLang.setIsDefault(Boolean.valueOf(false));
        }
        data.put("enabledLangs", enabledLangs);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String selectedId = (String)formShowParameter.getCustomParam("currentGroupId");
        List<GroupTreeNode> treeNodes = this.buildTreeNodes(formShowParameter);
        if (StringUtils.isBlank((CharSequence)selectedId) || treeNodes.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_AP});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_NODATA, "flexpanelap3", "flexpanelap6"});
        }
        data.put("treeNodes", treeNodes);
        String groupEntity = (String)formShowParameter.getCustomParam(GROUP_ENTITY);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)groupEntity);
        DataEntityPropertyCollection properties = type.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property.getParent() instanceof MainEntityType) || !(property instanceof ParentBasedataProp)) continue;
            data.put("longNumberDLM", ((ParentBasedataProp)property).getLongNumberDLM());
            break;
        }
        this.customControl.setData(data);
    }

    private List<GroupTreeNode> buildTreeNodes(FormShowParameter formShowParameter) {
        String groupEntity = (String)formShowParameter.getCustomParam(GROUP_ENTITY);
        String useOrg = (String)formShowParameter.getCustomParam("useOrg");
        if (StringUtils.isNotEmpty((CharSequence)useOrg)) {
            QFilter groupFilter = new QFilter("createorg.id", "=", (Object)Long.parseLong(useOrg));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)groupEntity, (String)TREE_COLUMNS, (QFilter[])new QFilter[]{groupFilter.and("status", "=", (Object)"C").and("enable", "=", (Object)"1")}, (String)"createtime desc");
            return this.buildTreeData(dynamicObjects, (String)formShowParameter.getCustomParam("currentGroupId"));
        }
        return Collections.emptyList();
    }

    private List<GroupTreeNode> buildTreeData(DynamicObject[] dynamicObjects, String selectedId) {
        ArrayList<GroupTreeNode> treeNodes = new ArrayList<GroupTreeNode>(dynamicObjects.length);
        LinkedHashMap<String, GroupTreeNode> nodes = new LinkedHashMap<String, GroupTreeNode>(dynamicObjects.length);
        for (DynamicObject value : dynamicObjects) {
            GroupTreeNode node = new GroupTreeNode();
            String key = value.get("id") + "";
            node.setId(key);
            node.setKey(key);
            ILocaleString name = value.getLocaleString("name");
            if (name != null) {
                node.setText(name.getLocaleValue());
                node.setName((OrmLocaleValue)name);
            }
            node.setParentid(value.getString("parent.id"));
            if (key.equals(selectedId)) {
                node.setSelected(true);
            }
            node.setLongNumber(value.getString("longnumber"));
            node.setVisiblerange(value.getString("visiblerange"));
            node.setChildren(new ArrayList<GroupTreeNode>());
            nodes.put(key, node);
        }
        for (Map.Entry entry : nodes.entrySet()) {
            GroupTreeNode value = (GroupTreeNode)entry.getValue();
            if (StringUtils.isNotBlank((CharSequence)value.getParentid()) && !"0".equals(value.getParentid())) {
                GroupTreeNode parent = (GroupTreeNode)nodes.get(value.getParentid());
                parent.getChildren().add(value);
                continue;
            }
            treeNodes.add(value);
        }
        return treeNodes;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        JSONObject params = JSON.parseObject((String)e.getEventArgs());
        switch (eventName) {
            case "selectNode": {
                this.selectNode(params);
                break;
            }
            case "addTreeNodeData": {
                this.addTreeNodeData(params);
                break;
            }
            case "getTreeNodeId": {
                this.getTreeNodeId(params);
                break;
            }
            case "tryMutexLock": {
                this.tryMutexLock(params);
                break;
            }
            case "deleteNode": {
                this.deleteNode(params);
                break;
            }
            case "saveData": {
                this.doSaveData(params);
                break;
            }
            case "showMsg": {
                this.showMsg(params);
                break;
            }
        }
    }

    private void showMsg(JSONObject params) {
        if ("warn".equals(params.getString("type"))) {
            this.getView().showTipNotification(params.getString("text"));
        }
    }

    private void doSaveData(JSONObject params) {
        String dataString;
        JSONObject jsonObject = params.getJSONObject("langValues");
        if (jsonObject != null && !jsonObject.isEmpty()) {
            for (String s : jsonObject.keySet()) {
                JSONObject saveData = new JSONObject();
                saveData.put("type", (Object)"add");
                saveData.put("langs", (Object)jsonObject.getJSONObject(s));
                saveData.put(NODE_KEY, (Object)s);
                this.saveDataToCache(saveData);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(dataString = this.getPageCache().get(TREE_NODE_DATA_EDIT)))) {
            JSONObject data = JSON.parseObject((String)dataString);
            String groupEntity = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ENTITY);
            String useOrg = (String)this.getView().getFormShowParameter().getCustomParam("useOrg");
            ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> addData = new ArrayList<DynamicObject>();
            ArrayList<Map<String, Object>> mutexRequireList = new ArrayList<Map<String, Object>>(4);
            List collect = data.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)groupEntity, (String)TREE_COLUMNS, (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
            for (DynamicObject value : dynamicObjects) {
                String key = value.get("id") + "";
                JSONObject object = data.getJSONObject(key);
                if (object == null) continue;
                TemplateGroupTreeEditPlugin.buildMutexInfo(key, groupEntity, mutexRequireList);
                TemplateGroupTreeEditPlugin.buildDynamicObject(value, object, useOrg, "");
                updateData.add(value);
                data.remove((Object)key);
            }
            for (String key : data.keySet()) {
                JSONObject object = data.getJSONObject(key);
                if (!"add".equals(object.getString("type")) && !"addChild".equals(object.getString("type")) || object.getJSONObject("langs") == null) continue;
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)groupEntity);
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)type);
                TemplateGroupTreeEditPlugin.buildDynamicObject(dynamicObject, object, useOrg, "add");
                addData.add(dynamicObject);
            }
            if (!updateData.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
                this.releaseMutexLock(mutexRequireList);
            }
            if (!addData.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addData.toArray(new DynamicObject[0]));
            }
        }
        this.getView().returnDataToParent((Object)"dook");
        this.getView().close();
        IFormView parentView = this.getView().getParentView();
        parentView.updateView();
        this.getView().sendFormAction(parentView);
    }

    private void deleteNode(JSONObject params) {
        this.getPageCache().put(DETETE_NODE_ID, params.getString("id"));
        this.getPageCache().put(DETETE_NEW_DATA_NODE_ID, params.getJSONArray("newDataKey").toJSONString());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u6811\u8282\u70b9\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"TemplateGroupTreeEditPlugin_0", (String)"ai-km", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETE_NODE_CALL_BACK));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (DELETE_NODE_CALL_BACK.equals(event.getCallBackId())) {
            HashMap<String, Object> data = new HashMap<String, Object>(8);
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                this.doNodeDelete(data);
            }
            data.put("time", System.currentTimeMillis());
            this.customControl.setData(data);
        }
    }

    private void doNodeDelete(Map<String, Object> data) {
        String deleteId = this.getPageCache().get(DETETE_NODE_ID);
        String groupEntity = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ENTITY);
        DynamicObject managerEntity = kmDataService.getManagerByGroupEntityNumber(groupEntity);
        boolean isKnlExsit = kmDataService.isKnlExsit(managerEntity.getString("number"), Long.parseLong(deleteId));
        if (isKnlExsit) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u76ee\u5f55\u4e0b\u5b58\u5728\u76f8\u5173\u77e5\u8bc6\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"TemplateGroupTreeEditPlugin_1", (String)"ai-km", (Object[])new Object[0]));
            return;
        }
        List<Long> allSubGroupIds = kmDataService.getAllSubGroupIds(groupEntity, Long.parseLong(deleteId));
        String s = this.getPageCache().get(TREE_NODE_DATA_EDIT);
        if (!StringUtils.isBlank((CharSequence)s)) {
            JSONObject jsonObject = JSON.parseObject((String)s);
            String newDataKeys = this.getPageCache().get(DETETE_NEW_DATA_NODE_ID);
            JSONArray jsonArray = JSON.parseArray((String)newDataKeys);
            if (jsonArray != null && !jsonArray.isEmpty()) {
                for (Object o : jsonArray) {
                    jsonObject.remove((Object)(o + ""));
                }
            }
            jsonObject.remove((Object)deleteId);
            this.getPageCache().put(TREE_NODE_DATA_EDIT, jsonObject.toJSONString());
        }
        DeleteServiceHelper.delete((String)groupEntity, (QFilter[])new QFilter[]{new QFilter("id", "in", allSubGroupIds)});
        data.put("delete", 1);
    }

    private void tryMutexLock(JSONObject params) {
        String id = params.getString("id");
        MutexLockInfo mutexLockInfo = new MutexLockInfo();
        String groupEntity = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ENTITY);
        mutexLockInfo.setEntityNumber(groupEntity);
        mutexLockInfo.setDataObjId(id);
        mutexLockInfo.setDataObjNumber(id);
        mutexLockInfo.setOperationKey("modify");
        StringBuilder builder = new StringBuilder();
        boolean required = MutexHelper.require((MutexLockInfo)mutexLockInfo, (StringBuilder)builder);
        if (!required) {
            this.getView().showMessage(builder.toString());
        }
        HashMap<String, Comparable<Boolean>> data = new HashMap<String, Comparable<Boolean>>(8);
        data.put("required", Boolean.valueOf(required));
        data.put("time", Long.valueOf(System.currentTimeMillis()));
        this.customControl.setData(data);
    }

    private void getTreeNodeId(JSONObject param) {
        String currentId = ID.genLongId() + "";
        this.getPageCache().put(CURRENT_TREE_NODE, currentId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)"add");
        jsonObject.put(NODE_KEY, (Object)currentId);
        if (StringUtils.isNotBlank((CharSequence)param.getString(PARENT_KEY))) {
            jsonObject.put(PARENT_KEY, (Object)param.getString(PARENT_KEY));
        }
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)param.getString(PARENT_LONG_NUMBER))) {
            builder.append(param.getString(PARENT_LONG_NUMBER)).append(param.getString("longNumberDLM"));
        }
        builder.append(currentId);
        jsonObject.put(LONG_NUMBER, (Object)builder.toString());
        this.saveDataToCache(jsonObject);
        this.getPageCache().put(CURRENT_TREE_NODE, currentId);
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("treeNodeId", currentId);
        data.put(LONG_NUMBER, builder.toString());
        this.customControl.setData(data);
    }

    private void addTreeNodeData(JSONObject eventArgs) {
        if (!eventArgs.isEmpty() && !eventArgs.getJSONObject("langs").isEmpty()) {
            JSONObject langs = eventArgs.getJSONObject("langs");
            String name = Lang.defaultLang().name();
            this.setLabelName(langs.getString(name));
            this.saveDataToCache(eventArgs);
            return;
        }
        this.getModel().setValue(COMBOFIELD, (Object)PUBLIC);
        this.getModel().setValue(MULBASEDATAROLE, null);
        this.getModel().setValue(MULBASEDATAUSER, null);
        this.getModel().setValue(MULBASEDATAORG, null);
        this.getModel().setValue(RADIOGROUPFIELD, (Object)"2");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_NODATA});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_PANEL_AP});
    }

    private void saveDataToCache(JSONObject eventArgs) {
        String visiblerange = PUBLIC;
        switch (eventArgs.getString("type")) {
            case "add": 
            case "addChild": {
                JSONObject jsonObject = this.getJSONObjectByCache();
                JSONObject data = jsonObject.getJSONObject(eventArgs.getString(NODE_KEY));
                if (data != null) {
                    data.put("langs", eventArgs.get((Object)"langs"));
                    visiblerange = data.getString(COMBOFIELD);
                } else {
                    eventArgs.put(COMBOFIELD, (Object)visiblerange);
                    eventArgs.put(RADIOGROUPFIELD, (Object)"2");
                    jsonObject.put(eventArgs.getString(NODE_KEY), (Object)eventArgs);
                }
                this.getPageCache().put(TREE_NODE_DATA_EDIT, jsonObject.toJSONString());
                break;
            }
            case "edit": {
                JSONObject nodeDataEdit = this.getJSONObjectByCache();
                JSONObject object = nodeDataEdit.getJSONObject(eventArgs.getString(NODE_KEY));
                if (object == null) break;
                object.put("langs", eventArgs.get((Object)"langs"));
                visiblerange = object.getString(COMBOFIELD);
                nodeDataEdit.put(eventArgs.getString(NODE_KEY), (Object)object);
                this.getPageCache().put(TREE_NODE_DATA_EDIT, nodeDataEdit.toJSONString());
                break;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("visiblerange", visiblerange);
        map.put("time", System.currentTimeMillis());
        this.customControl.setData(map);
        this.getPageCache().put(CURRENT_TREE_NODE, eventArgs.getString(NODE_KEY));
    }

    private JSONObject getJSONObjectByCache() {
        String treeNodeDataAdd = this.getPageCache().get(TREE_NODE_DATA_EDIT);
        JSONObject json = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)treeNodeDataAdd)) {
            json = JSON.parseObject((String)treeNodeDataAdd);
        }
        return json;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "combofield": {
                Object visibleRange = e.getChangeSet()[0].getNewValue();
                this.getView().setVisible(Boolean.valueOf(!PUBLIC.equals(visibleRange)), new String[]{"flexpanelap3", "flexpanelap6"});
                this.getView().updateView();
                this.updateDataToCache(e, name);
                break;
            }
            case "mulbasedatauser": 
            case "mulbasedataorg": 
            case "mulbasedatarole": 
            case "radiogroupfield": {
                this.updateDataToCache(e, name);
                break;
            }
        }
    }

    private void updateDataToCache(PropertyChangedArgs e, String name) {
        String currentKey = this.getPageCache().get(CURRENT_TREE_NODE);
        if (StringUtils.isBlank((CharSequence)currentKey)) {
            return;
        }
        String data = this.getPageCache().get(TREE_NODE_DATA_EDIT);
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        JSONObject dataObj = JSON.parseObject((String)data);
        JSONObject object = dataObj.getJSONObject(currentKey);
        Object newValue = e.getChangeSet()[0].getNewValue();
        this.putValueToCache(newValue, object, name, dataObj, currentKey);
    }

    private void putValueToCache(Object newValue, JSONObject object, String name, JSONObject dataObj, String currentKey) {
        if (newValue instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)newValue;
            List collect = collection.stream().map(v -> {
                if (v.get(2) != null) {
                    return v.get(2).toString();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            object.put(name, collect);
        }
        if (newValue instanceof String) {
            object.put(name, newValue);
        }
        dataObj.put(currentKey, (Object)object);
        this.getPageCache().put(TREE_NODE_DATA_EDIT, dataObj.toJSONString());
    }

    private void selectNode(JSONObject eventArgs) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_PANEL_AP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL_NODATA});
        String key = eventArgs.getString("key");
        this.getPageCache().put(CURRENT_TREE_NODE, key);
        String groupEntity = (String)this.getView().getFormShowParameter().getCustomParam(GROUP_ENTITY);
        String s = this.getPageCache().get(TREE_NODE_DATA_EDIT);
        JSONObject current = null;
        JSONObject data = null;
        if (StringUtils.isNotBlank((CharSequence)s)) {
            data = JSON.parseObject((String)s);
            current = data.getJSONObject(key);
        }
        if (current == null) {
            String user;
            String org;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)groupEntity, (String)TREE_COLUMNS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(key))});
            if (dynamicObject == null) {
                return;
            }
            current = new JSONObject();
            current.put(NODE_KEY, (Object)(dynamicObject.getLong("id") + ""));
            current.put(PARENT_KEY, (Object)(dynamicObject.getLong("parent.id") + ""));
            current.put("langs", (Object)dynamicObject.getLocaleString("name"));
            current.put("type", (Object)"edit");
            current.put(COMBOFIELD, (Object)dynamicObject.getString("visiblerange"));
            String role = dynamicObject.getString(VISIBLEROLE);
            if (StringUtils.isNotBlank((CharSequence)role)) {
                String[] split = role.split(",");
                current.put(MULBASEDATAROLE, (Object)split);
            }
            if (StringUtils.isNotBlank((CharSequence)(org = dynamicObject.getString(VISIBLEORG)))) {
                String[] split = org.split(",");
                current.put(MULBASEDATAORG, (Object)split);
            }
            if (StringUtils.isNotBlank((CharSequence)(user = dynamicObject.getString(VISIBLEUSER)))) {
                String[] split = user.split(",");
                current.put(MULBASEDATAUSER, (Object)split);
            }
            current.put(RADIOGROUPFIELD, (Object)dynamicObject.getString("effectivelogic"));
            if (data == null) {
                data = new JSONObject();
            }
            data.put(key, (Object)current);
            this.getPageCache().put(TREE_NODE_DATA_EDIT, data.toJSONString());
        }
        this.getView().setVisible(Boolean.valueOf(!PUBLIC.equals(current.getString(COMBOFIELD))), new String[]{"flexpanelap3", "flexpanelap6"});
        this.setLabelName(eventArgs.getString("text"));
        this.getModel().setValue(COMBOFIELD, (Object)current.getString(COMBOFIELD));
        this.setRoleValue(current);
        this.setUserValue(current);
        this.setOrgValue(current);
        this.getModel().setValue(RADIOGROUPFIELD, (Object)current.getString(RADIOGROUPFIELD));
    }

    private void setUserValue(JSONObject current) {
        JSONArray mulbasedatauser = current.getJSONArray(MULBASEDATAUSER);
        if (mulbasedatauser != null) {
            Object[] array = mulbasedatauser.stream().map(v -> Long.parseLong(v + "")).toArray();
            this.getModel().setValue(MULBASEDATAUSER, (Object)array);
        } else {
            this.getModel().setValue(MULBASEDATAUSER, null);
        }
    }

    private void setOrgValue(JSONObject current) {
        JSONArray mulbasedataorg = current.getJSONArray(MULBASEDATAORG);
        if (mulbasedataorg != null) {
            Object[] array = mulbasedataorg.stream().map(v -> Long.parseLong(v + "")).toArray();
            this.getModel().setValue(MULBASEDATAORG, (Object)array);
        } else {
            this.getModel().setValue(MULBASEDATAORG, null);
        }
    }

    private void setRoleValue(JSONObject current) {
        JSONArray mulbasedatarole = current.getJSONArray(MULBASEDATAROLE);
        if (mulbasedatarole != null) {
            Object[] array = mulbasedatarole.toArray();
            this.getModel().setValue(MULBASEDATAROLE, (Object)array);
        } else {
            this.getModel().setValue(MULBASEDATAROLE, null);
        }
    }

    private void setLabelName(String name) {
        String text = name;
        if (StringUtils.isBlank((CharSequence)text)) {
            text = ResManager.loadKDString((String)"\u521b\u5efa\u76ee\u5f55", (String)"TemplateGroupTreeEditPlugin_1", (String)"ai-km", (Object[])new Object[0]);
        }
        Label groupLabel = (Label)this.getControl("grouplabel");
        groupLabel.setText(text);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("dook".equals(operateKey)) {
            HashMap<String, Boolean> params = new HashMap<String, Boolean>(4);
            params.put("doSave", true);
            this.customControl.setData(params);
        }
    }

    private void releaseMutexLock(List<Map<String, Object>> mutexRequireList) {
        try (DataMutex dataMutex = DataMutex.create();){
            dataMutex.batchRelease(mutexRequireList);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private static void buildMutexInfo(String key, String groupEntity, List<Map<String, Object>> mutexRequireList) {
        HashMap<String, String> requireParam = new HashMap<String, String>();
        requireParam.put("dataObjId", key);
        requireParam.put("entityKey", groupEntity);
        requireParam.put("operationKey", "modify");
        mutexRequireList.add(requireParam);
    }

    private static void buildDynamicObject(DynamicObject dynamicObject, JSONObject object, String useOrg, String type) {
        JSONArray mulbasedatauser;
        JSONArray mulbasedataorg;
        if ("add".equals(type)) {
            dynamicObject.set("number", object.get((Object)NODE_KEY));
            dynamicObject.set("id", (Object)Long.parseLong(object.getString(NODE_KEY)));
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createorg", (Object)Long.parseLong(useOrg));
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("longnumber", (Object)object.getString(LONG_NUMBER));
            String parentKey = object.getString(PARENT_KEY);
            if (StringUtils.isBlank((CharSequence)parentKey)) {
                parentKey = "0";
            }
            dynamicObject.set("parent", (Object)Long.parseLong(parentKey));
        }
        dynamicObject.set("name", object.get((Object)"langs"));
        dynamicObject.set("visiblerange", (Object)object.getString(COMBOFIELD));
        JSONArray mulbasedatarole = object.getJSONArray(MULBASEDATAROLE);
        if (mulbasedatarole != null) {
            List collect = mulbasedatarole.stream().map(String::valueOf).collect(Collectors.toList());
            dynamicObject.set(VISIBLEROLE, (Object)String.join((CharSequence)",", collect));
        }
        if ((mulbasedataorg = object.getJSONArray(MULBASEDATAORG)) != null) {
            List org = mulbasedataorg.stream().map(String::valueOf).collect(Collectors.toList());
            dynamicObject.set(VISIBLEORG, (Object)String.join((CharSequence)",", org));
        }
        if ((mulbasedatauser = object.getJSONArray(MULBASEDATAUSER)) != null) {
            List user = mulbasedatauser.stream().map(String::valueOf).collect(Collectors.toList());
            dynamicObject.set(VISIBLEUSER, (Object)String.join((CharSequence)",", user));
        }
        dynamicObject.set("effectivelogic", object.get((Object)RADIOGROUPFIELD));
    }
}

