/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base.qa;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.ai.km.base.qa.ExcelParserData;
import kd.ai.km.base.qa.ExcelParserTool;
import kd.ai.km.service.KMDataService;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ImportQaConfigPlugin
extends AbstractBasePlugIn
implements UploadListener {
    private static final Log log = LogFactory.getLog(ImportQaConfigPlugin.class);
    private static final String BTN_CHANGE_FILE = "buttonap";
    private static final String BTN_OK = "buttonok";
    private static final String OP_OK = "dook";

    public void registerListener(EventObject e) {
        Button button = (Button)this.getControl(BTN_CHANGE_FILE);
        button.addClickListener((ClickListener)this);
        button.addUploadListener((UploadListener)this);
        Button buttonOk = (Button)this.getControl(BTN_OK);
        buttonOk.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        try {
            String fileName = (String)customParams.get("fileName");
            int fileSize = (Integer)customParams.get("fileSize");
            this.setLabelValue(fileName, fileSize);
            String fileUrl = (String)customParams.get("fileUrl");
            ExcelParserData data = this.parserExcel(fileName, fileUrl);
            this.setComboEditValue(data);
            this.excelPreview(data.getData());
            this.cacheFileUrl(fileUrl, fileName);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
        }
    }

    private void cacheFileUrl(String fileUrl, String fileName) {
        this.getPageCache().put("fileUrl", fileUrl);
        this.getPageCache().put("fileName", fileName);
    }

    private ExcelParserData parserExcel(String fileName, String fileUrl) throws IOException {
        String type = fileName.substring(fileName.lastIndexOf(".") + 1);
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inputStream = tempFileCache.getInputStream(fileUrl);
        int available = inputStream.available();
        ExcelParserData data = ExcelParserTool.parse(inputStream, type);
        data.setSize(available);
        return data;
    }

    private void excelPreview(JSONObject data) {
        if (data == null) {
            return;
        }
        String sheet = (String)this.getModel().getValue("combofield");
        BigDecimal row = (BigDecimal)this.getModel().getValue("row");
        int rowIntValue = Math.max(row.intValue(), 1);
        BigDecimal clo = (BigDecimal)this.getModel().getValue("clo");
        int cloIntValue = Math.max(clo.intValue(), 1);
        JSONObject rowData = (JSONObject)data.get((Object)sheet);
        int index = Math.min(rowIntValue, rowData.size());
        int maxLine = 10;
        int lineNum = 0;
        this.getModel().deleteEntryData("entryentity");
        for (int i = index - 1; i < rowData.size() && lineNum <= maxLine - 1; ++i) {
            this.getModel().createNewEntryRow("entryentity");
            JSONObject cellData = (JSONObject)rowData.get((Object)(i + ""));
            if (cellData == null) continue;
            int cellIndex = Math.min(cloIntValue, cellData.size());
            this.getModel().setValue("question", cellData.get((Object)(cellIndex - 1 + "")), lineNum);
            this.getModel().setValue("answer", cellData.get((Object)(cellIndex + "")), lineNum);
            ++lineNum;
        }
    }

    private void setComboEditValue(ExcelParserData parse) {
        Map<Integer, String> sheets = parse.getSheetNames();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(sheets.size());
        ComboItem selectedFirst = null;
        for (Map.Entry<Integer, String> entry : sheets.entrySet()) {
            ComboItem comboItem = new ComboItem(new LocaleString(entry.getValue()), String.valueOf(entry.getKey()));
            comboItem.setId(String.valueOf(entry.getKey()));
            if (selectedFirst == null) {
                selectedFirst = comboItem;
            }
            comboItems.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
        comboEdit.setComboItems(comboItems);
        if (selectedFirst != null) {
            this.getModel().setValue("combofield", (Object)selectedFirst.getValue());
        }
    }

    private void setLabelValue(String fileName, int fileSize) {
        BigDecimal bigDecimal = new BigDecimal(1024);
        BigDecimal divide = new BigDecimal(fileSize).divide(bigDecimal, 2, RoundingMode.HALF_UP);
        Label filename = (Label)this.getControl("filename");
        Label filesize = (Label)this.getControl("filesize");
        filename.setText(fileName);
        filesize.setText(divide + "KB");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "row": 
            case "clo": 
            case "combofield": {
                try {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d\u4e2d", (String)"ImportQaConfigPlugin_2", (String)"ai-km", (Object[])new Object[0])));
                    this.excelPreview(this.getExcelDataFromCache());
                }
                catch (Exception ex) {
                    log.error((Throwable)ex);
                }
                this.getView().hideLoading();
                break;
            }
        }
    }

    private JSONObject getExcelDataFromCache() throws IOException {
        String url = this.getPageCache().get("fileUrl");
        String name = this.getPageCache().get("fileName");
        ExcelParserData excelParserData = this.parserExcel(name, url);
        return excelParserData.getData();
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (null == urls || urls.length == 0) {
            evt.setCancel(true);
            return;
        }
        Object[] names = evt.getNames();
        String url = (String)urls[0];
        String fileName = (String)names[0];
        try {
            ExcelParserData excelParserData = this.parserExcel(fileName, url);
            this.setLabelValue(fileName, excelParserData.getSize());
            this.setComboEditValue(excelParserData);
            this.excelPreview(excelParserData.getData());
            this.cacheFileUrl(url, fileName);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (OP_OK.equals(operateKey)) {
            try {
                JSONObject excelDataFromCache = this.getExcelDataFromCache();
                JSONArray jsonArray = this.buildQAData(excelDataFromCache);
                this.saveQa(jsonArray);
                this.closePage();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    private void closePage() {
        this.getView().close();
        IFormView parentView = this.getView().getParentView();
        parentView.close();
        this.getView().sendFormAction(parentView);
    }

    private void saveQa(JSONArray jsonArray) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String formId = (String)formShowParameter.getCustomParam("formId");
        String useOrg = (String)formShowParameter.getCustomParam("useOrg");
        String groupId = (String)formShowParameter.getCustomParam("groupId");
        KMDataService kmDataService = KMDataService.create();
        Map<Integer, String> msg = kmDataService.batchCreateQAKMObject(formId, Long.parseLong(useOrg), groupId, jsonArray, null);
        this.showErrorMsg(msg);
    }

    private void showErrorMsg(Map<Integer, String> msg) {
        if (msg != null && !msg.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Integer, String> entry : msg.entrySet()) {
                builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u5bfc\u5165\u5931\u8d25\uff1a%2s", (String)"ImportQaConfigPlugin_1", (String)"ai-km", (Object[])new Object[0]), entry.getKey() + 1, entry.getValue()));
                builder.append("\n");
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"ImportQaConfigPlugin_0", (String)"ai-km", (Object[])new Object[0]), builder.toString(), MessageTypes.Default);
        }
    }

    private JSONArray buildQAData(JSONObject excelDataFromCache) {
        if (excelDataFromCache != null) {
            JSONArray qaData = new JSONArray();
            BigDecimal row = (BigDecimal)this.getModel().getValue("row");
            int rowIntValue = Math.max(row.intValue(), 1);
            BigDecimal clo = (BigDecimal)this.getModel().getValue("clo");
            int cloIntValue = Math.max(clo.intValue(), 1);
            for (String sheet : excelDataFromCache.keySet()) {
                JSONObject rowData = (JSONObject)excelDataFromCache.get((Object)sheet);
                int index = Math.min(rowIntValue, rowData.size());
                for (int i = index - 1; i < rowData.size(); ++i) {
                    JSONObject cellData = (JSONObject)rowData.get((Object)(i + ""));
                    if (cellData == null) continue;
                    JSONObject jsonObject = new JSONObject();
                    int cellIndex = Math.min(cloIntValue, cellData.size());
                    jsonObject.put("Q", cellData.get((Object)(cellIndex - 1 + "")));
                    jsonObject.put("A", cellData.get((Object)(cellIndex + "")));
                    qaData.add((Object)jsonObject);
                }
            }
            return qaData;
        }
        return null;
    }
}

