/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base.qa;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import org.apache.commons.lang.StringUtils;

public class ImportQaPlugin
extends AbstractBasePlugIn
implements UploadListener {
    private static final String ATTACHMENT_PANEL = "attachmentpanelap";
    private static final String BTN_NEXT = "buttonnext";
    private static final String SYSTEM_TYPE = "ai-km";
    public static final String FILE_URL = "fileUrl";
    public static final String FILE_NAME = "fileName";
    public static final String FILE_SIZE = "fileSize";
    private static final String AIKM_KNL_QA_IMPORT_CONFIG = "aikm_knl_qa_import_config";

    public void registerListener(EventObject e) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENT_PANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        Button button = (Button)this.getControl(BTN_NEXT);
        button.addClickListener((ClickListener)this);
    }

    public void upload(UploadEvent evt) {
        Object[] attachmentInfos = evt.getUrls();
        if (null == attachmentInfos || attachmentInfos.length == 0) {
            evt.setCancel(true);
            return;
        }
        Map fileInfo = (Map)attachmentInfos[0];
        if (!fileInfo.containsKey("url") || !fileInfo.containsKey("name")) {
            evt.setCancel(true);
            evt.setCancelMsg(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5b8c\u6574\u7684\u6587\u4ef6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u5e76\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ImportQaPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(FILE_URL, (String)fileInfo.get("url"));
        map.put(FILE_NAME, (String)fileInfo.get("name"));
        map.put(FILE_SIZE, fileInfo.get("size").toString());
        this.getPageCache().put(map);
    }

    public void click(EventObject evt) {
        Button button;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_NEXT.equals((button = (Button)source).getKey())) {
            if (!this.checkFileInfo()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImportQaPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                return;
            }
            this.showConfigForm();
        }
    }

    private void showConfigForm() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam(FILE_URL, (Object)this.getPageCache().get(FILE_URL));
        showParameter.setCustomParam(FILE_NAME, (Object)this.getPageCache().get(FILE_NAME));
        showParameter.setCustomParam(FILE_SIZE, (Object)Integer.parseInt(this.getPageCache().get(FILE_SIZE)));
        showParameter.setCustomParam("formId", formShowParameter.getCustomParam("formId"));
        showParameter.setCustomParam("useOrg", formShowParameter.getCustomParam("useOrg"));
        showParameter.setCustomParam("groupId", formShowParameter.getCustomParam("groupId"));
        showParameter.setFormId(AIKM_KNL_QA_IMPORT_CONFIG);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(openStyle);
        this.getView().showForm(showParameter);
    }

    private boolean checkFileInfo() {
        String fileUrl = this.getPageCache().get(FILE_URL);
        String fileName = this.getPageCache().get(FILE_NAME);
        String fileSize = this.getPageCache().get(FILE_SIZE);
        if (StringUtils.isBlank((String)fileSize)) {
            return false;
        }
        int size = Integer.parseInt(fileSize);
        return size > 0 && !StringUtils.isBlank((String)fileName) && !StringUtils.isBlank((String)fileUrl);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView = this.getView().getParentView();
        parentView.updateView();
        this.getView().sendFormAction(parentView);
    }
}

