/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kd.ai.km.base.KMDesignerData;
import kd.ai.km.management.model.PermAssign;
import kd.ai.km.management.model.PermData;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMEditFormPlugin
extends AbstractFormPlugin {
    private static final Logger log = LoggerFactory.getLogger(KMEditFormPlugin.class);
    private static final String SYSTEM = "ai-km";
    private static final String ENTITY_KM_MANAGER = "aikm_knl_manager";
    private static final String BTN_SAVE = "btnok";
    private static final String FIELD_NAME = "knowledge_name";
    private static final String FIELD_NUMBER = "knowledge_number";
    private static final String FIELD_DESC = "knowledge_desc";
    private static final String FIELD_GROUP = "knowledge_group";
    private static final String FIELD_ENABLE_PERM = "enable_perm";
    private static final String FIELD_IMAGE = "knowledge_image";
    private static final String PARAM_MANAGER_ID = "manager_id";
    private static final String PERM_ITEM_AUTH = "4S69XB/TDL5N";
    private static final int PERM_USER_LIMIT = 100;
    private static final int PERM_ROLE_LIMIT = 100;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_SAVE});
        this.addAfterPermF7SelectListener();
    }

    public void afterCreateNewData(EventObject e) {
        this.loadKMInfo();
    }

    public void afterBindData(EventObject e) {
        boolean hasCreateKMPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY_KM_MANAGER, (String)PERM_ITEM_AUTH);
        if (!hasCreateKMPerm) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u77e5\u8bc6\u5e93\u7ba1\u7406\u201d\u7684\u201c\u6388\u6743\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u4fee\u6539\u6743\u9650\u3002", (String)"KMEditFormPlugin_2", (String)SYSTEM, (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap_right_5"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (FIELD_ENABLE_PERM.equals(property.getName())) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            PermData permData = PermData.fromModel(this.getModel());
            if (oldValue != newValue && Boolean.TRUE.equals(newValue) && permData.isAllEmpty()) {
                this.getModel().setValue("perm_admin_user", (Object)Collections.singletonList(RequestContext.get().getCurrUserId()).toArray());
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        boolean hasEditPerm;
        Button btn;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_SAVE.equals(key = (btn = (Button)source).getKey()) && !(hasEditPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY_KM_MANAGER, (String)"4715a0df000000ac"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u77e5\u8bc6\u5e93\u7ba1\u7406\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KMEditFormPlugin_3", (String)SYSTEM, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_SAVE.equals(key = (btn = (Button)source).getKey())) {
            this.assignPermToKnowledgeEntity();
            this.saveKMManager();
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u4fdd\u5b58\u6210\u529f\u3002", (String)"KMEditFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private void saveKMManager() {
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)ENTITY_KM_MANAGER);
        DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam(PARAM_MANAGER_ID), (DynamicObjectType)managerType);
        managerData.set("picturefield", this.getModel().getValue(FIELD_IMAGE));
        managerData.set("desc", this.getModel().getValue(FIELD_DESC));
        boolean enablePerm = (Boolean)this.getModel().getValue(FIELD_ENABLE_PERM);
        int authorizeStatus = managerData.getInt("authorizestatus");
        boolean oldEnablePerm = authorizeStatus != 0;
        PermData permData = PermData.fromModel(this.getModel());
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(FIELD_NAME);
        ILocaleString oldName = managerData.getLocaleString("name");
        if (oldEnablePerm != enablePerm || this.isLocaleStringChanged(name, oldName)) {
            if (!oldEnablePerm && enablePerm) {
                managerData.set("authorizestatus", (Object)(permData.isAllEmpty() ? 1 : 2));
                this.setManagerPermissions(managerData, permData);
            } else if (oldEnablePerm && !enablePerm) {
                managerData.set("authorizestatus", (Object)0);
                this.setManagerPermissions(managerData, new PermData(new ArrayList<Long>(0), new ArrayList<Long>(0), new ArrayList<Long>(0), new ArrayList<Long>(0), new ArrayList<String>(0), new ArrayList<String>(0), new ArrayList<String>(0), new ArrayList<String>(0)));
            } else if (oldEnablePerm) {
                this.setManagerPermissions(managerData, permData);
            }
            managerData.set("name", (Object)name);
            KMDesignerData.modify(managerData.getString("number"), enablePerm, LocaleString.fromMap((Map)name));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{managerData});
    }

    private void loadKMInfo() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object managerId = fsp.getCustomParam(PARAM_MANAGER_ID);
        if (StringUtils.isBlank((Object)managerId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u7ba1\u7406\u6570\u636e\u3002", (String)"KMEditFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
        }
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)ENTITY_KM_MANAGER);
        DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)managerId, (DynamicObjectType)managerType);
        if (null == managerData) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u7ba1\u7406\u6570\u636e\u3002", (String)"KMEditFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
        }
        this.getModel().setValue(FIELD_NAME, managerData.get("name"));
        this.getModel().setValue(FIELD_NUMBER, managerData.get("number"));
        this.getModel().setValue(FIELD_DESC, managerData.get("desc"));
        this.getModel().setValue(FIELD_GROUP, managerData.get("group"));
        this.getModel().setValue(FIELD_ENABLE_PERM, (Object)(managerData.getInt("authorizestatus") != 0 ? 1 : 0));
        this.getModel().setValue(FIELD_IMAGE, managerData.get("picturefield"));
        PermData permData = PermData.fromDynamicObject(managerData);
        this.getModel().setValue("perm_admin_user", (Object)permData.getAdminUsers().toArray());
        this.getModel().setValue("perm_edit_user", (Object)permData.getEditUsers().toArray());
        this.getModel().setValue("perm_audit_user", (Object)permData.getAuditUsers().toArray());
        this.getModel().setValue("perm_view_user", (Object)permData.getViewUsers().toArray());
        this.getModel().setValue("perm_admin_role", (Object)permData.getAdminRoles().toArray());
        this.getModel().setValue("perm_edit_role", (Object)permData.getEditRoles().toArray());
        this.getModel().setValue("perm_audit_role", (Object)permData.getAuditRoles().toArray());
        this.getModel().setValue("perm_view_role", (Object)permData.getViewRoles().toArray());
        this.setPermissionDataToCache(managerData);
    }

    private void setManagerPermissions(DynamicObject managerData, PermData permData) {
        managerData.set("adminuser_tag", (Object)PermData.convertToString(permData.getAdminUsers()));
        managerData.set("adminrole_tag", (Object)PermData.convertToString(permData.getAdminRoles()));
        managerData.set("edituser_tag", (Object)PermData.convertToString(permData.getEditUsers()));
        managerData.set("editrole_tag", (Object)PermData.convertToString(permData.getEditRoles()));
        managerData.set("audituser_tag", (Object)PermData.convertToString(permData.getAuditUsers()));
        managerData.set("auditrole_tag", (Object)PermData.convertToString(permData.getAuditRoles()));
        managerData.set("viewuser_tag", (Object)PermData.convertToString(permData.getViewUsers()));
        managerData.set("viewrole_tag", (Object)PermData.convertToString(permData.getViewRoles()));
    }

    private void setPermissionDataToCache(DynamicObject managerData) {
        PermData permData = PermData.fromDynamicObject(managerData);
        this.getPageCache().put("permissionData", JSON.toJSONString((Object)permData));
    }

    private PermData getPermissionFromCache() {
        String permissionJson = this.getPageCache().get("permissionData");
        return (PermData)JSON.parseObject((String)permissionJson, PermData.class);
    }

    private void assignPermToKnowledgeEntity() {
        Object managerId = this.getView().getFormShowParameter().getCustomParam(PARAM_MANAGER_ID);
        if (!(managerId instanceof Long)) {
            throw new RuntimeException("Manager ID cannot be empty");
        }
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)ENTITY_KM_MANAGER);
        DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)managerId, (DynamicObjectType)managerType);
        if (managerData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u7ba1\u7406\u6570\u636e\u3002", (String)"KMEditFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
        }
        String kmEntityNum = MetadataDao.getNumberById((String)managerData.get("kmentityid").toString());
        String kmqaEntityNum = MetadataDao.getNumberById((String)managerData.get("kmqaentityid").toString());
        List<String> entityIds = Arrays.asList(kmEntityNum, kmqaEntityNum);
        PermData permData = PermData.fromModel(this.getModel());
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                PermData cachePermData = this.getPermissionFromCache();
                PermDiff permDiff = this.comparePermData(cachePermData, permData);
                if (permDiff.hasRemovedItems()) {
                    PermAssign.unAssignUser(entityIds, permDiff.getRemovedUsers());
                    PermAssign.unAssignRole(entityIds, permDiff.getRemovedRoles());
                }
                EnumMap<PermAssign.PermItemType, List> userPermMap = new EnumMap<PermAssign.PermItemType, List>(PermAssign.PermItemType.class);
                userPermMap.put(PermAssign.PermItemType.ADMIN, permData.getAdminUsers());
                userPermMap.put(PermAssign.PermItemType.EDIT, permData.getEditUsers());
                userPermMap.put(PermAssign.PermItemType.AUDIT, permData.getAuditUsers());
                userPermMap.put(PermAssign.PermItemType.VIEW, permData.getViewUsers());
                userPermMap.forEach((permType, users) -> PermAssign.unAssignUser(entityIds, users));
                userPermMap.forEach((permType, users) -> PermAssign.assignUser(entityIds, users, permType));
                EnumMap<PermAssign.PermItemType, List> rolePermMap = new EnumMap<PermAssign.PermItemType, List>(PermAssign.PermItemType.class);
                rolePermMap.put(PermAssign.PermItemType.ADMIN, permData.getAdminRoles());
                rolePermMap.put(PermAssign.PermItemType.EDIT, permData.getEditRoles());
                rolePermMap.put(PermAssign.PermItemType.AUDIT, permData.getAuditRoles());
                rolePermMap.put(PermAssign.PermItemType.VIEW, permData.getViewRoles());
                rolePermMap.forEach((permType, roles) -> PermAssign.unAssignRole(entityIds, roles));
                rolePermMap.forEach((permType, roles) -> PermAssign.assignRole(entityIds, roles, permType));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private PermDiff comparePermData(PermData cachePermData, PermData currentPerm) {
        ArrayList<Long> removedUsers = new ArrayList<Long>();
        this.addRemovedItems(removedUsers, cachePermData.getAdminUsers(), currentPerm.getAdminUsers());
        this.addRemovedItems(removedUsers, cachePermData.getEditUsers(), currentPerm.getEditUsers());
        this.addRemovedItems(removedUsers, cachePermData.getAuditUsers(), currentPerm.getAuditUsers());
        this.addRemovedItems(removedUsers, cachePermData.getViewUsers(), currentPerm.getViewUsers());
        removedUsers = new ArrayList(new LinkedHashSet(removedUsers));
        ArrayList<String> removedRoles = new ArrayList<String>();
        this.addRemovedItems(removedRoles, cachePermData.getAdminRoles(), currentPerm.getAdminRoles());
        this.addRemovedItems(removedRoles, cachePermData.getEditRoles(), currentPerm.getEditRoles());
        this.addRemovedItems(removedRoles, cachePermData.getAuditRoles(), currentPerm.getAuditRoles());
        this.addRemovedItems(removedRoles, cachePermData.getViewRoles(), currentPerm.getViewRoles());
        removedRoles = new ArrayList(new LinkedHashSet(removedRoles));
        return new PermDiff(removedUsers, removedRoles);
    }

    private <T> void addRemovedItems(List<T> removedItems, List<T> originalItems, List<T> currentItems) {
        if (originalItems == null) {
            return;
        }
        if (currentItems == null) {
            removedItems.addAll(originalItems);
            return;
        }
        for (T item : originalItems) {
            if (currentItems.contains(item)) continue;
            removedItems.add(item);
        }
    }

    private void addAfterPermF7SelectListener() {
        String fieldType = ResManager.loadKDString((String)"\u7528\u6237", (String)"KMEditFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]);
        this.validatePermCount("perm_admin_user", fieldType, 100);
        this.validatePermCount("perm_edit_user", fieldType, 100);
        this.validatePermCount("perm_audit_user", fieldType, 100);
        this.validatePermCount("perm_view_user", fieldType, 100);
        fieldType = ResManager.loadKDString((String)"\u89d2\u8272", (String)"KMEditFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]);
        this.validatePermCount("perm_admin_role", fieldType, 100);
        this.validatePermCount("perm_edit_role", fieldType, 100);
        this.validatePermCount("perm_audit_role", fieldType, 100);
        this.validatePermCount("perm_view_role", fieldType, 100);
    }

    private void validatePermCount(String field, String type, int limit) {
        MulBasedataEdit permUser = (MulBasedataEdit)this.getControl(field);
        String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u9009%1$s\u6570\u91cf\u8d85\u8fc7\u9650\u5236\uff0c\u5c06\u53ea\u4fdd\u7559\u524d%2$s\u4e2a\u3002", (String)"KMEditFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]), type, limit);
        permUser.addAfterF7SelectListener(evt -> {
            ListSelectedRowCollection col = evt.getListSelectedRowCollection();
            if (col.size() > limit) {
                this.getView().showTipNotification(msg);
                this.getModel().setValue(field, (Object)col.stream().limit(limit).map(ListSelectedRow::getPrimaryKeyValue).toArray());
            }
        });
    }

    private boolean isLocaleStringChanged(OrmLocaleValue newNameMap, ILocaleString oldNameMap) {
        if (null == newNameMap) {
            return false;
        }
        if (newNameMap.size() != oldNameMap.size()) {
            return true;
        }
        for (Map.Entry nameItem : newNameMap.entrySet()) {
            String lcId = (String)nameItem.getKey();
            String newName = (String)nameItem.getValue();
            if (oldNameMap.containsKey((Object)lcId) && !StringUtils.equals((CharSequence)newName, (CharSequence)((CharSequence)oldNameMap.get((Object)lcId)))) continue;
            return true;
        }
        return false;
    }

    private static class PermDiff {
        private final List<Long> removedUsers;
        private final List<String> removedRoles;

        public PermDiff(List<Long> removedUsers, List<String> removedRoles) {
            this.removedUsers = removedUsers != null ? removedUsers : new ArrayList();
            this.removedRoles = removedRoles != null ? removedRoles : new ArrayList();
        }

        public List<Long> getRemovedUsers() {
            return this.removedUsers;
        }

        public List<String> getRemovedRoles() {
            return this.removedRoles;
        }

        public boolean hasRemovedItems() {
            return !this.removedUsers.isEmpty() || !this.removedRoles.isEmpty();
        }
    }
}

