/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.km.base.KMDesignerData;
import kd.ai.km.management.model.PermAssign;
import kd.ai.km.utils.KMManageUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMManageDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String SYSTEM = "ai-km";
    private static final String ENTITY_KM_CONFIG = "bos_knl_kmconfig";
    private static final String ENTITY_KM_MANAGER = "aikm_knl_manager";
    private static final String OPTION_KM_ENTITY = "kmEntityMap";
    private static final String OPTION_QA_ENTITY = "qaEntityMap";
    private static final String OPTION_GROUP_ENTITY = "groupEntityMap";
    private static final Logger log = LoggerFactory.getLogger(KMManageDeleteOpPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new KMManageDeleteValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, String> managerKMEntityMap = new HashMap<String, String>(dataEntities.length);
        HashMap<String, String> managerQAEntityMap = new HashMap<String, String>(dataEntities.length);
        HashMap<String, String> managerGroupEntityMap = new HashMap<String, String>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String managerNumber = dataEntity.getString("number");
            managerKMEntityMap.put(managerNumber, KMManageUtils.getKMEntityNumber(managerNumber));
            managerQAEntityMap.put(managerNumber, KMManageUtils.getKMQAEntityNumber(managerNumber));
            managerGroupEntityMap.put(managerNumber, KMManageUtils.getKMGroupEntityNumber(managerNumber));
        }
        this.getOption().setVariableValue(OPTION_KM_ENTITY, JSON.toJSONString(managerKMEntityMap));
        this.getOption().setVariableValue(OPTION_QA_ENTITY, JSON.toJSONString(managerQAEntityMap));
        this.getOption().setVariableValue(OPTION_GROUP_ENTITY, JSON.toJSONString(managerGroupEntityMap));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Map kmEntityMap = (Map)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue(OPTION_KM_ENTITY, "{}"), Map.class);
        Map qaEntityMap = (Map)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue(OPTION_QA_ENTITY, "{}"), Map.class);
        Map groupEntityMap = (Map)SerializationUtils.fromJsonString((String)this.getOption().getVariableValue(OPTION_GROUP_ENTITY, "{}"), Map.class);
        ArrayList<String> list = new ArrayList<String>(16);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            String managerNumber = dataEntity.getString("number");
            String kmEntityNumber = (String)kmEntityMap.get(managerNumber);
            String qaEntityNumber = (String)qaEntityMap.get(managerNumber);
            String groupEntityNumber = (String)groupEntityMap.get(managerNumber);
            this.deleteConfig(kmEntityNumber, qaEntityNumber);
            this.deleteMetadata(kmEntityNumber, qaEntityNumber, groupEntityNumber);
            list.add(kmEntityNumber);
            list.add(qaEntityNumber);
            list.add(groupEntityNumber);
        }
        PermAssign.deletePerm(list.toArray(new String[0]));
    }

    private void deleteMetadata(String kmEntityNumber, String qaEntityNumber, String groupEntityNumber) {
        if (StringUtils.isNotBlank((CharSequence)qaEntityNumber)) {
            String qaEntityId = MetadataDao.getIdByNumber((String)qaEntityNumber, (MetaCategory)MetaCategory.Entity);
            KMDesignerData.deleteFormMetadataIfNotNull(qaEntityId);
        }
        if (StringUtils.isNotBlank((CharSequence)kmEntityNumber)) {
            String kmEntityId = MetadataDao.getIdByNumber((String)kmEntityNumber, (MetaCategory)MetaCategory.Entity);
            KMDesignerData.deleteFormMetadataIfNotNull(kmEntityId);
        }
        if (StringUtils.isNotBlank((CharSequence)groupEntityNumber)) {
            String groupEntityId = MetadataDao.getIdByNumber((String)groupEntityNumber, (MetaCategory)MetaCategory.Entity);
            KMDesignerData.deleteFormMetadataIfNotNull(groupEntityId);
        }
    }

    private void deleteConfig(String kmEntityNumber, String qaEntityNumber) {
        List<String> kmEntityNumbers = Arrays.asList(kmEntityNumber, qaEntityNumber);
        DeleteServiceHelper.delete((String)ENTITY_KM_CONFIG, (QFilter[])new QFilter[]{new QFilter("kmformid.id", "in", kmEntityNumbers)});
    }

    private static class KMManageDeleteValidator
    extends AbstractValidator {
        private KMManageDeleteValidator() {
        }

        public void validate() {
            if (this.dataEntities == null || this.dataEntities.length == 0) {
                return;
            }
            String existKnlMsg = ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93[%s]\u4e2d\u5b58\u5728\u77e5\u8bc6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"KMManageDeleteOpPlugin_0", (String)KMManageDeleteOpPlugin.SYSTEM, (Object[])new Object[0]);
            String associatedAgentMsg = ResManager.loadKDString((String)"\u5f53\u524d\u77e5\u8bc6\u5e93\u5df2\u88ab%1$s[%2$s]\u5f15\u7528\uff0c\u8bf7\u5220\u9664\u540e\u518d\u8bd5\u3002", (String)"KMManageDeleteOpPlugin_1", (String)KMManageDeleteOpPlugin.SYSTEM, (Object[])new Object[0]);
            String agentTypeName = ResManager.loadKDString((String)"\u667a\u80fd\u4f53", (String)"KMManageDeleteOpPlugin_2", (String)KMManageDeleteOpPlugin.SYSTEM, (Object[])new Object[0]);
            String processTypeName = ResManager.loadKDString((String)"\u4efb\u52a1\u6d41", (String)"KMManageDeleteOpPlugin_3", (String)KMManageDeleteOpPlugin.SYSTEM, (Object[])new Object[0]);
            JSONObject associatedAgentInfos = this.getAssociatedAgentInfos();
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject data = dataEntity.getDataEntity();
                String managerNumber = data.getString("number");
                String kmEntityNumber = KMManageUtils.getKMEntityNumber(managerNumber);
                if (QueryServiceHelper.exists((String)kmEntityNumber, (QFilter[])new QFilter[0])) {
                    this.addMessage(dataEntity, String.format(existKnlMsg, managerNumber));
                    continue;
                }
                String qaEntityNumber = KMManageUtils.getKMQAEntityNumber(managerNumber);
                if (QueryServiceHelper.exists((String)qaEntityNumber, null)) {
                    this.addMessage(dataEntity, String.format(existKnlMsg, managerNumber));
                    continue;
                }
                if (null == associatedAgentInfos || associatedAgentInfos.isEmpty() || !associatedAgentInfos.containsKey((Object)dataEntity.getBillPkId().toString())) continue;
                this.validateAssociate(associatedAgentInfos.getJSONArray(dataEntity.getBillPkId().toString()), dataEntity, associatedAgentMsg, agentTypeName, processTypeName);
            }
        }

        private JSONObject getAssociatedAgentInfos() {
            List managerIds = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toList());
            JSONObject param = new JSONObject();
            param.put("formId", (Object)KMManageDeleteOpPlugin.ENTITY_KM_MANAGER);
            param.put("dataIds", managerIds);
            String result = "";
            try {
                result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRefrenceService", (String)"queryRefrenceDetailDatas", (Object[])new Object[]{JSON.toJSONString((Object)param)});
                log.info("query param: {},delete validate queryRefrenceDetailDatas result: {}", (Object)param, (Object)result);
            }
            catch (Exception e) {
                log.error("Failed to query reference details: {}", (Object)e.getMessage());
                return null;
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                return null;
            }
            JSONObject resultJson = JSON.parseObject((String)result);
            JSONObject dataJson = resultJson.getJSONObject("data");
            if (null == dataJson || dataJson.isEmpty()) {
                return null;
            }
            return dataJson;
        }

        private void validateAssociate(JSONArray agentInfos, ExtendedDataEntity dataEntity, String message, String agentType, String processType) {
            if (null == agentInfos || agentInfos.isEmpty()) {
                return;
            }
            for (Object info : agentInfos) {
                Map infoMap;
                if (!(info instanceof Map) || !"1".equals((infoMap = (Map)info).get("enable"))) continue;
                Object formId = infoMap.get("formId");
                String type = "";
                if ("gai_agent".equals(formId)) {
                    type = agentType;
                } else if ("gai_process".equals(formId)) {
                    type = processType;
                }
                this.addMessage(dataEntity, String.format(message, type, infoMap.get("name")));
            }
        }
    }
}

