/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.km.utils.AppParameterUtils;
import kd.ai.km.utils.KMManageUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.threads.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMManageListPlugin
extends AbstractTreeListPlugin {
    private static final Logger log = LoggerFactory.getLogger(KMManageListPlugin.class);
    private static final String SYSTEM = "ai-km";
    private static final String ENTITY_KM_MANAGER = "aikm_knl_manager";
    private static final String ENTITY_KM_CONFIG = "bos_knl_kmconfig";
    private static final String ENTITY_KM_CREATE = "aikm_knl_create";
    private static final String ENTITY_KM_EDIT = "aikm_knl_eidt";
    private static final String FORM_KM_UPDATE = "aikm_knl_perm_update";
    private static final String FIELD_NUMBER = "number";
    private static final String CONTROL_TREE = "treeview";
    private static final String BTN_NEW_KM = "tblnewkm";
    private static final String BTN_REFRESH = "tblrefresh";
    private static final String BTN_NEW_GROUP = "btnnew";
    private static final String BTN_EDIT_GROUP = "btnedit";
    private static final String BTN_DELETE_GROUP = "btndel";
    private static final String BTN_AUTHORIZATION = "btn_authorization";
    private static final String BTN_DISABLE = "btn_disable";
    private static final String BTN_ENABLE = "btn_enable";
    private static final String BTN_CONFIG = "btn_config";
    private static final String BTN_EDIT_KM = "editkm";
    private static final String TREE_TOOLBAR_NEW = "btnnew";
    private static final String USE_ORG = "createOrg";
    private static final String PARAM_CREATE_ORG = "createorg";
    private static final String PARAM_GROUP_ID = "group";
    private static final String PARAM_MANAGER_ID = "manager_id";
    private static final String CALLBACK_CREATE_KM = "CallBackCreateKM";
    private static final String CALLBACK_EDIT_KM = "callBackEditKM";
    private static final String CALLBACK_EDIT_CONFIG = "CallBackEditConfig";
    public static final String SWITCH = "switch";
    private static final String PERM_ITEM_AUTH = "4S69XB/TDL5N";
    private static final String PERM_ITEM_CONFIG = "4S6=1DPCQ83G";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{BTN_NEW_KM, BTN_REFRESH});
        this.addClickListeners(new String[]{"btnnew", BTN_AUTHORIZATION, BTN_DISABLE, BTN_ENABLE, BTN_CONFIG, BTN_EDIT_KM, SWITCH});
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map<String, Object> result = AppParameterUtils.getAppParam();
        if (result == null || result.get("knlversion") == null) {
            log.error("KMManageListPlugin.preOpenForm \u83b7\u53d6\u77e5\u8bc6\u5e93\u7248\u672c\u5931\u8d25\u3002");
            return;
        }
        int knlVersion = (Integer)result.get("knlversion");
        if (knlVersion < 4) {
            e.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("aikm_upgrade_kmentity");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            String pageId = e.getFormShowParameter().getParentPageId();
            IFormView parentView = SessionManager.getCurrent().getView(pageId);
            String appId = parentView.getFormShowParameter().getAppId();
            formShowParameter.setCustomParam("appid", (Object)appId);
            formShowParameter.setCustomParam("needcompareversion", (Object)Boolean.TRUE);
            parentView.showForm(formShowParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.updateKnlAndAgentCount();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String permName;
        boolean hasPerm;
        String itemKey = evt.getItemKey();
        if (BTN_NEW_KM.equals(itemKey) && !(hasPerm = this.validatePerm("47156aff000000ac", permName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"KMManageListPlugin_8", (String)SYSTEM, (Object[])new Object[0])))) {
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "tblnewkm": {
                String useOrg = this.getPageCache().get(USE_ORG);
                if (StringUtils.isBlank((CharSequence)useOrg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"KMManageListPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                    return;
                }
                TreeView treeView = this.getTreeListView().getTreeView();
                String focusNodeId = treeView.getTreeState().getFocusNodeId();
                String rootId = this.getTreeModel().getRoot().getId();
                if (StringUtils.isBlank((CharSequence)focusNodeId) || StringUtils.equals((CharSequence)focusNodeId, (CharSequence)rootId)) {
                    focusNodeId = "0";
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(ENTITY_KM_CREATE);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam(PARAM_CREATE_ORG, (Object)useOrg);
                fsp.setCustomParam(PARAM_GROUP_ID, (Object)focusNodeId);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CREATE_KM));
                this.getView().showForm(fsp);
                break;
            }
            case "switch": {
                this.doSwitch();
                break;
            }
            case "tblrefresh": {
                this.updateKnlAndAgentCount();
                break;
            }
            case "hittest": {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("bos_km_hittest");
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListSelectedRowCollection listSelectedRowCollection = ((BillList)this.getControl("billlistap")).getSelectedRows();
                fsp.setCustomParam("source", (Object)"km");
                if (listSelectedRowCollection != null && listSelectedRowCollection.size() > 0) {
                    Object[] pks = listSelectedRowCollection.getPrimaryKeyValues();
                    fsp.setCustomParam("knowledgeids", (Object)pks);
                }
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    private void doSwitch() {
        ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)"gai_repo_info", (boolean)true, (int)0, (boolean)false);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void beforeClick(BeforeClickEvent evt) {
        String permName;
        boolean hasPerm;
        String key;
        Object source = evt.getSource();
        if (source instanceof Label) {
            String permName2;
            boolean hasPerm2;
            String key2 = ((Label)source).getKey();
            if (BTN_AUTHORIZATION.equals(key2)) {
                String permName3 = ResManager.loadKDString((String)"\u6388\u6743", (String)"KMManageListPlugin_5", (String)SYSTEM, (Object[])new Object[0]);
                boolean hasPerm3 = this.validatePerm(PERM_ITEM_AUTH, permName3);
                if (!hasPerm3) {
                    evt.setCancel(true);
                }
            } else if (BTN_CONFIG.equals(key2) && !(hasPerm2 = this.validatePerm(PERM_ITEM_CONFIG, permName2 = ResManager.loadKDString((String)"\u914d\u7f6e", (String)"KMManageListPlugin_6", (String)SYSTEM, (Object[])new Object[0])))) {
                evt.setCancel(true);
            }
        } else if (source instanceof Vector && BTN_EDIT_KM.equals(key = ((Vector)source).getKey()) && !(hasPerm = this.validatePerm("4715a0df000000ac", permName = ResManager.loadKDString((String)"\u4fee\u6539", (String)"KMManageListPlugin_7", (String)SYSTEM, (Object[])new Object[0])))) {
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        String key;
        Object source = evt.getSource();
        Object focusRowPkId = this.getFocusRowPkId();
        if (StringUtils.isBlank((Object)focusRowPkId)) {
            return;
        }
        if (source instanceof Label) {
            String key2 = ((Label)source).getKey();
            if (BTN_AUTHORIZATION.equals(key2)) {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(FORM_KM_UPDATE);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam(PARAM_MANAGER_ID, focusRowPkId);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_CREATE_KM));
                this.getView().showForm(fsp);
            } else if (BTN_DISABLE.equals(key2)) {
                this.disableKM(focusRowPkId);
            } else if (BTN_ENABLE.equals(key2)) {
                this.enableKM(focusRowPkId);
            } else if (BTN_CONFIG.equals(key2)) {
                ListSelectedRow currentRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
                this.openKMConfig(currentRow.getNumber());
            }
        } else if (source instanceof Vector && BTN_EDIT_KM.equals(key = ((Vector)source).getKey())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(ENTITY_KM_EDIT);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam(PARAM_MANAGER_ID, focusRowPkId);
            fsp.setStatus(OperationStatus.EDIT);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EDIT_KM));
            this.getView().showForm(fsp);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (FIELD_NUMBER.equals(fieldName)) {
            args.setCancel(true);
            ListSelectedRow currentRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
            this.openKMList(currentRow.getNumber(), currentRow.getName());
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow currentRow = evt.getCurrentListSelectedRow();
        this.openKMList(currentRow.getNumber(), currentRow.getName());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "CallBackCreateKM": 
            case "callBackEditKM": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                break;
            }
            case "CallBackEditConfig": {
                Object returnData = evt.getReturnData();
                if (!(returnData instanceof String)) break;
                String kmEntityNumber = (String)returnData;
                this.syncQAKMConfig(kmEntityNumber);
                break;
            }
        }
    }

    private void enableKM(Object kmId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"enable", (String)ENTITY_KM_MANAGER, (Object[])new Object[]{kmId}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"KMManageListPlugin_3", (String)SYSTEM, (Object[])new Object[0]));
        } else {
            List errorInfos = result.getAllErrorOrValidateInfo();
            if (!errorInfos.isEmpty()) {
                IOperateInfo errorInfo = (IOperateInfo)errorInfos.get(0);
                this.getView().showTipNotification(errorInfo.getMessage());
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void disableKM(Object kmId) {
        OperationResult result = OperationServiceHelper.executeOperate((String)"disable", (String)ENTITY_KM_MANAGER, (Object[])new Object[]{kmId}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"KMManageListPlugin_4", (String)SYSTEM, (Object[])new Object[0]));
        } else {
            List errorInfos = result.getAllErrorOrValidateInfo();
            if (!errorInfos.isEmpty()) {
                IOperateInfo errorInfo = (IOperateInfo)errorInfos.get(0);
                this.getView().showTipNotification(errorInfo.getMessage());
            }
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void openKMConfig(String kmNumber) {
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId(ENTITY_KM_CONFIG);
        String kmEntityNumber = KMManageUtils.getKMEntityNumber(kmNumber);
        DynamicObject km = QueryServiceHelper.queryOne((String)ENTITY_KM_CONFIG, (String)"id", (QFilter[])new QFilter[]{new QFilter("kmformid.id", "=", (Object)kmEntityNumber)});
        Object kmId = km.get("id");
        bsp.setPkId(kmId);
        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EDIT_CONFIG));
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setBillStatus(BillOperationStatus.EDIT);
        bsp.setStatus(OperationStatus.EDIT);
        bsp.setCustomParam("entityNumber", (Object)kmEntityNumber);
        bsp.setCustomParam("lockdesc", (Object)true);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void syncQAKMConfig(String kmEntityNumber) {
        DynamicObject kmConfig = BusinessDataServiceHelper.loadSingle((String)ENTITY_KM_CONFIG, (QFilter[])new QFilter[]{new QFilter("kmformid.id", "=", (Object)kmEntityNumber)});
        DynamicObject qaKMConfig = BusinessDataServiceHelper.loadSingle((String)ENTITY_KM_CONFIG, (QFilter[])new QFilter[]{new QFilter("kmformid.id", "=", (Object)(kmEntityNumber + "_qa"))});
        if (null == kmConfig || null == qaKMConfig) {
            return;
        }
        DataEntityPropertyCollection properties = kmConfig.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            if ("id".equals(propName) || "kmformid".equals(propName) || "kmformid_id".equals(propName) || "name".equals(propName) || property instanceof DynamicLocaleProperty) continue;
            qaKMConfig.set(propName, kmConfig.get(propName));
        }
        qaKMConfig.set("enableindex", (Object)false);
        SaveServiceHelper.save((IDataEntityType)kmConfig.getDataEntityType(), (Object[])new Object[]{qaKMConfig});
    }

    private void openKMList(String kmNumber, String kmName) {
        String entityNumber = KMManageUtils.getKMEntityNumber(kmNumber);
        try {
            EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        catch (KDException exp) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u77e5\u8bc6\u5e93\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"KMManageListPlugin_2", (String)SYSTEM, (Object[])new Object[0]), entityNumber));
            return;
        }
        ListShowParameter lsp = new ListShowParameter();
        lsp.setBillFormId(entityNumber);
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        lsp.setCaption(kmName);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void updateKnlAndAgentCount() {
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        if (lsp.isLookUp()) {
            return;
        }
        String pageId = this.getView().getPageId();
        ThreadPools.executeOnce((String)"km_manager_knl_count_update", () -> {
            Map managerMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_KM_MANAGER, null);
            Collection managers = managerMap.values();
            Map<Long, Integer> kmAssistantCountMap = this.getAssistantCount(new ArrayList<Object>(managerMap.keySet()));
            for (DynamicObject manager : managers) {
                String kmEntityId = manager.getString("kmentityid");
                String qaEntityId = manager.getString("kmqaentityid");
                List<Long> knlIds = this.getKnlIds(kmEntityId);
                List<Long> qaIds = this.getKnlIds(qaEntityId);
                manager.set("knlcount", (Object)(knlIds.size() + qaIds.size()));
                long kmId = manager.getLong("id");
                manager.set("assistantcount", (Object)kmAssistantCountMap.getOrDefault(kmId, 0));
            }
            SaveServiceHelper.save((DynamicObject[])managers.toArray(new DynamicObject[0]));
            IFormView view = SessionManager.getCurrent().getView(pageId);
            ((ListView)view).refresh();
            String rootPageId = view.getFormShowParameter().getRootPageId();
            IFormView rootView = SessionManager.getCurrent().getViewNoPlugin(rootPageId);
            rootView.sendFormAction(view);
            PushMessage message = new PushMessage(PushMessageRange.RootPage, rootPageId, (Object)JSON.toJSONString((Object)rootView.getActionResult()));
            PushServiceHelper.push((PushMessage)message);
        });
    }

    private List<Long> getKnlIds(String entityId) {
        MainEntityType kmEntityType;
        try {
            kmEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return new ArrayList<Long>(0);
        }
        if (null == kmEntityType) {
            return new ArrayList<Long>(0);
        }
        DynamicObjectCollection knlDatas = QueryServiceHelper.query((String)kmEntityType.getName(), (String)"id", null);
        if (null == knlDatas || knlDatas.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        return knlDatas.stream().map(k -> k.getLong("id")).collect(Collectors.toList());
    }

    private Map<Long, Integer> getAssistantCount(List<Object> kmIds) {
        if (kmIds.isEmpty()) {
            return new HashMap<Long, Integer>(0);
        }
        JSONObject param = new JSONObject();
        param.put("formId", (Object)ENTITY_KM_MANAGER);
        param.put("dataIds", kmIds);
        String result = "";
        try {
            result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiRefrenceService", (String)"queryRefrenceDetailDatas", (Object[])new Object[]{JSON.toJSONString((Object)param)});
        }
        catch (Exception e) {
            log.error("Failed to query reference details: {}", (Object)e.getMessage());
            return new HashMap<Long, Integer>(0);
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        JSONObject dataJson = resultJson.getJSONObject("data");
        if (null == dataJson || dataJson.isEmpty()) {
            return new HashMap<Long, Integer>(0);
        }
        HashMap<Long, Integer> kmAssistantCountMap = new HashMap<Long, Integer>(dataJson.size());
        for (Map.Entry data : dataJson.entrySet()) {
            String kmId = (String)data.getKey();
            JSONArray refrenceAssistantInfos = (JSONArray)data.getValue();
            kmAssistantCountMap.put(Long.parseLong(kmId), refrenceAssistantInfos.size());
        }
        return kmAssistantCountMap;
    }

    private boolean validatePerm(String permItem, String permName) {
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY_KM_MANAGER, (String)permItem);
        if (!hasPerm) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c\u77e5\u8bc6\u5e93\u7ba1\u7406\u201d\u7684\u201c%s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KMManageListPlugin_9", (String)SYSTEM, (Object[])new Object[0]);
            this.getView().showErrorNotification(String.format(msg, permName));
            return false;
        }
        return true;
    }
}

