/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import kd.ai.km.management.model.PermAssign;
import kd.ai.km.management.model.PermData;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMPermEditFormPlugin
extends AbstractFormPlugin {
    private static final Logger log = LoggerFactory.getLogger(KMPermEditFormPlugin.class);
    private static final String SYSTEM = "ai-km";
    private static final String MANAGER_ENTITY = "aikm_knl_manager";
    private static final int PERM_USER_LIMIT = 100;
    private static final int PERM_ROLE_LIMIT = 100;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addAfterPermF7SelectListener();
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject managerData = this.loadPermissionData();
        this.fillPermissionView(managerData);
        this.setPermissionDataToCache(managerData);
    }

    public void click(EventObject evt) {
        if (!"btnok".equals(((Button)evt.getSource()).getKey())) {
            return;
        }
        try {
            this.assignPermToKnowledgeEntity();
            this.saveKnowledgeBaseManager();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u6388\u6743\u6210\u529f\u3002", (String)"KMPermEditFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    private DynamicObject loadPermissionData() {
        try {
            Object managerId = this.getView().getFormShowParameter().getCustomParam("manager_id");
            if (!(managerId instanceof Long)) {
                log.error("Invalid manager ID type: {}", (Object)(managerId != null ? managerId.getClass().getName() : "null"));
                throw new RuntimeException("Manager ID cannot be empty");
            }
            MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)MANAGER_ENTITY);
            DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)managerId, (DynamicObjectType)managerType);
            if (managerData == null) {
                log.error("Manager data not found for ID: {}", managerId);
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u7ba1\u7406\u6570\u636e\u3002", (String)"KMCreateFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]));
            }
            return managerData;
        }
        catch (Exception e) {
            log.error("Permission data load failed: {}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u52a0\u8f7d\u6743\u9650\u6570\u636e\u5931\u8d25: ", (String)"KMPermEditFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]) + e.getMessage());
        }
    }

    private void fillPermissionView(DynamicObject managerData) {
        PermData permData = PermData.fromDynamicObject(managerData);
        this.getModel().setValue("perm_admin_user", (Object)permData.getAdminUsers().toArray());
        this.getModel().setValue("perm_edit_user", (Object)permData.getEditUsers().toArray());
        this.getModel().setValue("perm_audit_user", (Object)permData.getAuditUsers().toArray());
        this.getModel().setValue("perm_view_user", (Object)permData.getViewUsers().toArray());
        this.getModel().setValue("perm_admin_role", (Object)permData.getAdminRoles().toArray());
        this.getModel().setValue("perm_edit_role", (Object)permData.getEditRoles().toArray());
        this.getModel().setValue("perm_audit_role", (Object)permData.getAuditRoles().toArray());
        this.getModel().setValue("perm_view_role", (Object)permData.getViewRoles().toArray());
    }

    private void setPermissionDataToCache(DynamicObject managerData) {
        PermData permData = PermData.fromDynamicObject(managerData);
        this.getPageCache().put("permissionData", JSON.toJSONString((Object)permData));
    }

    private PermData getPermissionFromCache() {
        String permissionJson = this.getPageCache().get("permissionData");
        return (PermData)JSON.parseObject((String)permissionJson, PermData.class);
    }

    private void saveKnowledgeBaseManager() {
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)MANAGER_ENTITY);
        DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)this.getView().getFormShowParameter().getCustomParam("manager_id"), (DynamicObjectType)managerType);
        this.setManagerPermissions(managerData);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{managerData});
    }

    private void setManagerPermissions(DynamicObject managerData) {
        PermData permData = PermData.fromModel(this.getModel());
        int authorizeStatus = 2;
        if (permData.isAllEmpty()) {
            authorizeStatus = 1;
        }
        managerData.set("authorizestatus", (Object)authorizeStatus);
        managerData.set("adminuser_tag", (Object)PermData.convertToString(permData.getAdminUsers()));
        managerData.set("adminrole_tag", (Object)PermData.convertToString(permData.getAdminRoles()));
        managerData.set("edituser_tag", (Object)PermData.convertToString(permData.getEditUsers()));
        managerData.set("editrole_tag", (Object)PermData.convertToString(permData.getEditRoles()));
        managerData.set("audituser_tag", (Object)PermData.convertToString(permData.getAuditUsers()));
        managerData.set("auditrole_tag", (Object)PermData.convertToString(permData.getAuditRoles()));
        managerData.set("viewuser_tag", (Object)PermData.convertToString(permData.getViewUsers()));
        managerData.set("viewrole_tag", (Object)PermData.convertToString(permData.getViewRoles()));
    }

    private void assignPermToKnowledgeEntity() {
        Object managerId = this.getView().getFormShowParameter().getCustomParam("manager_id");
        if (!(managerId instanceof Long)) {
            throw new RuntimeException("Manager ID cannot be empty");
        }
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)MANAGER_ENTITY);
        DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)managerId, (DynamicObjectType)managerType);
        if (managerData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u7ba1\u7406\u6570\u636e\u3002", (String)"KMCreateFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]));
        }
        String kmEntityNum = MetadataDao.getNumberById((String)managerData.get("kmentityid").toString());
        String kmqaEntityNum = MetadataDao.getNumberById((String)managerData.get("kmqaentityid").toString());
        List<String> entityIds = Arrays.asList(kmEntityNum, kmqaEntityNum);
        PermData permData = PermData.fromModel(this.getModel());
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                PermData cachePermData = this.getPermissionFromCache();
                PermDiff permDiff = this.comparePermData(cachePermData, permData);
                if (permDiff.hasRemovedItems()) {
                    PermAssign.unAssignUser(entityIds, permDiff.getRemovedUsers());
                    PermAssign.unAssignRole(entityIds, permDiff.getRemovedRoles());
                }
                EnumMap<PermAssign.PermItemType, List> userPermMap = new EnumMap<PermAssign.PermItemType, List>(PermAssign.PermItemType.class);
                userPermMap.put(PermAssign.PermItemType.ADMIN, permData.getAdminUsers());
                userPermMap.put(PermAssign.PermItemType.EDIT, permData.getEditUsers());
                userPermMap.put(PermAssign.PermItemType.AUDIT, permData.getAuditUsers());
                userPermMap.put(PermAssign.PermItemType.VIEW, permData.getViewUsers());
                userPermMap.forEach((permType, users) -> PermAssign.unAssignUser(entityIds, users));
                userPermMap.forEach((permType, users) -> PermAssign.assignUser(entityIds, users, permType));
                EnumMap<PermAssign.PermItemType, List> rolePermMap = new EnumMap<PermAssign.PermItemType, List>(PermAssign.PermItemType.class);
                rolePermMap.put(PermAssign.PermItemType.ADMIN, permData.getAdminRoles());
                rolePermMap.put(PermAssign.PermItemType.EDIT, permData.getEditRoles());
                rolePermMap.put(PermAssign.PermItemType.AUDIT, permData.getAuditRoles());
                rolePermMap.put(PermAssign.PermItemType.VIEW, permData.getViewRoles());
                rolePermMap.forEach((permType, roles) -> PermAssign.unAssignRole(entityIds, roles));
                rolePermMap.forEach((permType, roles) -> PermAssign.assignRole(entityIds, roles, permType));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private PermDiff comparePermData(PermData cachePermData, PermData currentPerm) {
        ArrayList<Long> removedUsers = new ArrayList<Long>();
        this.addRemovedItems(removedUsers, cachePermData.getAdminUsers(), currentPerm.getAdminUsers());
        this.addRemovedItems(removedUsers, cachePermData.getEditUsers(), currentPerm.getEditUsers());
        this.addRemovedItems(removedUsers, cachePermData.getAuditUsers(), currentPerm.getAuditUsers());
        this.addRemovedItems(removedUsers, cachePermData.getViewUsers(), currentPerm.getViewUsers());
        removedUsers = new ArrayList(new LinkedHashSet(removedUsers));
        ArrayList<String> removedRoles = new ArrayList<String>();
        this.addRemovedItems(removedRoles, cachePermData.getAdminRoles(), currentPerm.getAdminRoles());
        this.addRemovedItems(removedRoles, cachePermData.getEditRoles(), currentPerm.getEditRoles());
        this.addRemovedItems(removedRoles, cachePermData.getAuditRoles(), currentPerm.getAuditRoles());
        this.addRemovedItems(removedRoles, cachePermData.getViewRoles(), currentPerm.getViewRoles());
        removedRoles = new ArrayList(new LinkedHashSet(removedRoles));
        return new PermDiff(removedUsers, removedRoles);
    }

    private <T> void addRemovedItems(List<T> removedItems, List<T> originalItems, List<T> currentItems) {
        if (originalItems == null) {
            return;
        }
        if (currentItems == null) {
            removedItems.addAll(originalItems);
            return;
        }
        for (T item : originalItems) {
            if (currentItems.contains(item)) continue;
            removedItems.add(item);
        }
    }

    private void addAfterPermF7SelectListener() {
        String fieldType = ResManager.loadKDString((String)"\u7528\u6237", (String)"KMEditFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]);
        this.validatePermCount("perm_admin_user", fieldType, 100);
        this.validatePermCount("perm_edit_user", fieldType, 100);
        this.validatePermCount("perm_audit_user", fieldType, 100);
        this.validatePermCount("perm_view_user", fieldType, 100);
        fieldType = ResManager.loadKDString((String)"\u89d2\u8272", (String)"KMEditFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]);
        this.validatePermCount("perm_admin_role", fieldType, 100);
        this.validatePermCount("perm_edit_role", fieldType, 100);
        this.validatePermCount("perm_audit_role", fieldType, 100);
        this.validatePermCount("perm_view_role", fieldType, 100);
    }

    private void validatePermCount(String field, String type, int limit) {
        MulBasedataEdit permUser = (MulBasedataEdit)this.getControl(field);
        String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u9009%1$s\u6570\u91cf\u8d85\u8fc7\u9650\u5236\uff0c\u5c06\u53ea\u4fdd\u7559\u524d%2$s\u4e2a\u3002", (String)"KMEditFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]), type, limit);
        permUser.addAfterF7SelectListener(evt -> {
            ListSelectedRowCollection col = evt.getListSelectedRowCollection();
            if (col.size() > limit) {
                this.getView().showTipNotification(msg);
                this.getModel().setValue(field, (Object)col.stream().limit(limit).map(ListSelectedRow::getPrimaryKeyValue).toArray());
            }
        });
    }

    private static class PermDiff {
        private final List<Long> removedUsers;
        private final List<String> removedRoles;

        public PermDiff(List<Long> removedUsers, List<String> removedRoles) {
            this.removedUsers = removedUsers != null ? removedUsers : new ArrayList();
            this.removedRoles = removedRoles != null ? removedRoles : new ArrayList();
        }

        public List<Long> getRemovedUsers() {
            return this.removedUsers;
        }

        public List<String> getRemovedRoles() {
            return this.removedRoles;
        }

        public boolean hasRemovedItems() {
            return !this.removedUsers.isEmpty() || !this.removedRoles.isEmpty();
        }
    }
}

