/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnlUnauditSynchronScheduleTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(KnlUnauditSynchronScheduleTask.class);

    public void setTaskId(String id) {
        super.setTaskId("KnlUnauditSynchronScheduleTask" + id);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        Map result = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        for (DynamicObject dynamicObject : result.values()) {
            try {
                Map qaEntityObject;
                List validResult;
                OperationResult opResult;
                DynamicObject[] dynamicObjArrays;
                Map knls;
                String entityNumber;
                Map entityObject;
                String entityId = dynamicObject.getString("kmentityid");
                String qaentityId = dynamicObject.getString("kmqaentityid");
                HashSet expireEntityIds = new HashSet();
                if (StringUtils.isNotBlank((CharSequence)entityId) && !(entityObject = BusinessDataReader.loadFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("dentityid", "=", (Object)entityId)})).isEmpty()) {
                    for (DynamicObject dy : entityObject.values()) {
                        entityNumber = dy.getString("id");
                        knls = BusinessDataReader.loadFromCache((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("expiretime", "<=", (Object)new Date()), new QFilter("status", "=", (Object)"C")});
                        if (knls.isEmpty()) continue;
                        expireEntityIds.addAll(knls.keySet());
                        dynamicObjArrays = new DynamicObject[]{};
                        opResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNumber, (DynamicObject[])knls.values().toArray(dynamicObjArrays));
                        validResult = opResult.getAllErrorOrValidateInfo();
                        if (validResult.isEmpty()) continue;
                        LOG.error(this.showValidateResult(validResult));
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)qaentityId) || (qaEntityObject = BusinessDataReader.loadFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{new QFilter("dentityid", "=", (Object)qaentityId)})).isEmpty()) continue;
                for (DynamicObject dy : qaEntityObject.values()) {
                    entityNumber = dy.getString("id");
                    knls = BusinessDataReader.loadFromCache((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("expiretime", "<=", (Object)new Date()).or(new QFilter("associateknl", "in", expireEntityIds)), new QFilter("status", "=", (Object)"C")});
                    if (knls.isEmpty()) continue;
                    dynamicObjArrays = new DynamicObject[]{};
                    opResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNumber, (DynamicObject[])knls.values().toArray(dynamicObjArrays));
                    validResult = opResult.getAllErrorOrValidateInfo();
                    if (validResult.isEmpty()) continue;
                    LOG.error(this.showValidateResult(validResult));
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
        }
    }

    public String showValidateResult(List<IOperateInfo> errorInfos) {
        StringBuilder errorMsg = new StringBuilder();
        for (IOperateInfo errorInfo : errorInfos) {
            errorMsg.append(errorInfo.getMessage());
            if (errorMsg.length() <= 2000) continue;
            return errorMsg.toString();
        }
        return errorMsg.toString();
    }
}

