/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class RepoSchemeFormPlugin
extends AbstractFormPlugin {
    private static final String APPID_GAI = "3ACHGCGWU9MJ";
    private static final String SYSTEM = "ai-km";

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnok", "btn_update"});
    }

    public void beforeBindData(EventObject e) {
        List<ComboItem> embedingList = this.getEmbedingList();
        if (embedingList != null) {
            ComboEdit findexmethod = (ComboEdit)this.getControl("indexmethod");
            findexmethod.setComboItems(embedingList);
        }
        this.toggleMaxQEnable();
    }

    private List<ComboItem> getEmbedingList() {
        EmbeddingModel[] values = EmbeddingModel.values();
        List list = (List)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"queryInstance", (Object[])new Object[]{null, null, null});
        HashMap<String, String> mapService = new HashMap<String, String>(16);
        if (list != null && !list.isEmpty()) {
            for (Map map : list) {
                String serviceNumber = (String)map.get("service.number");
                mapService.put(serviceNumber, (String)map.get("service.name"));
            }
            ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
            for (EmbeddingModel valueMapItem : values) {
                String s = (String)mapService.get(valueMapItem.name());
                if (s == null) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(valueMapItem.name());
                comboItem.setCaption(new LocaleString(s));
                comboItemList.add(comboItem);
            }
            return comboItemList;
        }
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        if ("save".equals(operation.getOperateKey())) {
            EmbeddingModel embeddingModel;
            int dimension;
            Boolean q = (Boolean)this.getModel().getValue("q");
            Boolean qa = (Boolean)this.getModel().getValue("qa");
            if (q.equals(Boolean.FALSE) && qa.equals(Boolean.FALSE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"QA\u5411\u91cf\u8303\u56f4\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u3002", (String)"RepoSchemeFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Integer chunksize = (Integer)this.getModel().getValue("chunksize");
            String indexMethod = (String)this.getModel().getValue("indexmethod");
            if (StringUtils.isNotBlank((CharSequence)indexMethod) && (dimension = (embeddingModel = Enum.valueOf(EmbeddingModel.class, indexMethod)).getMaxToken()) < chunksize) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5757\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7\u5411\u91cf\u6a21\u578b\u7684\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002\u7ef4\u5ea6:%s", (String)"RepoSchemeFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]), dimension));
                args.setCancel(true);
                return;
            }
            if (this.getModel().getValue("enableindex") == Boolean.TRUE) {
                int maxQ = this.getMaxQ();
                BigDecimal currentQ = (BigDecimal)this.getModel().getValue("maxq");
                if (currentQ.intValue() > maxQ) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u8054\u95ee\u9898\u4e0a\u9650\u4e0d\u80fd\u8d85\u8fc7%s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RepoSchemeFormPlugin_2", (String)SYSTEM, (Object[])new Object[0]), maxQ));
                    args.setCancel(true);
                    return;
                }
                if (currentQ.intValue() == 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u8054\u95ee\u9898\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RepoSchemeFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]), maxQ));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("enableindex")) {
            this.toggleMaxQEnable();
        } else if (e.getProperty().getName().equals("chunksize") && this.getModel().getValue("enableindex") == Boolean.TRUE) {
            Integer chunksize;
            Integer value = (Integer)RepoSchemeFormPlugin.getAppParamValue(APPID_GAI, "indexspan");
            if (value == null || value == 0) {
                value = 100;
            }
            if ((chunksize = (Integer)this.getModel().getValue("chunksize")) == null) {
                chunksize = 0;
            }
            this.getModel().setValue("maxq", (Object)Math.ceil((double)chunksize.intValue() / (double)value.intValue()));
        }
    }

    private int getMaxQ() {
        Integer chunksize;
        Integer value = (Integer)RepoSchemeFormPlugin.getAppParamValue(APPID_GAI, "indexspan");
        if (value == null || value == 0) {
            value = 100;
        }
        if ((chunksize = (Integer)this.getModel().getValue("chunksize")) == null) {
            chunksize = 0;
        }
        return (int)Math.ceil((double)chunksize.intValue() / (double)value.intValue());
    }

    private static Object getAppParamValue(String bizAppId, String key) {
        AppParam appParam = new AppParam();
        appParam.setAppId(bizAppId);
        appParam.setOrgId(Long.valueOf(RequestContext.get().getOrgId()));
        appParam.setViewType("15");
        Map m = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Object paramValue = m.get(key);
        if (StringUtils.isBlank(paramValue)) {
            return "";
        }
        return paramValue;
    }

    private void toggleMaxQEnable() {
        Boolean enableindex = (Boolean)this.getModel().getValue("enableindex");
        this.getView().setEnable(enableindex, new String[]{"maxq"});
    }
}

