/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.km.base.KMDesignerData;
import kd.ai.km.service.DBField;
import kd.ai.km.service.DBFieldType;
import kd.ai.km.utils.AppParameterUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;

public class UpgradeKMEntityTask
extends AbstractTask {
    private static final String SYSTEM_TYPE = "ai-km";
    private static final Log LOG = LogFactory.getLog(UpgradeKMEntityTask.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    public static final int TARGET_VERSION = 4;
    private static final String SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '%1$s' AND KSQL_COL_NAME ='%2$s') \nALTER TABLE %3$s ADD (%4$s %5$s);";
    private static final String SQL_TABLE_EXSIT = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%1$s'";
    private static final String SQL_CREATE_TABLE = "CREATE TABLE %1$s (FDETAILID BIGINT DEFAULT 0 NOT NULL);";
    private static final String SQL_CREATE_PK = "EXEC P_ALTERPK 'PK_%1$S', '%2$S', '%3$S', '1'";
    private static final String SQL_CREATE_INDEX = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = '%1$S' AND KSQL_INDNAME = 'IDX_%2$s_%3$s') CREATE INDEX IDX_%4$s_%5$s ON %6$s ( %7$s )";
    private static final DBField[] TPL_FIELDS = new DBField[]{new DBField("FATTACHSIZE", "BIGINT DEFAULT 0 NOT NULL", DBFieldType.MAIN), new DBField("FFILEHASH", "VARCHAR(128) DEFAULT ' ' NOT NULL", DBFieldType.MAIN), new DBField("FENABLEOCR", "CHAR(1) DEFAULT '1' NOT NULL", DBFieldType.MAIN)};
    private static final DBField[] DOC_FIELDS = new DBField[]{new DBField("FTHIRDID", "VARCHAR(100) DEFAULT ' ' NOT NULL", DBFieldType.MAIN), new DBField("FGENINDEX", "VARCHAR(1) DEFAULT '0' NOT NULL", DBFieldType.CARDENTRY), new DBField("FDETAILID", "BIGINT DEFAULT 0 NOT NULL", DBFieldType.SUBENTRY), new DBField("FENTRYID", "BIGINT DEFAULT 0 NOT NULL", DBFieldType.SUBENTRY), new DBField("FSEQ", "BIGINT DEFAULT 0 NOT NULL", DBFieldType.SUBENTRY), new DBField("FQINDEX", "VARCHAR(500) DEFAULT ' ' NOT NULL", DBFieldType.SUBENTRY)};
    private static final DBField[] QA_FIELDS = new DBField[0];
    private final List<String> warnInfos = new ArrayList<String>(10);
    private final List<String> successInfos = new ArrayList<String>(10);
    private int entityCount = 0;
    private int progressCount = 1;
    private int successCount = 0;
    private int progressPercent = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String cacheKey = CacheKeyUtil.getAcctId() + ".aikm_UpgradeKMEntityTask";
        try {
            if (StringUtils.isNotBlank((CharSequence)this.taskId)) {
                cache.put(cacheKey, (Object)this.taskId, 28800);
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(3);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"UpgradeKMEntityTask_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), null);
            Map entityObject = Collections.emptyMap();
            if (TPL_FIELDS.length > 0) {
                entityObject = BusinessDataReader.loadFromCache((String)"bos_entityobject", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("modeltype", "=", (Object)"KMModel"), new QFilter("istemplate", "=", (Object)"0")});
                this.entityCount += entityObject.size() * TPL_FIELDS.length;
            }
            Map result = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[0]);
            HashSet kmEntityIds = new HashSet(10);
            HashSet<String> qaEntityIds = new HashSet<String>(10);
            for (DynamicObject dynamicObject : result.values()) {
                Iterator entityId = dynamicObject.getString("kmentityid");
                String qaEntityId = dynamicObject.getString("kmqaentityid");
                String entityNumber = dynamicObject.getString("number");
                try {
                    if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
                        KMDesignerData.upgrade(entityNumber);
                    }
                    if (StringUtils.isNotBlank(entityId)) {
                        kmEntityIds.add(entityId);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)qaEntityId)) continue;
                    qaEntityIds.add(qaEntityId);
                }
                catch (Exception e) {
                    LOG.error(String.format("\u77e5\u8bc6\u5e93\u5b9e\u4f53\u5347\u7ea7\u5931\u8d25\uff0c \u5b9e\u4f53\u7f16\u7801%1$s, \u5931\u8d25\u539f\u56e0\uff1a", entityNumber), (Throwable)e);
                }
            }
            Map docEntityObject = Collections.emptyMap();
            if (DOC_FIELDS.length > 0 && !kmEntityIds.isEmpty()) {
                docEntityObject = BusinessDataReader.loadFromCache((String)"bos_entityobject", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("dentityid", "in", kmEntityIds), new QFilter("modeltype", "=", (Object)"KMModel")});
                this.entityCount += docEntityObject.size() * DOC_FIELDS.length;
            }
            Map qaEntityObject = Collections.emptyMap();
            if (QA_FIELDS.length > 0 && !qaEntityIds.isEmpty()) {
                qaEntityObject = BusinessDataReader.loadFromCache((String)"bos_entityobject", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("dentityid", "in", qaEntityIds), new QFilter("modeltype", "=", (Object)"KMModel")});
                this.entityCount += qaEntityObject.size() * QA_FIELDS.length;
            }
            for (DynamicObject dynamicObject : entityObject.values()) {
                this.excuteSql(dynamicObject, TPL_FIELDS);
            }
            for (DynamicObject dynamicObject : docEntityObject.values()) {
                this.excuteSql(dynamicObject, DOC_FIELDS);
            }
            for (DynamicObject dynamicObject : qaEntityObject.values()) {
                this.excuteSql(dynamicObject, QA_FIELDS);
            }
            returnData.put("successCount", this.successCount);
            returnData.put("successInfos", this.successInfos);
            returnData.put("warnInfos", this.warnInfos);
            this.feedbackCustomdata(returnData);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("knlversion", 4);
            AppParameterUtils.saveAppParam(param);
        }
        catch (Throwable e) {
            LOG.error("UpgradeKMEntityTask.execute\u77e5\u8bc6\u5e93\u5b9e\u4f53\u8868\u6dfb\u52a0\u5b57\u6bb5\u5931\u8d25\uff0c \u5931\u8d25\u539f\u56e0\uff1a", e);
        }
        finally {
            cache.remove(cacheKey);
        }
    }

    private void excuteSql(DynamicObject dynamicObject, DBField[] dbFieldArrays) {
        this.progressPercent = 100 * this.progressCount / this.entityCount;
        this.feedbackProgress(this.progressPercent, String.format("\u6b63\u5728\u5904\u7406\u7b2c%1$s/%2$s\uff1a%3$s", this.progressCount, this.entityCount, ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u6b63\u5728\u5347\u7ea7", (String)"UpgradeKMEntityTask_1", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
        String entityNumber = dynamicObject.getString("number");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            this.progressCount += dbFieldArrays.length;
            return;
        }
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String routKey = mainEntityType.getDBRouteKey();
            if (StringUtils.isBlank((CharSequence)routKey)) {
                routKey = "aidb";
            }
            DBRoute dbRoute = new DBRoute(routKey);
            for (DBField dbField : dbFieldArrays) {
                String fieldName = dbField.getFieldName();
                String fieldConstraint = dbField.getFieldConstraint();
                DBFieldType fieldType = dbField.getFieldType();
                String tableName = this.getTableName(fieldType, mainEntityType);
                ++this.progressCount;
                if (StringUtils.isBlank((CharSequence)tableName) || !StringUtils.isNotBlank((CharSequence)fieldName) || !StringUtils.isNotBlank((CharSequence)fieldConstraint)) continue;
                boolean tableExsit = this.tableExsit(dbRoute, tableName);
                if (tableExsit) {
                    this.excuteAddFieldSql(tableName, fieldName, fieldConstraint, dbRoute);
                    if (fieldType != DBFieldType.SUBENTRY) continue;
                    this.excuteCreateIndexSql(tableName, fieldName, fieldConstraint, dbRoute);
                    continue;
                }
                this.warnInfos.add(String.format("%1$s \u8868\u4e0d\u5b58\u5728", tableName));
                if (fieldType != DBFieldType.SUBENTRY) continue;
                String sql = String.format(SQL_CREATE_TABLE, tableName);
                DB.execute((DBRoute)dbRoute, (String)sql);
                tableExsit = this.tableExsit(dbRoute, tableName);
                if (tableExsit) {
                    this.excuteAddFieldSql(tableName, fieldName, fieldConstraint, dbRoute);
                    this.excuteCreateIndexSql(tableName, fieldName, fieldConstraint, dbRoute);
                    continue;
                }
                this.warnInfos.add(String.format("%1$s \u8868\u521b\u5efa\u5931\u8d25", tableName));
            }
        }
        catch (Throwable e) {
            LOG.error("UpgradeKMEntityTask.excuteSql\u77e5\u8bc6\u5e93\u5b9e\u4f53\u8868\u6dfb\u52a0\u5b57\u6bb5\u5931\u8d25\uff0c \u9519\u8bef\u4fe1\u606f\uff1a", e);
        }
    }

    private boolean tableExsit(DBRoute dbRoute, String tableName) {
        return (Boolean)DB.query((DBRoute)dbRoute, (String)String.format(SQL_TABLE_EXSIT, tableName), (ResultSetHandler)new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private void excuteCreateIndexSql(String tableName, String fieldName, String fieldConstraint, DBRoute dbRoute) {
        if ("FDETAILID".equals(fieldName)) {
            String sql_create_pk = String.format(SQL_CREATE_PK, tableName, tableName, fieldName);
            DB.execute((DBRoute)dbRoute, (String)sql_create_pk);
        } else if ("FENTRYID".equals(fieldName)) {
            String tableNameSub = tableName.toUpperCase().substring(1);
            String fieldNameSub = fieldName.toUpperCase().substring(1);
            String sql_create_index = String.format(SQL_CREATE_INDEX, tableName, tableNameSub, fieldNameSub, tableNameSub, fieldNameSub, tableName, fieldName);
            DB.execute((DBRoute)dbRoute, (String)sql_create_index);
        }
    }

    private void excuteAddFieldSql(String tableName, String fieldName, String fieldConstraint, DBRoute dbRoute) {
        String sql = String.format(SQL, tableName, fieldName, tableName, fieldName, fieldConstraint);
        boolean reslut = DB.execute((DBRoute)dbRoute, (String)sql);
        if (reslut) {
            ++this.successCount;
            this.successInfos.add(String.format("%1$s \u8868\u6dfb\u52a0 %2$s \u5b57\u6bb5\u6210\u529f", tableName, fieldName));
        } else {
            this.warnInfos.add(String.format("%1$s \u8868\u6dfb\u52a0 %2$s \u5931\u8d25", tableName, fieldName));
        }
    }

    private String getTableName(DBFieldType dbfieldType, MainEntityType mainEntityType) {
        String tableName = "";
        Map entities = mainEntityType.getAllEntities();
        switch (dbfieldType) {
            case MAIN: {
                EntityType entityType;
                String mainEntityName = mainEntityType.getName();
                if (!StringUtils.isNotBlank((CharSequence)mainEntityName) || (entityType = (EntityType)entities.get(mainEntityName)) == null) break;
                tableName = entityType.getAlias();
                break;
            }
            case ENTRY: 
            case SUBCARDENTRY: {
                tableName = "";
                break;
            }
            case SUBENTRY: {
                EntityType entityType = (EntityType)entities.get("subentryentity");
                if (entityType == null) break;
                tableName = entityType.getAlias();
                break;
            }
            case CARDENTRY: {
                EntityType entityType = (EntityType)entities.get("segmententity");
                if (entityType == null) break;
                tableName = entityType.getAlias();
                break;
            }
        }
        return tableName;
    }

    public boolean getStop() {
        return this.isStop();
    }

    public void updateProgress(String progress) {
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c%1$s/%2$s\u77e5\u8bc6\u5e93sql\u8bed\u53e5\uff1a%3$s", (String)"UpgradeKMEntityTask_2", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.feedbackProgress(this.progressPercent, String.format(msg, this.progressCount, this.entityCount, progress), null);
    }
}

