/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.genqa;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import kd.ai.km.service.KMDataService;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.llm.MessageStream;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class KMGenQAFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(KMGenQAFormPlugin.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("GenQACache", new DistributeCacheHAPolicy(true, true));
    private static final String SYSTEM_TYPE = "ai-km";
    private static final String CHK_SCENE_TYPE = "chkscenetype";
    private static final String CUSTOM_SCENE = "customscene";
    private static final String CHK_TARGET_GROUP = "chktargetgroup";
    private static final String CUSTOM_TARGET = "customtarget";
    private static final String TEXTAREA_FIELD = "textareafield";
    private static final String CHK_QTYPE = "chkqtype";
    private static final String CUSTOM_QTYPE = "customqtype";
    private static final String CHK_QDEPTH = "chkqdepth";
    private static final String RADIO_FORMAT = "radioformat";
    private static final String CUSTOM_FORMAT = "customformat";
    private static final String COUNT = "count";
    private static final String[] All_PROMPT_KEYS = new String[]{"chkscenetype", "customscene", "chktargetgroup", "customtarget", "textareafield", "chkqtype", "chkqdepth", "customqtype", "radioformat", "customformat", "count"};
    private static final String CUSTOM = "custom";
    private static final String QA_ENTRY = "qaentry";
    private static final String TXT_Q = "txtq";
    private static final String TXT_A = "txta";
    private static final String TXT_ASS_KNL_ID = "assknlid";
    private static final String TXT_GROUP_ID = "groupid";
    private static final String BTN_PREVIOUS = "btnprevious";
    protected static final String BTN_GEN = "btngen";
    private static final String BTN_ADD = "btnadd";
    private static final String LBL_ADVANCE = "lbladvance";
    private static final String TABAP = "tabap";
    private static final String QA_TABPAGE = "qatabpage";
    private static final String CONFIG_TABPAGE = "configtabpage";
    private static final String COMMA = ",";
    private static final String PROMPT_CALLBACK = "promptcallback";
    private static final String PROMPT_CACHE = "prompter";
    private static final String QA_ENTITY_NUMBER = "QAEntityNumber";
    private static final String ENTITY_NUMBER = "entityNumber";
    private static final String CALLBACK_TASK_GEN_QA = "taskGenQA";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_GEN, BTN_PREVIOUS, BTN_ADD});
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(TEXTAREA_FIELD, (Object)" - \u5236\u5ea6\u80cc\u666f\n - \u8d23\u4efb\u5206\u914d\n - \u5b9e\u65bd\u65b9\u6cd5");
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_PREVIOUS, BTN_ADD});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btngen": {
                List qas;
                FormShowParameter parameter = this.getView().getFormShowParameter();
                String entityNumber = (String)parameter.getCustomParam(ENTITY_NUMBER);
                String knlIds = (String)parameter.getCustomParam("knlIds");
                if (knlIds != null) {
                    List idList = (List)SerializationUtils.fromJsonString((String)knlIds, Object.class);
                    this.dispatchTask(entityNumber, idList);
                    return;
                }
                String prompt = this.getFinalPrompt(this.buildPrompt());
                MessageStream stream = LLMService.create().llm(prompt, new HashMap(0));
                String content = stream.fetch();
                if (StringUtils.isBlank((CharSequence)content)) {
                    return;
                }
                content = content.replace("```json", "").replace("```", "");
                try {
                    qas = SerializationUtils.fromJsonStringToList((String)content, Map.class);
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                    return;
                }
                this.getModel().deleteEntryData(QA_ENTRY);
                int[] rows = this.getModel().batchCreateNewEntryRow(QA_ENTRY, qas.size());
                for (int i = 0; i < rows.length; ++i) {
                    this.getModel().setValue(TXT_Q, ((Map)qas.get(i)).get("question"), i);
                    this.getModel().setValue(TXT_A, ((Map)qas.get(i)).get("answer"), i);
                }
                Tab tab = (Tab)this.getControl(TABAP);
                tab.activeTab(QA_TABPAGE);
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GEN});
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_PREVIOUS, BTN_ADD});
                break;
            }
            case "btnprevious": {
                Tab tab = (Tab)this.getControl(TABAP);
                tab.activeTab(CONFIG_TABPAGE);
                this.getView().setVisible(Boolean.TRUE, new String[]{BTN_GEN});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTN_PREVIOUS, BTN_ADD});
                break;
            }
            case "btnadd": {
                this.genQASave();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        String property = e.getProperty().getName();
        if (Arrays.asList(All_PROMPT_KEYS).contains(property) && !Objects.equals((changeData = e.getChangeSet()[0]).getOldValue(), changeData.getNewValue())) {
            this.getPageCache().remove(PROMPT_CACHE);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (LBL_ADVANCE.equals(fieldName)) {
            String prompt = this.buildPrompt();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PROMPT_CALLBACK));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("aikm_knl_genqa_detail");
            parameter.setCustomParam("content", (Object)prompt);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (PROMPT_CALLBACK.equals(actionId)) {
            String newContent = (String)returnData;
            this.getPageCache().put(PROMPT_CACHE, newContent);
            if (KMGenQAFormPlugin.compareIgnoreSpecialChars(this.buildConfigPrompt(), newContent)) {
                this.getView().setEnable(Boolean.TRUE, All_PROMPT_KEYS);
            } else {
                this.getView().setEnable(Boolean.FALSE, All_PROMPT_KEYS);
            }
        } else if (CALLBACK_TASK_GEN_QA.equals(actionId)) {
            this.taskClosedCallBack(returnData);
        }
    }

    private static boolean compareIgnoreSpecialChars(String str1, String str2) {
        String processedStr1 = Pattern.compile("[\r\n\t]").matcher(str1).replaceAll("");
        String processedStr2 = Pattern.compile("[\r\n\t]").matcher(str2).replaceAll("");
        return processedStr1.equals(processedStr2);
    }

    private String buildPrompt() {
        String prompt = this.getPageCache().get(PROMPT_CACHE);
        if (StringUtils.isNotBlank((CharSequence)prompt)) {
            return prompt;
        }
        prompt = this.buildConfigPrompt();
        this.getPageCache().put(PROMPT_CACHE, prompt);
        return prompt;
    }

    private String buildConfigPrompt() {
        String scene = this.getPromptWord(CHK_SCENE_TYPE, CUSTOM_SCENE, "\u573a\u666f\u7c7b\u578b");
        String target = this.getPromptWord(CHK_TARGET_GROUP, CUSTOM_TARGET, "\u76ee\u6807\u7528\u6237");
        String qtype = this.getPromptWord(CHK_QTYPE, CUSTOM_QTYPE, "\u95ee\u9898\u7c7b\u578b");
        String qdepth = this.getPromptWord(CHK_QDEPTH, null, "\u95ee\u9898\u6df1\u5ea6");
        String format = this.getPromptWord(RADIO_FORMAT, CUSTOM_FORMAT, "\u5185\u5bb9\u683c\u5f0f");
        if (StringUtils.isBlank((CharSequence)scene) || StringUtils.isBlank((CharSequence)target) || StringUtils.isBlank((CharSequence)qtype) || StringUtils.isBlank((CharSequence)format)) {
            throw new RuntimeException("\u7f3a\u5c11\u914d\u7f6e\u9879");
        }
        String field = (String)this.getModel().getValue(TEXTAREA_FIELD);
        BigDecimal count = (BigDecimal)this.getModel().getValue(COUNT);
        String promptTemplate = this.getPromptTemplateFromFile("prompt/GenQA.md", "");
        return promptTemplate.replace("{{scene}}", scene).replace("{{target}}", target).replace("{{field}}", field).replace("{{qtype}}", qtype).replace("{{qdepth}}", qdepth).replace("{{format}}", format).replace("{{count}}", String.valueOf(count));
    }

    private String getFinalPrompt(String prompt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String subject = (String)parameter.getCustomParam("subject");
        String article = (String)parameter.getCustomParam("article");
        prompt = prompt + "\n\u8bf7\u6839\u636e\u6587\u7ae0\u5185\u5bb9\uff0c\u751f\u6210\u5173\u4e8e<<{{subject}}>>\u7684\u95ee\u7b54\u5bf9\u3002\n";
        prompt = prompt + "# \u8f93\u51fa\u8981\u6c42:\n\u4e25\u683c\u6309\u7167\u4ee5 `[{\"question\":?,\"answer\":?}]` \u7684json\u5217\u8868\u683c\u5f0f\u8f93\u51fa\u7ed3\u679c\u3002question\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7{{chunkSize}}\u5b57\u3002\n";
        prompt = prompt.replace("{{subject}}", subject);
        prompt = prompt.replace("{{chunkSize}}", this.getQAChunkSize() + "");
        prompt = prompt + "\n# \u6587\u7ae0\u5185\u5bb9:\n " + article;
        StringBuilder sb = new StringBuilder();
        sb.append(prompt);
        String securityPrompt = this.getPromptTemplateFromFile("prompt/SecurityPrompt.md", "");
        if (StringUtils.isBlank((CharSequence)securityPrompt)) {
            return sb.toString();
        }
        sb.insert(0, securityPrompt);
        return sb.toString();
    }

    private int getQAChunkSize() {
        String QAEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(QA_ENTITY_NUMBER);
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(QAEntityNumber);
        return splitConfig.getChunkSize() != 0 ? splitConfig.getChunkSize() : 200;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getPromptTemplateFromFile(String filePath, String securityPrompt) {
        try {
            QFilter qFilter = new QFilter("path", "=", (Object)filePath);
            qFilter.or("number", "=", (Object)filePath);
            Optional<String> prompt = KMGenQAFormPlugin.loadPromptTemplateFromSkillCorpus(qFilter);
            if (prompt.isPresent()) {
                return prompt.get();
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        try (InputStream stream = KMGenQAFormPlugin.class.getResourceAsStream("/" + KMGenQAFormPlugin.class.getPackage().getName().replace(".", "/") + "/" + filePath);){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)securityPrompt)) {
                s.append(securityPrompt);
            }
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i));
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Optional<String> loadPromptTemplateFromSkillCorpus(QFilter qFilter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_skillcorpus", (String)"number, name, inputcontent, inputcontent_tag", (QFilter[])qFilter.and(enableFilter).toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            String json = dynamicObjects[0].getString("inputcontent_tag");
            return Optional.of(json);
        }
        return Optional.empty();
    }

    private void dispatchTask(String entityNumber, List<Object> idList) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appId = entityType.getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        LocaleString jobName = new LocaleString(entityType.getDisplayName().getLocaleValue());
        jobInfo.setName(jobName.toString());
        jobInfo.setNumber(entityNumber + "_genQAJob");
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.km.management.genqa.BatchGenQATask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        String pageId = this.getView().getPageId();
        params.put("pageId", pageId);
        params.put(ENTITY_NUMBER, entityNumber);
        params.put("prompt", this.buildPrompt());
        String securityPrompt = this.getPromptTemplateFromFile("prompt/SecurityPrompt.md", "");
        params.put("securityPrompt", securityPrompt);
        params.put("ids", idList);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_TASK_GEN_QA);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"KMGenQAFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.ai.km.management.genqa.BatchGenQATaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void taskClosedCallBack(Object returnData) {
        Map returnDataMap = (Map)returnData;
        if (!returnDataMap.containsKey("taskinfo")) {
            return;
        }
        String taskInfoStr = (String)returnDataMap.get("taskinfo");
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        Object isSuccess = dataMap.get("success");
        List errorInfos = dataMap.getOrDefault("errorInfos", new ArrayList(0));
        int fileCount = dataMap.getOrDefault("fileCount", 0);
        int successCount = dataMap.getOrDefault("successCount", 0);
        if ("true".equals(isSuccess)) {
            String title = ResManager.loadKDString((String)"QA\u751f\u6210\u5b8c\u6210\u3002", (String)"KMGenQAFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showSuccessNotification(title);
        } else {
            String titile = String.format(ResManager.loadKDString((String)"QA\u751f\u6210\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"KMGenQAFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), successCount, fileCount - successCount);
            this.getView().showMessage(titile, String.join((CharSequence)"\n", errorInfos), MessageTypes.Default);
        }
        if (successCount <= 0) {
            return;
        }
        String pageId = this.getView().getPageId();
        String dataStr = (String)cache.get(pageId);
        if (StringUtils.isBlank((CharSequence)dataStr)) {
            return;
        }
        cache.remove(pageId);
        Map qaMap = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        if (qaMap == null) {
            return;
        }
        this.getModel().deleteEntryData(QA_ENTRY);
        for (Map.Entry entry : qaMap.entrySet()) {
            Object pk = entry.getKey();
            Object value = entry.getValue();
            List qas = (List)value;
            for (Map qa : qas) {
                int row = this.getModel().createNewEntryRow(QA_ENTRY);
                this.getModel().setValue(TXT_Q, qa.get("question"), row);
                this.getModel().setValue(TXT_A, qa.get("answer"), row);
                this.getModel().setValue(TXT_GROUP_ID, qa.get("groupId"), row);
                this.getModel().setValue(TXT_ASS_KNL_ID, pk, row);
            }
        }
        Tab tab = (Tab)this.getControl(TABAP);
        tab.activeTab(QA_TABPAGE);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_GEN});
        this.getView().setVisible(Boolean.TRUE, new String[]{BTN_PREVIOUS, BTN_ADD});
    }

    private void genQASave() {
        DynamicObjectCollection qaEntry = this.getModel().getEntryEntity(QA_ENTRY);
        if (qaEntry.size() == 0) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object groupId = showParameter.getCustomParam("groupId");
        Object associateKnlId = showParameter.getCustomParam("pkValue");
        String knlIds = (String)showParameter.getCustomParam("knlIds");
        String QAEntityNumber = (String)showParameter.getCustomParam(QA_ENTITY_NUMBER);
        Object useOrg = showParameter.getCustomParam("useOrg");
        int chunkSize = this.getQAChunkSize();
        ArrayList<Map<String, Object>> knlObjList = new ArrayList<Map<String, Object>>(qaEntry.size());
        for (int i = 0; i < qaEntry.size(); ++i) {
            DynamicObject qa = (DynamicObject)qaEntry.get(i);
            String question = qa.getString(TXT_Q);
            String answer = qa.getString(TXT_A);
            if (StringUtils.isBlank((CharSequence)question) || StringUtils.isBlank((CharSequence)answer) || question.length() >= chunkSize) continue;
            if (StringUtils.isNotBlank((CharSequence)knlIds)) {
                groupId = qa.getString(TXT_GROUP_ID);
                associateKnlId = qa.getString(TXT_ASS_KNL_ID);
            }
            HashMap<String, Object> knlObjMap = new HashMap<String, Object>(6);
            knlObjMap.put("Q", question);
            knlObjMap.put("A", answer);
            knlObjMap.put("seq", i);
            knlObjMap.put("useOrg", useOrg);
            knlObjMap.put("groupId", groupId);
            knlObjMap.put("associateKnlId", associateKnlId);
            knlObjList.add(knlObjMap);
        }
        Map<Integer, String> resultMap = KMDataService.create().batchCreateQAKMObject(QAEntityNumber, knlObjList);
        IFormView parentView = this.getView().getParentView();
        if (!resultMap.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Integer, String> entry : resultMap.entrySet()) {
                builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u4fdd\u5b58\u5931\u8d25\uff1a%2s", (String)"KMGenQAFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), entry.getKey() + 1, entry.getValue()));
                builder.append("\n");
            }
            parentView.showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"KMGenQAFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), builder.toString(), MessageTypes.Default);
            this.getView().sendFormAction(parentView);
            return;
        }
        this.getView().returnDataToParent((Object)"1");
        this.getView().close();
    }

    private String getPromptWord(String key, String customKey, String tips) {
        String promptWord = (String)this.getModel().getValue(key);
        if (StringUtils.contains((CharSequence)promptWord, (CharSequence)CUSTOM)) {
            promptWord = (String)this.getModel().getValue(customKey);
        } else {
            String[] splitPromptWords;
            ArrayList<String> promptWordList = new ArrayList<String>(10);
            for (String split : splitPromptWords = promptWord.split(COMMA)) {
                if (!StringUtils.isNotBlank((CharSequence)split)) continue;
                promptWordList.add(PromptWord.valueOf(StringUtils.upperCase((String)split)).getValue());
            }
            promptWord = StringUtils.join((Object[])promptWordList.toArray(new String[0]), (String)COMMA);
        }
        if (StringUtils.isBlank((CharSequence)promptWord)) {
            this.getView().showTipNotification(tips + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return promptWord;
    }

    private static enum PromptWord {
        REGULATION("\u5236\u5ea6\u89e3\u8bfb"),
        USAGE("\u4f7f\u7528\u573a\u666f"),
        MANUAL("\u64cd\u4f5c\u624b\u518c"),
        STAFF("\u5458\u5de5"),
        USER("\u7528\u6237"),
        DEVELOPER("\u5f00\u53d1\u8005"),
        MANAGER("\u7ba1\u7406\u5c42"),
        CONCEPT("\u6982\u5ff5\u6027\u95ee\u9898"),
        OPERATE("\u64cd\u4f5c\u6027\u95ee\u9898"),
        SITUATION("\u573a\u666f\u5316\u95ee\u9898"),
        BASIC("\u57fa\u7840"),
        MIDDLE("\u4e2d\u7ea7"),
        ADVANCE("\u9ad8\u7ea7"),
        SIMPLE("\u7b80\u660e\u627c\u8981"),
        PROCEDURE("\u8be6\u7ec6\u6b65\u9aa4"),
        EXAMPLE("\u4e3e\u4f8b\u8bf4\u660e");

        private final String value;

        private PromptWord(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

