/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.genqa;

import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.km.management.genqa.model.KMGenQAConfig;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class KMGenQALoadSchemePlugin
extends AbstractFormPlugin {
    private static final String ENTITY_SCHEME = "aikm_genqa_scheme";
    private static final String BTN_EDIT = "btn_edit";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_LOAD_SCHEME = "btn_loadscheme";
    private static final String FIELD_NAME_EDIT = "nameedit";
    private static final String FIELD_NAME_VIEW = "nameview";
    private static final String ENTRY_SCHEME = "schemeentry";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_EDIT, BTN_SAVE, BTN_LOAD_SCHEME});
    }

    public void afterBindData(EventObject e) {
        this.loadSchemeEntry();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_EDIT.equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SCHEME);
            if (rowIndex < 0) {
                return;
            }
            CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_SCHEME);
            cardEntry.setChildVisible(false, rowIndex, new String[]{FIELD_NAME_VIEW, BTN_EDIT});
            cardEntry.setChildVisible(true, rowIndex, new String[]{FIELD_NAME_EDIT, BTN_SAVE});
        } else if (BTN_SAVE.equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SCHEME);
            CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_SCHEME);
            cardEntry.setChildVisible(true, rowIndex, new String[]{FIELD_NAME_VIEW, BTN_EDIT});
            cardEntry.setChildVisible(false, rowIndex, new String[]{FIELD_NAME_EDIT, BTN_SAVE});
            this.saveScheme();
        } else if (BTN_LOAD_SCHEME.equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SCHEME);
            this.loadSchemeConfig(rowIndex);
        }
    }

    private void loadSchemeEntry() {
        this.getModel().deleteEntryData(ENTRY_SCHEME);
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRY_SCHEME);
        DynamicObjectCollection schemeDataCol = QueryServiceHelper.query((String)ENTITY_SCHEME, (String)"id,name,scenetype,coverarea,conceptual,procedural,contextual,contentmodel,gencount,prompt,creator.id,createtime", null);
        List sortedSchemeDatas = schemeDataCol.stream().sorted(Comparator.comparing(schemeData -> schemeData.getDate("createtime"))).collect(Collectors.toList());
        if (schemeDataCol.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_SCHEME, schemeDataCol.size());
        for (int i = 0; i < sortedSchemeDatas.size(); ++i) {
            DynamicObject schemeData2 = (DynamicObject)sortedSchemeDatas.get(sortedSchemeDatas.size() - 1 - i);
            this.getModel().setValue(FIELD_NAME_VIEW, (Object)schemeData2.getString("name"), i);
            this.getModel().setValue(FIELD_NAME_EDIT, (Object)schemeData2.getString("name"), i);
            this.getModel().setValue("schemeid", schemeData2.get("id"), i);
            this.getModel().setValue("scenetype", schemeData2.get("scenetype"), i);
            this.getModel().setValue("coverarea", schemeData2.get("coverarea"), i);
            this.getModel().setValue("conceptual", schemeData2.get("conceptual"), i);
            this.getModel().setValue("procedural", schemeData2.get("procedural"), i);
            this.getModel().setValue("contextual", schemeData2.get("contextual"), i);
            this.getModel().setValue("contentmodel", schemeData2.get("contentmodel"), i);
            this.getModel().setValue("gencount", schemeData2.get("gencount"), i);
            this.getModel().setValue("prompt", schemeData2.get("prompt"), i);
            cardEntry.setChildVisible(false, i, new String[]{FIELD_NAME_EDIT, BTN_SAVE});
        }
        this.getView().updateView(ENTRY_SCHEME);
    }

    private void saveScheme() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_SCHEME);
        Object schemeId = this.getModel().getValue("schemeid", rowIndex);
        if (StringUtils.isBlank((Object)schemeId)) {
            return;
        }
        DynamicObject schemeData = BusinessDataServiceHelper.loadSingle((String)ENTITY_SCHEME, (QFilter[])new QFilter[]{new QFilter("id", "=", schemeId)});
        if (null == schemeData) {
            return;
        }
        Object name = this.getModel().getValue(FIELD_NAME_EDIT);
        schemeData.set("name", name);
        SaveServiceHelper.update((DynamicObject)schemeData);
        this.getModel().setValue(FIELD_NAME_VIEW, name);
    }

    private void loadSchemeConfig(int rowIndex) {
        KMGenQAConfig config = new KMGenQAConfig();
        Object prompt = this.getModel().getValue("prompt", rowIndex);
        if (StringUtils.isNotBlank((Object)prompt)) {
            config.setPrompt(prompt.toString());
        } else {
            config.setSceneType(this.getModel().getValue("scenetype", rowIndex).toString());
            config.setCoverArea(this.getModel().getValue("coverarea", rowIndex).toString());
            config.setContextual((Boolean)this.getModel().getValue("contextual", rowIndex));
            config.setProcedural((Boolean)this.getModel().getValue("procedural", rowIndex));
            config.setConceptual((Boolean)this.getModel().getValue("conceptual", rowIndex));
            config.setContentMode(Integer.parseInt(this.getModel().getValue("contentmodel", rowIndex).toString()));
            config.setGenCount(Integer.parseInt(this.getModel().getValue("gencount", rowIndex).toString()));
        }
        IFormView configView = this.getView().getParentView();
        configView.getPageCache().put("loadConfig", SerializationUtils.toJsonString((Object)config));
        configView.updateView();
        this.getView().sendFormAction(configView);
    }
}

