/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.genqa;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;

public class KMGenQASuccessFormPlugin
extends AbstractFormPlugin {
    private static final String SYSTEM = "ai-km";
    private static final String BTN_VIEW_QA = "btnok";
    private static final String PROP_KNL_NAME = "knlname";
    private static final String PROP_QUESTION_TYPE = "questiontype";
    private static final String PROP_CONTENT_FORMAT = "contentformat";
    private static final String PROP_QA_COUNT = "qacount";
    private static final String PARAM_QA_COUNT = "qaCount";
    private static final String PARAM_KNL_NAMES = "knlNames";
    private static final String PARAM_QUESTION_TYPE = "questionType";
    private static final String PARAM_CONTENT_FORMAT = "contentFormat";
    private static final String PARAM_KM_ENTITY_NUMBER = "kmEntityNumber";
    private static final String PARAM_QA_ENTITY_NUMBER = "qaEntityNumber";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_VIEW_QA});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams == null || !customParams.containsKey(PARAM_QA_COUNT)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u751f\u6210\u4fe1\u606f\u3002", (String)"KMGenQASuccessFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue(PROP_QA_COUNT, customParams.get(PARAM_QA_COUNT));
        if (customParams.containsKey(PARAM_KNL_NAMES)) {
            this.getModel().setValue(PROP_KNL_NAME, (Object)KMGenQASuccessFormPlugin.getSummary((List)customParams.get(PARAM_KNL_NAMES)));
        }
        this.getModel().setValue(PROP_QUESTION_TYPE, customParams.get(PARAM_QUESTION_TYPE));
        this.getModel().setValue(PROP_CONTENT_FORMAT, customParams.get(PARAM_CONTENT_FORMAT));
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_VIEW_QA.equals(key)) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object kmEntityNumber = customParams.get(PARAM_KM_ENTITY_NUMBER);
            if (StringUtils.isBlank(kmEntityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u77e5\u8bc6\u5e93\u4fe1\u606f\u3002", (String)"KMGenQASuccessFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
                return;
            }
            IFormView parentView = this.getView().getParentView();
            if (parentView instanceof IListView && kmEntityNumber.equals(((ListShowParameter)parentView.getFormShowParameter()).getBillFormId())) {
                Tab tab = (Tab)parentView.getControl("tabap");
                tab.activeTab("tabqa");
                this.getView().sendFormAction(parentView);
                this.getView().close();
                return;
            }
            IFormView parentView1 = parentView.getParentView();
            if (parentView1 instanceof IListView && kmEntityNumber.equals(((ListShowParameter)parentView1.getFormShowParameter()).getBillFormId())) {
                parentView1.activate();
                Tab tab = (Tab)parentView1.getControl("tabap");
                tab.activeTab("tabqa");
                this.getView().sendFormAction(parentView1);
                this.getView().close();
                return;
            }
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(kmEntityNumber.toString());
            lsp.setCustomParam("showQAList", (Object)"true");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parentView.showForm((FormShowParameter)lsp);
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    public static String getSummary(List<String> knlNames) {
        String separator;
        int i;
        if (knlNames == null || knlNames.isEmpty()) {
            return "";
        }
        int maxLen = 30;
        int totalDocs = knlNames.size();
        String suffix = String.format(ResManager.loadKDString((String)"\u2026\u7b49%s\u4e2a\u6587\u6863", (String)"KMGenQASuccessFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]), totalDocs);
        int suffixLen = suffix.length();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < totalDocs; ++i) {
            String toAdd;
            String fileName = knlNames.get(i);
            String string = toAdd = sb.length() == 0 ? fileName : "\u3001" + fileName;
            if (sb.length() + toAdd.length() > maxLen) break;
            sb.append(toAdd);
        }
        if (i == totalDocs) {
            return sb.toString();
        }
        int currentLen = sb.length();
        int available = maxLen - currentLen - (separator = sb.length() == 0 ? "" : "\u3001").length() - suffixLen;
        if (available > 0) {
            String fileName = knlNames.get(i);
            String partial = fileName.substring(0, Math.min(available, fileName.length()));
            sb.append(separator).append(partial);
        }
        sb.append(suffix);
        return sb.toString();
    }
}

