/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.index;

import java.util.ArrayList;
import java.util.function.Consumer;
import kd.ai.km.management.index.KMIndexServiceImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.kmbase.service.EmbeddingTransactionHandler;

public class KMIndexHandler
implements EmbeddingTransactionHandler {
    private static final String INDEX = "_index";

    public int getChunkCount(DynamicObject data) {
        DynamicObjectCollection rows = data.getDynamicObjectCollection("segmententity");
        int count = 0;
        for (DynamicObject row : rows) {
            DynamicObjectCollection subRows = row.getDynamicObjectCollection("subentryentity");
            count += subRows.size();
        }
        return count;
    }

    public void save(String entityId, SplitConfig splitConfig, DynamicObject data, Consumer<Integer> consumer) {
        entityId = entityId + INDEX;
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>(16);
        DynamicObjectCollection rows = data.getDynamicObjectCollection("segmententity");
        for (DynamicObject row : rows) {
            DynamicObjectCollection subRows = row.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subRow : subRows) {
                long id = subRow.getLong("id");
                Chunk chunk = new Chunk(Long.valueOf(id), entityId, Long.valueOf(data.getLong("id")), subRow.getString("qindex"));
                chunk.setGroupId(Long.valueOf(data.getLong("group_id")));
                chunk.setChunkType("TEXT");
                chunkList.add(chunk);
            }
        }
        if (!chunkList.isEmpty()) {
            KMIndexServiceImpl kmIndexService = new KMIndexServiceImpl(splitConfig.getEmbeddingModel());
            kmIndexService.addEmbeddingCompleteListener(consumer::accept);
            boolean result = kmIndexService.batchSave(entityId, chunkList);
            if (!result) {
                throw new KDBizException(GptasErrorCode.VECTOR_STORE_WRITE_ERROR.toErrorCode(), new Object[0]);
            }
        }
    }

    public void deleteAll(String entityId, SplitConfig splitConfig, DynamicObject data) {
        entityId = entityId + INDEX;
        ArrayList<Long> deleteList = new ArrayList<Long>(16);
        DynamicObjectCollection rows = data.getDynamicObjectCollection("segmententity");
        for (DynamicObject row : rows) {
            DynamicObjectCollection subRows = row.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subRow : subRows) {
                long id = subRow.getLong("id");
                deleteList.add(id);
            }
        }
        if (!deleteList.isEmpty()) {
            new KMIndexServiceImpl(splitConfig.getEmbeddingModel()).delete(entityId, deleteList);
        }
    }
}

