/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.km.management.index.KMIndexStorePlugin;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.VectorServiceImpl;
import kd.bos.gptas.common.vectordb.model.VectorQuery;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KMIndexServiceImpl
extends VectorServiceImpl {
    private static final Log logger = LogFactory.getLog(KMIndexServiceImpl.class);

    public KMIndexServiceImpl(EmbeddingModel embeddingModel) {
        super(embeddingModel);
        this.setVectorStorePlugin(Collections.singletonList(new KMIndexStorePlugin()));
    }

    private String ensureEntityId(String entityId) {
        if (!entityId.endsWith("_index")) {
            return entityId + "_index";
        }
        return entityId;
    }

    public void save(Chunk chunk) {
        chunk.setEntityId(this.ensureEntityId(chunk.getEntityId()));
        super.save(chunk);
    }

    public List<VectorResult> searchByVector(VectorQuery query) {
        VectorQuery newQuery = (VectorQuery)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)query), VectorQuery.class);
        ArrayList<String> repositoryIdList = new ArrayList<String>(16);
        for (String repositoryId : newQuery.getRepositoryIds()) {
            repositoryIdList.add(this.ensureEntityId(repositoryId));
        }
        newQuery.setRepositoryIds(repositoryIdList);
        return super.searchByVector(newQuery);
    }

    public void save(String entityId, Long knowledgeId, Long chunkId, String content) {
        entityId = this.ensureEntityId(entityId);
        super.save(entityId, knowledgeId, chunkId, content);
    }

    public boolean batchSave(String entityId, List<Chunk> chunks) {
        entityId = this.ensureEntityId(entityId);
        return super.batchSave(entityId, chunks);
    }

    public void delete(String entityId, List<Long> chunkIds) {
        entityId = this.ensureEntityId(entityId);
        super.delete(entityId, chunkIds);
    }
}

