/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.kmreimport;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.management.kmreimport.KMReimportTask;
import kd.ai.km.utils.KMManager;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.QueryServiceHelper;

public class KMReimportFormPlugin
extends AbstractFormPlugin {
    private static final String AI_KM = "ai-km";
    public static final String LISTVIEWPAGEID = "listviewpageid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"reimportall", "reimportselect"});
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equals("reimportall")) {
            this.doImportAll();
        } else if (btn.getKey().equals("reimportselect")) {
            this.doImportSelect();
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"targetknl"});
    }

    private void doImportAll() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5168\u90e8\u91cd\u65b0\u5bfc\u5165\u4f1a\u5bf9\u5f53\u524d\u77e5\u8bc6\u5e93\u6240\u6709\u6587\u6863\u91cd\u65b0\u89e3\u6790\uff0c\u8017\u65f6\u8f83\u957f\uff0c\u786e\u5b9a\u5168\u90e8\u91cd\u65b0\u5bfc\u5165\u5417?", (String)"KMReimportFormPlugin_0", (String)AI_KM, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("runall", (IFormPlugin)this));
    }

    private void doImportSelect() {
        List saveIds;
        DynamicObject target;
        DynamicObject km = (DynamicObject)this.getModel().getValue("knl");
        if (km == null) {
            return;
        }
        String pageId = this.getPageCache().get(LISTVIEWPAGEID);
        if (pageId == null) {
            this.getView().showTipNotification("must be select knl.");
            return;
        }
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            this.getView().showTipNotification("list view not exists.");
            return;
        }
        BillList billlistap = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billlistap.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification("no select rows");
            return;
        }
        KMManager kmManager = new KMManager(km.getLong("id"));
        Boolean sync = (Boolean)this.getModel().getValue("sync");
        if (sync.booleanValue()) {
            target = (DynamicObject)this.getModel().getValue("targetknl");
            if (target == null) {
                this.getView().showTipNotification("please select target knl.");
                return;
            }
            if (target.getLong("id") == km.getLong("id")) {
                this.getView().showTipNotification("target knl can not be same as source knl.");
                return;
            }
        } else {
            target = null;
        }
        if ((saveIds = QueryServiceHelper.queryPrimaryKeys((String)kmManager.getKMEntityNumber(), (QFilter[])new QFilter[]{new QFilter("status", "!=", (Object)"A"), new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues())}, (String)"id", (int)selectedRows.size())).size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6682\u5b58\u7684\u6570\u636e\u3002", (String)"KMReimportFormPlugin_1", (String)AI_KM, (Object[])new Object[0]));
            return;
        }
        Boolean needSplit = (Boolean)this.getModel().getValue("needSplit");
        KMReimportTask.start(this, "runner", km.getLong("id"), target == null ? null : Long.valueOf(target.getLong("id")), selectedRows.getPrimaryKeyValues(), needSplit);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("knl")) {
            this.showKnlListView();
        }
        if (e.getProperty().getName().equals("sync")) {
            if (((Boolean)this.getModel().getValue("sync")).booleanValue()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"targetknl"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"targetknl"});
            }
        }
    }

    private void showKnlListView() {
        DynamicObject km = (DynamicObject)this.getModel().getValue("knl");
        if (km == null) {
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        KMManager kmManager = new KMManager(km.getLong("id"));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)kmManager.getKMEntityNumber(), (boolean)true, (int)0, (boolean)false);
        OpenStyle openStyle = listShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("flexpanelap1");
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("100%");
        openStyle.setInlineStyleCss(styleCss);
        String pageID = listShowParameter.getPageId();
        listShowParameter.addCustPlugin("kd.ai.km.management.kmreimport.KMReimportFormPlugin$NoCloseListFormPlugin");
        this.getPageCache().put(LISTVIEWPAGEID, pageID);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        if (evt.getActionId().equals("runner") && (returnData = evt.getReturnData()) instanceof Map) {
            Map returnDataMap = (Map)returnData;
            if (!returnDataMap.containsKey("taskinfo")) {
                return;
            }
            String taskInfoStr = (String)returnDataMap.get("taskinfo");
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            Map<String, Object> taskData = this.getTaskData(taskInfo);
            int count = taskData.get("cnt") == null ? -1 : Integer.parseInt(String.valueOf(taskData.get("cnt")));
            String errors = taskData.get("errors") == null ? "" : String.valueOf(taskData.get("errors"));
            String msg = "\u5bfc\u5165\u5b8c\u6210\u3002%s\u6587\u6863.%s";
            this.getView().showSuccessNotification(String.format(msg, count, errors));
        }
    }

    private Map<String, Object> getTaskData(TaskInfo taskInfo) {
        if (StringUtils.isNotBlank((CharSequence)taskInfo.getData())) {
            Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            return data;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("cnt", -1);
        data.put("errors", "");
        return data;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getCallBackId().equals("runall") && evt.getResult() == MessageBoxResult.Yes) {
            DynamicObject target;
            DynamicObject km = (DynamicObject)this.getModel().getValue("knl");
            if (km == null) {
                return;
            }
            Boolean needSplit = (Boolean)this.getModel().getValue("needSplit");
            Boolean sync = (Boolean)this.getModel().getValue("sync");
            if (sync.booleanValue()) {
                target = (DynamicObject)this.getModel().getValue("targetknl");
                if (target == null) {
                    this.getView().showTipNotification("please select target knl.");
                    return;
                }
                if (target.getLong("id") == km.getLong("id")) {
                    this.getView().showTipNotification("target knl can not be same as source knl.");
                    return;
                }
            } else {
                target = null;
            }
            KMReimportTask.start(this, "runner", km.getLong("id"), target == null ? null : Long.valueOf(target.getLong("id")), null, needSplit);
        }
    }

    public static class NoCloseListFormPlugin
    extends AbstractListPlugin {
        public void afterBindData(EventObject e) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblclose"});
        }

        public void beforeClosed(BeforeClosedEvent e) {
            e.setCancel(true);
        }
    }
}

