/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.permission.cache.CacheMrg;
import kd.bos.permission.model.perm.req.DimFuncPermReq;
import kd.bos.permission.model.perm.req.user.UserDirectAssignPermReq;
import kd.bos.permission.model.perm.req.user.UserDirectAssignReq;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PermAssign {
    private static final AppInfo app_info;
    private static final String PERM_ITEM_SAVE = "0=KX5+QVF5+R";
    private static final String PERM_ITEM_COPY = "4730fc9f000020ae";
    private static Map<PermItemType, List<String>> perm_items;

    public static void assignUser(List<String> entityIds, List<Long> userIds, PermItemType permItemType) {
        List<String> permItems = perm_items.get((Object)permItemType);
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)"gai");
        ArrayList<UserDirectAssignPermReq> reqList = new ArrayList<UserDirectAssignPermReq>(userIds.size());
        for (Long userId : userIds) {
            UserDirectAssignPermReq permReq = new UserDirectAssignPermReq();
            permReq.setUserId(userId);
            permReq.setDimType("bos_org");
            ArrayList<DimFuncPermReq> dimFuncPermReqs = new ArrayList<DimFuncPermReq>(10);
            permReq.setAddList(dimFuncPermReqs);
            for (String entityId : entityIds) {
                for (String permItem : permItems) {
                    DimFuncPermReq dimFuncPermReq = new DimFuncPermReq();
                    dimFuncPermReq.setDimId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
                    dimFuncPermReq.setIncludeSub(Boolean.TRUE);
                    dimFuncPermReq.setAppId(appInfo.getId());
                    dimFuncPermReq.setEntityNumber(entityId);
                    dimFuncPermReq.setPermItemId(permItem);
                    dimFuncPermReq.setFromTypeDesc("km_model");
                    dimFuncPermReqs.add(dimFuncPermReq);
                }
            }
            reqList.add(permReq);
        }
        if (!reqList.isEmpty()) {
            UserDirectAssignReq req = new UserDirectAssignReq();
            req.setReqList(reqList);
            req.setSkipCheckFunPermission(true);
            req.setSkipCheckAdminDataRange(true);
            PermissionServiceHelper.userDirectAssignPerm((UserDirectAssignReq)req);
        }
    }

    public static void unAssignUser(List<String> entityIds, List<Long> userIds) {
        List<String> permItems = perm_items.get((Object)PermItemType.ALL);
        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)"gai");
        ArrayList<UserDirectAssignPermReq> reqList = new ArrayList<UserDirectAssignPermReq>(userIds.size());
        for (Long userId : userIds) {
            UserDirectAssignPermReq permReq = new UserDirectAssignPermReq();
            permReq.setUserId(userId);
            permReq.setDimType("bos_org");
            ArrayList<DimFuncPermReq> dimFuncPermReqs = new ArrayList<DimFuncPermReq>(10);
            permReq.setDelList(dimFuncPermReqs);
            for (String entityId : entityIds) {
                for (String permItem : permItems) {
                    DimFuncPermReq dimFuncPermReq = new DimFuncPermReq();
                    dimFuncPermReq.setDimId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
                    dimFuncPermReq.setIncludeSub(Boolean.TRUE);
                    dimFuncPermReq.setAppId(appInfo.getId());
                    dimFuncPermReq.setEntityNumber(entityId);
                    dimFuncPermReq.setPermItemId(permItem);
                    dimFuncPermReq.setFromTypeDesc("km_model");
                    dimFuncPermReqs.add(dimFuncPermReq);
                }
            }
            reqList.add(permReq);
        }
        if (!reqList.isEmpty()) {
            UserDirectAssignReq req = new UserDirectAssignReq();
            req.setReqList(reqList);
            req.setSkipCheckFunPermission(true);
            req.setSkipCheckAdminDataRange(true);
            PermissionServiceHelper.userDirectAssignPerm((UserDirectAssignReq)req);
        }
    }

    public static void assignRole(List<String> entityIds, List<String> roleIds, PermItemType permItemType) {
        HashMap<String, Map> appEntityPermItemMap = new HashMap<String, Map>(1);
        Map entityPermItemMap = appEntityPermItemMap.computeIfAbsent(app_info.getId(), s -> new HashMap(1));
        for (String entityId : entityIds) {
            entityPermItemMap.computeIfAbsent(entityId, s -> new ArrayList(8)).addAll((Collection)perm_items.get((Object)permItemType));
        }
        for (String roleId : roleIds) {
            PermissionServiceHelper.roleAssignFuncPerm((String)roleId, appEntityPermItemMap, (boolean)true, (StringBuilder)new StringBuilder());
        }
    }

    public static void unAssignRole(List<String> entityIds, List<String> roleIds) {
        HashMap<String, Map> appEntityPermItemMap = new HashMap<String, Map>(1);
        Map entityPermItemMap = appEntityPermItemMap.computeIfAbsent(app_info.getId(), s -> new HashMap(1));
        for (String entityId : entityIds) {
            entityPermItemMap.computeIfAbsent(entityId, s -> new ArrayList(8)).addAll((Collection)perm_items.get((Object)PermItemType.ALL));
        }
        for (String roleId : roleIds) {
            PermissionServiceHelper.roleAssignFuncPerm((String)roleId, appEntityPermItemMap, (boolean)false, (StringBuilder)new StringBuilder());
        }
    }

    public static void deletePerm(String ... entityNumbers) {
        ArrayList<SqlBuilder> list = new ArrayList<SqlBuilder>(16);
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from t_perm_userpermdetail where", new Object[0]).appendIn(" fentitytypeid ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_disfunperm where", new Object[0]).appendIn(" fentitytypeid ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_rolepermdetial where ", new Object[0]).appendIn(" fentitytypeid ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_bizroledisperm where ", new Object[0]).appendIn(" fentitytypeid ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_bizroledisperm where ", new Object[0]).appendIn(" fentitytypeid ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_datapermentry where ", new Object[0]).appendIn(" fentitytypeid ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_datarule  where ", new Object[0]).appendIn(" fentitynum  ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_datarules_entry  where ", new Object[0]).appendIn(" fentitynum ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_userdatarule  where ", new Object[0]).appendIn(" fentitynum ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_fieldpermdetail  where ", new Object[0]).appendIn(" fentitytypeid  ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_operationrule  where ", new Object[0]).appendIn(" fentitytypeid  ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_operationruleobj  where ", new Object[0]).appendIn(" fentitytypeid  ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_admingroupfunperm where ", new Object[0]).appendIn(" fentitynum  ", (Object[])entityNumbers);
        list.add(sql);
        sql = new SqlBuilder();
        sql.append("delete from t_perm_adminschemedetail where ", new Object[0]).appendIn(" fentitynum  ", (Object[])entityNumbers);
        list.add(sql);
        list.forEach(o -> DB.execute((DBRoute)DBRoute.base, (SqlBuilder)o));
        PermissionServiceHelper.clearAllCache();
        CacheMrg.clearAllCache();
    }

    static {
        perm_items = new HashMap<PermItemType, List<String>>(4);
        app_info = AppMetadataCache.getAppInfoByNumber((String)"gai");
        perm_items.put(PermItemType.ALL, Arrays.asList("47156aff000000ac", "4715a0df000000ac", "4715e1f1000000ac", "804f6478000000ac", "80513207000000ac", "47162f66000000ac", "47165e8e000000ac", "47150e89000000ac", "4730fc9f000003ae", "4730fc9f000004ae", PERM_ITEM_COPY, PERM_ITEM_SAVE));
        perm_items.put(PermItemType.ADMIN, Arrays.asList("47156aff000000ac", "4715a0df000000ac", "4715e1f1000000ac", "804f6478000000ac", "80513207000000ac", "47162f66000000ac", "47165e8e000000ac", "47150e89000000ac", "4730fc9f000003ae", "4730fc9f000004ae", PERM_ITEM_COPY, PERM_ITEM_SAVE));
        perm_items.put(PermItemType.EDIT, Arrays.asList("47156aff000000ac", "4715a0df000000ac", "4715e1f1000000ac", "804f6478000000ac", "80513207000000ac", "47150e89000000ac", "4730fc9f000003ae", "4730fc9f000004ae", PERM_ITEM_COPY));
        perm_items.put(PermItemType.AUDIT, Arrays.asList("47162f66000000ac", "47165e8e000000ac", "47150e89000000ac"));
        perm_items.put(PermItemType.VIEW, Collections.singletonList("47150e89000000ac"));
    }

    public static enum PermItemType {
        ALL,
        ADMIN,
        EDIT,
        AUDIT,
        VIEW;

    }
}

